/*
 * Decompiled with CFR 0.152.
 */
package weixin.sms.util;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.BufferedWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.jeecgframework.core.util.ApplicationContextUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import weixin.sms.entity.TSSmsEntity;
import weixin.sms.entity.TSSmsSqlEntity;
import weixin.sms.entity.TSSmsTemplateEntity;
import weixin.sms.entity.TSSmsTemplateSqlEntity;
import weixin.sms.service.TSSmsServiceI;
import weixin.sms.service.TSSmsSqlServiceI;
import weixin.sms.service.TSSmsTemplateServiceI;
import weixin.sms.service.TSSmsTemplateSqlServiceI;

public class TuiSongMsgUtil {
    private static TSSmsServiceI tSSmsService;
    private static SystemService systemService;
    private static TSSmsTemplateSqlServiceI tSSmsTemplateSqlService;
    private static TSSmsTemplateServiceI tSSmsTemplateService;
    private static TSSmsSqlServiceI tSSmsSqlService;
    private static NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private static Configuration configuration;

    public static String sendMessage(String title, String msgType, String code, Map<String, Object> map, String sentTo) {
        try {
            TSSmsEntity tss = new TSSmsEntity();
            tss.setEsType(msgType);
            tss.setEsTitle(title);
            tss.setEsReceiver(sentTo);
            tss.setEsStatus("1");
            String hql = "from TSSmsTemplateSqlEntity as tempSql where tempSql.code=? ";
            String smsContent = "";
            List tssmsTemplateSqlList = TuiSongMsgUtil.getTssmsTemplateSqlInstance().findHql(hql, new Object[]{code});
            for (TSSmsTemplateSqlEntity tsSmsTemplateSqlEntity : tssmsTemplateSqlList) {
                TSSmsSqlEntity tsSmsSqlEntity = (TSSmsSqlEntity)TuiSongMsgUtil.getTSSmsServiceInstance().getEntity(TSSmsSqlEntity.class, (Serializable)((Object)tsSmsTemplateSqlEntity.getSqlId()));
                String templateSql = tsSmsSqlEntity.getSqlContent();
                TSSmsTemplateEntity tsSmsTemplateEntity = (TSSmsTemplateEntity)TuiSongMsgUtil.getTSSmsServiceInstance().getEntity(TSSmsTemplateEntity.class, (Serializable)((Object)tsSmsTemplateSqlEntity.getTemplateId()));
                String templateContent = tsSmsTemplateEntity.getTemplateContent();
                Map<String, Object> rootMap = TuiSongMsgUtil.getRootMapBySql(templateSql, map);
                StringReader strR = new StringReader(templateContent);
                Template template = new Template("strTemplate", (Reader)strR, new Configuration());
                StringWriter stringWriter = new StringWriter();
                BufferedWriter writer = new BufferedWriter(stringWriter);
                template.process(rootMap, (Writer)writer);
                smsContent = stringWriter.toString();
            }
            tss.setEsContent(smsContent);
            TuiSongMsgUtil.getTSSmsServiceInstance().save(tss);
            return "success";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public static NamedParameterJdbcTemplate getNamedParameterJdbcTemplate() {
        if (namedParameterJdbcTemplate == null) {
            namedParameterJdbcTemplate = (NamedParameterJdbcTemplate)ApplicationContextUtil.getContext().getBean(NamedParameterJdbcTemplate.class);
        }
        return namedParameterJdbcTemplate;
    }

    public static Configuration getConfiguration() {
        if (configuration == null) {
            configuration = (Configuration)ApplicationContextUtil.getContext().getBean(Configuration.class);
        }
        return configuration;
    }

    public static Map<String, Object> getRootMapBySql(String templateSql, Map<String, Object> map) {
        MapSqlParameterSource sqlp = new MapSqlParameterSource(map);
        return TuiSongMsgUtil.getNamedParameterJdbcTemplate().queryForMap(templateSql, (SqlParameterSource)sqlp);
    }

    public static String getTemplateSql(String sqlId) {
        String hql = "from TSSmsSqlEntity as tssSql where tssSql.id=?";
        List tssmsSqlList = TuiSongMsgUtil.getTSSmsSqlInstance().findHql(hql, new Object[]{sqlId});
        String sqlContent = "";
        for (TSSmsSqlEntity tsSmsSqlEntity : tssmsSqlList) {
            sqlContent = tsSmsSqlEntity.getSqlContent();
        }
        return sqlContent;
    }

    public static String getTemplateContent(String templateId) {
        String hql = "from TSSmsTemplateEntity as template where template.id=? ";
        List tSSmsTemplateList = TuiSongMsgUtil.getTssmsTemplateInstance().findHql(hql, new Object[]{templateId});
        String templateConetent = "";
        for (TSSmsTemplateEntity tsSmsTemplateEntity : tSSmsTemplateList) {
            templateConetent = tsSmsTemplateEntity.getTemplateContent();
        }
        return templateConetent;
    }

    public static TSSmsServiceI getTSSmsServiceInstance() {
        if (tSSmsService == null) {
            tSSmsService = (TSSmsServiceI)ApplicationContextUtil.getContext().getBean(TSSmsServiceI.class);
        }
        return tSSmsService;
    }

    public static TSSmsTemplateSqlServiceI getTssmsTemplateSqlInstance() {
        if (tSSmsTemplateSqlService == null) {
            tSSmsTemplateSqlService = (TSSmsTemplateSqlServiceI)ApplicationContextUtil.getContext().getBean(TSSmsTemplateSqlServiceI.class);
        }
        return tSSmsTemplateSqlService;
    }

    public static TSSmsTemplateServiceI getTssmsTemplateInstance() {
        if (tSSmsTemplateService == null) {
            tSSmsTemplateService = (TSSmsTemplateServiceI)ApplicationContextUtil.getContext().getBean(TSSmsTemplateServiceI.class);
        }
        return tSSmsTemplateService;
    }

    public static TSSmsSqlServiceI getTSSmsSqlInstance() {
        if (tSSmsSqlService == null) {
            tSSmsSqlService = (TSSmsSqlServiceI)ApplicationContextUtil.getContext().getBean(TSSmsSqlServiceI.class);
        }
        return tSSmsSqlService;
    }
}

