/*
 * Decompiled with CFR 0.152.
 */
package weixin.sms.service.impl;

import com.sun.mail.smtp.SMTPAddressFailedException;
import java.io.Serializable;
import java.net.ConnectException;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.mail.AuthenticationFailedException;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.PropertiesUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import weixin.sms.entity.TSSmsEntity;
import weixin.sms.service.TSSmsServiceI;
import weixin.sms.util.MailUtil;
import weixin.sms.util.SmsSender;

@Service(value="tSSmsService")
@Transactional
public class TSSmsServiceImpl
extends CommonServiceImpl
implements TSSmsServiceI {
    @Override
    public <T> void delete(T entity) {
        super.delete(entity);
        this.doDelSql((TSSmsEntity)entity);
    }

    @Override
    public <T> Serializable save(T entity) {
        Serializable t = super.save(entity);
        this.doAddSql((TSSmsEntity)entity);
        return t;
    }

    @Override
    public <T> void saveOrUpdate(T entity) {
        super.saveOrUpdate(entity);
        this.doUpdateSql((TSSmsEntity)entity);
    }

    @Override
    public boolean doAddSql(TSSmsEntity t) {
        return true;
    }

    @Override
    public boolean doUpdateSql(TSSmsEntity t) {
        return true;
    }

    @Override
    public boolean doDelSql(TSSmsEntity t) {
        return true;
    }

    public String replaceVal(String sql, TSSmsEntity t) {
        sql = sql.replace("#{id}", String.valueOf(t.getId()));
        sql = sql.replace("#{create_name}", String.valueOf(t.getCreateName()));
        sql = sql.replace("#{create_by}", String.valueOf(t.getCreateBy()));
        sql = sql.replace("#{create_date}", String.valueOf(t.getCreateDate()));
        sql = sql.replace("#{update_name}", String.valueOf(t.getUpdateName()));
        sql = sql.replace("#{update_by}", String.valueOf(t.getUpdateBy()));
        sql = sql.replace("#{update_date}", String.valueOf(t.getUpdateDate()));
        sql = sql.replace("#{es_title}", String.valueOf(t.getEsTitle()));
        sql = sql.replace("#{es_type}", String.valueOf(t.getEsType()));
        sql = sql.replace("#{es_sender}", String.valueOf(t.getEsSender()));
        sql = sql.replace("#{es_receiver}", String.valueOf(t.getEsReceiver()));
        sql = sql.replace("#{es_content}", String.valueOf(t.getEsContent()));
        sql = sql.replace("#{es_sendtime}", String.valueOf(t.getEsSendtime()));
        sql = sql.replace("#{es_status}", String.valueOf(t.getEsStatus()));
        sql = sql.replace("#{UUID}", UUID.randomUUID().toString());
        return sql;
    }

    @Override
    @Transactional
    public void send() {
        LogUtil.info((Object)"===============\u6d88\u606f\u53d1\u626b\u63cf\u5f00\u59cb=================");
        List smsSendList = this.findHql("from TSSmsEntity e where e.esStatus = ?", new Object[]{"1"});
        if (smsSendList == null || smsSendList.size() == 0) {
            return;
        }
        PropertiesUtil util = new PropertiesUtil("sysConfig.properties");
        for (TSSmsEntity tsSmsEntity : smsSendList) {
            String remark = "";
            if ("2".equals(tsSmsEntity.getEsType())) {
                try {
                    MailUtil.sendEmail(util.readProperty("mail.smtpHost"), tsSmsEntity.getEsReceiver(), tsSmsEntity.getEsTitle(), tsSmsEntity.getEsContent(), util.readProperty("mail.sender"), util.readProperty("mail.user"), util.readProperty("mail.pwd"));
                    tsSmsEntity.setEsStatus("2");
                    tsSmsEntity.setEsSendtime(new Date());
                    remark = "\u53d1\u9001\u6210\u529f";
                    tsSmsEntity.setRemark(remark);
                    this.updateEntitie(tsSmsEntity);
                }
                catch (Exception e) {
                    remark = e instanceof AuthenticationFailedException ? "\u8ba4\u8bc1\u5931\u8d25\u9519\u8bef\u7684\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801" : (e instanceof SMTPAddressFailedException ? "\u63a5\u53d7\u90ae\u7bb1\u683c\u5f0f\u4e0d\u5bf9" : (e instanceof ConnectException ? "\u90ae\u4ef6\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25" : e.getMessage()));
                    tsSmsEntity.setEsStatus("3");
                    tsSmsEntity.setEsSendtime(new Date());
                    tsSmsEntity.setRemark(remark);
                    this.updateEntitie(tsSmsEntity);
                }
            }
            if (!"1".equals(tsSmsEntity.getEsType())) continue;
            try {
                String r = SmsSender.send(tsSmsEntity.getEsReceiver(), tsSmsEntity.getEsContent());
                if ("\u63d0\u4ea4\u6210\u529f".equals(r) || "\u7cfb\u7edf\u8fd4\u56de\u5f02\u5e38".equals(r)) {
                    tsSmsEntity.setEsStatus("2");
                } else {
                    tsSmsEntity.setEsStatus("3");
                }
                remark = r;
                tsSmsEntity.setRemark(remark);
                tsSmsEntity.setEsSendtime(new Date());
                this.updateEntitie(tsSmsEntity);
            }
            catch (Exception e) {
                LogUtil.info((Object)remark);
            }
        }
        LogUtil.info((Object)"===============\u6d88\u606f\u53d1\u626b\u63cf\u7ed3\u675f=================");
    }
}

