/*
 * Decompiled with CFR 0.152.
 */
package weixin.sms.controller;

import java.io.Serializable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.sms.entity.TSSmsTemplateEntity;
import weixin.sms.service.TSSmsTemplateServiceI;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/tSSmsTemplateController"})
public class TSSmsTemplateController
extends BaseController {
    private static final Logger logger = Logger.getLogger(TSSmsTemplateController.class);
    @Autowired
    private TSSmsTemplateServiceI tSSmsTemplateService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"tSSmsTemplate"})
    public ModelAndView tSSmsTemplate(HttpServletRequest request) {
        return new ModelAndView("weixin/sms/tSSmsTemplateList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(TSSmsTemplateEntity tSSmsTemplate, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(TSSmsTemplateEntity.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)tSSmsTemplate, (Map)request.getParameterMap());
        cq.add();
        this.tSSmsTemplateService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(TSSmsTemplateEntity tSSmsTemplate, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        tSSmsTemplate = (TSSmsTemplateEntity)this.systemService.getEntity(TSSmsTemplateEntity.class, (Serializable)((Object)tSSmsTemplate.getId()));
        this.message = "\u6d88\u606f\u6a21\u672c\u8868\u5220\u9664\u6210\u529f";
        try {
            this.tSSmsTemplateService.delete(tSSmsTemplate);
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u6d88\u606f\u6a21\u672c\u8868\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u6d88\u606f\u6a21\u672c\u8868\u5220\u9664\u6210\u529f";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                TSSmsTemplateEntity tSSmsTemplate = (TSSmsTemplateEntity)this.systemService.getEntity(TSSmsTemplateEntity.class, (Serializable)((Object)id));
                this.tSSmsTemplateService.delete(tSSmsTemplate);
                this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u6d88\u606f\u6a21\u672c\u8868\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(TSSmsTemplateEntity tSSmsTemplate, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u6d88\u606f\u6a21\u672c\u8868\u6dfb\u52a0\u6210\u529f";
        try {
            this.tSSmsTemplateService.save(tSSmsTemplate);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u6d88\u606f\u6a21\u672c\u8868\u6dfb\u52a0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doUpdate"})
    @ResponseBody
    public AjaxJson doUpdate(TSSmsTemplateEntity tSSmsTemplate, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u6d88\u606f\u6a21\u672c\u8868\u66f4\u65b0\u6210\u529f";
        TSSmsTemplateEntity t = (TSSmsTemplateEntity)this.tSSmsTemplateService.get(TSSmsTemplateEntity.class, (Serializable)((Object)tSSmsTemplate.getId()));
        try {
            MyBeanUtils.copyBeanNotNull2Bean((Object)tSSmsTemplate, (Object)t);
            this.tSSmsTemplateService.saveOrUpdate(t);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u6d88\u606f\u6a21\u672c\u8868\u66f4\u65b0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(TSSmsTemplateEntity tSSmsTemplate, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)tSSmsTemplate.getId())) {
            tSSmsTemplate = (TSSmsTemplateEntity)this.tSSmsTemplateService.getEntity(TSSmsTemplateEntity.class, (Serializable)((Object)tSSmsTemplate.getId()));
            req.setAttribute("tSSmsTemplatePage", (Object)tSSmsTemplate);
        }
        return new ModelAndView("weixin/sms/tSSmsTemplate-add");
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(TSSmsTemplateEntity tSSmsTemplate, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)tSSmsTemplate.getId())) {
            tSSmsTemplate = (TSSmsTemplateEntity)this.tSSmsTemplateService.getEntity(TSSmsTemplateEntity.class, (Serializable)((Object)tSSmsTemplate.getId()));
            req.setAttribute("tSSmsTemplatePage", (Object)tSSmsTemplate);
        }
        return new ModelAndView("weixin/sms/tSSmsTemplate-update");
    }

    @RequestMapping(params={"upload"})
    public ModelAndView upload(HttpServletRequest req) {
        return new ModelAndView("weixin/sms/tSSmsTemplateUpload");
    }

    @RequestMapping(params={"importExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson importExcel(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        return j;
    }
}

