/*
 * Decompiled with CFR 0.152.
 */
package weixin.sms.controller;

import java.io.Serializable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.sms.entity.TSSmsSqlEntity;
import weixin.sms.service.TSSmsSqlServiceI;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/tSSmsSqlController"})
public class TSSmsSqlController
extends BaseController {
    private static final Logger logger = Logger.getLogger(TSSmsSqlController.class);
    @Autowired
    private TSSmsSqlServiceI tSSmsSqlService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"tSSmsSql"})
    public ModelAndView tSSmsSql(HttpServletRequest request) {
        return new ModelAndView("weixin/sms/tSSmsSqlList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(TSSmsSqlEntity tSSmsSql, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(TSSmsSqlEntity.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)tSSmsSql, (Map)request.getParameterMap());
        cq.add();
        this.systemService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(TSSmsSqlEntity tSSmsSql, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        tSSmsSql = (TSSmsSqlEntity)this.systemService.getEntity(TSSmsSqlEntity.class, (Serializable)((Object)tSSmsSql.getId()));
        this.message = "\u4e1a\u52a1SQL\u8868\u5220\u9664\u6210\u529f";
        try {
            this.systemService.delete((Object)tSSmsSql);
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u4e1a\u52a1SQL\u8868\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u4e1a\u52a1SQL\u8868\u5220\u9664\u6210\u529f";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                TSSmsSqlEntity tSSmsSql = (TSSmsSqlEntity)this.systemService.getEntity(TSSmsSqlEntity.class, (Serializable)((Object)id));
                this.systemService.delete((Object)tSSmsSql);
                this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u4e1a\u52a1SQL\u8868\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(TSSmsSqlEntity tSSmsSql, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u4e1a\u52a1SQL\u8868\u6dfb\u52a0\u6210\u529f";
        try {
            this.tSSmsSqlService.save(tSSmsSql);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u4e1a\u52a1SQL\u8868\u6dfb\u52a0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doUpdate"})
    @ResponseBody
    public AjaxJson doUpdate(TSSmsSqlEntity tSSmsSql, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u4e1a\u52a1SQL\u8868\u66f4\u65b0\u6210\u529f";
        TSSmsSqlEntity t = (TSSmsSqlEntity)this.systemService.get(TSSmsSqlEntity.class, (Serializable)((Object)tSSmsSql.getId()));
        try {
            MyBeanUtils.copyBeanNotNull2Bean((Object)tSSmsSql, (Object)t);
            this.systemService.saveOrUpdate((Object)t);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u4e1a\u52a1SQL\u8868\u66f4\u65b0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(TSSmsSqlEntity tSSmsSql, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)tSSmsSql.getId())) {
            tSSmsSql = (TSSmsSqlEntity)this.systemService.getEntity(TSSmsSqlEntity.class, (Serializable)((Object)tSSmsSql.getId()));
            req.setAttribute("tSSmsSqlPage", (Object)tSSmsSql);
        }
        return new ModelAndView("weixin/sms/tSSmsSql-add");
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(TSSmsSqlEntity tSSmsSql, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)tSSmsSql.getId())) {
            tSSmsSql = (TSSmsSqlEntity)this.systemService.getEntity(TSSmsSqlEntity.class, (Serializable)((Object)tSSmsSql.getId()));
            req.setAttribute("tSSmsSqlPage", (Object)tSSmsSql);
        }
        return new ModelAndView("weixin/sms/tSSmsSql-update");
    }

    @RequestMapping(params={"upload"})
    public ModelAndView upload(HttpServletRequest req) {
        return new ModelAndView("weixin/sms/tSSmsSqlUpload");
    }

    @RequestMapping(params={"importExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson importExcel(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        return j;
    }
}

