/*
 * Decompiled with CFR 0.152.
 */
package weixin.sms.controller;

import java.io.Serializable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.sms.entity.TSSmsEntity;
import weixin.sms.service.TSSmsServiceI;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/tSSmsController"})
public class TSSmsController
extends BaseController {
    private static final Logger logger = Logger.getLogger(TSSmsController.class);
    @Autowired
    private TSSmsServiceI tSSmsService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"tSSms"})
    public ModelAndView tSSms(HttpServletRequest request) {
        return new ModelAndView("weixin/sms/tSSmsList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(TSSmsEntity tSSms, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(TSSmsEntity.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)tSSms, (Map)request.getParameterMap());
        cq.add();
        this.tSSmsService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(TSSmsEntity tSSms, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        tSSms = (TSSmsEntity)this.systemService.getEntity(TSSmsEntity.class, (Serializable)((Object)tSSms.getId()));
        this.message = "\u6d88\u606f\u53d1\u9001\u8bb0\u5f55\u8868\u5220\u9664\u6210\u529f";
        try {
            this.tSSmsService.delete(tSSms);
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u6d88\u606f\u53d1\u9001\u8bb0\u5f55\u8868\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u6d88\u606f\u53d1\u9001\u8bb0\u5f55\u8868\u5220\u9664\u6210\u529f";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                TSSmsEntity tSSms = (TSSmsEntity)this.systemService.getEntity(TSSmsEntity.class, (Serializable)((Object)id));
                this.tSSmsService.delete(tSSms);
                this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u6d88\u606f\u53d1\u9001\u8bb0\u5f55\u8868\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(TSSmsEntity tSSms, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u6d88\u606f\u53d1\u9001\u8bb0\u5f55\u8868\u6dfb\u52a0\u6210\u529f";
        try {
            this.tSSmsService.save(tSSms);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u6d88\u606f\u53d1\u9001\u8bb0\u5f55\u8868\u6dfb\u52a0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doUpdate"})
    @ResponseBody
    public AjaxJson doUpdate(TSSmsEntity tSSms, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u6d88\u606f\u53d1\u9001\u8bb0\u5f55\u8868\u66f4\u65b0\u6210\u529f";
        TSSmsEntity t = (TSSmsEntity)this.tSSmsService.get(TSSmsEntity.class, (Serializable)((Object)tSSms.getId()));
        try {
            MyBeanUtils.copyBeanNotNull2Bean((Object)tSSms, (Object)t);
            this.tSSmsService.saveOrUpdate(t);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u6d88\u606f\u53d1\u9001\u8bb0\u5f55\u8868\u66f4\u65b0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(TSSmsEntity tSSms, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)tSSms.getId())) {
            tSSms = (TSSmsEntity)this.tSSmsService.getEntity(TSSmsEntity.class, (Serializable)((Object)tSSms.getId()));
            req.setAttribute("tSSmsPage", (Object)tSSms);
        }
        return new ModelAndView("weixin/sms/tSSms-add");
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(TSSmsEntity tSSms, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)tSSms.getId())) {
            tSSms = (TSSmsEntity)this.tSSmsService.getEntity(TSSmsEntity.class, (Serializable)((Object)tSSms.getId()));
            req.setAttribute("tSSmsPage", (Object)tSSms);
        }
        return new ModelAndView("weixin/sms/tSSms-update");
    }

    @RequestMapping(params={"upload"})
    public ModelAndView upload(HttpServletRequest req) {
        return new ModelAndView("weixin/sms/tSSmsUpload");
    }

    @RequestMapping(params={"importExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson importExcel(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        return j;
    }
}

