/*
 * Decompiled with CFR 0.152.
 */
package weixin.shop.core;

import com.alibaba.fastjson.JSONArray;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.web.system.pojo.base.TSUser;
import org.jeecgframework.web.system.service.SystemService;
import org.jeecgframework.web.system.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import weixin.cms.util.CmsCollectExcutor;
import weixin.cms.util.CmsFreemarkerHelper;
import weixin.guanjia.account.entity.WeixinAccountEntity;
import weixin.huodong.entity.WxZhongjiangEntity;
import weixin.shop.base.entity.WeixinShopAddressEntity;
import weixin.shop.base.entity.WeixinShopCartEntity;
import weixin.shop.base.entity.WeixinShopGoodsEntity;
import weixin.shop.base.entity.WeixinShopSellerEntity;
import weixin.shop.base.service.WeixinShopGoodsAttentionServiceI;
import weixin.shop.base.service.WeixinShopGoodsServiceI;
import weixin.shop.common.ShopDataContent;
import weixin.shop.shopdata.impl.AddAddrCollect;
import weixin.shop.shopdata.impl.CartListCollect;
import weixin.shop.shopdata.impl.ConfirmOrderCollect;
import weixin.shop.shopdata.impl.EditAddrCollect;
import weixin.shop.shopdata.impl.ExchangeListCollect;
import weixin.shop.shopdata.impl.IntegDetailOrDetailCollect;
import weixin.shop.shopdata.impl.OrderListCollect;
import weixin.shop.shopdata.impl.ShopAddressListCollect;
import weixin.shop.shopdata.impl.ShopGoodsdetailCollect;
import weixin.shop.shopdata.impl.ShopGoodslistCollect;
import weixin.shop.shopdata.impl.ShopIndexCollect;
import weixin.shop.shopdata.impl.ShowMyJiangpCollect;

@Controller
@RequestMapping(value={"/weixinShopController"})
public class WeixinShopController
extends BaseController {
    @Autowired
    private WeixinShopGoodsServiceI weixinShopGoodsService;
    @Autowired
    private WeixinShopGoodsAttentionServiceI weixinShopGoodsAttentionService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private UserService userService;
    private static Map<String, Object> dataCollectContent = new HashMap<String, Object>();

    static {
        dataCollectContent.put("index", new ShopIndexCollect());
        dataCollectContent.put("goodslist", new ShopGoodslistCollect());
        dataCollectContent.put("goodsdetail", new ShopGoodsdetailCollect());
        dataCollectContent.put("addresslist", new ShopAddressListCollect());
        dataCollectContent.put("exchange", new ExchangeListCollect());
        dataCollectContent.put("saveExchange", new ExchangeListCollect());
        dataCollectContent.put("showMyJiangp", new ShowMyJiangpCollect());
        dataCollectContent.put("shopintegraldetal", new IntegDetailOrDetailCollect());
        dataCollectContent.put("cartlist", new CartListCollect());
        dataCollectContent.put("confirmorder", new ConfirmOrderCollect());
        dataCollectContent.put("addAddr", new AddAddrCollect());
        dataCollectContent.put("orderlist", new OrderListCollect());
        dataCollectContent.put("editAddr", new EditAddrCollect());
    }

    @RequestMapping(params={"goPage"})
    public void goPage(HttpServletRequest request, HttpServletResponse response, @RequestParam String page) {
        Map<String, String> params = this.paramsToMap(request);
        ResourceUtil.initQianTaiRequestAccountId((HttpServletRequest)request);
        ShopDataContent.put("domain", ResourceUtil.getDomainByConfig());
        String accountId = request.getParameter("accountid");
        String openid = ResourceUtil.getUserOpenId();
        ShopDataContent.put("openid", openid);
        HttpSession session = request.getSession();
        String templatePath = this.templatePath(request);
        params.put("templatePath", templatePath);
        if (StringUtils.isNotEmpty((String)accountId)) {
            WeixinAccountEntity weixinAccount = (WeixinAccountEntity)this.systemService.getEntity(WeixinAccountEntity.class, (Serializable)((Object)accountId));
            session.setAttribute("WEIXIN_ACCOUNT", (Object)weixinAccount);
        }
        if (CmsCollectExcutor.get("shop", page) != null) {
            CmsCollectExcutor.collect("shop", page, params);
        }
        CmsFreemarkerHelper cmsFreemarkerHelper = new CmsFreemarkerHelper();
        String pageUrl = "/template/shop" + templatePath + page + ".ftl";
        String html = cmsFreemarkerHelper.parseTemplate(pageUrl, ShopDataContent.loadContent());
        response.setContentType("text/html");
        response.setHeader("Cache-Control", "no-store");
        try {
            PrintWriter writer = response.getWriter();
            writer.println(html);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(params={"goodslist"})
    @ResponseBody
    public JSONArray goodslist(HttpServletRequest request, HttpServletResponse response) {
        JSONArray json = new JSONArray();
        Map<String, String> params = this.paramsToMap(request);
        int page = Integer.parseInt(params.get("page"));
        int rows = Integer.parseInt(params.get("pagesize"));
        List<WeixinShopGoodsEntity> goodslist = this.weixinShopGoodsService.list(params, page, rows);
        json = JSONArray.parseArray((String)JSONArray.toJSONString(goodslist));
        return json;
    }

    @RequestMapping(params={"attentionGoodslist"})
    @ResponseBody
    public JSONArray attentionGoodslist(HttpServletRequest request, HttpServletResponse response) {
        JSONArray json = new JSONArray();
        Map<String, String> params = this.paramsToMap(request);
        int page = Integer.parseInt(params.get("page"));
        int rows = Integer.parseInt(params.get("pagesize"));
        String openid = ResourceUtil.getUserOpenId();
        List<WeixinShopGoodsEntity> goodslist = this.weixinShopGoodsAttentionService.attentionGoodslist(openid);
        json = JSONArray.parseArray((String)JSONArray.toJSONString(goodslist));
        return json;
    }

    private Map<String, String> paramsToMap(HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        Enumeration em = request.getParameterNames();
        while (em.hasMoreElements()) {
            String paramName = (String)em.nextElement();
            String paramValue = request.getParameter(paramName);
            params.put(paramName, paramValue);
        }
        return params;
    }

    @RequestMapping(params={"saveExchange"})
    @ResponseBody
    public AjaxJson saveExchange(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        try {
            j.setSuccess(Boolean.FALSE.booleanValue());
            String accountid = request.getParameter("accountid");
            String zhongjianId = request.getParameter("zhongjianId");
            Integer integral = Integer.parseInt(request.getParameter("needIntegral"));
            TSUser u = (TSUser)this.userService.getEntity(TSUser.class, (Serializable)((Object)accountid));
            WxZhongjiangEntity wxzj = (WxZhongjiangEntity)this.systemService.getEntity(WxZhongjiangEntity.class, (Serializable)((Object)zhongjianId));
            wxzj.setUser(u);
            this.systemService.saveOrUpdate((Object)wxzj);
            j.setSuccess(Boolean.TRUE.booleanValue());
        }
        catch (Exception e) {
            j.setSuccess(Boolean.FALSE.booleanValue());
        }
        return j;
    }

    @RequestMapping(params={"addGoodsToCart"})
    @ResponseBody
    public AjaxJson addGoodsToCart(@RequestParam(value="goodsIds[]") String[] goodsIds, @RequestParam(value="buyNums[]") Integer[] buyNums, HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        int batchAmount = goodsIds.length;
        TSUser buyer = ResourceUtil.getSessionUserName();
        String buyId = buyer.getId();
        String accountid = ResourceUtil.getQianTaiAccountId();
        WeixinAccountEntity weixinAccount = ResourceUtil.getShangJiaAccount();
        TSUser seller = null;
        String sellerId = "";
        if (weixinAccount != null) {
            seller = (TSUser)this.systemService.findUniqueByProperty(TSUser.class, "userName", (Object)weixinAccount.getUserName());
            sellerId = seller.getId();
        }
        WeixinShopCartEntity weixinShopCart = null;
        int buyNum = 0;
        String goodsId = "";
        int i = 0;
        while (i < batchAmount) {
            buyNum = buyNums[i];
            goodsId = goodsIds[i];
            LogUtil.info((Object)("....buyNum....." + buyNum + ".....goodsId....." + goodsId + "...buyId..." + buyId));
            WeixinShopGoodsEntity goodsEntity = (WeixinShopGoodsEntity)this.systemService.getEntity(WeixinShopGoodsEntity.class, (Serializable)((Object)goodsId));
            String hql = "from WeixinShopCartEntity where shopGoodsEntity.id='" + goodsId + "' and buyer.id='" + buyId + "' and seller.id='" + sellerId + "'";
            List shopCarList = this.systemService.findByQueryString(hql);
            LogUtil.info((Object)("....size of shopCarList...." + shopCarList.size()));
            if (shopCarList.size() > 0) {
                weixinShopCart = (WeixinShopCartEntity)shopCarList.get(0);
                int count = weixinShopCart.getCount() + buyNum;
                weixinShopCart.setCount(count);
                double total = (double)count * goodsEntity.getRealPrice();
                LogUtil.info((Object)("...total..." + total));
                weixinShopCart.setTotal(total);
                this.systemService.updateEntitie((Object)weixinShopCart);
            } else {
                weixinShopCart = new WeixinShopCartEntity();
                weixinShopCart.setSeller(seller);
                double realPrice = goodsEntity.getRealPrice();
                weixinShopCart.setBuyPrice(realPrice);
                weixinShopCart.setCount(buyNum);
                weixinShopCart.setShopGoodsEntity(goodsEntity);
                weixinShopCart.setGoodsProperty("");
                weixinShopCart.setTotal(realPrice * (double)buyNum);
                weixinShopCart.setBuyer(buyer);
                weixinShopCart.setAccountid(accountid);
                this.systemService.save((Object)weixinShopCart);
            }
            ++i;
        }
        return j;
    }

    @RequestMapping(params={"delCart"})
    @ResponseBody
    public AjaxJson delCart(WeixinShopCartEntity weixinShopCart, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinShopCart = (WeixinShopCartEntity)this.systemService.getEntity(WeixinShopCartEntity.class, (Serializable)((Object)weixinShopCart.getId()));
        String message = "\u8d2d\u7269\u8f66 \u5220\u9664\u6210\u529f";
        this.systemService.delete((Object)weixinShopCart);
        this.systemService.addLog(message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(message);
        return j;
    }

    @RequestMapping(params={"updateShopCartNumber"})
    @ResponseBody
    public AjaxJson updateShopCartNumber(HttpServletRequest req) {
        AjaxJson j = new AjaxJson();
        WeixinAccountEntity weixinAccount = ResourceUtil.getShangJiaAccount();
        String id = req.getParameter("id");
        String num = req.getParameter("num");
        HashMap<String, Number> mapParams = new HashMap<String, Number>();
        if (weixinAccount != null) {
            WeixinShopCartEntity weixinShopCartEntity = (WeixinShopCartEntity)this.systemService.getEntity(WeixinShopCartEntity.class, (Serializable)((Object)id));
            weixinShopCartEntity.setCount(Integer.parseInt(num));
            weixinShopCartEntity.setTotal(weixinShopCartEntity.getBuyPrice() * (double)Integer.parseInt(num));
            this.systemService.updateEntitie((Object)weixinShopCartEntity);
            mapParams.put("shopTotal", weixinShopCartEntity.getTotal());
            TSUser seller = (TSUser)this.systemService.findUniqueByProperty(TSUser.class, "userName", (Object)weixinAccount.getUserName());
            String sellerId = seller.getId();
            String hql = "from WeixinShopCartEntity where buyer.id='" + ResourceUtil.getSessionUserName().getId() + "' and seller.id='" + sellerId + "'";
            LogUtil.info((Object)("...the hql of cart is....." + hql));
            List ShopCarList = this.systemService.findByQueryString(hql);
            LogUtil.info((Object)("...the size of cart is....." + ShopCarList.size()));
            double totalMoney = 0.0;
            int totalNum = 0;
            for (WeixinShopCartEntity tempShopCart : ShopCarList) {
                totalNum += tempShopCart.getCount().intValue();
                totalMoney += tempShopCart.getTotal().doubleValue();
            }
            mapParams.put("totalNum", totalNum);
            mapParams.put("totalMoney", totalMoney);
            j.setAttributes(mapParams);
        }
        return j;
    }

    @RequestMapping(params={"setDefaultAddress"})
    @ResponseBody
    public AjaxJson setDefaultAddress(WeixinShopAddressEntity weixinShopAddress, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.systemService.executeSql("update weixin_shop_address set defaultflag=0 where userid = '" + ResourceUtil.getSessionUserName().getId() + "'", new Object[0]);
        weixinShopAddress = (WeixinShopAddressEntity)this.systemService.getEntity(WeixinShopAddressEntity.class, (Serializable)((Object)weixinShopAddress.getId()));
        weixinShopAddress.setDefaultflag(1);
        String message = "\u8bbe\u5b9a\u9ed8\u8ba4\u5730\u5740\u6210\u529f";
        try {
            this.systemService.updateEntitie((Object)weixinShopAddress);
            this.systemService.addLog(message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            message = "\u8bbe\u5b9a\u9ed8\u8ba4\u5730\u5740\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(message);
        return j;
    }

    @RequestMapping(params={"doaddAddr"})
    @ResponseBody
    public AjaxJson doaddAddr(WeixinShopAddressEntity weixinShopAddress, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String message = "\u6536\u8d27\u5730\u5740\u4fe1\u606f\u6dfb\u52a0\u6210\u529f";
        try {
            weixinShopAddress.setUserid(ResourceUtil.getSessionUserName().getId());
            weixinShopAddress.setDefaultflag(0);
            String address = String.valueOf(weixinShopAddress.getProvince()) + weixinShopAddress.getCity() + weixinShopAddress.getArea() + weixinShopAddress.getAddress() + weixinShopAddress.getRealname() + weixinShopAddress.getTel();
            weixinShopAddress.setAlladdress(address);
            this.systemService.save((Object)weixinShopAddress);
            this.systemService.addLog(message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            message = "\u5730\u5740\u4fe1\u606f\u6dfb\u52a0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(message);
        return j;
    }

    @RequestMapping(params={"doeditAddr"})
    @ResponseBody
    public AjaxJson doeditAddr(WeixinShopAddressEntity weixinShopAddress, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String message = "\u6536\u8d27\u5730\u5740\u4fe1\u606f\u66f4\u65b0\u6210\u529f";
        try {
            if (oConvertUtils.isNotEmpty((Object)weixinShopAddress.getId())) {
                WeixinShopAddressEntity dbAddress = (WeixinShopAddressEntity)this.systemService.getEntity(WeixinShopAddressEntity.class, (Serializable)((Object)weixinShopAddress.getId()));
                if (oConvertUtils.isNotEmpty((Object)dbAddress)) {
                    String address = String.valueOf(weixinShopAddress.getProvince()) + weixinShopAddress.getCity() + weixinShopAddress.getArea() + weixinShopAddress.getAddress() + weixinShopAddress.getRealname() + weixinShopAddress.getTel();
                    weixinShopAddress.setAlladdress(address);
                    MyBeanUtils.copyBeanNotNull2Bean((Object)weixinShopAddress, (Object)dbAddress);
                    this.systemService.updateEntitie((Object)dbAddress);
                    this.systemService.addLog(message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
                } else {
                    message = "\u60a8\u8981\u66f4\u65b0\u7684\u6536\u8d27\u5730\u5740\u4fe1\u606f\u4e0d\u5b58\u5728";
                }
            } else {
                message = "\u60a8\u8981\u66f4\u65b0\u7684\u6536\u8d27\u5730\u5740\u4fe1\u606f\u4f20\u5165\u9519\u8bef";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            message = "\u5730\u5740\u4fe1\u606f\u66f4\u65b0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(message);
        return j;
    }

    private String templatePath(HttpServletRequest request) {
        String style = "";
        String accountId = request.getParameter("accountid");
        String domain = ResourceUtil.getConfigByName((String)"domain");
        List list = this.systemService.findByProperty(WeixinShopSellerEntity.class, "accountId", (Object)accountId);
        if (oConvertUtils.isEmpty((Object)list) || list.size() < 1) {
            style = "/default/ftl/";
            ShopDataContent.put("style", String.valueOf(domain) + style.replace("/ftl/", ""));
        } else if (oConvertUtils.isEmpty((Object)((WeixinShopSellerEntity)list.get(0)).getShoptpl()) || oConvertUtils.isEmpty((Object)((WeixinShopSellerEntity)list.get(0)).getShoptpl().getTplpath())) {
            style = "/default/ftl/";
            ShopDataContent.put("style", String.valueOf(domain) + style.replace("/ftl/", ""));
        } else {
            style = ((WeixinShopSellerEntity)list.get(0)).getShoptpl().getTplpath();
            ShopDataContent.put("style", String.valueOf(domain) + "/template/shop" + "/" + style);
            style = "/" + style + "/ftl/";
        }
        return style;
    }
}

