/*
 * Decompiled with CFR 0.152.
 */
package weixin.shop.base.service.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.web.system.pojo.base.TSUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import weixin.shop.base.dao.WeixinShopTempletDao;
import weixin.shop.base.entity.WeixinShopTempletEntity;
import weixin.shop.base.service.WeixinShopTempletServiceI;

@Service(value="weixinShopTempletService")
@Transactional
public class WeixinShopTempletServiceImpl
extends CommonServiceImpl
implements WeixinShopTempletServiceI {
    @Autowired
    private WeixinShopTempletDao weixinShopTempletDao;

    @Override
    public <T> void delete(T entity) {
        super.delete(entity);
        this.doDelSql((WeixinShopTempletEntity)entity);
    }

    @Override
    public <T> Serializable save(T entity) {
        Serializable t = super.save(entity);
        this.doAddSql((WeixinShopTempletEntity)entity);
        return t;
    }

    @Override
    public <T> void saveOrUpdate(T entity) {
        super.saveOrUpdate(entity);
        this.doUpdateSql((WeixinShopTempletEntity)entity);
    }

    @Override
    public boolean doAddSql(WeixinShopTempletEntity t) {
        return true;
    }

    @Override
    public boolean doUpdateSql(WeixinShopTempletEntity t) {
        return true;
    }

    @Override
    public boolean doDelSql(WeixinShopTempletEntity t) {
        return true;
    }

    public String replaceVal(String sql, WeixinShopTempletEntity t) {
        sql = sql.replace("#{id}", String.valueOf(t.getId()));
        sql = sql.replace("#{tplname}", String.valueOf(t.getTplname()));
        sql = sql.replace("#{tplpath}", String.valueOf(t.getTplpath()));
        sql = sql.replace("#{tplimages}", String.valueOf(t.getTplimages()));
        sql = sql.replace("#{tpldesc}", String.valueOf(t.getTpldesc()));
        sql = sql.replace("#{UUID}", UUID.randomUUID().toString());
        return sql;
    }

    @Override
    public List<WeixinShopTempletEntity> userTempletes(TSUser user, int page, int rows) {
        HashMap<String, String> param = new HashMap<String, String>();
        if (!this.isAdmin(user)) {
            param.put("isAdmin", "0");
            param.put("accountid", ResourceUtil.getShangJiaAccountId());
        } else {
            param.put("isAdmin", "1");
        }
        return this.weixinShopTempletDao.userTempletes(param, page, rows);
    }

    @Override
    public Integer getCountUserTempletes(TSUser user) {
        HashMap<String, String> param = new HashMap<String, String>();
        if (!this.isAdmin(user)) {
            param.put("isAdmin", "0");
            param.put("accountid", ResourceUtil.getShangJiaAccountId());
        } else {
            param.put("isAdmin", "1");
        }
        return this.weixinShopTempletDao.getCountUserTempletes(param);
    }

    private boolean isAdmin(TSUser user) {
        return oConvertUtils.isNotEmpty((Object)user.getUserName()) && user.getUserName().equals("admin");
    }
}

