/*
 * Decompiled with CFR 0.152.
 */
package weixin.shop.base.controller;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.tools.zip.ZipEntry;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.common.UploadFile;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.BrowserUtils;
import org.jeecgframework.core.util.ExceptionUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.MyClassLoader;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.ZipUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExcelTitle;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.pojo.base.TSDocument;
import org.jeecgframework.web.system.pojo.base.TSType;
import org.jeecgframework.web.system.pojo.base.TSTypegroup;
import org.jeecgframework.web.system.pojo.base.TSUser;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import weixin.cms.controller.WeixinCmsStyleController;
import weixin.shop.base.entity.WeixinShopTempletEntity;
import weixin.shop.base.service.WeixinShopTempletServiceI;
import weixin.util.DateUtils;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/weixinShopTempletController"})
public class WeixinShopTempletController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinShopTempletController.class);
    @Autowired
    private WeixinShopTempletServiceI weixinShopTempletService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"weixinShopTemplet"})
    public ModelAndView weixinShopTemplet(HttpServletRequest request) {
        return new ModelAndView("weixin/shop/base/weixinShopTempletList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeixinShopTempletEntity weixinShopTemplet, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        try {
            TSUser user = ResourceUtil.getSessionUserName();
            List<WeixinShopTempletEntity> list = this.weixinShopTempletService.userTempletes(user, dataGrid.getPage(), dataGrid.getRows());
            int count = this.weixinShopTempletService.getCountUserTempletes(user);
            dataGrid.setTotal(count);
            dataGrid.setResults(list);
            TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(WeixinShopTempletEntity weixinShopTemplet, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinShopTemplet = (WeixinShopTempletEntity)this.systemService.getEntity(WeixinShopTempletEntity.class, (Serializable)((Object)weixinShopTemplet.getId()));
        this.message = "weixin_shop_templet\u5220\u9664\u6210\u529f";
        try {
            this.weixinShopTempletService.delete(weixinShopTemplet);
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "weixin_shop_templet\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "weixin_shop_templet\u5220\u9664\u6210\u529f";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                WeixinShopTempletEntity weixinShopTemplet = (WeixinShopTempletEntity)this.systemService.getEntity(WeixinShopTempletEntity.class, (Serializable)((Object)id));
                this.weixinShopTempletService.delete(weixinShopTemplet);
                this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "weixin_shop_templet\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(WeixinShopTempletEntity weixinShopTemplet, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "weixin_shop_templet\u6dfb\u52a0\u6210\u529f";
        try {
            this.weixinShopTempletService.save(weixinShopTemplet);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "weixin_shop_templet\u6dfb\u52a0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        j.setObj((Object)weixinShopTemplet);
        return j;
    }

    @RequestMapping(params={"doUpdate"})
    @ResponseBody
    public AjaxJson doUpdate(WeixinShopTempletEntity weixinShopTemplet, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "weixin_shop_templet\u66f4\u65b0\u6210\u529f";
        WeixinShopTempletEntity t = (WeixinShopTempletEntity)this.weixinShopTempletService.get(WeixinShopTempletEntity.class, (Serializable)((Object)weixinShopTemplet.getId()));
        try {
            MyBeanUtils.copyBeanNotNull2Bean((Object)weixinShopTemplet, (Object)t);
            this.weixinShopTempletService.saveOrUpdate(t);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "weixin_shop_templet\u66f4\u65b0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        j.setObj((Object)t);
        return j;
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(WeixinShopTempletEntity weixinShopTemplet, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinShopTemplet.getId())) {
            weixinShopTemplet = (WeixinShopTempletEntity)this.weixinShopTempletService.getEntity(WeixinShopTempletEntity.class, (Serializable)((Object)weixinShopTemplet.getId()));
            req.setAttribute("weixinShopTempletPage", (Object)weixinShopTemplet);
        }
        return new ModelAndView("weixin/shop/base/weixinShopTemplet-add");
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(WeixinShopTempletEntity weixinShopTemplet, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinShopTemplet.getId())) {
            weixinShopTemplet = (WeixinShopTempletEntity)this.weixinShopTempletService.getEntity(WeixinShopTempletEntity.class, (Serializable)((Object)weixinShopTemplet.getId()));
            req.setAttribute("weixinShopTempletPage", (Object)weixinShopTemplet);
        }
        return new ModelAndView("weixin/shop/base/weixinShopTemplet-update");
    }

    @RequestMapping(params={"upload"})
    public ModelAndView upload(HttpServletRequest req) {
        return new ModelAndView("weixin/shop/base/weixinShopTempletUpload");
    }

    @RequestMapping(params={"uploadZip"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson uploadZip(MultipartHttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        String id = request.getParameter("id");
        HashMap<String, String> attributes = new HashMap<String, String>();
        TSTypegroup tsTypegroup = this.systemService.getTypeGroup("fieltype", "\u6587\u6863\u5206\u7c7b");
        TSType tsType = this.systemService.getType("files", "\u9644\u4ef6", tsTypegroup);
        String fileKey = oConvertUtils.getString((String)request.getParameter("fileKey"));
        String documentTitle = oConvertUtils.getString((String)request.getParameter("documentTitle"));
        TSDocument document = new TSDocument();
        if (StringUtil.isNotEmpty((Object)fileKey)) {
            document.setId(fileKey);
            document = (TSDocument)this.systemService.getEntity(TSDocument.class, (Serializable)((Object)fileKey));
            document.setDocumentTitle(documentTitle);
        }
        document.setSubclassname(MyClassLoader.getPackPath((Object)document));
        document.setCreatedate(DateUtils.gettimestamp());
        document.setTSType(tsType);
        UploadFile uploadFile = new UploadFile((HttpServletRequest)request, (Object)document);
        uploadFile.setCusPath("files");
        uploadFile.setSwfpath("swfpath");
        document = (TSDocument)this.systemService.uploadFile(uploadFile);
        WeixinShopTempletEntity tpl = (WeixinShopTempletEntity)this.systemService.getEntity(WeixinShopTempletEntity.class, (Serializable)((Object)id));
        String requestPath = WeixinShopTempletController.tplRealPath(tpl);
        String tplPath = tpl.getTplpath();
        String realpath = String.valueOf(requestPath) + "/" + tplPath + "/";
        File tempfolder = new File(realpath);
        if (!tempfolder.exists()) {
            tempfolder.mkdirs();
        }
        try {
            String path = String.valueOf(request.getSession().getServletContext().getRealPath("/")) + document.getRealpath();
            ZipUtil.unZip((String)path, (String)(String.valueOf(tempfolder.getAbsolutePath()) + "/"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        attributes.put("url", document.getRealpath());
        attributes.put("fileKey", document.getId());
        attributes.put("name", document.getAttachmenttitle());
        attributes.put("viewhref", "commonController.do?openViewFile&fileid=" + document.getId());
        attributes.put("delurl", "commonController.do?delObjFile&fileKey=" + document.getId());
        j.setMsg("\u6587\u4ef6\u6dfb\u52a0\u6210\u529f");
        j.setAttributes(attributes);
        return j;
    }

    private static String tplRealPath(WeixinShopTempletEntity tpl) {
        String refPath = "";
        refPath = "2".equals(tpl.getTpltype()) ? "template/cms" : "template/shop";
        String requestPath = "";
        try {
            if (StringUtils.isEmpty((CharSequence)refPath)) {
                refPath = "";
            }
            requestPath = String.valueOf(WeixinCmsStyleController.class.getClassLoader().getResource("").toURI().getRawPath()) + refPath;
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
        return requestPath;
    }

    @RequestMapping(params={"exportXls"})
    public void exportXls(WeixinShopTempletEntity weixinShopTemplet, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "weixin_shop_templet";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                CriteriaQuery cq = new CriteriaQuery(WeixinShopTempletEntity.class, dataGrid);
                HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinShopTemplet, (Map)request.getParameterMap());
                List weixinShopTemplets = this.weixinShopTempletService.getListByCriteriaQuery(cq, false);
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("weixin_shop_templet\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WeixinShopTempletEntity.class, (Collection)weixinShopTemplets);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"exportXlsByT"})
    public void exportXlsByT(WeixinShopTempletEntity weixinShopTemplet, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "weixin_shop_templet";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("weixin_shop_templet\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WeixinShopTempletEntity.class, null);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"importExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson importExcel(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setSecondTitleRows(1);
            params.setNeedSave(true);
            try {
                try {
                    List listWeixinShopTempletEntitys = (List)ExcelImportUtil.importExcelByIs((InputStream)file.getInputStream(), WeixinShopTempletEntity.class, (ImportParams)params);
                    for (WeixinShopTempletEntity weixinShopTemplet : listWeixinShopTempletEntitys) {
                        this.weixinShopTempletService.save(weixinShopTemplet);
                    }
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01");
                }
                catch (Exception e) {
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
                    logger.error((Object)ExceptionUtil.getExceptionMessage((Exception)e));
                    try {
                        file.getInputStream().close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                file.getInputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return j;
    }

    @RequestMapping(params={"downloadTemplate"})
    public void downloadTemplate(WeixinShopTempletEntity wixinShopTemplet, HttpServletRequest request, HttpServletResponse response) {
        wixinShopTemplet = (WeixinShopTempletEntity)this.systemService.get(WeixinShopTempletEntity.class, (Serializable)((Object)wixinShopTemplet.getId()));
        String path = "/template/shop/" + wixinShopTemplet.getTplpath();
        String sourceSrc = WeixinShopTempletController.tplRealPath(wixinShopTemplet);
        String downloadSrc = String.valueOf(sourceSrc) + ".zip";
        try {
            WeixinShopTempletController.compress(sourceSrc, downloadSrc);
            String fileName = String.valueOf(wixinShopTemplet.getTplpath()) + ".zip";
            response.reset();
            response.setContentType("APPLICATION/OCTET-STREAM");
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setHeader("Content-disposition", "attachment;filename=" + new String(fileName.getBytes("utf-8"), "ISO8859-1"));
            FileInputStream inStream = new FileInputStream(downloadSrc);
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = ((InputStream)inStream).read(buffer, 0, 8192)) != -1) {
                ((OutputStream)out).write(buffer, 0, bytesRead);
            }
            ((OutputStream)out).write(buffer);
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
            ((InputStream)inStream).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void compress(String source, String destinct) throws IOException {
        List fileList = WeixinShopTempletController.loadFilename(new File(source));
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(new File(destinct)));
        byte[] buffere = new byte[8192];
        int i = 0;
        while (i < fileList.size()) {
            int length;
            File file = (File)fileList.get(i);
            zos.putNextEntry((java.util.zip.ZipEntry)new ZipEntry(WeixinShopTempletController.getEntryName(source, file)));
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            while ((length = bis.read(buffere)) != -1) {
                zos.write(buffere, 0, length);
            }
            bis.close();
            zos.closeEntry();
            ++i;
        }
        zos.close();
    }

    private static String getEntryName(String base, File file) {
        File baseFile = new File(base);
        String filename = file.getPath();
        String entryName = null;
        entryName = baseFile.getParentFile().getParentFile() == null ? filename.substring(baseFile.getParent().length()) : filename.substring(baseFile.getParent().length() + 1);
        int pos = entryName.indexOf(System.getProperty("file.separator"));
        if (pos != -1) {
            entryName = entryName.substring(pos + 1, entryName.length());
        }
        return entryName;
    }

    private static List loadFilename(File file) {
        ArrayList<File> filenameList = new ArrayList<File>();
        if (file.isFile()) {
            filenameList.add(file);
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                filenameList.addAll(WeixinShopTempletController.loadFilename(f));
                ++n2;
            }
        }
        return filenameList;
    }
}

