/*
 * Decompiled with CFR 0.152.
 */
package weixin.shop.base.controller;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.BrowserUtils;
import org.jeecgframework.core.util.ExceptionUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExcelTitle;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import weixin.shop.base.entity.WeixinShopSellerEntity;
import weixin.shop.base.entity.WeixinShopTempletEntity;
import weixin.shop.base.service.WeixinShopSellerServiceI;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/weixinShopSellerController"})
public class WeixinShopSellerController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinShopSellerController.class);
    @Autowired
    private WeixinShopSellerServiceI weixinShopSellerService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"weixinShopSeller"})
    public ModelAndView weixinShopSeller(HttpServletRequest request) {
        return new ModelAndView("weixin/shop/base/weixinShopSellerList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeixinShopSellerEntity weixinShopSeller, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinShopSellerEntity.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinShopSeller, (Map)request.getParameterMap());
        try {
            cq.eq("accountId", (Object)ResourceUtil.getShangJiaAccountId());
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        cq.add();
        this.weixinShopSellerService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(WeixinShopSellerEntity weixinShopSeller, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinShopSeller = (WeixinShopSellerEntity)this.systemService.getEntity(WeixinShopSellerEntity.class, (Serializable)((Object)weixinShopSeller.getId()));
        this.message = "weixin_shop_seller\u5220\u9664\u6210\u529f";
        try {
            this.weixinShopSellerService.delete(weixinShopSeller);
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "weixin_shop_seller\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "weixin_shop_seller\u5220\u9664\u6210\u529f";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                WeixinShopSellerEntity weixinShopSeller = (WeixinShopSellerEntity)this.systemService.getEntity(WeixinShopSellerEntity.class, (Serializable)((Object)id));
                this.weixinShopSellerService.delete(weixinShopSeller);
                this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "weixin_shop_seller\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(WeixinShopSellerEntity weixinShopSeller, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "weixin_shop_seller\u6dfb\u52a0\u6210\u529f";
        try {
            weixinShopSeller.setAccountId(ResourceUtil.getShangJiaAccountId());
            if (oConvertUtils.isEmpty((Object)weixinShopSeller.getShoptpl()) || oConvertUtils.isEmpty((Object)weixinShopSeller.getShoptpl().getId())) {
                weixinShopSeller.setShoptpl(null);
            }
            this.weixinShopSellerService.save(weixinShopSeller);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "weixin_shop_seller\u6dfb\u52a0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doUpdate"})
    @ResponseBody
    public AjaxJson doUpdate(WeixinShopSellerEntity weixinShopSeller, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "weixin_shop_seller\u66f4\u65b0\u6210\u529f";
        WeixinShopSellerEntity t = (WeixinShopSellerEntity)this.weixinShopSellerService.get(WeixinShopSellerEntity.class, (Serializable)((Object)weixinShopSeller.getId()));
        try {
            MyBeanUtils.copyBeanNotNull2Bean((Object)weixinShopSeller, (Object)t);
            if (oConvertUtils.isEmpty((Object)t.getShoptpl()) || oConvertUtils.isEmpty((Object)t.getShoptpl().getId())) {
                t.setShoptpl(null);
            }
            this.weixinShopSellerService.saveOrUpdate(t);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "weixin_shop_seller\u66f4\u65b0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(WeixinShopSellerEntity weixinShopSeller, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinShopSeller.getId())) {
            weixinShopSeller = (WeixinShopSellerEntity)this.weixinShopSellerService.getEntity(WeixinShopSellerEntity.class, (Serializable)((Object)weixinShopSeller.getId()));
            req.setAttribute("weixinShopSellerPage", (Object)weixinShopSeller);
        }
        ArrayList sharetemplateList = this.systemService.findHql("from WeixinShopTempletEntity where publiced=1 and tpltype=1", null);
        ArrayList selfttemplateList = this.systemService.findHql("from WeixinShopTempletEntity where accountid=? and tpltype=1", new Object[]{ResourceUtil.getShangJiaAccountId()});
        if (oConvertUtils.isEmpty((Object)sharetemplateList)) {
            sharetemplateList = new ArrayList();
        }
        if (oConvertUtils.isEmpty((Object)selfttemplateList)) {
            selfttemplateList = new ArrayList();
        }
        sharetemplateList.addAll(selfttemplateList);
        ArrayList<WeixinShopTempletEntity> templateList = new ArrayList<WeixinShopTempletEntity>();
        HashMap<String, String> container = new HashMap<String, String>();
        for (WeixinShopTempletEntity tpl : sharetemplateList) {
            if (container.containsKey(tpl.getId())) continue;
            container.put(tpl.getId(), "1");
            templateList.add(tpl);
        }
        req.setAttribute("templateList", templateList);
        return new ModelAndView("weixin/shop/base/weixinShopSeller-add");
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(WeixinShopSellerEntity weixinShopSeller, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinShopSeller.getId())) {
            weixinShopSeller = (WeixinShopSellerEntity)this.weixinShopSellerService.getEntity(WeixinShopSellerEntity.class, (Serializable)((Object)weixinShopSeller.getId()));
            req.setAttribute("weixinShopSellerPage", (Object)weixinShopSeller);
        }
        ArrayList sharetemplateList = this.systemService.findHql("from WeixinShopTempletEntity where publiced=1 and tpltype=1", null);
        ArrayList selfttemplateList = this.systemService.findHql("from WeixinShopTempletEntity where accountid=? and tpltype=1", new Object[]{ResourceUtil.getShangJiaAccountId()});
        if (oConvertUtils.isEmpty((Object)sharetemplateList)) {
            sharetemplateList = new ArrayList();
        }
        if (oConvertUtils.isEmpty((Object)selfttemplateList)) {
            selfttemplateList = new ArrayList();
        }
        sharetemplateList.addAll(selfttemplateList);
        ArrayList<WeixinShopTempletEntity> templateList = new ArrayList<WeixinShopTempletEntity>();
        HashMap<String, String> container = new HashMap<String, String>();
        for (WeixinShopTempletEntity tpl : sharetemplateList) {
            if (container.containsKey(tpl.getId())) continue;
            container.put(tpl.getId(), "1");
            templateList.add(tpl);
        }
        req.setAttribute("templateList", templateList);
        return new ModelAndView("weixin/shop/base/weixinShopSeller-update");
    }

    @RequestMapping(params={"upload"})
    public ModelAndView upload(HttpServletRequest req) {
        return new ModelAndView("weixin/shop/base/weixinShopSellerUpload");
    }

    @RequestMapping(params={"exportXls"})
    public void exportXls(WeixinShopSellerEntity weixinShopSeller, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "weixin_shop_seller";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                CriteriaQuery cq = new CriteriaQuery(WeixinShopSellerEntity.class, dataGrid);
                HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinShopSeller, (Map)request.getParameterMap());
                List weixinShopSellers = this.weixinShopSellerService.getListByCriteriaQuery(cq, false);
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("weixin_shop_seller\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WeixinShopSellerEntity.class, (Collection)weixinShopSellers);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"exportXlsByT"})
    public void exportXlsByT(WeixinShopSellerEntity weixinShopSeller, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "weixin_shop_seller";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("weixin_shop_seller\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WeixinShopSellerEntity.class, null);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"importExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson importExcel(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setSecondTitleRows(1);
            params.setNeedSave(true);
            try {
                try {
                    List listWeixinShopSellerEntitys = (List)ExcelImportUtil.importExcelByIs((InputStream)file.getInputStream(), WeixinShopSellerEntity.class, (ImportParams)params);
                    for (WeixinShopSellerEntity weixinShopSeller : listWeixinShopSellerEntitys) {
                        this.weixinShopSellerService.save(weixinShopSeller);
                    }
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01");
                }
                catch (Exception e) {
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
                    logger.error((Object)ExceptionUtil.getExceptionMessage((Exception)e));
                    try {
                        file.getInputStream().close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                file.getInputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return j;
    }
}

