/*
 * Decompiled with CFR 0.152.
 */
package weixin.shop.base.controller;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.common.UploadFile;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.BrowserUtils;
import org.jeecgframework.core.util.ExceptionUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.MyClassLoader;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExcelTitle;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.tag.vo.datatable.SortDirection;
import org.jeecgframework.web.system.pojo.base.TSDocument;
import org.jeecgframework.web.system.pojo.base.TSType;
import org.jeecgframework.web.system.pojo.base.TSTypegroup;
import org.jeecgframework.web.system.pojo.base.TSUser;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import weixin.shop.base.entity.WeixinShopCartEntity;
import weixin.shop.base.entity.WeixinShopIntegralGoodsEntity;
import weixin.shop.base.service.WeixinShopIntegralGoodsServiceI;
import weixin.util.DateUtils;

@Controller
@RequestMapping(value={"/weixinShopIntegralGoodsController"})
public class WeixinShopIntegralGoodsController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinShopIntegralGoodsController.class);
    @Autowired
    private WeixinShopIntegralGoodsServiceI weixinShopIntegralGoodsService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"weixinShopIntegralGoods"})
    public ModelAndView weixinShopIntegralGoods(HttpServletRequest request) {
        return new ModelAndView("weixin/shop/base/weixinShopIntegralGoodsList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeixinShopIntegralGoodsEntity weixinShopIntegralGoods, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinShopIntegralGoodsEntity.class, dataGrid);
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        cq.addOrder("createDate", SortDirection.desc);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinShopIntegralGoods, (Map)request.getParameterMap());
        cq.add();
        this.weixinShopIntegralGoodsService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(WeixinShopIntegralGoodsEntity weixinShopIntegralGoods, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinShopIntegralGoods = (WeixinShopIntegralGoodsEntity)this.systemService.getEntity(WeixinShopIntegralGoodsEntity.class, (Serializable)((Object)weixinShopIntegralGoods.getId()));
        this.message = "\u5546\u54c1\u4fe1\u606f\u5220\u9664\u6210\u529f";
        try {
            this.weixinShopIntegralGoodsService.delete(weixinShopIntegralGoods);
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5546\u54c1\u4fe1\u606f\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u5546\u54c1\u4fe1\u606f\u5220\u9664\u6210\u529f,\u90e8\u5206\u5546\u54c1\u53ef\u80fd\u5df2\u7ecf\u4e0b\u5355\uff0c\u4e0d\u80fd\u5220\u9664\u3002";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                WeixinShopIntegralGoodsEntity weixinShopIntegralGoods = (WeixinShopIntegralGoodsEntity)this.systemService.getEntity(WeixinShopIntegralGoodsEntity.class, (Serializable)((Object)id));
                List cartlist = this.systemService.findByProperty(WeixinShopCartEntity.class, "shopGoodsEntity.id", (Object)id);
                this.systemService.deleteAllEntitie((Collection)cartlist);
                this.weixinShopIntegralGoodsService.delete(weixinShopIntegralGoods);
                this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5546\u54c1\u4fe1\u606f\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(WeixinShopIntegralGoodsEntity weixinShopIntegralGoods, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u5546\u54c1\u4fe1\u606f\u6dfb\u52a0\u6210\u529f";
        try {
            TSUser user = ResourceUtil.getSessionUserName();
            weixinShopIntegralGoods.setSellerId(user.getId());
            weixinShopIntegralGoods.setStatement("0");
            weixinShopIntegralGoods.setGoodCount(0);
            weixinShopIntegralGoods.setDiscussCount(0);
            weixinShopIntegralGoods.setSellCount(0);
            weixinShopIntegralGoods.setBadCount(0);
            this.weixinShopIntegralGoodsService.save(weixinShopIntegralGoods);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5546\u54c1\u4fe1\u606f\u6dfb\u52a0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doUpdate"})
    @ResponseBody
    public AjaxJson doUpdate(WeixinShopIntegralGoodsEntity weixinShopIntegralGoods, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u5546\u54c1\u4fe1\u606f\u66f4\u65b0\u6210\u529f";
        WeixinShopIntegralGoodsEntity t = (WeixinShopIntegralGoodsEntity)this.weixinShopIntegralGoodsService.get(WeixinShopIntegralGoodsEntity.class, (Serializable)((Object)weixinShopIntegralGoods.getId()));
        try {
            t.setMaxcount(weixinShopIntegralGoods.getMaxcount());
            t.setNeedintegral(weixinShopIntegralGoods.getNeedintegral());
            MyBeanUtils.copyBeanNotNull2Bean((Object)weixinShopIntegralGoods, (Object)t);
            this.weixinShopIntegralGoodsService.saveOrUpdate(t);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5546\u54c1\u4fe1\u606f\u66f4\u65b0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(WeixinShopIntegralGoodsEntity weixinShopIntegralGoods, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinShopIntegralGoods.getId())) {
            weixinShopIntegralGoods = (WeixinShopIntegralGoodsEntity)this.weixinShopIntegralGoodsService.getEntity(WeixinShopIntegralGoodsEntity.class, (Serializable)((Object)weixinShopIntegralGoods.getId()));
            req.setAttribute("weixinShopIntegralGoodsPage", (Object)weixinShopIntegralGoods);
        }
        return new ModelAndView("weixin/shop/base/weixinShopIntegralGoods-add");
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(WeixinShopIntegralGoodsEntity weixinShopIntegralGoods, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinShopIntegralGoods.getId())) {
            weixinShopIntegralGoods = (WeixinShopIntegralGoodsEntity)this.weixinShopIntegralGoodsService.getEntity(WeixinShopIntegralGoodsEntity.class, (Serializable)((Object)weixinShopIntegralGoods.getId()));
            req.setAttribute("weixinShopIntegralGoodsPage", (Object)weixinShopIntegralGoods);
        }
        return new ModelAndView("weixin/shop/base/weixinShopIntegralGoods-update");
    }

    @RequestMapping(params={"upload"})
    public ModelAndView upload(HttpServletRequest req) {
        return new ModelAndView("weixin/shop/base/weixinShopIntegralGoodsUpload");
    }

    @RequestMapping(params={"exportXls"})
    public void exportXls(WeixinShopIntegralGoodsEntity weixinShopIntegralGoods, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u5546\u54c1\u4fe1\u606f";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                CriteriaQuery cq = new CriteriaQuery(WeixinShopIntegralGoodsEntity.class, dataGrid);
                HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinShopIntegralGoods, (Map)request.getParameterMap());
                List weixinShopIntegralGoodss = this.weixinShopIntegralGoodsService.getListByCriteriaQuery(cq, false);
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("\u5546\u54c1\u4fe1\u606f\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WeixinShopIntegralGoodsEntity.class, (Collection)weixinShopIntegralGoodss);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"exportXlsByT"})
    public void exportXlsByT(WeixinShopIntegralGoodsEntity weixinShopIntegralGoods, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u5546\u54c1\u4fe1\u606f";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("\u5546\u54c1\u4fe1\u606f\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WeixinShopIntegralGoodsEntity.class, null);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"importExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson importExcel(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setSecondTitleRows(1);
            params.setNeedSave(true);
            try {
                try {
                    List listWeixinShopIntegralGoodsEntitys = (List)ExcelImportUtil.importExcelByIs((InputStream)file.getInputStream(), WeixinShopIntegralGoodsEntity.class, (ImportParams)params);
                    for (WeixinShopIntegralGoodsEntity weixinShopIntegralGoods : listWeixinShopIntegralGoodsEntitys) {
                        this.weixinShopIntegralGoodsService.save(weixinShopIntegralGoods);
                    }
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01");
                }
                catch (Exception e) {
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
                    logger.error((Object)ExceptionUtil.getExceptionMessage((Exception)e));
                    try {
                        file.getInputStream().close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                file.getInputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return j;
    }

    @RequestMapping(params={"upload"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson upload(MultipartHttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        HashMap<String, String> attributes = new HashMap<String, String>();
        TSTypegroup tsTypegroup = this.systemService.getTypeGroup("fieltype", "\u6587\u6863\u5206\u7c7b");
        TSType tsType = this.systemService.getType("files", "\u9644\u4ef6", tsTypegroup);
        String fileKey = oConvertUtils.getString((String)request.getParameter("fileKey"));
        String documentTitle = oConvertUtils.getString((String)request.getParameter("documentTitle"));
        TSDocument document = new TSDocument();
        if (StringUtil.isNotEmpty((Object)fileKey)) {
            document.setId(fileKey);
            document = (TSDocument)this.systemService.getEntity(TSDocument.class, (Serializable)((Object)fileKey));
            document.setDocumentTitle(documentTitle);
        }
        document.setSubclassname(MyClassLoader.getPackPath((Object)document));
        document.setCreatedate(DateUtils.gettimestamp());
        document.setTSType(tsType);
        UploadFile uploadFile = new UploadFile((HttpServletRequest)request, (Object)document);
        uploadFile.setCusPath("files");
        uploadFile.setSwfpath("swfpath");
        document = (TSDocument)this.systemService.uploadFile(uploadFile);
        attributes.put("url", document.getRealpath());
        attributes.put("fileKey", document.getId());
        attributes.put("name", document.getAttachmenttitle());
        attributes.put("viewhref", "commonController.do?openViewFile&fileid=" + document.getId());
        attributes.put("delurl", "commonController.do?delObjFile&fileKey=" + document.getId());
        j.setMsg("\u6587\u4ef6\u6dfb\u52a0\u6210\u529f");
        j.setAttributes(attributes);
        return j;
    }
}

