/*
 * Decompiled with CFR 0.152.
 */
package weixin.shop.base.controller;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.BrowserUtils;
import org.jeecgframework.core.util.ExceptionUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExcelTitle;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import weixin.shop.base.entity.WeixinShopGoodsAttentionEntity;
import weixin.shop.base.service.WeixinShopGoodsAttentionServiceI;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/weixinShopGoodsAttentionController"})
public class WeixinShopGoodsAttentionController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinShopGoodsAttentionController.class);
    @Autowired
    private WeixinShopGoodsAttentionServiceI weixinShopGoodsAttentionService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"weixinShopGoodsAttention"})
    public ModelAndView weixinShopGoodsAttention(HttpServletRequest request) {
        return new ModelAndView("weixin/shop/base/weixinShopGoodsAttentionList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeixinShopGoodsAttentionEntity weixinShopGoodsAttention, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinShopGoodsAttentionEntity.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinShopGoodsAttention, (Map)request.getParameterMap());
        cq.add();
        this.weixinShopGoodsAttentionService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(WeixinShopGoodsAttentionEntity weixinShopGoodsAttention, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinShopGoodsAttention = (WeixinShopGoodsAttentionEntity)this.systemService.getEntity(WeixinShopGoodsAttentionEntity.class, (Serializable)((Object)weixinShopGoodsAttention.getId()));
        this.message = "weixin_shop_goods_attention\u5220\u9664\u6210\u529f";
        try {
            this.weixinShopGoodsAttentionService.delete(weixinShopGoodsAttention);
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "weixin_shop_goods_attention\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "weixin_shop_goods_attention\u5220\u9664\u6210\u529f";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                WeixinShopGoodsAttentionEntity weixinShopGoodsAttention = (WeixinShopGoodsAttentionEntity)this.systemService.getEntity(WeixinShopGoodsAttentionEntity.class, (Serializable)((Object)id));
                this.weixinShopGoodsAttentionService.delete(weixinShopGoodsAttention);
                this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "weixin_shop_goods_attention\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(WeixinShopGoodsAttentionEntity weixinShopGoodsAttention, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "weixin_shop_goods_attention\u6dfb\u52a0\u6210\u529f";
        try {
            this.weixinShopGoodsAttentionService.save(weixinShopGoodsAttention);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "weixin_shop_goods_attention\u6dfb\u52a0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doAttention"})
    @ResponseBody
    public AjaxJson doAttention(@RequestParam(value="goodsIds[]") String[] goodsIds, Integer type, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String openid = ResourceUtil.getUserOpenId();
        this.message = "\u6210\u529f";
        try {
            WeixinShopGoodsAttentionEntity weixinShopGoodsAttention = null;
            if (!oConvertUtils.isEmpty((Object)goodsIds) && goodsIds.length > 0) {
                int len = goodsIds.length;
                Date time = new Date();
                List list = null;
                int i = 0;
                while (i < len) {
                    if (type == 1) {
                        this.message = "\u4e00\u952e\u5173\u6ce8\u6210\u529f";
                        list = this.weixinShopGoodsAttentionService.findHql("from WeixinShopGoodsAttentionEntity where goodsid=? and openid=?", new Object[]{goodsIds[i], openid});
                        if (oConvertUtils.isEmpty((Object)list) || list.size() < 1) {
                            weixinShopGoodsAttention = new WeixinShopGoodsAttentionEntity();
                            weixinShopGoodsAttention.setAttentiontime(time);
                            weixinShopGoodsAttention.setGoodsid(goodsIds[i]);
                            weixinShopGoodsAttention.setOpenid(openid);
                            this.weixinShopGoodsAttentionService.save(weixinShopGoodsAttention);
                        }
                    } else {
                        this.message = "\u4e00\u952e\u53d6\u6d88\u6210\u529f";
                        this.weixinShopGoodsAttentionService.executeSql("delete from weixin_shop_goods_attention where openid=? and goodsid=? ", new Object[]{openid, goodsIds[i]});
                    }
                    ++i;
                }
            }
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u4e00\u952e\u5173\u6ce8\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doUpdate"})
    @ResponseBody
    public AjaxJson doUpdate(WeixinShopGoodsAttentionEntity weixinShopGoodsAttention, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "weixin_shop_goods_attention\u66f4\u65b0\u6210\u529f";
        WeixinShopGoodsAttentionEntity t = (WeixinShopGoodsAttentionEntity)this.weixinShopGoodsAttentionService.get(WeixinShopGoodsAttentionEntity.class, (Serializable)((Object)weixinShopGoodsAttention.getId()));
        try {
            MyBeanUtils.copyBeanNotNull2Bean((Object)weixinShopGoodsAttention, (Object)t);
            this.weixinShopGoodsAttentionService.saveOrUpdate(t);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "weixin_shop_goods_attention\u66f4\u65b0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(WeixinShopGoodsAttentionEntity weixinShopGoodsAttention, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinShopGoodsAttention.getId())) {
            weixinShopGoodsAttention = (WeixinShopGoodsAttentionEntity)this.weixinShopGoodsAttentionService.getEntity(WeixinShopGoodsAttentionEntity.class, (Serializable)((Object)weixinShopGoodsAttention.getId()));
            req.setAttribute("weixinShopGoodsAttentionPage", (Object)weixinShopGoodsAttention);
        }
        return new ModelAndView("weixin/shop/base/weixinShopGoodsAttention-add");
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(WeixinShopGoodsAttentionEntity weixinShopGoodsAttention, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinShopGoodsAttention.getId())) {
            weixinShopGoodsAttention = (WeixinShopGoodsAttentionEntity)this.weixinShopGoodsAttentionService.getEntity(WeixinShopGoodsAttentionEntity.class, (Serializable)((Object)weixinShopGoodsAttention.getId()));
            req.setAttribute("weixinShopGoodsAttentionPage", (Object)weixinShopGoodsAttention);
        }
        return new ModelAndView("weixin/shop/base/weixinShopGoodsAttention-update");
    }

    @RequestMapping(params={"upload"})
    public ModelAndView upload(HttpServletRequest req) {
        return new ModelAndView("weixin/shop/base/weixinShopGoodsAttentionUpload");
    }

    @RequestMapping(params={"exportXls"})
    public void exportXls(WeixinShopGoodsAttentionEntity weixinShopGoodsAttention, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "weixin_shop_goods_attention";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                CriteriaQuery cq = new CriteriaQuery(WeixinShopGoodsAttentionEntity.class, dataGrid);
                HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinShopGoodsAttention, (Map)request.getParameterMap());
                List weixinShopGoodsAttentions = this.weixinShopGoodsAttentionService.getListByCriteriaQuery(cq, false);
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("weixin_shop_goods_attention\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WeixinShopGoodsAttentionEntity.class, (Collection)weixinShopGoodsAttentions);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"exportXlsByT"})
    public void exportXlsByT(WeixinShopGoodsAttentionEntity weixinShopGoodsAttention, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "weixin_shop_goods_attention";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("weixin_shop_goods_attention\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WeixinShopGoodsAttentionEntity.class, null);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"importExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson importExcel(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setSecondTitleRows(1);
            params.setNeedSave(true);
            try {
                try {
                    List listWeixinShopGoodsAttentionEntitys = (List)ExcelImportUtil.importExcelByIs((InputStream)file.getInputStream(), WeixinShopGoodsAttentionEntity.class, (ImportParams)params);
                    for (WeixinShopGoodsAttentionEntity weixinShopGoodsAttention : listWeixinShopGoodsAttentionEntitys) {
                        this.weixinShopGoodsAttentionService.save(weixinShopGoodsAttention);
                    }
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01");
                }
                catch (Exception e) {
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
                    logger.error((Object)ExceptionUtil.getExceptionMessage((Exception)e));
                    try {
                        file.getInputStream().close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                file.getInputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return j;
    }
}

