/*
 * Decompiled with CFR 0.152.
 */
package weixin.shop.base.controller;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.common.UploadFile;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.ComboTree;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.common.model.json.TreeGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.BrowserUtils;
import org.jeecgframework.core.util.ExceptionUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.MyClassLoader;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExcelTitle;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.tag.vo.datatable.SortDirection;
import org.jeecgframework.tag.vo.easyui.TreeGridModel;
import org.jeecgframework.web.system.pojo.base.TSDocument;
import org.jeecgframework.web.system.pojo.base.TSType;
import org.jeecgframework.web.system.pojo.base.TSTypegroup;
import org.jeecgframework.web.system.pojo.base.TSUser;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import weixin.shop.base.entity.WeixinShopCategoryEntity;
import weixin.shop.base.service.WeixinShopCategoryServiceI;
import weixin.shop.base.service.WeixinShopGoodsServiceI;
import weixin.util.DateUtils;

@Controller
@RequestMapping(value={"/weixinShopCategoryController"})
public class WeixinShopCategoryController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinShopCategoryController.class);
    @Autowired
    private WeixinShopCategoryServiceI weixinShopCategoryService;
    @Autowired
    private WeixinShopGoodsServiceI weixinShopGoodsService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"weixinShopCategory"})
    public ModelAndView weixinShopCategory(HttpServletRequest request) {
        return new ModelAndView("weixin/shop/base/weixinShopCategoryList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeixinShopCategoryEntity weixinShopCategory, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinShopCategoryEntity.class, dataGrid);
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        cq.addOrder("createDate", SortDirection.desc);
        cq.add();
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinShopCategory, (Map)request.getParameterMap());
        this.weixinShopCategoryService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"treedatagrid"})
    @ResponseBody
    public List<TreeGrid> treedatagrid(WeixinShopCategoryEntity weixinShopCategory, HttpServletRequest request, HttpServletResponse response, TreeGrid treegrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinShopCategoryEntity.class);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)request.getParameterMap());
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        if (treegrid.getId() != null) {
            cq.eq("weixinShopCategoryEntity.id", (Object)treegrid.getId());
        } else {
            cq.isNull("weixinShopCategoryEntity");
        }
        cq.add();
        List menuList = this.systemService.getListByCriteriaQuery(cq, Boolean.valueOf(false));
        ArrayList<TreeGrid> treeGrids = new ArrayList();
        TreeGridModel treeGridModel = new TreeGridModel();
        treeGridModel.setTextField("name");
        treeGridModel.setParentText("weixinShopCategoryEntity.name");
        treeGridModel.setParentId("pmeweixinShopCategoryEntity.id");
        treeGridModel.setSrc("imgurl");
        treeGridModel.setIdField("id");
        treeGridModel.setChildList("categoryList");
        treeGrids = this.systemService.treegrid(menuList, treeGridModel);
        return treeGrids;
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(WeixinShopCategoryEntity weixinShopCategory, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String sql = "select count(1) from weixin_shop_goods where CATEGORY_ID='" + weixinShopCategory.getId() + "'";
        Long count = this.systemService.getCountForJdbc(sql);
        if (oConvertUtils.isNotEmpty((Object)count) && count != 0L) {
            this.message = "\u6b64\u7c7b\u522b\u6709\u5546\u54c1\uff0c\u4e0d\u5141\u8bb8\u5220\u9664";
        } else {
            this.message = "\u5546\u54c1\u5206\u7c7b\u5220\u9664\u6210\u529f";
            try {
                weixinShopCategory = (WeixinShopCategoryEntity)this.systemService.getEntity(WeixinShopCategoryEntity.class, (Serializable)((Object)weixinShopCategory.getId()));
                this.weixinShopCategoryService.delete(weixinShopCategory);
                this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u5546\u54c1\u5206\u7c7b\u5220\u9664\u5931\u8d25";
                throw new BusinessException(e.getMessage());
            }
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u5546\u54c1\u5206\u7c7b\u5220\u9664\u6210\u529f";
        try {
            String nameStrTemp = "";
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                WeixinShopCategoryEntity weixinShopCategory = (WeixinShopCategoryEntity)this.systemService.getEntity(WeixinShopCategoryEntity.class, (Serializable)((Object)id));
                String sql = "select count(1) from weixin_shop_goods where CATEGORY_ID='" + id + "'";
                Long count = this.systemService.getCountForJdbc(sql);
                if (oConvertUtils.isNotEmpty((Object)count) && count != 0L) {
                    nameStrTemp = String.valueOf(nameStrTemp) + weixinShopCategory.getName() + ",";
                } else {
                    this.weixinShopCategoryService.delete(weixinShopCategory);
                    this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                }
                ++n2;
            }
            this.message = String.valueOf(nameStrTemp.substring(0, nameStrTemp.length() - 1)) + "\u6709\u5546\u54c1\uff0c\u4e0d\u5141\u8bb8\u5220\u9664,\u5176\u4f59\u5220\u9664\u6210\u529f";
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5546\u54c1\u5206\u7c7b\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(WeixinShopCategoryEntity weixinShopCategory, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u5546\u54c1\u5206\u7c7b\u6dfb\u52a0\u6210\u529f";
        try {
            TSUser user = ResourceUtil.getSessionUserName();
            weixinShopCategory.setSellerId(user.getId());
            if (oConvertUtils.isEmpty((Object)weixinShopCategory.getWeixinShopCategoryEntity()) || oConvertUtils.isEmpty((Object)weixinShopCategory.getWeixinShopCategoryEntity().getId())) {
                weixinShopCategory.setWeixinShopCategoryEntity(null);
            }
            this.weixinShopCategoryService.save(weixinShopCategory);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5546\u54c1\u5206\u7c7b\u6dfb\u52a0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doUpdate"})
    @ResponseBody
    public AjaxJson doUpdate(WeixinShopCategoryEntity weixinShopCategory, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u5546\u54c1\u5206\u7c7b\u66f4\u65b0\u6210\u529f";
        WeixinShopCategoryEntity t = (WeixinShopCategoryEntity)this.weixinShopCategoryService.get(WeixinShopCategoryEntity.class, (Serializable)((Object)weixinShopCategory.getId()));
        try {
            if (oConvertUtils.isEmpty((Object)weixinShopCategory.getWeixinShopCategoryEntity()) || oConvertUtils.isEmpty((Object)weixinShopCategory.getWeixinShopCategoryEntity().getId())) {
                weixinShopCategory.setWeixinShopCategoryEntity(null);
            }
            MyBeanUtils.copyBeanNotNull2Bean((Object)weixinShopCategory, (Object)t);
            if (oConvertUtils.isEmpty((Object)weixinShopCategory.getWeixinShopCategoryEntity()) || oConvertUtils.isEmpty((Object)weixinShopCategory.getWeixinShopCategoryEntity().getId())) {
                t.setWeixinShopCategoryEntity(null);
            }
            this.weixinShopCategoryService.saveOrUpdate(t);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5546\u54c1\u5206\u7c7b\u66f4\u65b0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(WeixinShopCategoryEntity weixinShopCategory, HttpServletRequest req) {
        if (weixinShopCategory.getWeixinShopCategoryEntity() != null && weixinShopCategory.getWeixinShopCategoryEntity().getId() != null) {
            weixinShopCategory.setWeixinShopCategoryEntity((WeixinShopCategoryEntity)this.weixinShopCategoryService.getEntity(WeixinShopCategoryEntity.class, (Serializable)((Object)weixinShopCategory.getWeixinShopCategoryEntity().getId())));
            req.setAttribute("weixinShopCategoryPage", (Object)weixinShopCategory);
        }
        if (StringUtil.isNotEmpty((Object)weixinShopCategory.getId())) {
            weixinShopCategory = (WeixinShopCategoryEntity)this.weixinShopCategoryService.getEntity(WeixinShopCategoryEntity.class, (Serializable)((Object)weixinShopCategory.getId()));
            req.setAttribute("weixinShopCategoryPage", (Object)weixinShopCategory);
        }
        return new ModelAndView("weixin/shop/base/weixinShopCategory-add");
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(WeixinShopCategoryEntity weixinShopCategory, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinShopCategory.getId())) {
            if ((weixinShopCategory = (WeixinShopCategoryEntity)this.weixinShopCategoryService.getEntity(WeixinShopCategoryEntity.class, (Serializable)((Object)weixinShopCategory.getId()))).getWeixinShopCategoryEntity() != null && weixinShopCategory.getWeixinShopCategoryEntity().getId() != null) {
                weixinShopCategory.setWeixinShopCategoryEntity((WeixinShopCategoryEntity)this.weixinShopCategoryService.getEntity(WeixinShopCategoryEntity.class, (Serializable)((Object)weixinShopCategory.getWeixinShopCategoryEntity().getId())));
            }
            req.setAttribute("weixinShopCategoryPage", (Object)weixinShopCategory);
        }
        return new ModelAndView("weixin/shop/base/weixinShopCategory-update");
    }

    @RequestMapping(params={"upload"})
    public ModelAndView upload(HttpServletRequest req) {
        return new ModelAndView("weixin/shop/base/weixinShopCategoryUpload");
    }

    @RequestMapping(params={"exportXls"})
    public void exportXls(WeixinShopCategoryEntity weixinShopCategory, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u5546\u54c1\u5206\u7c7b";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                CriteriaQuery cq = new CriteriaQuery(WeixinShopCategoryEntity.class, dataGrid);
                HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinShopCategory, (Map)request.getParameterMap());
                List weixinShopCategorys = this.weixinShopCategoryService.getListByCriteriaQuery(cq, false);
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("\u5546\u54c1\u5206\u7c7b\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WeixinShopCategoryEntity.class, (Collection)weixinShopCategorys);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"exportXlsByT"})
    public void exportXlsByT(WeixinShopCategoryEntity weixinShopCategory, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u5546\u54c1\u5206\u7c7b";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("\u5546\u54c1\u5206\u7c7b\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WeixinShopCategoryEntity.class, null);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"importExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson importExcel(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setSecondTitleRows(1);
            params.setNeedSave(true);
            try {
                try {
                    List listWeixinShopCategoryEntitys = (List)ExcelImportUtil.importExcelByIs((InputStream)file.getInputStream(), WeixinShopCategoryEntity.class, (ImportParams)params);
                    for (WeixinShopCategoryEntity weixinShopCategory : listWeixinShopCategoryEntitys) {
                        this.weixinShopCategoryService.save(weixinShopCategory);
                    }
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01");
                }
                catch (Exception e) {
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
                    logger.error((Object)ExceptionUtil.getExceptionMessage((Exception)e));
                    try {
                        file.getInputStream().close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                file.getInputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return j;
    }

    @RequestMapping(params={"upload"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson upload(MultipartHttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        HashMap<String, String> attributes = new HashMap<String, String>();
        TSTypegroup tsTypegroup = this.systemService.getTypeGroup("fieltype", "\u6587\u6863\u5206\u7c7b");
        TSType tsType = this.systemService.getType("files", "\u9644\u4ef6", tsTypegroup);
        String fileKey = oConvertUtils.getString((String)request.getParameter("fileKey"));
        String documentTitle = oConvertUtils.getString((String)request.getParameter("documentTitle"));
        TSDocument document = new TSDocument();
        if (StringUtil.isNotEmpty((Object)fileKey)) {
            document.setId(fileKey);
            document = (TSDocument)this.systemService.getEntity(TSDocument.class, (Serializable)((Object)fileKey));
            document.setDocumentTitle(documentTitle);
        }
        document.setSubclassname(MyClassLoader.getPackPath((Object)document));
        document.setCreatedate(DateUtils.gettimestamp());
        document.setTSType(tsType);
        UploadFile uploadFile = new UploadFile((HttpServletRequest)request, (Object)document);
        uploadFile.setCusPath("files");
        uploadFile.setSwfpath("swfpath");
        document = (TSDocument)this.systemService.uploadFile(uploadFile);
        attributes.put("url", document.getRealpath());
        attributes.put("fileKey", document.getId());
        attributes.put("name", document.getAttachmenttitle());
        attributes.put("viewhref", "commonController.do?openViewFile&fileid=" + document.getId());
        attributes.put("delurl", "commonController.do?delObjFile&fileKey=" + document.getId());
        j.setMsg("\u6587\u4ef6\u6dfb\u52a0\u6210\u529f");
        j.setAttributes(attributes);
        return j;
    }

    @RequestMapping(params={"treeCate"})
    @ResponseBody
    public List<TreeGrid> treeCate(HttpServletRequest request, ComboTree comboTree) {
        CriteriaQuery cq = new CriteriaQuery(WeixinShopCategoryEntity.class);
        ArrayList<WeixinShopCategoryEntity> menuList = null;
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        if (StringUtil.isNotEmpty((Object)comboTree.getId())) {
            cq.eq("weixinShopCategoryEntity.id", (Object)comboTree.getId());
            cq.add();
            menuList = this.systemService.getListByCriteriaQuery(cq, Boolean.valueOf(false));
        }
        if (StringUtil.isEmpty((String)comboTree.getId())) {
            List tmpList = null;
            cq.isNull("weixinShopCategoryEntity");
            cq.add();
            tmpList = this.systemService.getListByCriteriaQuery(cq, Boolean.valueOf(false));
            WeixinShopCategoryEntity defaultCate = new WeixinShopCategoryEntity();
            defaultCate.setName("\u8bf7\u9009\u62e9");
            menuList = new ArrayList<WeixinShopCategoryEntity>();
            menuList.add(defaultCate);
            if (oConvertUtils.isNotEmpty((Object)tmpList) && tmpList.size() > 0) {
                menuList.addAll(tmpList);
            }
        }
        ArrayList<TreeGrid> treeGrids = new ArrayList();
        TreeGridModel treeGridModel = new TreeGridModel();
        treeGridModel.setTextField("name");
        treeGridModel.setParentText("weixinShopCategoryEntity.name");
        treeGridModel.setParentId("pmeweixinShopCategoryEntity.id");
        treeGridModel.setSrc("imgurl");
        treeGridModel.setIdField("id");
        treeGridModel.setChildList("categoryList");
        treeGrids = this.systemService.treegrid(menuList, treeGridModel);
        return treeGrids;
    }
}

