/*
 * Decompiled with CFR 0.152.
 */
package weixin.shop.base.controller;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.pojo.base.TSUser;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.guanjia.account.entity.WeixinAccountEntity;
import weixin.shop.base.entity.WeixinShopCartEntity;
import weixin.shop.base.entity.WeixinShopGoodsEntity;
import weixin.shop.base.service.WeixinShopCartServiceI;

@Controller
@RequestMapping(value={"/weixinShopCartController"})
public class WeixinShopCartController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinShopCartController.class);
    @Autowired
    private WeixinShopCartServiceI weixinShopCartService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"weixinShopCart"})
    public ModelAndView weixinShopCart(HttpServletRequest request) {
        return new ModelAndView("weixin/shop/cart/weixinShopCartList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeixinShopCartEntity weixinShopCart, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinShopCartEntity.class, dataGrid);
        String accountid = ResourceUtil.getQianTaiAccountId();
        if (StringUtil.isNotEmpty((Object)accountid)) {
            cq.eq("accountid", (Object)accountid);
        }
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinShopCart, (Map)request.getParameterMap());
        this.weixinShopCartService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(WeixinShopCartEntity weixinShopCart, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinShopCart = (WeixinShopCartEntity)this.systemService.getEntity(WeixinShopCartEntity.class, (Serializable)((Object)weixinShopCart.getId()));
        this.message = "\u8d2d\u7269\u8f66 \u5220\u9664\u6210\u529f";
        this.weixinShopCartService.delete(weixinShopCart);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    public ModelAndView save(WeixinShopCartEntity weixinShopCart, HttpServletRequest request) {
        int buyNum = Integer.valueOf(request.getParameter("buyNum"));
        String goodsId = request.getParameter("goodsId");
        TSUser buyer = ResourceUtil.getSessionUserName();
        String buyId = buyer.getId();
        String accountid = ResourceUtil.getQianTaiAccountId();
        WeixinAccountEntity weixinAccount = ResourceUtil.getShangJiaAccount();
        String sellerId = "";
        if (weixinAccount != null) {
            TSUser seller = (TSUser)this.systemService.findUniqueByProperty(TSUser.class, "userName", (Object)weixinAccount.getUserName());
            sellerId = seller.getId();
            weixinShopCart.setSeller(seller);
        }
        LogUtil.info((Object)("....buyNum....." + buyNum + ".....goodsId....." + goodsId + "...buyId..." + buyId));
        WeixinShopGoodsEntity goodsEntity = (WeixinShopGoodsEntity)this.systemService.getEntity(WeixinShopGoodsEntity.class, (Serializable)((Object)goodsId));
        String hql = "from WeixinShopCartEntity where shopGoodsEntity.id='" + goodsId + "' and buyer.id='" + buyId + "' and seller.id='" + sellerId + "'";
        List shopCarList = this.weixinShopCartService.findByQueryString(hql);
        LogUtil.info((Object)("....size of shopCarList...." + shopCarList.size()));
        if (shopCarList.size() > 0) {
            weixinShopCart = (WeixinShopCartEntity)shopCarList.get(0);
            int count = weixinShopCart.getCount() + buyNum;
            weixinShopCart.setCount(count);
            double total = (double)count * goodsEntity.getRealPrice();
            weixinShopCart.setTotal(total);
            this.weixinShopCartService.updateEntitie(weixinShopCart);
        } else {
            double realPrice = goodsEntity.getRealPrice();
            weixinShopCart.setBuyPrice(realPrice);
            weixinShopCart.setCount(buyNum);
            weixinShopCart.setShopGoodsEntity(goodsEntity);
            weixinShopCart.setGoodsProperty("");
            weixinShopCart.setTotal(realPrice * (double)buyNum);
            weixinShopCart.setBuyer(buyer);
            weixinShopCart.setAccountid(accountid);
            this.weixinShopCartService.save(weixinShopCart);
        }
        List ShopCarList = this.systemService.findByProperty(WeixinShopCartEntity.class, "buser.id", (Object)buyId);
        double totalMoney = 0.0;
        for (WeixinShopCartEntity weixinShopCartEntity : ShopCarList) {
            totalMoney += weixinShopCartEntity.getTotal().doubleValue();
        }
        request.setAttribute("ShopCarList", (Object)ShopCarList);
        request.setAttribute("totalNum", (Object)ShopCarList.size());
        request.setAttribute("totalMoney", (Object)totalMoney);
        return new ModelAndView("weixin/shop/cart/weixinShopCart");
    }

    @RequestMapping(params={"judgeUserLogined"})
    @ResponseBody
    public AjaxJson judgeUserLogined(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        TSUser user = ResourceUtil.getSessionUserName();
        if (user == null) {
            j.setSuccess(false);
        }
        return j;
    }

    @RequestMapping(params={"addGoodsToCart"})
    @ResponseBody
    public AjaxJson addGoodsToCart(WeixinShopCartEntity weixinShopCart, HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        int buyNum = Integer.valueOf(request.getParameter("buyNum"));
        String goodsId = request.getParameter("goodsId");
        TSUser buyer = ResourceUtil.getSessionUserName();
        String buyId = buyer.getId();
        String accountid = ResourceUtil.getQianTaiAccountId();
        WeixinAccountEntity weixinAccount = ResourceUtil.getShangJiaAccount();
        String sellerId = "";
        if (weixinAccount != null) {
            TSUser seller = (TSUser)this.systemService.findUniqueByProperty(TSUser.class, "userName", (Object)weixinAccount.getUserName());
            sellerId = seller.getId();
            weixinShopCart.setSeller(seller);
        }
        LogUtil.info((Object)("....buyNum....." + buyNum + ".....goodsId....." + goodsId + "...buyId..." + buyId));
        WeixinShopGoodsEntity goodsEntity = (WeixinShopGoodsEntity)this.systemService.getEntity(WeixinShopGoodsEntity.class, (Serializable)((Object)goodsId));
        String hql = "from WeixinShopCartEntity where shopGoodsEntity.id='" + goodsId + "' and buyer.id='" + buyId + "' and seller.id='" + sellerId + "'";
        List shopCarList = this.weixinShopCartService.findByQueryString(hql);
        LogUtil.info((Object)("....size of shopCarList...." + shopCarList.size()));
        if (shopCarList.size() > 0) {
            weixinShopCart = (WeixinShopCartEntity)shopCarList.get(0);
            int count = weixinShopCart.getCount() + buyNum;
            weixinShopCart.setCount(count);
            double total = (double)count * goodsEntity.getRealPrice();
            LogUtil.info((Object)("...total..." + total));
            weixinShopCart.setTotal(total);
            this.weixinShopCartService.updateEntitie(weixinShopCart);
        } else {
            double realPrice = goodsEntity.getRealPrice();
            weixinShopCart.setBuyPrice(realPrice);
            weixinShopCart.setCount(buyNum);
            weixinShopCart.setShopGoodsEntity(goodsEntity);
            weixinShopCart.setGoodsProperty("");
            weixinShopCart.setTotal(realPrice * (double)buyNum);
            weixinShopCart.setBuyer(buyer);
            weixinShopCart.setAccountid(accountid);
            this.weixinShopCartService.save(weixinShopCart);
        }
        return j;
    }

    @RequestMapping(params={"goCart"})
    public ModelAndView goCart(WeixinShopCartEntity weixinShopCart, HttpServletRequest req) {
        String accountid = ResourceUtil.getQianTaiAccountId();
        WeixinAccountEntity weixinAccount = ResourceUtil.getShangJiaAccount();
        if (weixinAccount != null) {
            TSUser seller = (TSUser)this.systemService.findUniqueByProperty(TSUser.class, "userName", (Object)weixinAccount.getUserName());
            String sellerId = seller.getId();
            String hql = "from WeixinShopCartEntity where buyer.id='" + ResourceUtil.getSessionUserName().getId() + "' and seller.id='" + sellerId + "'";
            LogUtil.info((Object)("...the hql of cart is....." + hql));
            List ShopCarList = this.systemService.findByQueryString(hql);
            LogUtil.info((Object)("...the size of cart is....." + ShopCarList.size()));
            double totalMoney = 0.0;
            int totalNum = 0;
            for (WeixinShopCartEntity weixinShopCartEntity : ShopCarList) {
                totalNum += weixinShopCartEntity.getCount().intValue();
                totalMoney += weixinShopCartEntity.getTotal().doubleValue();
            }
            req.setAttribute("ShopCarList", (Object)ShopCarList);
            req.setAttribute("totalNum", (Object)totalNum);
            req.setAttribute("totalMoney", (Object)totalMoney);
            req.setAttribute("accountid", (Object)req.getParameter("accountid"));
            hql = "from WeixinShopCategoryEntity where accountid='" + weixinAccount.getId() + "'";
            List categoryList = this.systemService.findByQueryString(hql);
            req.setAttribute("categoryList", (Object)categoryList);
        }
        return new ModelAndView("weixin/shop/cart/weixinShopCart");
    }

    @RequestMapping(params={"getShopCartNumber"})
    @ResponseBody
    public AjaxJson getShopCartNumber(HttpServletRequest req) {
        AjaxJson j = new AjaxJson();
        WeixinAccountEntity weixinAccount = ResourceUtil.getShangJiaAccount();
        if (weixinAccount != null) {
            TSUser seller = (TSUser)this.systemService.findUniqueByProperty(TSUser.class, "userName", (Object)weixinAccount.getUserName());
            String sellerId = seller.getId();
            String hql = "from WeixinShopCartEntity where buyer.id='" + ResourceUtil.getSessionUserName().getId() + "' and seller.id='" + sellerId + "'";
            LogUtil.info((Object)("...the hql of cart is....." + hql));
            List ShopCarList = this.systemService.findByQueryString(hql);
            LogUtil.info((Object)("...the size of cart is....." + ShopCarList.size()));
            int totalNum = 0;
            for (WeixinShopCartEntity weixinShopCartEntity : ShopCarList) {
                totalNum += weixinShopCartEntity.getCount().intValue();
            }
            j.setObj((Object)totalNum);
        }
        return j;
    }

    @RequestMapping(params={"updateShopCartNumber"})
    @ResponseBody
    public AjaxJson updateShopCartNumber(HttpServletRequest req) {
        AjaxJson j = new AjaxJson();
        WeixinAccountEntity weixinAccount = ResourceUtil.getShangJiaAccount();
        String id = req.getParameter("id");
        String num = req.getParameter("num");
        HashMap<String, Number> mapParams = new HashMap<String, Number>();
        if (weixinAccount != null) {
            WeixinShopCartEntity weixinShopCartEntity = (WeixinShopCartEntity)this.weixinShopCartService.getEntity(WeixinShopCartEntity.class, (Serializable)((Object)id));
            weixinShopCartEntity.setCount(Integer.parseInt(num));
            weixinShopCartEntity.setTotal(weixinShopCartEntity.getBuyPrice() * (double)Integer.parseInt(num));
            this.weixinShopCartService.updateEntitie(weixinShopCartEntity);
            mapParams.put("shopTotal", weixinShopCartEntity.getTotal());
            TSUser seller = (TSUser)this.systemService.findUniqueByProperty(TSUser.class, "userName", (Object)weixinAccount.getUserName());
            String sellerId = seller.getId();
            String hql = "from WeixinShopCartEntity where buyer.id='" + ResourceUtil.getSessionUserName().getId() + "' and seller.id='" + sellerId + "'";
            LogUtil.info((Object)("...the hql of cart is....." + hql));
            List ShopCarList = this.systemService.findByQueryString(hql);
            LogUtil.info((Object)("...the size of cart is....." + ShopCarList.size()));
            double totalMoney = 0.0;
            int totalNum = 0;
            for (WeixinShopCartEntity tempShopCart : ShopCarList) {
                totalNum += tempShopCart.getCount().intValue();
                totalMoney += tempShopCart.getTotal().doubleValue();
            }
            mapParams.put("totalNum", totalNum);
            mapParams.put("totalMoney", totalMoney);
            j.setAttributes(mapParams);
        }
        return j;
    }

    @RequestMapping(params={"viewCartDetail"})
    public ModelAndView viewCartDetail(WeixinShopCartEntity weixinShopCart, HttpServletRequest request) {
        if (oConvertUtils.isNotEmpty((Object)weixinShopCart.getId())) {
            weixinShopCart = (WeixinShopCartEntity)this.weixinShopCartService.get(WeixinShopCartEntity.class, (Serializable)((Object)weixinShopCart.getId()));
            request.setAttribute("weixinShopCart", (Object)weixinShopCart);
        }
        return new ModelAndView("weixin/shop/cart/viewCartDetail");
    }
}

