/*
 * Decompiled with CFR 0.152.
 */
package weixin.share.service.impl;

import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.jeewx.api.core.exception.WexinReqException;
import org.jeewx.api.wxuser.user.JwUserAPI;
import org.jeewx.api.wxuser.user.model.Wxuser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.core.util.WeixinUtil;
import weixin.guanjia.gzuserinfo.entity.GzUserInfoYw;
import weixin.share.entity.WeixinShareRecordEntity;
import weixin.share.service.WeixinShareRecordServiceI;

@Service(value="weixinShareRecordService")
@Transactional
public class WeixinShareRecordServiceImpl
extends CommonServiceImpl
implements WeixinShareRecordServiceI {
    @Autowired
    private WeixinAccountServiceI weixinAccountService;

    @Override
    public <T> void delete(T entity) {
        super.delete(entity);
        this.doDelSql((WeixinShareRecordEntity)entity);
    }

    @Override
    public <T> Serializable save(T entity) {
        Serializable t = super.save(entity);
        this.doAddSql((WeixinShareRecordEntity)entity);
        return t;
    }

    @Override
    public <T> void saveOrUpdate(T entity) {
        super.saveOrUpdate(entity);
        this.doUpdateSql((WeixinShareRecordEntity)entity);
    }

    @Override
    public boolean doAddSql(WeixinShareRecordEntity t) {
        return true;
    }

    @Override
    public boolean doUpdateSql(WeixinShareRecordEntity t) {
        return true;
    }

    @Override
    public boolean doDelSql(WeixinShareRecordEntity t) {
        return true;
    }

    public String replaceVal(String sql, WeixinShareRecordEntity t) {
        sql = sql.replace("#{id}", String.valueOf(t.getId()));
        sql = sql.replace("#{openid}", String.valueOf(t.getOpenid()));
        sql = sql.replace("#{sharetime}", String.valueOf(t.getSharetime()));
        sql = sql.replace("#{articletitle}", String.valueOf(t.getArticletitle()));
        sql = sql.replace("#{articleid}", String.valueOf(t.getArticleid()));
        sql = sql.replace("#{readcount}", String.valueOf(t.getReadcount()));
        sql = sql.replace("#{sharetype}", String.valueOf(t.getSharetype()));
        sql = sql.replace("#{nickname}", String.valueOf(t.getNickname()));
        sql = sql.replace("#{UUID}", UUID.randomUUID().toString());
        return sql;
    }

    @Override
    public String getNickname(String openid, String accountId) {
        List data = this.findByProperty(GzUserInfoYw.class, "openid", openid);
        if (data != null && data.size() > 0) {
            return new String(WeixinUtil.decode(((GzUserInfoYw)((Object)data.get(0))).getNickname()));
        }
        String accesstoken = this.weixinAccountService.getAccessToken(accountId);
        try {
            Wxuser user = JwUserAPI.getWxuser((String)accesstoken, (String)openid);
            return user.getNickname();
        }
        catch (WexinReqException e) {
            e.printStackTrace();
            return null;
        }
    }
}

