/*
 * Decompiled with CFR 0.152.
 */
package weixin.report.controller;

import java.io.IOException;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.guanjia.account.service.WeixinReportServiceI;
import weixin.util.DateUtils;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/fineReportController"})
public class FineReportController {
    @Autowired
    private WeixinReportServiceI weixinReportService;

    @RequestMapping(params={"report"})
    public ModelAndView report(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String reportlet = request.getParameter("reportlet");
        String accountid = ResourceUtil.getShangJiaAccountId();
        if (StringUtil.isNotEmpty((Object)reportlet)) {
            response.sendRedirect("ReportServer?reportlet=" + reportlet + "&accountid=" + accountid);
        }
        return new ModelAndView("common/404");
    }

    @RequestMapping(params={"historyDataSynch"})
    public ModelAndView historyDataSynch(HttpServletRequest request) {
        return new ModelAndView("weixin/report/historyDataSynch");
    }

    @RequestMapping(params={"focuseUserDataSynch"})
    @ResponseBody
    public AjaxJson focuseUserDataSynch(HttpServletRequest request) throws Exception {
        String weixinAccountId = request.getParameter("weixinAccountId");
        String[] accountids = weixinAccountId.split(",");
        Date beginDate = DateUtils.parseDate(request.getParameter("beginDate"), "yyyy-MM-dd");
        Date endDate = DateUtils.parseDate(request.getParameter("endDate"), "yyyy-MM-dd");
        AjaxJson j = new AjaxJson();
        j.setSuccess(false);
        String msg = "\u6267\u884c\u5b8c\u6bd5,\u52a0\u8f7d\u6570\u636e\u6761\u6570\uff1a";
        int actionDateCount = 0;
        String result = "";
        String[] stringArray = accountids;
        int n = accountids.length;
        int n2 = 0;
        while (n2 < n) {
            String accountid = stringArray[n2];
            if (StringUtil.isNotEmpty((Object)accountid)) {
                Date temp = beginDate;
                while (temp.getTime() <= endDate.getTime()) {
                    actionDateCount += this.weixinReportService.saveOneDayFocusUserDataLocalDB(temp, accountid);
                    temp = DateUtils.getDate(temp.getTime() + 86400000L);
                }
            }
            ++n2;
        }
        j.setObj((Object)result);
        j.setMsg(String.valueOf(msg) + actionDateCount);
        j.setSuccess(true);
        return j;
    }

    @RequestMapping(params={"oneDayUserDataSynch"})
    @ResponseBody
    public AjaxJson oneDayUserDataSynch(HttpServletRequest request) throws Exception {
        String weixinAccountId = request.getParameter("weixinAccountId");
        String[] accountids = weixinAccountId.split(",");
        Date beginDate = DateUtils.parseDate(request.getParameter("beginDate"), "yyyy-MM-dd");
        Date endDate = DateUtils.parseDate(request.getParameter("endDate"), "yyyy-MM-dd");
        AjaxJson j = new AjaxJson();
        j.setSuccess(false);
        String msg = "\u6267\u884c\u5b8c\u6bd5,\u52a0\u8f7d\u6570\u636e\u6761\u6570\uff1a";
        int actionDateCount = 0;
        String result = "";
        String[] stringArray = accountids;
        int n = accountids.length;
        int n2 = 0;
        while (n2 < n) {
            String accountid = stringArray[n2];
            if (StringUtil.isNotEmpty((Object)accountid)) {
                Date temp = beginDate;
                while (temp.getTime() <= endDate.getTime()) {
                    actionDateCount += this.weixinReportService.saveOneDayUserDataLocalDB(temp, accountid);
                    temp = DateUtils.getDate(temp.getTime() + 86400000L);
                }
            }
            ++n2;
        }
        j.setObj((Object)result);
        j.setMsg(String.valueOf(msg) + actionDateCount);
        j.setSuccess(true);
        return j;
    }

    @RequestMapping(params={"articleSummaryDataSynch"})
    @ResponseBody
    public AjaxJson articleSummaryDataSynch(HttpServletRequest request) throws Exception {
        String weixinAccountId = request.getParameter("weixinAccountId");
        String[] accountids = weixinAccountId.split(",");
        Date beginDate = DateUtils.parseDate(request.getParameter("beginDate"), "yyyy-MM-dd");
        Date endDate = DateUtils.parseDate(request.getParameter("endDate"), "yyyy-MM-dd");
        AjaxJson j = new AjaxJson();
        j.setSuccess(false);
        String msg = "\u6267\u884c\u5b8c\u6bd5,\u52a0\u8f7d\u6570\u636e\u6761\u6570\uff1a";
        int actionDateCount = 0;
        String result = "";
        String[] stringArray = accountids;
        int n = accountids.length;
        int n2 = 0;
        while (n2 < n) {
            String accountid = stringArray[n2];
            if (StringUtil.isNotEmpty((Object)accountid)) {
                Date temp = beginDate;
                while (temp.getTime() <= endDate.getTime()) {
                    actionDateCount += this.weixinReportService.saveOneDayArticleSummaryLocalDB(accountid, DateUtils.formatDate(temp, "yyyy-MM-dd"));
                    temp = DateUtils.getDate(temp.getTime() + 86400000L);
                }
            }
            ++n2;
        }
        j.setObj((Object)result);
        j.setMsg(String.valueOf(msg) + actionDateCount);
        j.setSuccess(true);
        return j;
    }

    @RequestMapping(params={"articleTotalDataSynch"})
    @ResponseBody
    public AjaxJson articleTotalDataSynch(HttpServletRequest request) throws Exception {
        String weixinAccountId = request.getParameter("weixinAccountId");
        String[] accountids = weixinAccountId.split(",");
        Date beginDate = DateUtils.parseDate(request.getParameter("beginDate"), "yyyy-MM-dd");
        Date endDate = DateUtils.parseDate(request.getParameter("endDate"), "yyyy-MM-dd");
        AjaxJson j = new AjaxJson();
        j.setSuccess(false);
        String msg = "\u6267\u884c\u5b8c\u6bd5,\u52a0\u8f7d\u6570\u636e\u6761\u6570\uff1a";
        int actionDateCount = 0;
        String result = "";
        String[] stringArray = accountids;
        int n = accountids.length;
        int n2 = 0;
        while (n2 < n) {
            String accountid = stringArray[n2];
            if (StringUtil.isNotEmpty((Object)accountid)) {
                Date temp = beginDate;
                while (temp.getTime() <= endDate.getTime()) {
                    actionDateCount += this.weixinReportService.saveArticleTotalLocalDB(accountid, DateUtils.formatDate(temp, "yyyy-MM-dd"));
                    temp = DateUtils.getDate(temp.getTime() + 86400000L);
                }
            }
            ++n2;
        }
        j.setObj((Object)result);
        j.setMsg(String.valueOf(msg) + actionDateCount);
        j.setSuccess(true);
        return j;
    }
}

