/*
 * Decompiled with CFR 0.152.
 */
package weixin.promotion.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.promotion.entity.MemberCouponEntity;
import weixin.promotion.entity.PromotionCouponEntity;
import weixin.promotion.service.MemberCouponServiceI;
import weixin.promotion.service.PromotionCouponServiceI;
import weixin.vip.entity.WeixinVipMemberEntity;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/promotionCouponController"})
public class PromotionCouponController
extends BaseController {
    private static final Logger logger = Logger.getLogger(PromotionCouponController.class);
    @Autowired
    private PromotionCouponServiceI promotionCouponService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private MemberCouponServiceI memberCouponService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"toCouponList"})
    public ModelAndView toCouponList(HttpServletRequest request) {
        String openid = request.getParameter("openid");
        List vipMemberList = this.systemService.findByProperty(WeixinVipMemberEntity.class, "openid", (Object)openid);
        ArrayList<PromotionCouponEntity> promotionCouponList = new ArrayList<PromotionCouponEntity>();
        if (!oConvertUtils.isNullOrEmpty((Object)vipMemberList)) {
            List<MemberCouponEntity> memberCouponList = this.memberCouponService.loadMyCouponList(((WeixinVipMemberEntity)vipMemberList.get(0)).getId());
            for (MemberCouponEntity memberCouponEntity : memberCouponList) {
                promotionCouponList.add(memberCouponEntity.getCoupon());
            }
        }
        request.setAttribute("promotionCouponList", promotionCouponList);
        request.setAttribute("openid", (Object)openid);
        return new ModelAndView("weixin/promotion/privateCouponList");
    }

    @RequestMapping(params={"promotionCoupon"})
    public ModelAndView promotionCoupon(HttpServletRequest request) {
        return new ModelAndView("weixin/promotion/promotionCouponList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(PromotionCouponEntity promotionCoupon, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(PromotionCouponEntity.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)promotionCoupon, (Map)request.getParameterMap());
        this.promotionCouponService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(PromotionCouponEntity promotionCoupon, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        promotionCoupon = (PromotionCouponEntity)this.systemService.getEntity(PromotionCouponEntity.class, (Serializable)((Object)promotionCoupon.getId()));
        this.message = "\u4fc3\u9500\u6a21\u5757--\u4f18\u60e0\u52b5\u5220\u9664\u6210\u529f";
        this.promotionCouponService.delete(promotionCoupon);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(PromotionCouponEntity promotionCoupon, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty((Object)promotionCoupon.getId())) {
            this.message = "\u4fc3\u9500\u6a21\u5757--\u4f18\u60e0\u52b5\u66f4\u65b0\u6210\u529f";
            PromotionCouponEntity t = (PromotionCouponEntity)this.promotionCouponService.get(PromotionCouponEntity.class, (Serializable)((Object)promotionCoupon.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)promotionCoupon, (Object)t);
                this.promotionCouponService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u4fc3\u9500\u6a21\u5757--\u4f18\u60e0\u52b5\u66f4\u65b0\u5931\u8d25";
            }
        } else {
            this.message = "\u4fc3\u9500\u6a21\u5757--\u4f18\u60e0\u52b5\u6dfb\u52a0\u6210\u529f";
            promotionCoupon.setCreateTime(new Date());
            promotionCoupon.setType("0");
            promotionCoupon.setStatus("0");
            this.promotionCouponService.save(promotionCoupon);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(PromotionCouponEntity promotionCoupon, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)promotionCoupon.getId())) {
            promotionCoupon = (PromotionCouponEntity)this.promotionCouponService.getEntity(PromotionCouponEntity.class, (Serializable)((Object)promotionCoupon.getId()));
            req.setAttribute("promotionCouponPage", (Object)promotionCoupon);
        } else {
            String s = UUID.randomUUID().toString();
            String ss = "";
            String s1 = s.substring(0, 8);
            String s2 = s.substring(9, 13);
            String s3 = s.substring(14, 18);
            String s4 = s.substring(19, 23);
            String s5 = s.substring(24);
            ss = String.valueOf(ss) + s1.substring(0, 1);
            ss = String.valueOf(ss) + s2.substring(1, 2);
            ss = String.valueOf(ss) + s3.substring(2, 3);
            ss = String.valueOf(ss) + s4.substring(3, 4);
            ss = String.valueOf(ss) + s5.substring(4, 5);
            req.setAttribute("code", (Object)ss);
        }
        return new ModelAndView("weixin/promotion/promotionCoupon");
    }
}

