/*
 * Decompiled with CFR 0.152.
 */
package weixin.pay.tenpay;

import com.google.gson.Gson;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.util.JSONHelper;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.springframework.stereotype.Service;
import weixin.pay.PayBaseVo;
import weixin.pay.PayExecutor;
import weixin.pay.RefundBaseVo;
import weixin.pay.pojo.Wx_pay_pojo_tenpay;
import weixin.pay.tenpay.HttpRequester;
import weixin.pay.tenpay.HttpRespons;
import weixin.pay.tenpay.MD5Util;
import weixin.pay.tenpay.XMLUtil;

@Service(value="tenpay")
public class TenPayClient
implements PayExecutor {
    private static final String payUrl = "https://wap.tenpay.com/cgi-bin/wappayv2.0/wappay_init.cgi";
    private static final String FEE_TYPE = "1";
    private static final String BANK_TYPE = "0";
    private static final String CHARSET_VAL = "1";
    private static final String VERSION = "2.0";

    protected static String createSign(SortedMap<String, String> params, String key) {
        StringBuffer sb = new StringBuffer();
        Set<Map.Entry<String, String>> es = params.entrySet();
        for (Map.Entry<String, String> entry : es) {
            String k = entry.getKey();
            String v = entry.getValue();
            if (v == null || "".equals(v) || "sign".equals(k) || "key".equals(k)) continue;
            sb.append(String.valueOf(k) + "=" + v + "&");
        }
        sb.append("key=" + key);
        String sign = MD5Util.MD5Encode(sb.toString(), "UTF-8").toUpperCase();
        LogUtil.info((Object)("sign=" + sign));
        return sign;
    }

    public String obtain_token_id(Wx_pay_pojo_tenpay wxTenpay, PayBaseVo payBaseVo) {
        String token_id = "";
        try {
            HttpRequester request = new HttpRequester();
            TreeMap<String, String> params = new TreeMap<String, String>();
            String desc = payBaseVo.getDesc();
            String purchaser_id = "";
            String bargainor_id = wxTenpay.getBargainor_id();
            String sp_billno = payBaseVo.getOrderId();
            String total_fee = String.valueOf(BigDecimal.valueOf(Double.valueOf(payBaseVo.getTotal_money())).multiply(new BigDecimal(100)).intValue());
            String callback_url = this.getPayCallbackUrl(payBaseVo.getAccountid());
            String notify_url = this.getPayNotifyUrl(payBaseVo.getAccountid());
            String attach = "";
            params.put("ver", VERSION);
            params.put("charset", "1");
            params.put("bank_type", BANK_TYPE);
            params.put("desc", desc);
            params.put("purchaser_id", purchaser_id);
            params.put("bargainor_id", bargainor_id);
            params.put("sp_billno", sp_billno);
            params.put("total_fee", total_fee);
            params.put("fee_type", "1");
            params.put("notify_url", notify_url);
            params.put("callback_url", callback_url);
            params.put("attach", attach);
            String sign = TenPayClient.createSign(params, wxTenpay.getKey());
            params.put("sign", sign);
            HttpRespons hr = request.sendPost(payUrl, params);
            LogUtil.info((Object)"*************\u8d22\u4ed8\u901a\u652f\u4ed8\u8fd4\u56de\u4fe1\u606f_\u5f00\u59cb***************");
            LogUtil.info((Object)hr.getUrlString());
            LogUtil.info((Object)hr.getProtocol());
            LogUtil.info((Object)hr.getHost());
            LogUtil.info((Object)hr.getPort());
            LogUtil.info((Object)hr.getContentEncoding());
            LogUtil.info((Object)hr.getMethod());
            LogUtil.info((Object)hr.getContent());
            LogUtil.info((Object)hr.getContentEncoding());
            LogUtil.info((Object)("\u8fd4\u56de\u7684\u5185\u5bb9\uff1a" + hr.getContent()));
            LogUtil.info((Object)"*************\u8d22\u4ed8\u901a\u652f\u4ed8\u8fd4\u56de\u4fe1\u606f_\u7ed3\u675f***************");
            Map m = XMLUtil.doXMLParse(hr.getContent());
            token_id = (String)m.get("token_id");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return token_id;
    }

    @Override
    public String executePayMethod(HttpServletRequest req, PayBaseVo payBaseVo, String wxTenpayJson) {
        String modelViewStr = "";
        Wx_pay_pojo_tenpay wxTenpay = (Wx_pay_pojo_tenpay)JSONHelper.fromJsonToObject((String)wxTenpayJson, Wx_pay_pojo_tenpay.class);
        String token_id = this.obtain_token_id(wxTenpay, payBaseVo);
        LogUtil.info((Object)("\u53d6\u5f97\u8d22\u4ed8\u901a\u8fd4\u56de\u7684token_id=" + token_id));
        if (oConvertUtils.isNullOrEmpty((Object)token_id)) {
            throw new BusinessException("\u751f\u6210\u8d22\u4ed8\u901a\u7684\u9884\u652f\u4ed8ID\u5931\u8d25");
        }
        modelViewStr = "redirect:https://www.tenpay.com/app/mpay/mp_gate.cgi?token_id=" + token_id;
        return modelViewStr;
    }

    @Override
    public String getPayCallbackUrl(String accountid) {
        return String.valueOf(BaseCallBackURL) + "tenpay/" + accountid;
    }

    @Override
    public String getPayNotifyUrl(String accountid) {
        return String.valueOf(BaseNotifyUrl) + "tenpay" + accountid;
    }

    @Override
    public void doNotify(HttpServletRequest request, HttpServletResponse response, String payConfigJson) {
        Wx_pay_pojo_tenpay wxTenpay = (Wx_pay_pojo_tenpay)JSONHelper.fromJsonToObject((String)payConfigJson, Wx_pay_pojo_tenpay.class);
        try {
            SortedMap<String, String> params = this.paramsToTreeMap(request);
            String returnSign = oConvertUtils.getString((String)((String)params.get("sign")), (String)"");
            if (returnSign.equals(TenPayClient.createSign(params, wxTenpay.getKey()))) {
                if (BANK_TYPE.equals(params.get("pay_result"))) {
                    HttpRequester requester = new HttpRequester();
                    String postUrl = String.valueOf(ResourceBundle.getBundle("sysConfig").getString("domain")) + "/weixinShopDealController.do?payResultNotify&orderid=" + (String)params.get("sp_billno");
                    HttpRespons respons = requester.sendPost(postUrl);
                    LogUtil.info((Object)respons.getContent());
                    JSONObject json2 = JSONObject.fromObject((Object)respons.getContent());
                    Gson gson = new Gson();
                    AjaxJson ajaxJson = (AjaxJson)gson.fromJson(json2.toString(), AjaxJson.class);
                    if (ajaxJson.isSuccess()) {
                        response.getWriter().write("success");
                    } else {
                        response.getWriter().write("fail");
                    }
                }
            } else {
                response.getWriter().write("fail");
            }
        }
        catch (IOException e) {
            try {
                response.getWriter().write("fail");
            }
            catch (IOException e1) {
                LogUtil.info((Object)"\u8d22\u4ed8\u901a\u652f\u4ed8\u901a\u77e5IO\u5f02\u5e38");
            }
        }
    }

    private SortedMap<String, String> paramsToTreeMap(HttpServletRequest request) {
        HashSet<String> paramsNameSet = new HashSet<String>();
        paramsNameSet.add("ver");
        paramsNameSet.add("charset");
        paramsNameSet.add("bank_type");
        paramsNameSet.add("bank_billno");
        paramsNameSet.add("pay_result");
        paramsNameSet.add("pay_info");
        paramsNameSet.add("purchase_alias");
        paramsNameSet.add("bargainor_id");
        paramsNameSet.add("transaction_id");
        paramsNameSet.add("sp_billno");
        paramsNameSet.add("total_fee");
        paramsNameSet.add("fee_type");
        paramsNameSet.add("attach");
        paramsNameSet.add("time_end");
        paramsNameSet.add("sign");
        TreeMap<String, String> params = new TreeMap<String, String>();
        Enumeration em = request.getParameterNames();
        while (em.hasMoreElements()) {
            String paramName = (String)em.nextElement();
            if (!paramsNameSet.contains(paramName)) continue;
            String paramValue = request.getParameter(paramName);
            params.put(paramName, paramValue);
        }
        return params;
    }

    @Override
    public String executeRefundMethod(HttpServletRequest req, RefundBaseVo refundBaseVo, String payConfigJson) throws BusinessException {
        return null;
    }
}

