/*
 * Decompiled with CFR 0.152.
 */
package weixin.pay.controller;

import java.io.Serializable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.pay.entity.WxPayTypeEntity;
import weixin.pay.service.WxPayTypeServiceI;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/wxPayTypeController"})
public class WxPayTypeController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WxPayTypeController.class);
    @Autowired
    private WxPayTypeServiceI wxPayTypeService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"wxPayType"})
    public ModelAndView wxPayType(HttpServletRequest request) {
        return new ModelAndView("weixin/pay/paytype/wxPayTypeList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WxPayTypeEntity wxPayType, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WxPayTypeEntity.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)wxPayType, (Map)request.getParameterMap());
        cq.add();
        this.wxPayTypeService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(WxPayTypeEntity wxPayType, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        wxPayType = (WxPayTypeEntity)this.systemService.getEntity(WxPayTypeEntity.class, (Serializable)((Object)wxPayType.getId()));
        this.message = "\u652f\u4ed8\u7c7b\u578b\u5220\u9664\u6210\u529f";
        try {
            this.wxPayTypeService.delete(wxPayType);
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u652f\u4ed8\u7c7b\u578b\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u652f\u4ed8\u7c7b\u578b\u5220\u9664\u6210\u529f";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                WxPayTypeEntity wxPayType = (WxPayTypeEntity)this.systemService.getEntity(WxPayTypeEntity.class, (Serializable)((Object)id));
                this.wxPayTypeService.delete(wxPayType);
                this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u652f\u4ed8\u7c7b\u578b\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(WxPayTypeEntity wxPayType, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u652f\u4ed8\u7c7b\u578b\u6dfb\u52a0\u6210\u529f";
        try {
            this.wxPayTypeService.save(wxPayType);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u652f\u4ed8\u7c7b\u578b\u6dfb\u52a0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doUpdate"})
    @ResponseBody
    public AjaxJson doUpdate(WxPayTypeEntity wxPayType, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u652f\u4ed8\u7c7b\u578b\u66f4\u65b0\u6210\u529f";
        WxPayTypeEntity t = (WxPayTypeEntity)this.wxPayTypeService.get(WxPayTypeEntity.class, (Serializable)((Object)wxPayType.getId()));
        try {
            MyBeanUtils.copyBeanNotNull2Bean((Object)wxPayType, (Object)t);
            this.wxPayTypeService.saveOrUpdate(t);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u652f\u4ed8\u7c7b\u578b\u66f4\u65b0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(WxPayTypeEntity wxPayType, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)wxPayType.getId())) {
            wxPayType = (WxPayTypeEntity)this.wxPayTypeService.getEntity(WxPayTypeEntity.class, (Serializable)((Object)wxPayType.getId()));
            req.setAttribute("wxPayTypePage", (Object)wxPayType);
        }
        return new ModelAndView("weixin/pay/paytype/wxPayType-add");
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(WxPayTypeEntity wxPayType, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)wxPayType.getId())) {
            wxPayType = (WxPayTypeEntity)this.wxPayTypeService.getEntity(WxPayTypeEntity.class, (Serializable)((Object)wxPayType.getId()));
            req.setAttribute("wxPayTypePage", (Object)wxPayType);
        }
        return new ModelAndView("weixin/pay/paytype/wxPayType-update");
    }
}

