/*
 * Decompiled with CFR 0.152.
 */
package weixin.pay.controller;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.BrowserUtils;
import org.jeecgframework.core.util.ExceptionUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExcelTitle;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import weixin.pay.entity.WxPayLogEntity;
import weixin.pay.service.WxPayLogServiceI;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/wxPayLogController"})
public class WxPayLogController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WxPayLogController.class);
    @Autowired
    private WxPayLogServiceI wxPayLogService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"wxPayLog"})
    public ModelAndView wxPayLog(HttpServletRequest request) {
        return new ModelAndView("weixin/pay/wxPayLogList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WxPayLogEntity wxPayLog, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WxPayLogEntity.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)wxPayLog, (Map)request.getParameterMap());
        cq.add();
        this.wxPayLogService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(WxPayLogEntity wxPayLog, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        wxPayLog = (WxPayLogEntity)this.systemService.getEntity(WxPayLogEntity.class, (Serializable)((Object)wxPayLog.getId()));
        this.message = "\u652f\u4ed8\u8bb0\u5f55\u8868\u5220\u9664\u6210\u529f";
        try {
            this.wxPayLogService.delete(wxPayLog);
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u652f\u4ed8\u8bb0\u5f55\u8868\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u652f\u4ed8\u8bb0\u5f55\u8868\u5220\u9664\u6210\u529f";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                WxPayLogEntity wxPayLog = (WxPayLogEntity)this.systemService.getEntity(WxPayLogEntity.class, (Serializable)((Object)id));
                this.wxPayLogService.delete(wxPayLog);
                this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u652f\u4ed8\u8bb0\u5f55\u8868\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(WxPayLogEntity wxPayLog, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u652f\u4ed8\u8bb0\u5f55\u8868\u6dfb\u52a0\u6210\u529f";
        try {
            this.wxPayLogService.save(wxPayLog);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u652f\u4ed8\u8bb0\u5f55\u8868\u6dfb\u52a0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doUpdate"})
    @ResponseBody
    public AjaxJson doUpdate(WxPayLogEntity wxPayLog, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u652f\u4ed8\u8bb0\u5f55\u8868\u66f4\u65b0\u6210\u529f";
        WxPayLogEntity t = (WxPayLogEntity)this.wxPayLogService.get(WxPayLogEntity.class, (Serializable)((Object)wxPayLog.getId()));
        try {
            MyBeanUtils.copyBeanNotNull2Bean((Object)wxPayLog, (Object)t);
            this.wxPayLogService.saveOrUpdate(t);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u652f\u4ed8\u8bb0\u5f55\u8868\u66f4\u65b0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(WxPayLogEntity wxPayLog, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)wxPayLog.getId())) {
            wxPayLog = (WxPayLogEntity)this.wxPayLogService.getEntity(WxPayLogEntity.class, (Serializable)((Object)wxPayLog.getId()));
            req.setAttribute("wxPayLogPage", (Object)wxPayLog);
        }
        return new ModelAndView("weixin/pay/wxPayLog-add");
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(WxPayLogEntity wxPayLog, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)wxPayLog.getId())) {
            wxPayLog = (WxPayLogEntity)this.wxPayLogService.getEntity(WxPayLogEntity.class, (Serializable)((Object)wxPayLog.getId()));
            req.setAttribute("wxPayLogPage", (Object)wxPayLog);
        }
        return new ModelAndView("weixin/pay/wxPayLog-update");
    }

    @RequestMapping(params={"upload"})
    public ModelAndView upload(HttpServletRequest req) {
        return new ModelAndView("weixin/pay/wxPayLogUpload");
    }

    @RequestMapping(params={"exportXls"})
    public void exportXls(WxPayLogEntity wxPayLog, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u652f\u4ed8\u8bb0\u5f55\u8868";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                CriteriaQuery cq = new CriteriaQuery(WxPayLogEntity.class, dataGrid);
                HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)wxPayLog, (Map)request.getParameterMap());
                List wxPayLogs = this.wxPayLogService.getListByCriteriaQuery(cq, false);
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("\u652f\u4ed8\u8bb0\u5f55\u8868\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WxPayLogEntity.class, (Collection)wxPayLogs);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"exportXlsByT"})
    public void exportXlsByT(WxPayLogEntity wxPayLog, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u652f\u4ed8\u8bb0\u5f55\u8868";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("\u652f\u4ed8\u8bb0\u5f55\u8868\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WxPayLogEntity.class, null);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"importExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson importExcel(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setSecondTitleRows(1);
            params.setNeedSave(true);
            try {
                try {
                    List listWxPayLogEntitys = (List)ExcelImportUtil.importExcelByIs((InputStream)file.getInputStream(), WxPayLogEntity.class, (ImportParams)params);
                    for (WxPayLogEntity wxPayLog : listWxPayLogEntitys) {
                        this.wxPayLogService.save(wxPayLog);
                    }
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01");
                }
                catch (Exception e) {
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
                    logger.error((Object)ExceptionUtil.getExceptionMessage((Exception)e));
                    try {
                        file.getInputStream().close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                file.getInputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return j;
    }
}

