/*
 * Decompiled with CFR 0.152.
 */
package weixin.pay.controller;

import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.util.ApplicationContextUtil;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.guanjia.core.wxRule.impl.RemoteWeixinMethod;
import weixin.idea.oauth2.util.OAuth2Util;
import weixin.pay.PayBaseVo;
import weixin.pay.PayExecutor;
import weixin.pay.RefundBaseVo;
import weixin.pay.entity.WxPayConfigEntity;
import weixin.pay.entity.WxPayLogEntity;
import weixin.pay.service.WxPayConfigServiceI;
import weixin.pay.service.WxPayLogServiceI;
import weixin.pay.weixinpay.WeixinpayVo;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/weixinPayController"})
public class WeixinPayController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinPayController.class);
    @Autowired
    private WxPayConfigServiceI wxPayConfigService;
    @Autowired
    private RemoteWeixinMethod remoteWeixinMethod;
    @Autowired
    private WxPayLogServiceI wxPayLogService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"testPay"})
    public String testPay(HttpServletRequest request, HttpServletResponse response) {
        String modelViewStr = "weixin/pay/testPay";
        return modelViewStr;
    }

    @RequestMapping(params={"toPay"})
    public String toPay(HttpServletRequest req, PayBaseVo payBaseVo) {
        String modelViewStr = "";
        LogUtil.info((Object)("\u4f20\u5165\u7684\u652f\u4ed8\u5bf9\u8c61\u4e3a==>" + payBaseVo));
        String payType = payBaseVo.getPayType();
        List payConfigList = this.systemService.findByQueryString(" FROM WxPayConfigEntity p WHERE p.accountid='" + payBaseVo.getAccountid() + "' AND payType='" + payType + "'");
        if (oConvertUtils.isNullOrEmpty((Object)payConfigList)) {
            req.setAttribute("msg", (Object)"\u6682\u672a\u5f00\u542f\u8be5\u652f\u4ed8\u65b9\u5f0f");
            return "weixin/pay/payError";
        }
        if (!oConvertUtils.isNullOrEmpty((Object)payConfigList)) {
            String targetUrlMethod;
            String weixin_author2_url;
            WxPayConfigEntity configEntity = (WxPayConfigEntity)payConfigList.get(0);
            String payConfigJson = configEntity.getPayJson();
            PayExecutor payOutExecutor = (PayExecutor)ApplicationContextUtil.getContext().getBean(payType);
            if ("weixinpay".equals(payType) && oConvertUtils.isNotEmpty((Object)(weixin_author2_url = this.callWeixinAuthor2(req, targetUrlMethod = "toPay", payBaseVo)))) {
                return weixin_author2_url;
            }
            try {
                modelViewStr = payOutExecutor.executePayMethod(req, payBaseVo, payConfigJson);
            }
            catch (BusinessException e) {
                req.setAttribute("msg", (Object)e.getMessage());
                return "weixin/pay/payError";
            }
        }
        return modelViewStr;
    }

    @RequestMapping(params={"toRefundPay"})
    public ModelAndView toRefundPay(HttpServletRequest req, RefundBaseVo refundBaseVo) {
        List payConfigList;
        ModelAndView mv = new ModelAndView("weixin/pay/weixinpay/torefund");
        if (StringUtil.isEmpty((String)refundBaseVo.getOrderId())) {
            throw new BusinessException("\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        WxPayLogEntity wxpayLog = (WxPayLogEntity)this.systemService.findUniqueByProperty(WxPayLogEntity.class, "orderId", (Object)refundBaseVo.getOrderId());
        if (!oConvertUtils.isNullOrEmpty((Object)wxpayLog) && !oConvertUtils.isNullOrEmpty((Object)(payConfigList = this.systemService.findByQueryString(" FROM WxPayConfigEntity p WHERE p.accountid='" + wxpayLog.getAccountId() + "' AND payType='" + wxpayLog.getPayType() + "'")))) {
            PayExecutor payOutExecutor = (PayExecutor)ApplicationContextUtil.getContext().getBean(wxpayLog.getPayType());
            String string = payOutExecutor.executeRefundMethod(req, refundBaseVo, ((WxPayConfigEntity)payConfigList.get(0)).getPayJson());
        }
        return mv;
    }

    @RequestMapping(value={"/wx/weixinpay"}, params={"redirectWeixinpay"})
    public String redirectWeixinpay(HttpServletRequest request, HttpServletResponse response, WeixinpayVo weixinpayVo) {
        LogUtil.info((Object)("\u5fae\u4fe1\u652f\u4ed8\u53c2\u6570\u4e3a\uff1a" + weixinpayVo));
        request.setAttribute("weixinpayVo", (Object)weixinpayVo);
        String modelViewStr = "weixin/pay/weixinpay/toweixinpay";
        return modelViewStr;
    }

    @RequestMapping(value={"/paycallback/{payType}/{accountid}"})
    public String paycallbackRest(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="payType") String payType, @PathVariable(value="accountid") String accountid) {
        LogUtil.info((Object)("\u652f\u4ed8\u56de\u8c03\uff0c\u56de\u8c03\u7c7b\u578b\uff1a" + payType));
        if (!"Alipay".equalsIgnoreCase(payType)) {
            "Tenpay".equalsIgnoreCase(payType);
        }
        return null;
    }

    @RequestMapping(value={"/notify/{payType}/{accountid}"})
    @ResponseBody
    public void notifyRest(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="payType") String payType, @PathVariable(value="accountid") String accountid) {
        LogUtil.info((Object)("\u652f\u4ed8\u901a\u77e5\uff0c\u901a\u77e5\u7c7b\u578b\uff1a" + payType));
        LogUtil.info((Object)("\u652f\u4ed8\u901a\u77e5\uff0c\u5fae\u4fe1\u8d26\u6237accountid\uff1a" + accountid));
        List payConfigList = this.systemService.findByQueryString(" FROM WxPayConfigEntity p WHERE p.accountid='" + accountid + "' AND payType='" + payType + "'");
        if (!oConvertUtils.isNullOrEmpty((Object)payConfigList)) {
            WxPayConfigEntity configEntity = (WxPayConfigEntity)payConfigList.get(0);
            String payConfigJson = configEntity.getPayJson();
            PayExecutor payOutExecutor = (PayExecutor)ApplicationContextUtil.getContext().getBean(payType);
            payOutExecutor.doNotify(request, response, payConfigJson);
        }
    }

    private String callWeixinAuthor2(HttpServletRequest req, String targetUrlMethod, PayBaseVo payBaseVo) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        MyBeanUtils.copyBean2Map(paramsMap, (Object)payBaseVo);
        String tagetUrl = OAuth2Util.obtainTargetUrl(((Object)((Object)this)).getClass(), targetUrlMethod, paramsMap);
        String weixin_author2_url = this.remoteWeixinMethod.callWeixinAuthor2(req, payBaseVo.getAccountid(), tagetUrl);
        return weixin_author2_url;
    }
}

