/*
 * Decompiled with CFR 0.152.
 */
package weixin.pay.alipay.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.NameValuePair;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import weixin.pay.alipay.config.AlipayConfig;
import weixin.pay.alipay.sign.MD5;
import weixin.pay.alipay.sign.RSA;
import weixin.pay.alipay.util.AlipayCore;
import weixin.pay.alipay.util.httpClient.HttpProtocolHandler;
import weixin.pay.alipay.util.httpClient.HttpRequest;
import weixin.pay.alipay.util.httpClient.HttpResponse;
import weixin.pay.alipay.util.httpClient.HttpResultType;

public class AlipaySubmit {
    public static String buildRequestMysign(Map<String, String> sPara, String key) {
        String prestr = AlipayCore.createLinkString(sPara);
        String mysign = "";
        if (AlipayConfig.sign_type.equals("MD5")) {
            mysign = MD5.sign(prestr, key, AlipayConfig.input_charset);
        }
        if (AlipayConfig.sign_type.equals("0001")) {
            mysign = RSA.sign(prestr, AlipayConfig.private_key, AlipayConfig.input_charset);
        }
        return mysign;
    }

    private static Map<String, String> buildRequestPara(Map<String, String> sParaTemp) {
        Map<String, String> sPara = AlipayCore.paraFilter(sParaTemp);
        String mysign = AlipaySubmit.buildRequestMysign(sPara, sParaTemp.get("key"));
        sPara.put("sign", mysign);
        if (!sPara.get("service").equals("alipay.wap.trade.create.direct") && !sPara.get("service").equals("alipay.wap.auth.authAndExecute")) {
            sPara.put("sign_type", AlipayConfig.sign_type);
        }
        return sPara;
    }

    public static String buildRequest(String ALIPAY_GATEWAY_NEW, Map<String, String> sParaTemp, String strMethod, String strButtonName) {
        Map<String, String> sPara = AlipaySubmit.buildRequestPara(sParaTemp);
        ArrayList<String> keys = new ArrayList<String>(sPara.keySet());
        StringBuffer sbHtml = new StringBuffer();
        sbHtml.append("<form id=\"alipaysubmit\" name=\"alipaysubmit\" action=\"" + ALIPAY_GATEWAY_NEW + "_input_charset=" + AlipayConfig.input_charset + "\" method=\"" + strMethod + "\">");
        int i = 0;
        while (i < keys.size()) {
            String name = (String)keys.get(i);
            String value = sPara.get(name);
            sbHtml.append("<input type=\"hidden\" name=\"" + name + "\" value=\"" + value + "\"/>");
            ++i;
        }
        sbHtml.append("<input type=\"submit\" value=\"" + strButtonName + "\" style=\"display:none;\"></form>");
        sbHtml.append("<script>document.forms['alipaysubmit'].submit();</script>");
        return sbHtml.toString();
    }

    public static String buildRequest(String ALIPAY_GATEWAY_NEW, Map<String, String> sParaTemp, String strMethod, String strButtonName, String strParaFileName) {
        Map<String, String> sPara = AlipaySubmit.buildRequestPara(sParaTemp);
        ArrayList<String> keys = new ArrayList<String>(sPara.keySet());
        StringBuffer sbHtml = new StringBuffer();
        sbHtml.append("<form id=\"alipaysubmit\" name=\"alipaysubmit\"  enctype=\"multipart/form-data\" action=\"" + ALIPAY_GATEWAY_NEW + "_input_charset=" + AlipayConfig.input_charset + "\" method=\"" + strMethod + "\">");
        int i = 0;
        while (i < keys.size()) {
            String name = (String)keys.get(i);
            String value = sPara.get(name);
            sbHtml.append("<input type=\"hidden\" name=\"" + name + "\" value=\"" + value + "\"/>");
            ++i;
        }
        sbHtml.append("<input type=\"file\" name=\"" + strParaFileName + "\" />");
        sbHtml.append("<input type=\"submit\" value=\"" + strButtonName + "\" style=\"display:none;\"></form>");
        return sbHtml.toString();
    }

    public static String buildRequest(String ALIPAY_GATEWAY_NEW, String strParaFileName, String strFilePath, Map<String, String> sParaTemp) throws Exception {
        Map<String, String> sPara = AlipaySubmit.buildRequestPara(sParaTemp);
        HttpProtocolHandler httpProtocolHandler = HttpProtocolHandler.getInstance();
        HttpRequest request = new HttpRequest(HttpResultType.BYTES);
        request.setCharset(AlipayConfig.input_charset);
        request.setParameters(AlipaySubmit.generatNameValuePair(sPara));
        request.setUrl(String.valueOf(ALIPAY_GATEWAY_NEW) + "_input_charset=" + AlipayConfig.input_charset);
        HttpResponse response = httpProtocolHandler.execute(request, strParaFileName, strFilePath);
        if (response == null) {
            return null;
        }
        String strResult = response.getStringResult();
        return strResult;
    }

    private static NameValuePair[] generatNameValuePair(Map<String, String> properties) {
        NameValuePair[] nameValuePair = new NameValuePair[properties.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            nameValuePair[i++] = new NameValuePair(entry.getKey(), entry.getValue());
        }
        return nameValuePair;
    }

    public static String getRequestToken(String text) throws Exception {
        String request_token = "";
        String[] strSplitText = text.split("&");
        HashMap<String, String> paraText = new HashMap<String, String>();
        int i = 0;
        while (i < strSplitText.length) {
            int nPos = strSplitText[i].indexOf("=");
            int nLen = strSplitText[i].length();
            String strKey = strSplitText[i].substring(0, nPos);
            String strValue = strSplitText[i].substring(nPos + 1, nLen);
            paraText.put(strKey, strValue);
            ++i;
        }
        if (paraText.get("res_data") != null) {
            String res_data = (String)paraText.get("res_data");
            if (AlipayConfig.sign_type.equals("0001")) {
                res_data = RSA.decrypt(res_data, AlipayConfig.private_key, AlipayConfig.input_charset);
            }
            Document document = DocumentHelper.parseText((String)res_data);
            request_token = document.selectSingleNode("//direct_trade_create_res/request_token").getText();
        }
        return request_token;
    }
}

