/*
 * Decompiled with CFR 0.152.
 */
package weixin.idea.votepk.service.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.guanjia.account.entity.WeixinAccountEntity;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.core.util.WeixinUtil;
import weixin.guanjia.gzuserinfo.entity.GzUserInfoYw;
import weixin.guanjia.gzuserinfo.model.GzUserInfo;
import weixin.guanjia.gzuserinfo.service.GzUserInfoService;
import weixin.idea.votepk.entity.WeixinVotePKRecord;
import weixin.idea.votepk.entity.WeixinVotePKSignUserinfo;
import weixin.idea.votepk.service.WeixinVotePKConfigService;
import weixin.idea.votepk.service.WeixinVotePKRecordService;
import weixin.idea.votepk.service.WeixinVotePKService;
import weixin.idea.votepk.service.WeixinVotePKSignUserinfoService;

@Service(value="weixinVotePKService")
public class WeixinVotePKServiceImpl
extends CommonServiceImpl
implements WeixinVotePKService {
    @Autowired
    private WeixinVotePKSignUserinfoService weixinVotePKSignUserinfoService;
    @Autowired
    private WeixinVotePKRecordService weixinVotePKRecordService;
    @Autowired
    private GzUserInfoService gzUserInfoService;
    @Autowired
    private WeixinAccountServiceI weixinAccountService;
    @Autowired
    private WeixinVotePKConfigService weixinVotePKConfigService;

    @Override
    public void updateVoteCount(int sceneid, String accountid, String openid, String votetype, int count) {
        List userinfolist;
        GzUserInfoYw voteuser = this.gzUserInfoService.getLocalUserinfoSubscribe(openid, accountid);
        if (voteuser == null) {
            WeixinAccountEntity account = (WeixinAccountEntity)this.weixinAccountService.get(WeixinAccountEntity.class, (Serializable)((Object)accountid));
            this.gzUserInfoService.saveGzUserInfoByOpenId(openid, account.getWeixinOriginalAccountid());
            voteuser = this.gzUserInfoService.getLocalUserinfoSubscribe(openid, accountid);
        }
        if ((userinfolist = this.weixinVotePKSignUserinfoService.findByProperty(WeixinVotePKSignUserinfo.class, "sceneid", sceneid)) != null && userinfolist.size() != 0 && !this.weixinVotePKRecordService.checkVote(openid, ((WeixinVotePKSignUserinfo)userinfolist.get(0)).getOpenid(), accountid)) {
            GzUserInfo beivoteuser = this.gzUserInfoService.getGzUserInfo(((WeixinVotePKSignUserinfo)userinfolist.get(0)).getOpenid(), accountid);
            WeixinVotePKRecord record = new WeixinVotePKRecord();
            record.setVotetype(votetype);
            record.setVotedate(new Date());
            record.setOpenid(((WeixinVotePKSignUserinfo)userinfolist.get(0)).getOpenid());
            record.setAccountid(accountid);
            record.setVoteopenid(openid);
            record.setHeadimgurl(voteuser.getHeadimgurl());
            record.setNickname(beivoteuser.getNickname());
            record.setVotenickname(voteuser.getNickname());
            record.setSubscribe("1");
            record.setVotecount(count);
            this.weixinVotePKRecordService.save(record);
            WeixinVotePKSignUserinfo user = (WeixinVotePKSignUserinfo)userinfolist.get(0);
            user.setVotecount(user.getVotecount() + count);
            this.weixinVotePKSignUserinfoService.updateEntitie(user);
            int lettecount = 0;
            if (votetype.equals("1")) {
                lettecount = Integer.valueOf(this.weixinVotePKConfigService.getByName("normalvotelettecount", record.getAccountid()).getConfigValue());
                voteuser.setLettecount(voteuser.getLettecount() + lettecount);
            } else if (votetype.equals("2")) {
                lettecount = Integer.valueOf(this.weixinVotePKConfigService.getByName("qrcodevotelettecount", record.getAccountid()).getConfigValue());
                voteuser.setLettecount(voteuser.getLettecount() + lettecount);
            } else if (votetype.equals("3")) {
                lettecount = Integer.valueOf(this.weixinVotePKConfigService.getByName("sharevotelettecount", record.getAccountid()).getConfigValue());
                voteuser.setLettecount(voteuser.getLettecount() + lettecount);
            }
            this.updateEntitie((Object)voteuser);
            this.weixinVotePKRecordService.sendMsg(record.getOpenid(), record.getVoteopenid(), accountid, "2");
        }
    }

    @Override
    public void toSuccessUnsubscribeVoteCount(String accountid, String voteopenid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinVotePKRecord.class);
        try {
            cq.eq("accountid", (Object)accountid);
            cq.eq("voteopenid", (Object)voteopenid);
            cq.eq("subscribe", (Object)"0");
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        cq.add();
        List recordlist = this.weixinVotePKRecordService.getListByCriteriaQuery(cq, false);
        for (WeixinVotePKRecord record : recordlist) {
            record.setSubscribe("1");
            GzUserInfoYw voteuser = this.gzUserInfoService.getLocalUserinfoSubscribe(voteopenid, record.getAccountid());
            record.setVotenickname(new String(WeixinUtil.decode(voteuser.getNickname())));
            record.setHeadimgurl(voteuser.getHeadimgurl());
            record.setSubscribe("1");
            this.weixinVotePKRecordService.updateEntitie(record);
            WeixinVotePKSignUserinfo userinfo = this.weixinVotePKSignUserinfoService.getSignUserinfo(accountid, record.getOpenid());
            userinfo.setVotecount(userinfo.getVotecount() + 1);
            this.weixinVotePKSignUserinfoService.updateEntitie(userinfo);
            int lettecount = Integer.valueOf(this.weixinVotePKConfigService.getByName("normalvotelettecount", record.getAccountid()).getConfigValue());
            voteuser.setLettecount(voteuser.getLettecount() + lettecount);
            this.updateEntitie((Object)voteuser);
            this.weixinVotePKRecordService.sendMsg(record.getOpenid(), record.getVoteopenid(), record.getAccountid(), "1");
        }
    }
}

