/*
 * Decompiled with CFR 0.152.
 */
package weixin.idea.votepk.service.impl;

import java.io.Serializable;
import java.util.List;
import java.util.ResourceBundle;
import net.sf.json.JSONObject;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.guanjia.account.entity.WeixinAccountEntity;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.core.util.WeixinUtil;
import weixin.guanjia.gzuserinfo.entity.GzUserInfoYw;
import weixin.guanjia.gzuserinfo.service.GzUserInfoService;
import weixin.guanjia.message.model.TextItem;
import weixin.guanjia.message.model.TextMessageKf;
import weixin.guanjia.message.service.CustomerMessageService;
import weixin.idea.votepk.entity.WeixinVotePKRecord;
import weixin.idea.votepk.service.WeixinVotePKConfigService;
import weixin.idea.votepk.service.WeixinVotePKRecordService;

@Service(value="weixinVotePKRecordService")
public class WeixinVotePKRecordServiceImpl
extends CommonServiceImpl
implements WeixinVotePKRecordService {
    @Autowired
    private GzUserInfoService gzUserInfoService;
    @Autowired
    private CustomerMessageService customerMessageService;
    @Autowired
    private WeixinAccountServiceI weixinAccountService;
    @Autowired
    private WeixinVotePKConfigService weixinVotePKConfigService;

    @Override
    public List<WeixinVotePKRecord> getVotePkRecordList(String openid, String accountid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinVotePKRecord.class);
        try {
            cq.eq("accountid", (Object)accountid);
            cq.eq("openid", (Object)openid);
            cq.eq("subscribe", (Object)"1");
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        cq.add();
        List recordlist = this.getListByCriteriaQuery(cq, false);
        return recordlist;
    }

    @Override
    public List<WeixinVotePKRecord> getSelfVotePkRecordList(String openid, String accountid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinVotePKRecord.class);
        try {
            cq.eq("accountid", (Object)accountid);
            cq.eq("voteopenid", (Object)openid);
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        cq.add();
        List recordlist = this.getListByCriteriaQuery(cq, false);
        return recordlist;
    }

    @Override
    public boolean checkVote(String openid, String voteopenid, String accountid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinVotePKRecord.class);
        try {
            cq.eq("accountid", (Object)accountid);
            cq.eq("openid", (Object)openid);
            cq.eq("voteopenid", (Object)voteopenid);
            cq.notEq("votetype", (Object)"3");
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        cq.add();
        List recordlist = this.getListByCriteriaQuery(cq, false);
        return recordlist.size() != 0;
    }

    @Override
    public boolean checkVoteShare(String openid, String voteopenid, String accountid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinVotePKRecord.class);
        try {
            cq.eq("accountid", (Object)accountid);
            cq.eq("openid", (Object)openid);
            cq.eq("voteopenid", (Object)voteopenid);
            cq.eq("votetype", (Object)"3");
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        cq.add();
        List recordlist = this.getListByCriteriaQuery(cq, false);
        return recordlist.size() != 0;
    }

    @Override
    public void sendMsg(String openid, String voteopenid, String accountid, String type) {
        GzUserInfoYw beivoteuser = this.gzUserInfoService.getLocalUserinfoSubscribe(openid, accountid);
        GzUserInfoYw voteuser = this.gzUserInfoService.getLocalUserinfoSubscribe(voteopenid, accountid);
        if (voteuser == null) {
            WeixinAccountEntity account = (WeixinAccountEntity)this.weixinAccountService.get(WeixinAccountEntity.class, (Serializable)((Object)accountid));
            this.gzUserInfoService.saveGzUserInfoByOpenId(voteopenid, account.getWeixinOriginalAccountid());
            voteuser = this.gzUserInfoService.getLocalUserinfoSubscribe(openid, accountid);
        }
        ResourceBundle bundler = ResourceBundle.getBundle("sysConfig");
        String dzpurl = String.valueOf(bundler.getString("domain")) + "/zpController.do?goZhuanpanForVotepk&openid=" + openid + "&accountid=" + accountid;
        String responseTextForVoted = this.getVotedresponsetext(accountid);
        String responseTextForVote = this.getVoteresponsetext(accountid);
        if ("1".equals(type)) {
            if (voteuser != null) {
                responseTextForVoted = responseTextForVoted.replace("XXX", new String(WeixinUtil.decode(voteuser.getNickname()))).replace("dzpurl", dzpurl);
            }
            if (beivoteuser != null) {
                responseTextForVote = responseTextForVote.replace("XXX", new String(WeixinUtil.decode(beivoteuser.getNickname()))).replace("dzpurl", dzpurl);
            }
        } else if ("2".equals(type)) {
            if (voteuser != null) {
                responseTextForVoted = responseTextForVoted.replace("XXX", new String(WeixinUtil.decode(voteuser.getNickname()))).replace("dzpurl", dzpurl);
            }
            if (beivoteuser != null) {
                responseTextForVote = responseTextForVote.replace("XXX", new String(WeixinUtil.decode(beivoteuser.getNickname()))).replace("dzpurl", dzpurl);
            }
        } else if ("3".equals(type)) {
            if (voteuser != null) {
                responseTextForVoted = responseTextForVoted.replace("XXX", new String(WeixinUtil.decode(voteuser.getNickname()))).replace("dzpurl", dzpurl);
            }
            if (beivoteuser != null) {
                responseTextForVote = responseTextForVote.replace("XXX", new String(WeixinUtil.decode(beivoteuser.getNickname()))).replace("dzpurl", dzpurl);
            }
        }
        TextMessageKf customMessage = new TextMessageKf();
        customMessage.setMsgtype("text");
        TextItem textItem = new TextItem();
        textItem.setContent(responseTextForVoted);
        customMessage.setText(textItem);
        customMessage.setTouser(beivoteuser.getOpenid());
        JSONObject jsonObj = JSONObject.fromObject((Object)customMessage);
        this.customerMessageService.sendMessage(jsonObj.toString(), accountid);
        customMessage.setTouser(voteuser.getOpenid());
        textItem.setContent(responseTextForVote);
        jsonObj = JSONObject.fromObject((Object)customMessage);
        this.customerMessageService.sendMessage(jsonObj.toString(), accountid);
    }

    private String getVoteresponsetext(String accountid) {
        return this.weixinVotePKConfigService.getByName("voteresponsetext", accountid).getConfigValue();
    }

    private String getVotedresponsetext(String accountid) {
        return this.weixinVotePKConfigService.getByName("votedresponsetext", accountid).getConfigValue();
    }
}

