/*
 * Decompiled with CFR 0.152.
 */
package weixin.idea.votepk.controller;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.vo.datatable.SortDirection;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.guanjia.account.entity.WeixinAccountEntity;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.core.util.WeixinUtil;
import weixin.guanjia.gzuserinfo.entity.GzUserInfoYw;
import weixin.guanjia.gzuserinfo.model.GzUserInfo;
import weixin.guanjia.gzuserinfo.service.GzUserInfoService;
import weixin.guanjia.location.entity.LocationEntity;
import weixin.guanjia.location.service.LocationServiceI;
import weixin.guanjia.message.service.CustomerMessageService;
import weixin.idea.qrcode.entity.WeixinQrcodeEntity;
import weixin.idea.qrcode.service.WeixinQrcodeSceneSeqServiceI;
import weixin.idea.qrcode.service.WeixinQrcodeServiceI;
import weixin.idea.votepk.entity.WeixinVotePKConfig;
import weixin.idea.votepk.entity.WeixinVotePKRecord;
import weixin.idea.votepk.entity.WeixinVotePKSignUserinfo;
import weixin.idea.votepk.service.WeixinVotePKConfigService;
import weixin.idea.votepk.service.WeixinVotePKRecordService;
import weixin.idea.votepk.service.WeixinVotePKSignUserinfoService;
import weixin.idea.votepk.view.WeixinVotePKSortView;
import weixin.util.HttpUtil;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/weixinVotePKController"})
public class WeixinVotePKController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinVotePKController.class);
    @Autowired
    private WeixinVotePKSignUserinfoService weixinVotePKSignUserinfoService;
    @Autowired
    private WeixinVotePKRecordService weixinVotePKRecordService;
    @Autowired
    private GzUserInfoService gzUserInfoService;
    @Autowired
    private WeixinQrcodeServiceI weixinQrcodeService;
    @Autowired
    private WeixinQrcodeSceneSeqServiceI weixinQrcodeSceneSeqService;
    @Autowired
    private WeixinAccountServiceI weixinAccountService;
    @Autowired
    private CustomerMessageService customerMessageService;
    @Autowired
    private WeixinVotePKConfigService weixinVotePKConfigService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private LocationServiceI locationEntityService;

    @RequestMapping(params={"goZhongjiang"})
    public ModelAndView goZhongjiang() {
        return new ModelAndView("weixin/idea/votepk/zhongjiang");
    }

    @RequestMapping(params={"goSuccess"})
    public ModelAndView goSuccess() {
        return new ModelAndView("weixin/idea/votepk/success");
    }

    @RequestMapping(params={"goVotePK"})
    public ModelAndView goVotePK(WeixinVotePKSignUserinfo weixinVotePKSignUserinfo, String voteopenid, HttpServletRequest request) {
        ResourceBundle bundler = ResourceBundle.getBundle("sysConfig");
        String accountid = weixinVotePKSignUserinfo.getAccountid();
        String openid = weixinVotePKSignUserinfo.getOpenid();
        WeixinAccountEntity account = (WeixinAccountEntity)this.weixinAccountService.get(WeixinAccountEntity.class, (Serializable)((Object)accountid));
        String shareurl = "";
        try {
            String redirecturi = URLEncoder.encode(String.valueOf(bundler.getString("domain")) + "/weixinVotePKController.do?goVotePK&openid=" + openid + "&accountid=" + accountid, "UTF-8");
            shareurl = WeixinUtil.web_oauth_url.replace("APPID", account.getAccountappid()).replace("REDIRECT_URI", redirecturi).replace("SCOPE", "snsapi_base");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (request.getParameter("code") != null) {
            String code = request.getParameter("code");
            logger.info((Object)("\u901a\u8fc7\u7f51\u9875\u6388\u6743\u83b7\u5f97\u7684CODE\u4e3a\uff1a" + code));
            String openidurl = WeixinUtil.web_oauth_accesstoken_url.replace("APPID", account.getAccountappid()).replace("SECRET", account.getAccountappsecret()).replace("CODE", code);
            JSONObject jsonObj = WeixinUtil.httpRequest(openidurl, "GET", "");
            if (jsonObj.containsKey((Object)"openid")) {
                logger.info((Object)("\u901a\u8fc7\u7f51\u9875\u6388\u6743\u83b7\u5f97\u7684OPENID\u4e3a\uff1a" + jsonObj.getString("openid")));
                GzUserInfoYw voteuser = this.gzUserInfoService.getLocalUserinfoSubscribe(jsonObj.getString("openid"), accountid);
                if (voteuser != null && voteuser.getSubscribe().equals("1")) {
                    request.setAttribute("subscribeflag", (Object)1);
                } else {
                    request.setAttribute("subscribeflag", (Object)0);
                }
                voteopenid = jsonObj.getString("openid");
            }
        }
        WeixinVotePKSignUserinfo userinfo = this.weixinVotePKSignUserinfoService.getSignUserinfo(accountid, openid);
        GzUserInfoYw cuser = this.gzUserInfoService.getLocalUserinfoSubscribe(openid, accountid);
        request.setAttribute("domain", (Object)bundler.getString("domain"));
        request.setAttribute("appid", (Object)account.getAccountappid());
        if (userinfo != null) {
            List<WeixinVotePKRecord> recordlist = this.weixinVotePKRecordService.getVotePkRecordList(openid, accountid);
            request.setAttribute("userinfo", (Object)userinfo);
            request.setAttribute("nickname", (Object)new String(WeixinUtil.decode(cuser.getNickname())));
            request.setAttribute("recordlist", recordlist);
            request.setAttribute("cuser", (Object)cuser);
            request.setAttribute("openid", (Object)openid);
            request.setAttribute("accountid", (Object)accountid);
            request.setAttribute("shareurl", (Object)shareurl);
            request.setAttribute("sharecontent", (Object)this.getShareContent(accountid));
            WeixinVotePKConfig config = this.weixinVotePKConfigService.getByName("friendssharerows", userinfo.getAccountid());
            request.setAttribute("sharevotecount", (Object)config.getConfigValue());
            String subscribeurl = this.weixinVotePKConfigService.getByName("subscribearticleurl", accountid).getConfigValue();
            String hdjs = this.weixinVotePKConfigService.getByName("introduceurl", accountid).getConfigValue();
            String hdgz = this.weixinVotePKConfigService.getByName("ruleurl", accountid).getConfigValue();
            String tpgl = this.weixinVotePKConfigService.getByName("strategy", accountid).getConfigValue();
            String tpzc = this.weixinVotePKConfigService.getByName("votesupport", accountid).getConfigValue();
            String zcyl = this.weixinVotePKConfigService.getByName("supportgift", accountid).getConfigValue();
            request.setAttribute("hdjs", (Object)"#");
            request.setAttribute("hdgz", (Object)"#");
            request.setAttribute("tpgl", (Object)"#");
            if (!StringUtil.isEmpty((String)hdjs)) {
                request.setAttribute("hdjs", (Object)hdjs);
            }
            if (!StringUtil.isEmpty((String)tpgl)) {
                request.setAttribute("tpgl", (Object)tpgl);
            }
            if (!StringUtil.isEmpty((String)hdgz)) {
                request.setAttribute("hdgz", (Object)hdgz);
            }
            if (!StringUtil.isEmpty((String)tpzc)) {
                request.setAttribute("tpzc", (Object)tpzc);
            }
            if (!StringUtil.isEmpty((String)hdgz)) {
                request.setAttribute("zcyl", (Object)zcyl);
            }
            request.setAttribute("voteopenid", (Object)voteopenid);
            request.setAttribute("sharetitle", (Object)this.getSharetitle(accountid));
            request.setAttribute("subscribeurl", (Object)subscribeurl);
            return new ModelAndView("weixin/idea/votepk/weixinVotePK-userinfo");
        }
        LocationEntity location = this.locationEntityService.findLocation(openid, accountid);
        if (location != null) {
            String cityname = this.weixinVotePKConfigService.getByName("locationvalid", accountid).getConfigValue();
            String locationurl = "http://apis.map.qq.com/ws/geocoder/v1/?location=" + location.getLatitude() + "," + location.getLongitude() + "&key=FESBZ-YSJRU-QGDVM-4KPHK-GQPXF-HOBUO&get_poi=0";
            com.alibaba.fastjson.JSONObject jo = HttpUtil.httpRequest(locationurl, "GET", null);
            String currentcity = jo.getJSONObject("result").getJSONObject("address_component").getString("city");
            logger.info((Object)("\u5f53\u524d\u9650\u5236\u5730\u533a\u4e3a\uff1a" + cityname));
            logger.info((Object)("\u7528\u6237\u5730\u7406\u4f4d\u7f6e\u4e3a\uff1a" + currentcity));
            if (!cityname.contains(currentcity)) {
                request.setAttribute("msg", (Object)("\u672c\u6b21\u6d3b\u52a8\u4ec5\u9488\u5bf9" + cityname + "\u5730\u533a,\u8c22\u8c22\u60a8\u7684\u5173\u6ce8"));
                return new ModelAndView("weixin/idea/votepk/weixinVotePK-nolocation");
            }
        }
        if (request.getParameter("code") != null) {
            String code = request.getParameter("code");
            logger.info((Object)("\u901a\u8fc7\u7f51\u9875\u6388\u6743\u83b7\u5f97\u7684CODE\u4e3a\uff1a" + code));
            String openidurl = WeixinUtil.web_oauth_accesstoken_url.replace("APPID", account.getAccountappid()).replace("SECRET", account.getAccountappsecret()).replace("CODE", code);
            JSONObject jsonObj = WeixinUtil.httpRequest(openidurl, "GET", "");
            openid = jsonObj.getString("openid");
        }
        GzUserInfo user = this.gzUserInfoService.getGzUserInfo(openid, accountid);
        request.setAttribute("userinfo", (Object)user);
        request.setAttribute("openid", (Object)openid);
        request.setAttribute("accountid", (Object)accountid);
        request.setAttribute("shareurl", (Object)shareurl);
        request.setAttribute("sharecontent", (Object)this.getShareContent(accountid));
        request.setAttribute("sharetitle", (Object)this.getSharetitle(accountid));
        request.setAttribute("voteopenid", (Object)voteopenid);
        return new ModelAndView("weixin/idea/votepk/weixinVotePK-sign");
    }

    @RequestMapping(params={"goVotePKBySort"})
    public ModelAndView goVotePKBySort(WeixinVotePKSignUserinfo weixinVotePKSignUserinfo, String voteopenid, HttpServletRequest request) {
        ResourceBundle bundler = ResourceBundle.getBundle("sysConfig");
        String accountid = weixinVotePKSignUserinfo.getAccountid();
        String openid = weixinVotePKSignUserinfo.getOpenid();
        WeixinAccountEntity account = (WeixinAccountEntity)this.weixinAccountService.get(WeixinAccountEntity.class, (Serializable)((Object)accountid));
        String shareurl = "";
        try {
            String redirecturi = URLEncoder.encode(String.valueOf(bundler.getString("domain")) + "/weixinVotePKController.do?goVotePK&openid=" + openid + "&accountid=" + accountid, "UTF-8");
            shareurl = WeixinUtil.web_oauth_url.replace("APPID", account.getAccountappid()).replace("REDIRECT_URI", redirecturi).replace("SCOPE", "snsapi_base");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (request.getParameter("code") != null) {
            String code = request.getParameter("code");
            logger.info((Object)("\u901a\u8fc7\u7f51\u9875\u6388\u6743\u83b7\u5f97\u7684CODE\u4e3a\uff1a" + code));
            String openidurl = WeixinUtil.web_oauth_accesstoken_url.replace("APPID", account.getAccountappid()).replace("SECRET", account.getAccountappsecret()).replace("CODE", code);
            LogUtil.info((Object)openidurl);
            JSONObject jsonObj = WeixinUtil.httpRequest(openidurl, "GET", "");
            if (jsonObj.containsKey((Object)"openid")) {
                logger.info((Object)("\u901a\u8fc7\u7f51\u9875\u6388\u6743\u83b7\u5f97\u7684OPENID\u4e3a\uff1a" + jsonObj.getString("openid")));
                GzUserInfoYw voteuser = this.gzUserInfoService.getLocalUserinfoSubscribe(jsonObj.getString("openid"), accountid);
                if (voteuser != null && voteuser.getSubscribe().equals("1")) {
                    request.setAttribute("subscribeflag", (Object)1);
                } else {
                    request.setAttribute("subscribeflag", (Object)0);
                }
                voteopenid = jsonObj.getString("openid");
            }
        }
        WeixinVotePKSignUserinfo userinfo = this.weixinVotePKSignUserinfoService.getSignUserinfo(accountid, openid);
        GzUserInfoYw cuser = this.gzUserInfoService.getLocalUserinfoAll(openid, accountid);
        request.setAttribute("domain", (Object)bundler.getString("domain"));
        request.setAttribute("appid", (Object)account.getAccountappid());
        if (userinfo != null) {
            List<WeixinVotePKRecord> recordlist = this.weixinVotePKRecordService.getVotePkRecordList(openid, accountid);
            request.setAttribute("userinfo", (Object)userinfo);
            request.setAttribute("nickname", (Object)new String(WeixinUtil.decode(cuser.getNickname())));
            request.setAttribute("recordlist", recordlist);
            request.setAttribute("cuser", (Object)cuser);
            request.setAttribute("openid", (Object)openid);
            request.setAttribute("accountid", (Object)accountid);
            request.setAttribute("shareurl", (Object)shareurl);
            request.setAttribute("sharecontent", (Object)this.getShareContent(accountid));
            WeixinVotePKConfig config = this.weixinVotePKConfigService.getByName("friendssharerows", userinfo.getAccountid());
            request.setAttribute("sharevotecount", (Object)config.getConfigValue());
            String subscribeurl = this.weixinVotePKConfigService.getByName("subscribearticleurl", accountid).getConfigValue();
            String hdjs = this.weixinVotePKConfigService.getByName("introduceurl", accountid).getConfigValue();
            String hdgz = this.weixinVotePKConfigService.getByName("ruleurl", accountid).getConfigValue();
            String tpgl = this.weixinVotePKConfigService.getByName("strategy", accountid).getConfigValue();
            String tpzc = this.weixinVotePKConfigService.getByName("votesupport", accountid).getConfigValue();
            String zcyl = this.weixinVotePKConfigService.getByName("supportgift", accountid).getConfigValue();
            request.setAttribute("hdjs", (Object)"#");
            request.setAttribute("hdgz", (Object)"#");
            request.setAttribute("tpgl", (Object)"#");
            if (!StringUtil.isEmpty((String)hdjs)) {
                request.setAttribute("hdjs", (Object)hdjs);
            }
            if (!StringUtil.isEmpty((String)tpgl)) {
                request.setAttribute("tpgl", (Object)tpgl);
            }
            if (!StringUtil.isEmpty((String)hdgz)) {
                request.setAttribute("hdgz", (Object)hdgz);
            }
            if (!StringUtil.isEmpty((String)tpzc)) {
                request.setAttribute("tpzc", (Object)tpzc);
            }
            if (!StringUtil.isEmpty((String)hdgz)) {
                request.setAttribute("zcyl", (Object)zcyl);
            }
            request.setAttribute("voteopenid", (Object)voteopenid);
            request.setAttribute("sharetitle", (Object)this.getSharetitle(accountid));
            request.setAttribute("subscribeurl", (Object)subscribeurl);
        }
        return new ModelAndView("weixin/idea/votepk/weixinVotePK-userinfo");
    }

    @RequestMapping(params={"doSign"})
    public ModelAndView doSign(WeixinVotePKSignUserinfo userinfo, HttpServletRequest request) {
        GzUserInfoYw user = this.gzUserInfoService.getLocalUserinfoSubscribe(userinfo.getOpenid(), userinfo.getAccountid());
        if (user == null) {
            WeixinAccountEntity account = (WeixinAccountEntity)this.weixinAccountService.get(WeixinAccountEntity.class, (Serializable)((Object)userinfo.getAccountid()));
            this.gzUserInfoService.saveGzUserInfoByOpenId(userinfo.getOpenid(), account.getWeixinOriginalAccountid());
        }
        if (this.weixinVotePKSignUserinfoService.checkSign(userinfo.getOpenid(), userinfo.getAccountid())) {
            return this.goVotePK(userinfo, userinfo.getOpenid(), request);
        }
        AjaxJson j = new AjaxJson();
        WeixinQrcodeEntity weixinqrcode = new WeixinQrcodeEntity();
        int sceneid = this.weixinQrcodeSceneSeqService.getQrcodeSceneseq(userinfo.getAccountid()).getCount();
        weixinqrcode.setSceneId(sceneid);
        weixinqrcode.setAccountid(userinfo.getAccountid());
        String qrcodeurl = this.weixinQrcodeService.getQrcodeImgurl(weixinqrcode, request);
        userinfo.setQrcodeurl(qrcodeurl);
        userinfo.setSceneid(sceneid);
        userinfo.setSigndate(new Date());
        userinfo.setVotecount(0);
        this.weixinVotePKSignUserinfoService.save(userinfo);
        return this.goVotePK(userinfo, userinfo.getOpenid(), request);
    }

    @RequestMapping(params={"goVotePKSort"})
    public ModelAndView goVotePKSort(String accountid, int page, HttpServletRequest request) {
        int pageSize = Integer.valueOf(this.weixinVotePKConfigService.getByName("sortperpagerows", accountid).getConfigValue());
        CriteriaQuery cq = new CriteriaQuery(WeixinVotePKSignUserinfo.class);
        try {
            cq.eq("accountid", (Object)accountid);
            cq.setCurPage(Integer.valueOf(page));
            cq.setPageSize(pageSize);
            cq.addOrder("votecount", SortDirection.desc);
            cq.add();
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        List userlist = this.weixinVotePKSignUserinfoService.getListByCriteriaQuery(cq, true);
        int count = this.weixinVotePKSignUserinfoService.count(cq);
        ArrayList<WeixinVotePKSortView> viewlist = new ArrayList<WeixinVotePKSortView>();
        for (WeixinVotePKSignUserinfo u : userlist) {
            GzUserInfoYw gzuser = this.gzUserInfoService.getLocalUserinfoAll(u.getOpenid(), u.getAccountid());
            if (gzuser == null) continue;
            WeixinVotePKSortView view = new WeixinVotePKSortView();
            view.setAccountid(u.getAccountid());
            view.setVotecount(u.getVotecount());
            view.setOpenid(u.getOpenid());
            view.setImgurl(gzuser.getHeadimgurl());
            view.setNickname(new String(WeixinUtil.decode(gzuser.getNickname())));
            viewlist.add(view);
        }
        int pagecount = count % pageSize == 0 ? count / pageSize : count / pageSize + 1;
        String openid = request.getParameter("openid");
        String voteopenid = request.getParameter("voteopenid");
        if (!StringUtil.isEmpty((String)request.getParameter("code"))) {
            String code = request.getParameter("code");
            logger.info((Object)("\u901a\u8fc7\u7f51\u9875\u6388\u6743\u83b7\u5f97\u7684CODE\u4e3a\uff1a" + code));
            WeixinAccountEntity account = (WeixinAccountEntity)this.weixinAccountService.get(WeixinAccountEntity.class, (Serializable)((Object)accountid));
            String openidurl = WeixinUtil.web_oauth_accesstoken_url.replace("APPID", account.getAccountappid()).replace("SECRET", account.getAccountappsecret()).replace("CODE", code);
            JSONObject jsonObj = WeixinUtil.httpRequest(openidurl, "GET", "");
            voteopenid = jsonObj.getString("openid");
        }
        String hdjs = this.weixinVotePKConfigService.getByName("introduceurl", accountid).getConfigValue();
        String hdgz = this.weixinVotePKConfigService.getByName("ruleurl", accountid).getConfigValue();
        String tpgl = this.weixinVotePKConfigService.getByName("strategy", accountid).getConfigValue();
        request.setAttribute("openid", (Object)openid);
        request.setAttribute("voteopenid", (Object)voteopenid);
        request.setAttribute("accountid", (Object)accountid);
        request.setAttribute("count", (Object)count);
        request.setAttribute("pagecount", (Object)pagecount);
        request.setAttribute("page", (Object)page);
        request.setAttribute("pageSize", (Object)pageSize);
        request.setAttribute("viewlist", viewlist);
        request.setAttribute("sharecontent", (Object)this.getShareContent(accountid));
        request.setAttribute("shareurl", (Object)this.getSortShareUrl(openid, accountid));
        request.setAttribute("sharetitle", (Object)this.getSharetitle(accountid));
        WeixinVotePKSignUserinfo userinfo = this.weixinVotePKSignUserinfoService.getSignUserinfo(accountid, openid);
        request.setAttribute("userinfo", (Object)userinfo);
        request.setAttribute("hdjs", (Object)hdjs);
        request.setAttribute("hdgz", (Object)hdgz);
        request.setAttribute("tpgl", (Object)tpgl);
        return new ModelAndView("weixin/idea/votepk/weixinVotePK-sort");
    }

    private String getShareUrl(String openid, String accountid) {
        ResourceBundle bundler = ResourceBundle.getBundle("sysConfig");
        WeixinAccountEntity account = (WeixinAccountEntity)this.weixinAccountService.get(WeixinAccountEntity.class, (Serializable)((Object)accountid));
        String shareurl = "";
        try {
            String redirecturi = URLEncoder.encode(String.valueOf(bundler.getString("domain")) + "/weixinVotePKController.do?goVotePK&openid=" + openid + "&accountid=" + accountid, "UTF-8");
            shareurl = WeixinUtil.web_oauth_url.replace("APPID", account.getAccountappid()).replace("REDIRECT_URI", redirecturi).replace("SCOPE", "snsapi_base");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return shareurl;
    }

    private String getSortShareUrl(String openid, String accountid) {
        ResourceBundle bundler = ResourceBundle.getBundle("sysConfig");
        WeixinAccountEntity account = (WeixinAccountEntity)this.weixinAccountService.get(WeixinAccountEntity.class, (Serializable)((Object)accountid));
        String shareurl = "";
        try {
            String redirecturi = URLEncoder.encode(String.valueOf(bundler.getString("domain")) + "/weixinVotePKController.do?goVotePKSort&page=1&openid=" + openid + "&accountid=" + accountid, "UTF-8");
            shareurl = WeixinUtil.web_oauth_url.replace("APPID", account.getAccountappid()).replace("REDIRECT_URI", redirecturi).replace("SCOPE", "snsapi_base");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return shareurl;
    }

    private String getSharetitle(String accountid) {
        return this.weixinVotePKConfigService.getByName("sharetitle", accountid).getConfigValue();
    }

    private String getShareContent(String accountid) {
        return this.weixinVotePKConfigService.getByName("sharecontent", accountid).getConfigValue();
    }

    @RequestMapping(params={"getMore"})
    @ResponseBody
    public AjaxJson getMore(String accountid, int page, HttpServletRequest request) {
        int pageSize = Integer.valueOf(this.weixinVotePKConfigService.getByName("sortperpage", accountid).getConfigValue());
        AjaxJson j = new AjaxJson();
        CriteriaQuery cq = new CriteriaQuery(WeixinVotePKSignUserinfo.class);
        try {
            cq.eq("accountid", (Object)accountid);
            cq.setCurPage(Integer.valueOf(page));
            cq.setPageSize(pageSize);
            cq.addOrder("votecount", SortDirection.desc);
            cq.add();
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        List userlist = this.weixinVotePKSignUserinfoService.getListByCriteriaQuery(cq, true);
        ArrayList<WeixinVotePKSortView> viewlist = new ArrayList<WeixinVotePKSortView>();
        for (WeixinVotePKSignUserinfo u : userlist) {
            GzUserInfoYw gzuser = this.gzUserInfoService.getLocalUserinfoAll(u.getOpenid(), u.getAccountid());
            if (gzuser == null) continue;
            WeixinVotePKSortView view = new WeixinVotePKSortView();
            view.setAccountid(u.getAccountid());
            view.setImgurl(gzuser.getHeadimgurl());
            view.setNickname(new String(WeixinUtil.decode(gzuser.getNickname())));
            view.setVotecount(u.getVotecount());
            view.setOpenid(u.getOpenid());
            viewlist.add(view);
        }
        j.setObj(viewlist);
        return j;
    }

    @RequestMapping(params={"doAddVoteCountByFriends"})
    @ResponseBody
    public AjaxJson doAddVoteCountByFriends(WeixinVotePKSignUserinfo userinfo, String voteopenid, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isEmpty((String)voteopenid)) {
            j.setSuccess(false);
            return j;
        }
        if (userinfo.getOpenid().equals(voteopenid)) {
            return j;
        }
        if (this.weixinVotePKRecordService.checkVoteShare(userinfo.getOpenid(), voteopenid, userinfo.getAccountid())) {
            return j;
        }
        GzUserInfoYw voteuser = this.gzUserInfoService.getLocalUserinfoSubscribe(voteopenid, userinfo.getAccountid());
        if (voteuser != null && voteuser.getSubscribe().equals("1")) {
            userinfo = (WeixinVotePKSignUserinfo)this.weixinVotePKSignUserinfoService.get(WeixinVotePKSignUserinfo.class, (Serializable)((Object)userinfo.getId()));
            WeixinVotePKConfig config = this.weixinVotePKConfigService.getByName("friendssharecount", userinfo.getAccountid());
            int maxcount = 4;
            if (config != null) {
                maxcount = Integer.valueOf(config.getConfigValue());
            }
            userinfo.setVotecount(userinfo.getVotecount() + maxcount);
            this.weixinVotePKSignUserinfoService.updateEntitie(userinfo);
            WeixinVotePKRecord record = new WeixinVotePKRecord();
            record.setAccountid(userinfo.getAccountid());
            record.setOpenid(userinfo.getOpenid());
            record.setVotedate(new Date());
            record.setVoteopenid(voteopenid);
            record.setVotenickname(new String(WeixinUtil.decode(voteuser.getNickname())));
            record.setSubscribe("1");
            record.setVotecount(maxcount);
            GzUserInfoYw cuser = this.gzUserInfoService.getLocalUserinfoSubscribe(userinfo.getOpenid(), userinfo.getAccountid());
            record.setNickname(new String(WeixinUtil.decode(cuser.getNickname())));
            record.setHeadimgurl(voteuser.getHeadimgurl());
            record.setVotetype("3");
            int lettecount = Integer.valueOf(this.weixinVotePKConfigService.getByName("normalvotelettecount", record.getAccountid()).getConfigValue());
            voteuser.setLettecount(voteuser.getLettecount() + lettecount);
            this.systemService.updateEntitie((Object)voteuser);
            this.weixinVotePKRecordService.save(record);
            j.setSuccess(true);
            this.weixinVotePKRecordService.sendMsg(userinfo.getOpenid(), voteopenid, userinfo.getAccountid(), "3");
        }
        return j;
    }

    @RequestMapping(params={"doVotePK"})
    @ResponseBody
    public AjaxJson doVotePK(WeixinVotePKSignUserinfo userinfo, String voteopenid, HttpServletRequest request) {
        GzUserInfoYw cuser = this.gzUserInfoService.getLocalUserinfoSubscribe(userinfo.getOpenid(), userinfo.getAccountid());
        HashMap<String, String> locationmap = new HashMap<String, String>();
        GzUserInfoYw voteuser = null;
        AjaxJson j = new AjaxJson();
        if (StringUtil.isEmpty((String)voteopenid)) {
            j.setSuccess(false);
            j.setMsg("\u4eb2\uff0c\u8bf7\u91cd\u65b0\u8fdb\u5165\u6295\u7968\u9875\u9762\uff01");
            locationmap.put("flag", "0");
            j.setAttributes(locationmap);
            return j;
        }
        if (this.weixinVotePKRecordService.checkVote(userinfo.getOpenid(), voteopenid, userinfo.getAccountid())) {
            j.setSuccess(false);
            j.setMsg("\u4f60\u5df2\u7ecf\u6295\u8fc7\u7968\u4e86\uff0c\u4e0d\u80fd\u91cd\u590d\u6295\u7968\u3002");
            locationmap.put("flag", "0");
            j.setAttributes(locationmap);
            return j;
        }
        voteuser = this.gzUserInfoService.getLocalUserinfoSubscribe(voteopenid, userinfo.getAccountid());
        if (voteuser == null || voteuser.getSubscribe().equals("0")) {
            WeixinVotePKRecord record = new WeixinVotePKRecord();
            record.setAccountid(userinfo.getAccountid());
            record.setOpenid(userinfo.getOpenid());
            record.setVotedate(new Date());
            record.setVoteopenid(voteopenid);
            record.setVotetype("1");
            record.setSubscribe("0");
            record.setVotecount(1);
            if (voteuser != null && voteuser.getHeadimgurl() != null) {
                record.setHeadimgurl(voteuser.getHeadimgurl());
                record.setVotenickname(new String(WeixinUtil.decode(voteuser.getNickname())));
            } else {
                record.setHeadimgurl("#");
            }
            if (cuser != null) {
                record.setNickname(new String(WeixinUtil.decode(cuser.getNickname())));
            } else {
                record.setNickname("\u533f\u540d\u7528\u6237");
            }
            this.weixinVotePKRecordService.save(record);
            j.setSuccess(false);
            locationmap.put("flag", "1");
            j.setAttributes(locationmap);
            return j;
        }
        userinfo = (WeixinVotePKSignUserinfo)this.weixinVotePKSignUserinfoService.get(WeixinVotePKSignUserinfo.class, (Serializable)((Object)userinfo.getId()));
        userinfo.setVotecount(userinfo.getVotecount() + 1);
        this.weixinVotePKSignUserinfoService.updateEntitie(userinfo);
        WeixinVotePKRecord record = new WeixinVotePKRecord();
        record.setAccountid(userinfo.getAccountid());
        record.setOpenid(userinfo.getOpenid());
        record.setVotedate(new Date());
        record.setVoteopenid(voteopenid);
        record.setVotetype("1");
        record.setSubscribe("1");
        record.setVotenickname(new String(WeixinUtil.decode(voteuser.getNickname())));
        record.setVotecount(1);
        if (voteuser != null && voteuser.getHeadimgurl() != null) {
            record.setHeadimgurl(voteuser.getHeadimgurl());
        } else {
            record.setHeadimgurl("#");
        }
        if (cuser != null) {
            record.setNickname(new String(WeixinUtil.decode(cuser.getNickname())));
        } else {
            record.setNickname("\u533f\u540d\u7528\u6237");
        }
        int lettecount = Integer.valueOf(this.weixinVotePKConfigService.getByName("normalvotelettecount", record.getAccountid()).getConfigValue());
        voteuser.setLettecount(voteuser.getLettecount() + lettecount);
        this.systemService.updateEntitie((Object)voteuser);
        this.weixinVotePKRecordService.save(record);
        this.weixinVotePKRecordService.sendMsg(record.getOpenid(), record.getVoteopenid(), record.getAccountid(), record.getVotetype());
        j.setSuccess(true);
        return j;
    }

    @RequestMapping(params={"checkVoteUser"})
    @ResponseBody
    public AjaxJson checkVoteUser(WeixinVotePKSignUserinfo userinfo, String voteopenid, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        j.setSuccess(false);
        if (StringUtil.isEmpty((String)voteopenid)) {
            j.setSuccess(false);
            j.setMsg("0");
            return j;
        }
        GzUserInfoYw voteuser = this.gzUserInfoService.getLocalUserinfoSubscribe(voteopenid, userinfo.getAccountid());
        if (voteuser != null && voteuser.getSubscribe().equals("1")) {
            j.setSuccess(true);
            j.setMsg("1");
        }
        return j;
    }

    @RequestMapping(params={"checkSubscribe"})
    @ResponseBody
    public AjaxJson checkSubscribe(WeixinVotePKSignUserinfo userinfo, String voteopenid, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        GzUserInfoYw voteuser = this.gzUserInfoService.getLocalUserinfoSubscribe(voteopenid, userinfo.getAccountid());
        if (voteuser != null && voteuser.getSubscribe().equals("1")) {
            j.setSuccess(true);
        } else {
            j.setSuccess(false);
        }
        return j;
    }

    @RequestMapping(params={"updateNickname"})
    @ResponseBody
    public AjaxJson updateNickname(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        List recordlist = this.weixinVotePKRecordService.loadAll(WeixinVotePKRecord.class);
        List gzlist = this.weixinVotePKRecordService.loadAll(GzUserInfoYw.class);
        block0: for (WeixinVotePKRecord r : recordlist) {
            for (GzUserInfoYw gz : gzlist) {
                if (!gz.getOpenid().equals(r.getVoteopenid())) continue;
                r.setVotenickname(new String(WeixinUtil.decode(gz.getNickname())));
                this.weixinVotePKRecordService.updateEntitie(r);
                continue block0;
            }
        }
        return j;
    }
}

