/*
 * Decompiled with CFR 0.152.
 */
package weixin.idea.vote.service.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.StringUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import weixin.idea.vote.entity.WeixinVoteEntity;
import weixin.idea.vote.entity.WeixinVoteOptionEntity;
import weixin.idea.vote.service.WeixinVoteServiceI;

@Service(value="weixinVoteService")
@Transactional
public class WeixinVoteServiceImpl
extends CommonServiceImpl
implements WeixinVoteServiceI {
    @Override
    public <T> void delete(T entity) {
        super.delete(entity);
        this.doDelSql((WeixinVoteEntity)entity);
    }

    @Override
    public <T> Serializable save(T entity) {
        WeixinVoteEntity weixinVoteEntity = (WeixinVoteEntity)entity;
        if (StringUtil.isEmpty((String)weixinVoteEntity.getId())) {
            List<WeixinVoteOptionEntity> optionlist = weixinVoteEntity.getWeixinVoteOptions();
            weixinVoteEntity.setVoteCount(0);
            weixinVoteEntity.setStatement("0");
            Serializable t = super.save((Object)weixinVoteEntity);
            for (WeixinVoteOptionEntity option : optionlist) {
                option.setCount(0);
                option.setScale(0.0);
                option.setWeixinVote(weixinVoteEntity);
                super.save((Object)option);
            }
        } else {
            WeixinVoteEntity updateEntity = (WeixinVoteEntity)this.get(WeixinVoteEntity.class, (Serializable)((Object)weixinVoteEntity.getId()));
            List<WeixinVoteOptionEntity> optionlist = weixinVoteEntity.getWeixinVoteOptions();
            List oldoptionlist = super.findByProperty(WeixinVoteOptionEntity.class, "weixinVote.id", (Object)weixinVoteEntity.getId());
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)weixinVoteEntity, (Object)updateEntity);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            super.updateEntitie((Object)updateEntity);
            super.deleteAllEntitie((Collection)oldoptionlist);
            for (WeixinVoteOptionEntity option : optionlist) {
                option.setWeixinVote(weixinVoteEntity);
                option.setCount(0);
                option.setScale(0.0);
                super.save((Object)option);
            }
        }
        return weixinVoteEntity;
    }

    @Override
    public <T> void saveOrUpdate(T entity) {
        WeixinVoteEntity weixinVoteEntity = (WeixinVoteEntity)entity;
        super.saveOrUpdate((Object)weixinVoteEntity);
        this.doUpdateSql(weixinVoteEntity);
    }

    @Override
    public boolean doAddSql(WeixinVoteEntity t) {
        return true;
    }

    @Override
    public boolean doUpdateSql(WeixinVoteEntity t) {
        return true;
    }

    @Override
    public boolean doDelSql(WeixinVoteEntity t) {
        return true;
    }

    public String replaceVal(String sql, WeixinVoteEntity t) {
        sql = sql.replace("#{id}", String.valueOf(t.getId()));
        sql = sql.replace("#{create_name}", String.valueOf(t.getCreateName()));
        sql = sql.replace("#{create_date}", String.valueOf(t.getCreateDate()));
        sql = sql.replace("#{update_name}", String.valueOf(t.getUpdateName()));
        sql = sql.replace("#{update_date}", String.valueOf(t.getUpdateDate()));
        sql = sql.replace("#{vote_title}", String.valueOf(t.getVoteTitle()));
        sql = sql.replace("#{vote_count}", String.valueOf(t.getVoteCount()));
        sql = sql.replace("#{vote_description}", String.valueOf(t.getVoteDescription()));
        sql = sql.replace("#{integral}", String.valueOf(t.getIntegral()));
        sql = sql.replace("#{UUID}", UUID.randomUUID().toString());
        return sql;
    }
}

