/*
 * Decompiled with CFR 0.152.
 */
package weixin.idea.vote.controller;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.BrowserUtils;
import org.jeecgframework.core.util.ExceptionUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExcelTitle;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import weixin.idea.vote.entity.VoteRecordEntity;
import weixin.idea.vote.entity.WeixinVoteEntity;
import weixin.idea.vote.entity.WeixinVoteOptionEntity;
import weixin.idea.vote.service.VoteRecordServiceI;
import weixin.idea.vote.service.WeixinVoteOptionServiceI;
import weixin.idea.vote.service.WeixinVoteServiceI;
import weixin.vip.service.WeixinVipMemberServiceI;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/weixinVoteController"})
public class WeixinVoteController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinVoteController.class);
    @Autowired
    private WeixinVoteServiceI weixinVoteService;
    @Autowired
    private WeixinVoteOptionServiceI weixinVoteOptionService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private WeixinVipMemberServiceI weixinVipMemberService;
    @Autowired
    private VoteRecordServiceI voteRecordService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"weixinVote"})
    public ModelAndView weixinVote(HttpServletRequest request) {
        return new ModelAndView("weixin/idea/vote/weixinVoteList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeixinVoteEntity weixinVote, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinVoteEntity.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinVote, (Map)request.getParameterMap());
        try {
            cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        cq.add();
        this.weixinVoteService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"goAddVoteOption"})
    public ModelAndView goAddVoteOption(WeixinVoteEntity weixinVote, HttpServletRequest request) {
        if (!StringUtil.isEmpty((String)weixinVote.getId())) {
            List voteOptionList = this.weixinVoteOptionService.findByProperty(WeixinVoteOptionEntity.class, "weixinVote.id", weixinVote.getId());
            request.setAttribute("voteOptionList", (Object)voteOptionList);
        }
        return new ModelAndView("weixin/idea/vote/weixinVoteOption-add");
    }

    @RequestMapping(params={"deploy"})
    @ResponseBody
    public AjaxJson deploy(WeixinVoteEntity weixinVote, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String accountid = ResourceUtil.getShangJiaAccountId();
        if ("1".equals(weixinVote.getStatement())) {
            String sql = " UPDATE weixin_vote set statement = 2 where statement = 1 AND accountid= '" + accountid + "'";
            this.weixinVoteService.updateBySqlString(sql);
        }
        String sql2 = "UPDATE weixin_vote set statement ='" + weixinVote.getStatement() + "' where id = '" + weixinVote.getId() + "'";
        this.weixinVoteService.updateBySqlString(sql2);
        j.setSuccess(true);
        j.setMsg("\u64cd\u4f5c\u6210\u529f\uff01");
        return j;
    }

    @RequestMapping(params={"goVote"})
    public ModelAndView goVote(WeixinVoteEntity weixinVote, HttpServletRequest request) {
        List weixinVotes;
        String accountid = request.getParameter("accountid");
        String openid = request.getParameter("openid");
        if (StringUtil.isEmpty((String)accountid)) {
            accountid = ResourceUtil.getQianTaiAccountId();
        }
        if (!StringUtil.isEmpty((String)openid)) {
            request.setAttribute("openid", (Object)openid);
        }
        if ((weixinVotes = this.weixinVoteService.findByQueryString(" FROM WeixinVoteEntity v WHERE v.accountid = '" + accountid + "' AND statement = '1' ")).size() != 0) {
            request.setAttribute("weixinVote", weixinVotes.get(0));
            List voteoptionlist = this.weixinVoteOptionService.findByProperty(WeixinVoteOptionEntity.class, "weixinVote.id", ((WeixinVoteEntity)weixinVotes.get(0)).getId());
            request.setAttribute("voteoptionlist", (Object)voteoptionlist);
        }
        request.setAttribute("accountid", (Object)accountid);
        return new ModelAndView("weixin/idea/vote/front/vote");
    }

    @RequestMapping(params={"doVote"})
    @ResponseBody
    public AjaxJson doVote(WeixinVoteEntity weixinVote, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (this.voteRecordService.checkVote(ResourceUtil.getSessionUserName().getId(), weixinVote.getId())) {
            j.setSuccess(false);
            j.setMsg("\u60a8\u5df2\u7ecf\u6295\u8fc7\u7968\u4e86\uff01\u8c22\u8c22\u60a8\u7684\u53c2\u4e0e\u3002");
            return j;
        }
        weixinVote = (WeixinVoteEntity)this.weixinVoteService.get(WeixinVoteEntity.class, (Serializable)((Object)weixinVote.getId()));
        weixinVote.setVoteCount(weixinVote.getVoteCount() + 1);
        String optid = request.getParameter("optionid");
        WeixinVoteOptionEntity weixinVoteOption = (WeixinVoteOptionEntity)this.weixinVoteOptionService.get(WeixinVoteOptionEntity.class, (Serializable)((Object)optid));
        weixinVoteOption.setCount(weixinVoteOption.getCount() + 1);
        if (weixinVote.getVoteCount() != 0) {
            String scale = String.format("%.2f", (double)weixinVoteOption.getCount().intValue() / (double)weixinVote.getVoteCount().intValue());
            weixinVoteOption.setScale(Double.parseDouble(scale));
        }
        this.weixinVoteOptionService.updateEntitie(weixinVoteOption);
        if (ResourceUtil.getSessionUserName() != null) {
            this.weixinVipMemberService.updateMemberIntegral(ResourceUtil.getSessionUserName().getId(), request.getParameter("accountid"), weixinVote.getIntegral());
        }
        VoteRecordEntity voteRecordEntity = new VoteRecordEntity();
        voteRecordEntity.setAccountid(weixinVote.getAccountid());
        voteRecordEntity.setOpenid(request.getParameter("openid"));
        voteRecordEntity.setUserid(ResourceUtil.getSessionUserName().getId());
        voteRecordEntity.setVoteid(weixinVote.getId());
        voteRecordEntity.setOptionid(weixinVoteOption.getId());
        this.voteRecordService.save(voteRecordEntity);
        j.setSuccess(true);
        j.setMsg("\u6295\u7968\u6210\u529f");
        return j;
    }

    @RequestMapping(params={"goVoteCalculate"})
    public ModelAndView goVoteCalculate(WeixinVoteEntity weixinVote, HttpServletRequest request) {
        String accountid = request.getParameter("accountid");
        if (StringUtil.isEmpty((String)accountid)) {
            accountid = ResourceUtil.getQianTaiAccountId();
        }
        weixinVote = (WeixinVoteEntity)this.weixinVoteService.get(WeixinVoteEntity.class, (Serializable)((Object)weixinVote.getId()));
        request.setAttribute("weixinVote", (Object)weixinVote);
        request.setAttribute("accountid", (Object)accountid);
        return new ModelAndView("weixin/idea/vote/front/vote-calculate");
    }

    @RequestMapping(params={"getCalculateData"})
    @ResponseBody
    public AjaxJson getCalculateData(WeixinVoteEntity weixinVote, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (!StringUtil.isEmpty((String)weixinVote.getId())) {
            List optionlist = this.weixinVoteOptionService.findByProperty(WeixinVoteOptionEntity.class, "weixinVote.id", weixinVote.getId());
            j.setObj((Object)optionlist);
        }
        return j;
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(WeixinVoteEntity weixinVote, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinVote = (WeixinVoteEntity)this.systemService.getEntity(WeixinVoteEntity.class, (Serializable)((Object)weixinVote.getId()));
        List<WeixinVoteOptionEntity> ls = weixinVote.getWeixinVoteOptions();
        this.message = "\u5fae\u6295\u7968\u5220\u9664\u6210\u529f";
        try {
            this.weixinVoteOptionService.deleteAllEntitie(ls);
            this.weixinVoteService.delete(weixinVote);
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5fae\u6295\u7968\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u5fae\u6295\u7968\u5220\u9664\u6210\u529f";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                WeixinVoteEntity weixinVote = (WeixinVoteEntity)this.systemService.getEntity(WeixinVoteEntity.class, (Serializable)((Object)id));
                this.weixinVoteService.delete(weixinVote);
                this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5fae\u6295\u7968\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(WeixinVoteEntity weixinVote, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u5fae\u6295\u7968\u6dfb\u52a0\u6210\u529f";
        try {
            this.weixinVoteService.save(weixinVote);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5fae\u6295\u7968\u6dfb\u52a0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doUpdate"})
    @ResponseBody
    public AjaxJson doUpdate(WeixinVoteEntity weixinVote, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u5fae\u6295\u7968\u66f4\u65b0\u6210\u529f";
        WeixinVoteEntity t = (WeixinVoteEntity)this.weixinVoteService.get(WeixinVoteEntity.class, (Serializable)((Object)weixinVote.getId()));
        try {
            MyBeanUtils.copyBeanNotNull2Bean((Object)weixinVote, (Object)t);
            this.weixinVoteService.saveOrUpdate(t);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5fae\u6295\u7968\u66f4\u65b0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(WeixinVoteEntity weixinVote, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinVote.getId())) {
            weixinVote = (WeixinVoteEntity)this.weixinVoteService.getEntity(WeixinVoteEntity.class, (Serializable)((Object)weixinVote.getId()));
            req.setAttribute("weixinVotePage", (Object)weixinVote);
        }
        return new ModelAndView("weixin/idea/vote/weixinVote-add");
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(WeixinVoteEntity weixinVote, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinVote.getId())) {
            weixinVote = (WeixinVoteEntity)this.weixinVoteService.getEntity(WeixinVoteEntity.class, (Serializable)((Object)weixinVote.getId()));
            req.setAttribute("weixinVotePage", (Object)weixinVote);
        }
        return new ModelAndView("weixin/idea/vote/weixinVote-add");
    }

    @RequestMapping(params={"upload"})
    public ModelAndView upload(HttpServletRequest req) {
        return new ModelAndView("weixin/idea/vote/weixinVoteUpload");
    }

    @RequestMapping(params={"exportXls"})
    public void exportXls(WeixinVoteEntity weixinVote, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u5fae\u6295\u7968";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                CriteriaQuery cq = new CriteriaQuery(WeixinVoteEntity.class, dataGrid);
                HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinVote, (Map)request.getParameterMap());
                List weixinVotes = this.weixinVoteService.getListByCriteriaQuery(cq, false);
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("\u5fae\u6295\u7968\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WeixinVoteEntity.class, (Collection)weixinVotes);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"exportXlsByT"})
    public void exportXlsByT(WeixinVoteEntity weixinVote, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u5fae\u6295\u7968";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("\u5fae\u6295\u7968\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WeixinVoteEntity.class, null);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"importExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson importExcel(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setSecondTitleRows(1);
            params.setNeedSave(true);
            try {
                try {
                    List listWeixinVoteEntitys = (List)ExcelImportUtil.importExcelByIs((InputStream)file.getInputStream(), WeixinVoteEntity.class, (ImportParams)params);
                    for (WeixinVoteEntity weixinVote : listWeixinVoteEntitys) {
                        this.weixinVoteService.save(weixinVote);
                    }
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01");
                }
                catch (Exception e) {
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
                    logger.error((Object)ExceptionUtil.getExceptionMessage((Exception)e));
                    try {
                        file.getInputStream().close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                file.getInputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return j;
    }
}

