/*
 * Decompiled with CFR 0.152.
 */
package weixin.idea.video.controller;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.common.UploadFile;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.idea.video.entity.WeixinVideoEntity;
import weixin.idea.video.entity.WeixinVideoGroupEntity;
import weixin.idea.video.service.WeixinVideoGroupServiceI;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/weixinVideoGroupController"})
public class WeixinVideoGroupController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinVideoGroupController.class);
    @Autowired
    private WeixinVideoGroupServiceI weixinVideoGroupService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"weixinVideoGroup"})
    public ModelAndView weixinVideoGroup(HttpServletRequest request, WeixinVideoGroupEntity weixinVideoGroup) {
        CriteriaQuery cq = new CriteriaQuery(WeixinVideoGroupEntity.class);
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        cq.add();
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinVideoGroup, (Map)request.getParameterMap());
        List groups = this.weixinVideoGroupService.getListByCriteriaQuery(cq, false);
        request.setAttribute("groups", (Object)groups);
        return new ModelAndView("weixin/idea/video/weixinVideoGroupList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeixinVideoGroupEntity weixinVideoGroup, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinVideoGroupEntity.class, dataGrid);
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        cq.add();
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinVideoGroup, (Map)request.getParameterMap());
        this.weixinVideoGroupService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(WeixinVideoGroupEntity weixinVideoGroup, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String id = request.getParameter("id");
        weixinVideoGroup = (WeixinVideoGroupEntity)this.systemService.getEntity(WeixinVideoGroupEntity.class, (Serializable)((Object)id));
        this.weixinVideoGroupService.deleteFiles(weixinVideoGroup);
        this.message = "\u5fae\u89c6\u9891\u5e93\u5220\u9664\u6210\u529f";
        this.weixinVideoGroupService.delete(weixinVideoGroup);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"delVideo"})
    @ResponseBody
    public AjaxJson delVideo(WeixinVideoEntity weixinVideo, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinVideo = (WeixinVideoEntity)this.systemService.getEntity(WeixinVideoEntity.class, (Serializable)((Object)weixinVideo.getId()));
        this.weixinVideoGroupService.deleteFile(weixinVideo);
        this.message = "\u89c6\u9891\u5220\u9664\u6210\u529f";
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(WeixinVideoGroupEntity weixinVideoGroup, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String groupId = null;
        if (StringUtil.isNotEmpty((Object)weixinVideoGroup.getId())) {
            this.message = "\u5fae\u89c6\u9891\u5e93\u66f4\u65b0\u6210\u529f";
            groupId = weixinVideoGroup.getId();
            WeixinVideoGroupEntity t = (WeixinVideoGroupEntity)this.weixinVideoGroupService.get(WeixinVideoGroupEntity.class, (Serializable)((Object)weixinVideoGroup.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)weixinVideoGroup, (Object)t);
                this.weixinVideoGroupService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u5fae\u89c6\u9891\u5e93\u66f4\u65b0\u5931\u8d25";
            }
        } else {
            String accountId = ResourceUtil.getShangJiaAccountId();
            weixinVideoGroup.setAccountid(accountId);
            this.message = "\u5fae\u89c6\u9891\u5e93\u6dfb\u52a0\u6210\u529f";
            groupId = (String)((Object)this.weixinVideoGroupService.save(weixinVideoGroup));
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        j.setMsg(this.message);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("groupId", groupId);
        j.setAttributes(attributes);
        return j;
    }

    @RequestMapping(params={"saveVideo"})
    @ResponseBody
    public AjaxJson saveVideo(WeixinVideoEntity weixinVideo, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty((Object)weixinVideo.getId())) {
            this.message = "\u89c6\u9891\u66f4\u65b0\u6210\u529f";
            WeixinVideoEntity t = (WeixinVideoEntity)this.systemService.get(WeixinVideoEntity.class, (Serializable)((Object)weixinVideo.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)weixinVideo, (Object)t);
                this.weixinVideoGroupService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u89c6\u9891\u66f4\u65b0\u5931\u8d25";
            }
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(WeixinVideoGroupEntity weixinVideoGroup, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinVideoGroup.getId())) {
            weixinVideoGroup = (WeixinVideoGroupEntity)this.weixinVideoGroupService.getEntity(WeixinVideoGroupEntity.class, (Serializable)((Object)weixinVideoGroup.getId()));
            req.setAttribute("weixinVideoGroupPage", (Object)weixinVideoGroup);
        }
        return new ModelAndView("weixin/idea/video/weixinVideoGroup");
    }

    @RequestMapping(params={"goEditVideo"})
    public ModelAndView goEditVideo(WeixinVideoEntity weixinVideo, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinVideo.getId())) {
            weixinVideo = (WeixinVideoEntity)this.weixinVideoGroupService.getEntity(WeixinVideoEntity.class, (Serializable)((Object)weixinVideo.getId()));
            req.setAttribute("weixinVideo", (Object)weixinVideo);
        }
        return new ModelAndView("weixin/idea/video/weixinVideo");
    }

    @RequestMapping(params={"uploadVideoInit"})
    public ModelAndView uploadVideoInit(HttpServletRequest request) {
        request.setAttribute("groupId", (Object)request.getParameter("groupId"));
        return new ModelAndView("weixin/idea/video/uploadVideo");
    }

    @RequestMapping(params={"viewVideos"})
    public ModelAndView viewVideos(HttpServletRequest request) {
        String id = request.getParameter("id");
        request.setAttribute("id", (Object)id);
        WeixinVideoGroupEntity weixinVideoGroup = (WeixinVideoGroupEntity)this.weixinVideoGroupService.getEntity(WeixinVideoGroupEntity.class, (Serializable)((Object)id));
        List<WeixinVideoEntity> videos = weixinVideoGroup.getVideos();
        if (weixinVideoGroup.getVideo() != null) {
            request.setAttribute("videoId", (Object)weixinVideoGroup.getVideo().getId());
        } else {
            request.setAttribute("videoId", (Object)"");
        }
        request.setAttribute("videos", videos);
        return new ModelAndView("weixin/idea/video/viewVideos");
    }

    @RequestMapping(params={"saveFiles"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveFiles(HttpServletRequest request, HttpServletResponse response, WeixinVideoEntity video) {
        AjaxJson j = new AjaxJson();
        HashMap<String, String> attributes = new HashMap<String, String>();
        String fileKey = oConvertUtils.getString((String)request.getParameter("fileKey"));
        String groupId = oConvertUtils.getString((String)request.getParameter("groupId"));
        if (StringUtil.isNotEmpty((Object)fileKey)) {
            video.setId(fileKey);
            video = (WeixinVideoEntity)this.systemService.getEntity(WeixinVideoEntity.class, (Serializable)((Object)fileKey));
        }
        WeixinVideoGroupEntity group = (WeixinVideoGroupEntity)this.systemService.getEntity(WeixinVideoGroupEntity.class, (Serializable)((Object)groupId));
        video.setGroup(group);
        video.setName("\u672a\u547d\u540d");
        UploadFile uploadFile = new UploadFile(request, (Object)video);
        uploadFile.setCusPath("video");
        uploadFile.setSwfpath("swfpath");
        uploadFile.setByteField(null);
        video = (WeixinVideoEntity)this.systemService.uploadFile(uploadFile);
        attributes.put("fileKey", video.getId());
        attributes.put("viewhref", "commonController.do?objfileList&fileKey=" + video.getId());
        attributes.put("delurl", "commonController.do?delObjFile&fileKey=" + video.getId());
        j.setMsg("\u6587\u4ef6\u6dfb\u52a0\u6210\u529f");
        j.setAttributes(attributes);
        return j;
    }

    @RequestMapping(params={"setGroupFace"})
    @ResponseBody
    public AjaxJson setGroupFace(WeixinVideoGroupEntity weixinVideoGroup, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String videoId = request.getParameter("videoId");
        WeixinVideoEntity video = (WeixinVideoEntity)this.systemService.get(WeixinVideoEntity.class, (Serializable)((Object)videoId));
        WeixinVideoGroupEntity t = (WeixinVideoGroupEntity)this.weixinVideoGroupService.get(WeixinVideoGroupEntity.class, (Serializable)((Object)weixinVideoGroup.getId()));
        t.setVideo(video);
        this.weixinVideoGroupService.saveOrUpdate(t);
        this.message = "\u6210\u529f\u8bbe\u7f6e\u5c01\u9762";
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"cancelGroupFace"})
    @ResponseBody
    public AjaxJson cancelGroupFace(WeixinVideoGroupEntity weixinVideoGroup, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        WeixinVideoGroupEntity t = (WeixinVideoGroupEntity)this.weixinVideoGroupService.get(WeixinVideoGroupEntity.class, (Serializable)((Object)weixinVideoGroup.getId()));
        t.setVideo(null);
        this.weixinVideoGroupService.saveOrUpdate(t);
        this.message = "\u6210\u529f\u53d6\u6d88\u5c01\u9762";
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"playVideo"})
    public ModelAndView playVideo(HttpServletRequest request) {
        return new ModelAndView("weixin/idea/video/playVideo");
    }
}

