/*
 * Decompiled with CFR 0.152.
 */
package weixin.idea.video.common;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import weixin.idea.video.common.CmdExecuter;
import weixin.idea.video.common.IStringGetter;

public class FFMpegUtil
implements IStringGetter {
    private int runtime = 0;
    private String ffmpegUri;
    private String originFileUri;
    private FFMpegUtilStatus status = FFMpegUtilStatus.Empty;
    private String runTimeStr = "00:00";
    private boolean isSupported;
    private List<String> cmd = new ArrayList<String>();

    public FFMpegUtil(String ffmpegUri, String originFileUri) {
        this.ffmpegUri = ffmpegUri;
        this.originFileUri = originFileUri;
    }

    public String getRuntime() {
        this.runtime = 0;
        this.runTimeStr = "00:00";
        this.status = FFMpegUtilStatus.GettingRuntime;
        this.cmd.clear();
        this.cmd.add(this.ffmpegUri);
        this.cmd.add("-i");
        this.cmd.add(this.originFileUri);
        CmdExecuter.exec(this.cmd, this);
        return this.runTimeStr;
    }

    public boolean isSupported() {
        this.isSupported = true;
        this.status = FFMpegUtilStatus.CheckingFile;
        this.cmd.clear();
        this.cmd.add(this.ffmpegUri);
        this.cmd.add("-i");
        this.cmd.add(this.originFileUri);
        CmdExecuter.exec(this.cmd, this);
        return this.isSupported;
    }

    public void makeScreenCut(String imageSavePath, String screenSize) {
        this.cmd.clear();
        this.cmd.add(this.ffmpegUri);
        this.cmd.add("-i");
        this.cmd.add(this.originFileUri);
        this.cmd.add("-y");
        this.cmd.add("-f");
        this.cmd.add("image2");
        this.cmd.add("-ss");
        this.cmd.add("8");
        this.cmd.add("-t");
        this.cmd.add("0.001");
        this.cmd.add("-s");
        this.cmd.add(screenSize);
        this.cmd.add(imageSavePath);
        CmdExecuter.exec(this.cmd, this);
    }

    public void videoTransfer(String fileSavePath, String screenSize, int audioByte, int audioCollection, double quality, double fps) {
        this.cmd.clear();
        this.cmd.add(this.ffmpegUri);
        this.cmd.add("-i");
        this.cmd.add(this.originFileUri);
        this.cmd.add("-y");
        this.cmd.add("-ab");
        this.cmd.add(Integer.toString(audioByte));
        this.cmd.add("-ar");
        this.cmd.add(Integer.toString(audioCollection));
        this.cmd.add("-qscale");
        this.cmd.add(Double.toString(quality));
        this.cmd.add("-r");
        this.cmd.add(Double.toString(fps));
        this.cmd.add("-s");
        this.cmd.add(screenSize);
        this.cmd.add(fileSavePath);
        CmdExecuter.exec(this.cmd, this);
    }

    public void amr2mp3(String fileSavePath) {
        this.cmd.clear();
        this.cmd.add(this.ffmpegUri);
        this.cmd.add("-i");
        this.cmd.add(this.originFileUri);
        this.cmd.add(fileSavePath);
        CmdExecuter.exec(this.cmd, this);
    }

    @Override
    public void dealString(String str) {
        switch (this.status) {
            case Empty: {
                break;
            }
            case CheckingFile: {
                Matcher m = Pattern.compile("Unknown format").matcher(str);
                if (!m.find()) break;
                this.isSupported = false;
                break;
            }
            case GettingRuntime: {
                Matcher m = Pattern.compile("Duration: //w+://w+://w+").matcher(str);
                while (m.find()) {
                    String msg = m.group();
                    this.runTimeStr = msg = msg.replace("Duration: ", "");
                }
                break;
            }
        }
    }

    public static void main(String[] args) {
        String basePath = "C:/Users/anchao/Desktop/ffmpeg-20141223-git-32c836c-win32-static/ffmpeg-20141223-git-32c836c-win32-static/bin/";
        FFMpegUtil ffMpegUtil = new FFMpegUtil(String.valueOf(basePath) + "ffmpeg", "C:/Users/anchao/Desktop/a.mp4");
        ffMpegUtil.makeScreenCut("C:/Users/anchao/Desktop/1111222.jpg", "640x480");
        ffMpegUtil.videoTransfer("C:/Users/anchao/Desktop/b.flv", "640*480", 56, 22050, 200.0, 15.0);
    }

    private static enum FFMpegUtilStatus {
        Empty,
        CheckingFile,
        GettingRuntime;

    }
}

