/*
 * Decompiled with CFR 0.152.
 */
package weixin.idea.survey.controller;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.BrowserUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.entity.ExcelTitle;
import org.jeecgframework.web.system.pojo.base.TSBaseUser;
import org.jeecgframework.web.system.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import weixin.idea.survey.entity.WeixinSurveyEntity;
import weixin.idea.survey.entity.WeixinSurveyMainEntity;
import weixin.idea.survey.entity.WeixinSurveyRecordEntity;
import weixin.idea.survey.entity.WeixinSurveyRecordExportView;
import weixin.idea.survey.service.WeixinSurveyMainServiceI;
import weixin.idea.survey.service.WeixinSurveyRecordServiceI;
import weixin.idea.survey.service.WeixinSurveyServiceI;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/weixinSurveyRecordController"})
public class WeixinSurveyRecordController
extends BaseController {
    @Autowired
    private WeixinSurveyRecordServiceI weixinSurveyRecordService;
    @Autowired
    private WeixinSurveyMainServiceI weixinSurveyMainService;
    @Autowired
    private WeixinSurveyServiceI weixinSurveyService;
    @Autowired
    private UserService userService;

    @RequestMapping(params={"exportXls"})
    public void exportXls(WeixinSurveyRecordEntity weixinSurveyRecord, HttpServletRequest request, HttpServletResponse response) {
        CriteriaQuery cq = new CriteriaQuery(WeixinSurveyRecordEntity.class);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinSurveyRecord, (Map)request.getParameterMap());
        try {
            cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        cq.add();
        List recordlist = this.weixinSurveyRecordService.getListByCriteriaQuery(cq, false);
        ArrayList<WeixinSurveyRecordExportView> viewlist = new ArrayList<WeixinSurveyRecordExportView>();
        List weixinSurveyMainList = this.weixinSurveyMainService.findByProperty(WeixinSurveyMainEntity.class, "accountid", ResourceUtil.getShangJiaAccountId());
        List surveylist = this.weixinSurveyService.findByProperty(WeixinSurveyEntity.class, "accountid", ResourceUtil.getShangJiaAccountId());
        List userlist = this.userService.loadAll(TSBaseUser.class);
        for (WeixinSurveyRecordEntity r : recordlist) {
            WeixinSurveyRecordExportView exportView = new WeixinSurveyRecordExportView();
            exportView.setMainTitle("\u5df2\u5220\u9664\u95ee\u5377\u3002");
            exportView.setAnswers(r.getAnswer());
            exportView.setSurveyDate(r.getCreateDate());
            exportView.setSurveyTitle("\u5df2\u5220\u9664\u9898\u76ee");
            exportView.setUsername("\u533f\u540d\u7528\u6237");
            for (WeixinSurveyMainEntity main : weixinSurveyMainList) {
                if (!r.getMainid().equals(main.getId())) continue;
                exportView.setMainTitle(main.getSurveyTitle());
                break;
            }
            for (WeixinSurveyEntity survey : surveylist) {
                if (!r.getSurveyid().equals(survey.getId())) continue;
                exportView.setSurveyTitle(survey.getSurveyTitle());
                break;
            }
            for (TSBaseUser u : userlist) {
                if (!r.getSurveyid().equals(u.getId()) || StringUtil.isEmpty((String)u.getUserName())) continue;
                exportView.setUsername(u.getUserName());
                break;
            }
            viewlist.add(exportView);
        }
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u5fae\u8c03\u7814\u56de\u7b54\u8bb0\u5f55 ";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("\u5fae\u8c03\u7814 \u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WeixinSurveyRecordExportView.class, viewlist);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }
}

