/*
 * Decompiled with CFR 0.152.
 */
package weixin.idea.survey.controller;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.BrowserUtils;
import org.jeecgframework.core.util.ExceptionUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExcelTitle;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.tag.vo.datatable.SortDirection;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import weixin.idea.survey.entity.WeixinSurveyEntity;
import weixin.idea.survey.entity.WeixinSurveyMainEntity;
import weixin.idea.survey.entity.WeixinSurveyOptionEntity;
import weixin.idea.survey.entity.WeixinSurveyView;
import weixin.idea.survey.service.WeixinSurveyMainServiceI;
import weixin.idea.survey.service.WeixinSurveyOptionServiceI;
import weixin.idea.survey.service.WeixinSurveyRecordServiceI;
import weixin.idea.survey.service.WeixinSurveyServiceI;
import weixin.vip.service.WeixinVipMemberServiceI;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/weixinSurveyMainController"})
public class WeixinSurveyMainController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinSurveyMainController.class);
    @Autowired
    private WeixinSurveyServiceI weixinSurveyService;
    @Autowired
    private WeixinSurveyMainServiceI weixinSurveyMainService;
    @Autowired
    private WeixinSurveyOptionServiceI weixinSurveyOptionService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private WeixinVipMemberServiceI weixinVipMemberService;
    @Autowired
    private WeixinSurveyRecordServiceI weixinSurveyRecordService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"weixinSurveyMain"})
    public ModelAndView weixinSurveyMain(HttpServletRequest request) {
        return new ModelAndView("weixin/idea/survey/weixinSurveyMainList");
    }

    @RequestMapping(params={"goReview"})
    public ModelAndView goReview(WeixinSurveyMainEntity weixinSurveyMain, HttpServletRequest request) {
        weixinSurveyMain = (WeixinSurveyMainEntity)this.weixinSurveyMainService.get(WeixinSurveyMainEntity.class, (Serializable)((Object)weixinSurveyMain.getId()));
        String accountid = request.getParameter("accountid");
        String openid = request.getParameter("openid");
        if (StringUtil.isEmpty((String)accountid)) {
            accountid = ResourceUtil.getShangJiaAccountId();
        }
        if (!StringUtil.isEmpty((String)openid)) {
            request.setAttribute("openid", (Object)openid);
        }
        CriteriaQuery cq = new CriteriaQuery(WeixinSurveyEntity.class);
        cq.eq("mainId", (Object)weixinSurveyMain.getId());
        cq.addOrder("seq", SortDirection.asc);
        cq.add();
        List weixinSurveys = this.weixinSurveyService.getListByCriteriaQuery(cq, false);
        request.setAttribute("accountid", (Object)accountid);
        request.setAttribute("openid", (Object)request.getParameter("openid"));
        ArrayList<WeixinSurveyView> viewlist = new ArrayList<WeixinSurveyView>();
        if (weixinSurveys.size() != 0) {
            for (WeixinSurveyEntity surveyEntity : weixinSurveys) {
                WeixinSurveyView surveyView = new WeixinSurveyView();
                List surveyoptionlist = this.weixinSurveyOptionService.findByProperty(WeixinSurveyOptionEntity.class, "weixinSurvey.id", surveyEntity.getId());
                surveyView.setOptionlist(surveyoptionlist);
                surveyView.setSurveyDescription(surveyEntity.getSurveyDescription());
                surveyView.setSurveyid(surveyEntity.getId());
                surveyView.setSurveyTitle(surveyEntity.getSurveyTitle());
                surveyView.setSurveyType(surveyEntity.getSurveyType());
                viewlist.add(surveyView);
            }
            request.setAttribute("viewlist", viewlist);
        }
        request.setAttribute("surveyMain", (Object)weixinSurveyMain);
        return new ModelAndView("weixin/idea/survey/front/survey-review");
    }

    @RequestMapping(params={"goSurveyMainCalculate"})
    public ModelAndView goSurveyMainCalculate(WeixinSurveyMainEntity weixinSurveyMain, HttpServletRequest request) {
        weixinSurveyMain = (WeixinSurveyMainEntity)this.weixinSurveyMainService.get(WeixinSurveyMainEntity.class, (Serializable)((Object)weixinSurveyMain.getId()));
        CriteriaQuery cq = new CriteriaQuery(WeixinSurveyEntity.class);
        cq.eq("mainId", (Object)weixinSurveyMain.getId());
        cq.addOrder("seq", SortDirection.asc);
        cq.add();
        List surveylist = this.weixinSurveyService.getListByCriteriaQuery(cq, false);
        request.setAttribute("weixinSurveyMain", (Object)weixinSurveyMain);
        request.setAttribute("surveylist", (Object)surveylist);
        return new ModelAndView("weixin/idea/survey/weixinSurveyMain-calculate");
    }

    @RequestMapping(params={"getCalculateData"})
    @ResponseBody
    public AjaxJson getCalculateData(WeixinSurveyEntity weixinSurvey, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (!StringUtil.isEmpty((String)weixinSurvey.getId())) {
            List optionlist = this.weixinSurveyOptionService.findByProperty(WeixinSurveyOptionEntity.class, "weixinSurvey.id", weixinSurvey.getId());
            j.setObj((Object)optionlist);
        }
        return j;
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeixinSurveyMainEntity weixinSurvey, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinSurveyMainEntity.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinSurvey, (Map)request.getParameterMap());
        try {
            cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        cq.add();
        this.weixinSurveyMainService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"deploy"})
    @ResponseBody
    public AjaxJson deploy(WeixinSurveyMainEntity weixinSurveyMain, String statement, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if ("1".equals(statement)) {
            CriteriaQuery maincq = new CriteriaQuery(WeixinSurveyMainEntity.class);
            maincq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
            maincq.eq("statement", (Object)"1");
            maincq.add();
            List mainlist = this.weixinSurveyMainService.getListByCriteriaQuery(maincq, false);
            if (mainlist.size() != 0) {
                this.message = "\u8c03\u7814\u95ee\u5377\uff1a" + ((WeixinSurveyMainEntity)mainlist.get(0)).getSurveyTitle() + "\u5df2\u7ecf\u53d1\u5e03\uff0c\u8bf7\u7ed3\u675f\u8be5\u4e3b\u9898\u540e\u518d\u53d1\u5e03\u65b0\u8c03\u7814\u95ee\u5377\u3002";
            } else {
                WeixinSurveyMainEntity weixinSurvey = (WeixinSurveyMainEntity)this.systemService.getEntity(WeixinSurveyMainEntity.class, (Serializable)((Object)weixinSurveyMain.getId()));
                weixinSurvey.setStatement(statement);
                this.weixinSurveyMainService.updateEntitie(weixinSurvey);
                this.message = "\u5fae\u8c03\u7814 \u53d1\u5e03\u6210\u529f";
            }
        } else {
            WeixinSurveyMainEntity weixinSurvey = (WeixinSurveyMainEntity)this.systemService.getEntity(WeixinSurveyMainEntity.class, (Serializable)((Object)weixinSurveyMain.getId()));
            weixinSurvey.setStatement(statement);
            this.weixinSurveyMainService.updateEntitie(weixinSurvey);
            this.message = "\u5fae\u8c03\u7814 \u53d1\u5e03\u6210\u529f";
        }
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(WeixinSurveyMainEntity weixinMainSurvey, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinMainSurvey = (WeixinSurveyMainEntity)this.systemService.getEntity(WeixinSurveyMainEntity.class, (Serializable)((Object)weixinMainSurvey.getId()));
        this.message = "\u5fae\u8c03\u7814 \u5220\u9664\u6210\u529f";
        try {
            List optionlist = this.weixinSurveyOptionService.findByProperty(WeixinSurveyOptionEntity.class, "weixinSurvey.id", weixinMainSurvey.getId());
            List surveylist = this.weixinSurveyService.findByProperty(WeixinSurveyEntity.class, "mainId", weixinMainSurvey.getId());
            this.weixinSurveyRecordService.deleteAllEntitie(optionlist);
            this.weixinSurveyService.deleteAllEntitie(surveylist);
            this.weixinSurveyMainService.delete(weixinMainSurvey);
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5fae\u8c03\u7814 \u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u5fae\u8c03\u7814 \u5220\u9664\u6210\u529f";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                WeixinSurveyMainEntity weixinMainSurvey = (WeixinSurveyMainEntity)this.systemService.getEntity(WeixinSurveyMainEntity.class, (Serializable)((Object)id));
                List surveylist = this.weixinSurveyService.findByProperty(WeixinSurveyEntity.class, "mainId", weixinMainSurvey.getId());
                List optionlist = this.weixinSurveyOptionService.findByProperty(WeixinSurveyOptionEntity.class, "weixinSurvey.id", weixinMainSurvey.getId());
                this.weixinSurveyRecordService.deleteAllEntitie(optionlist);
                this.weixinSurveyService.deleteAllEntitie(surveylist);
                this.weixinSurveyMainService.delete(weixinMainSurvey);
                this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5fae\u8c03\u7814 \u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(WeixinSurveyMainEntity weixinSurvey, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u5fae\u8c03\u7814 \u6dfb\u52a0\u6210\u529f";
        try {
            if (StringUtil.isEmpty((String)weixinSurvey.getId())) {
                weixinSurvey.setStatement("0");
                weixinSurvey.setSurveyCount(0);
                this.weixinSurveyMainService.save(weixinSurvey);
            } else {
                this.weixinSurveyMainService.updateEntitie(weixinSurvey);
            }
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5fae\u8c03\u7814 \u6dfb\u52a0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doUpdate"})
    @ResponseBody
    public AjaxJson doUpdate(WeixinSurveyMainEntity weixinSurvey, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u5fae\u8c03\u7814 \u66f4\u65b0\u6210\u529f";
        WeixinSurveyMainEntity t = (WeixinSurveyMainEntity)this.weixinSurveyService.get(WeixinSurveyMainEntity.class, (Serializable)((Object)weixinSurvey.getId()));
        try {
            MyBeanUtils.copyBeanNotNull2Bean((Object)weixinSurvey, (Object)t);
            this.weixinSurveyMainService.saveOrUpdate(t);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5fae\u8c03\u7814 \u66f4\u65b0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(WeixinSurveyMainEntity weixinSurvey, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinSurvey.getId())) {
            weixinSurvey = (WeixinSurveyMainEntity)this.weixinSurveyService.getEntity(WeixinSurveyMainEntity.class, (Serializable)((Object)weixinSurvey.getId()));
            req.setAttribute("weixinSurveyMainPage", (Object)weixinSurvey);
        }
        return new ModelAndView("weixin/idea/survey/weixinSurveyMain-add");
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(WeixinSurveyMainEntity weixinSurvey, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinSurvey.getId())) {
            weixinSurvey = (WeixinSurveyMainEntity)this.weixinSurveyService.getEntity(WeixinSurveyMainEntity.class, (Serializable)((Object)weixinSurvey.getId()));
            req.setAttribute("weixinSurveyMainPage", (Object)weixinSurvey);
        }
        return new ModelAndView("weixin/idea/survey/weixinSurveyMain-add");
    }

    @RequestMapping(params={"upload"})
    public ModelAndView upload(HttpServletRequest req) {
        return new ModelAndView("weixin/idea/survey/weixinSurveyUpload");
    }

    @RequestMapping(params={"exportXls"})
    public void exportXls(WeixinSurveyMainEntity weixinSurvey, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u5fae\u8c03\u7814 ";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                CriteriaQuery cq = new CriteriaQuery(WeixinSurveyMainEntity.class, dataGrid);
                HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinSurvey, (Map)request.getParameterMap());
                List weixinSurveys = this.weixinSurveyService.getListByCriteriaQuery(cq, false);
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("\u5fae\u8c03\u7814 \u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WeixinSurveyMainEntity.class, (Collection)weixinSurveys);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"exportXlsByT"})
    public void exportXlsByT(WeixinSurveyMainEntity weixinSurvey, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u5fae\u8c03\u7814 ";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("\u5fae\u8c03\u7814 \u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WeixinSurveyMainEntity.class, null);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"importExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson importExcel(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setSecondTitleRows(1);
            params.setNeedSave(true);
            try {
                try {
                    List listWeixinSurveyMainEntitys = (List)ExcelImportUtil.importExcelByIs((InputStream)file.getInputStream(), WeixinSurveyMainEntity.class, (ImportParams)params);
                    for (WeixinSurveyMainEntity weixinSurvey : listWeixinSurveyMainEntitys) {
                        this.weixinSurveyService.save(weixinSurvey);
                    }
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01");
                }
                catch (Exception e) {
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
                    logger.error((Object)ExceptionUtil.getExceptionMessage((Exception)e));
                    try {
                        file.getInputStream().close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                file.getInputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return j;
    }
}

