/*
 * Decompiled with CFR 0.152.
 */
package weixin.idea.survey.controller;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.BrowserUtils;
import org.jeecgframework.core.util.ExceptionUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExcelTitle;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.tag.vo.datatable.SortDirection;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import weixin.guanjia.core.util.WeixinUtil;
import weixin.guanjia.gzuserinfo.entity.GzUserInfoYw;
import weixin.guanjia.gzuserinfo.service.GzUserInfoService;
import weixin.idea.survey.entity.WeixinSurveyEntity;
import weixin.idea.survey.entity.WeixinSurveyMainEntity;
import weixin.idea.survey.entity.WeixinSurveyOptionEntity;
import weixin.idea.survey.entity.WeixinSurveyRecordEntity;
import weixin.idea.survey.entity.WeixinSurveyResultView;
import weixin.idea.survey.entity.WeixinSurveyView;
import weixin.idea.survey.service.WeixinSurveyMainServiceI;
import weixin.idea.survey.service.WeixinSurveyOptionServiceI;
import weixin.idea.survey.service.WeixinSurveyRecordServiceI;
import weixin.idea.survey.service.WeixinSurveyServiceI;
import weixin.vip.service.WeixinVipMemberServiceI;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/weixinSurveyController"})
public class WeixinSurveyController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinSurveyController.class);
    @Autowired
    private WeixinSurveyServiceI weixinSurveyService;
    @Autowired
    private WeixinSurveyMainServiceI weixinSurveyMainService;
    @Autowired
    private WeixinSurveyOptionServiceI weixinSurveyOptionService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private WeixinVipMemberServiceI weixinVipMemberService;
    @Autowired
    private WeixinSurveyRecordServiceI weixinSurveyRecordService;
    @Autowired
    private GzUserInfoService gzUserInfoService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"weixinSurvey"})
    public ModelAndView weixinSurvey(HttpServletRequest request) {
        return new ModelAndView("weixin/idea/survey/weixinSurveyList");
    }

    @RequestMapping(params={"weixinSurveyRecord"})
    public ModelAndView weixinSurveyRecord(HttpServletRequest request) {
        return new ModelAndView("weixin/idea/survey/weixinSurveyRecordList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeixinSurveyEntity weixinSurvey, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinSurveyEntity.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinSurvey, (Map)request.getParameterMap());
        try {
            cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        cq.add();
        this.weixinSurveyService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"recorddatagrid"})
    public void recorddatagrid(WeixinSurveyRecordEntity weixinSurveyRecord, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinSurveyRecordEntity.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinSurveyRecord, (Map)request.getParameterMap());
        try {
            cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        cq.add();
        this.weixinSurveyRecordService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"goAddSurveyOption"})
    public ModelAndView goAddSurveyOption(WeixinSurveyEntity weixinSurvey, HttpServletRequest request) {
        if (!StringUtil.isEmpty((String)weixinSurvey.getId())) {
            List surveyOptionList = this.weixinSurveyOptionService.findByProperty(WeixinSurveyOptionEntity.class, "weixinSurvey.id", weixinSurvey.getId());
            request.setAttribute("surveyOptionList", (Object)surveyOptionList);
        }
        return new ModelAndView("weixin/idea/survey/weixinSurveyOption-add");
    }

    @RequestMapping(params={"deploy"})
    @ResponseBody
    public AjaxJson deploy(String ids, String statement, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String[] stringArray = ids.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            WeixinSurveyEntity weixinSurvey = (WeixinSurveyEntity)this.systemService.getEntity(WeixinSurveyEntity.class, (Serializable)((Object)id));
            weixinSurvey.setStatement(statement);
            this.weixinSurveyService.updateEntitie(weixinSurvey);
            this.message = "\u5fae\u8c03\u7814 \u53d1\u5e03\u6210\u529f";
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
            ++n2;
        }
        j.setSuccess(true);
        j.setMsg("\u64cd\u4f5c\u6210\u529f\uff01");
        return j;
    }

    @RequestMapping(params={"goSurvey"})
    public ModelAndView goSurvey(WeixinSurveyEntity weixinSurvey, HttpServletRequest request) {
        String accountid = request.getParameter("accountid");
        String openid = request.getParameter("openid");
        if (StringUtil.isEmpty((String)accountid)) {
            accountid = ResourceUtil.getQianTaiAccountId();
        }
        if (!StringUtil.isEmpty((String)openid)) {
            request.setAttribute("openid", (Object)openid);
        }
        CriteriaQuery maincq = new CriteriaQuery(WeixinSurveyMainEntity.class);
        maincq.eq("accountid", (Object)accountid);
        maincq.eq("statement", (Object)"1");
        maincq.add();
        List mainlist = this.weixinSurveyMainService.getListByCriteriaQuery(maincq, false);
        if (mainlist.size() != 0) {
            CriteriaQuery recordcq = new CriteriaQuery(WeixinSurveyRecordEntity.class);
            recordcq.eq("mainid", (Object)((WeixinSurveyMainEntity)mainlist.get(0)).getId());
            recordcq.eq("userid", (Object)ResourceUtil.getSessionUserName().getId());
            recordcq.add();
            List recordlist = this.weixinSurveyRecordService.getListByCriteriaQuery(recordcq, false);
            if (recordlist.size() != 0) {
                return this.goSurveyResultShow((WeixinSurveyMainEntity)mainlist.get(0), request);
            }
            CriteriaQuery cq = new CriteriaQuery(WeixinSurveyEntity.class);
            cq.eq("mainId", (Object)((WeixinSurveyMainEntity)mainlist.get(0)).getId());
            cq.addOrder("seq", SortDirection.asc);
            cq.add();
            List weixinSurveys = this.weixinSurveyService.getListByCriteriaQuery(cq, false);
            request.setAttribute("accountid", (Object)accountid);
            request.setAttribute("openid", (Object)request.getParameter("openid"));
            ArrayList<WeixinSurveyView> viewlist = new ArrayList<WeixinSurveyView>();
            if (weixinSurveys.size() != 0) {
                for (WeixinSurveyEntity surveyEntity : weixinSurveys) {
                    WeixinSurveyView surveyView = new WeixinSurveyView();
                    List surveyoptionlist = this.weixinSurveyOptionService.findByProperty(WeixinSurveyOptionEntity.class, "weixinSurvey.id", surveyEntity.getId());
                    surveyView.setOptionlist(surveyoptionlist);
                    surveyView.setSurveyDescription(surveyEntity.getSurveyDescription());
                    surveyView.setSurveyid(surveyEntity.getId());
                    surveyView.setSurveyTitle(surveyEntity.getSurveyTitle());
                    surveyView.setSurveyType(surveyEntity.getSurveyType());
                    viewlist.add(surveyView);
                }
                request.setAttribute("viewlist", viewlist);
            }
            request.setAttribute("surveyMain", mainlist.get(0));
        }
        return new ModelAndView("weixin/idea/survey/front/survey");
    }

    @RequestMapping(params={"doSurvey"})
    @ResponseBody
    public AjaxJson doSurvey(String[] answer, String mainid, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        WeixinSurveyMainEntity weixinSurveyMain = (WeixinSurveyMainEntity)this.weixinSurveyMainService.get(WeixinSurveyMainEntity.class, (Serializable)((Object)mainid));
        weixinSurveyMain.setSurveyCount(weixinSurveyMain.getSurveyCount() + 1);
        this.weixinSurveyMainService.updateEntitie(weixinSurveyMain);
        if (answer != null && answer.length != 0) {
            String[] stringArray = answer;
            int n = answer.length;
            int n2 = 0;
            while (n2 < n) {
                String an = stringArray[n2];
                String[] valstrs = an.split("_");
                String surveyid = valstrs[0];
                String answervalue = valstrs[1];
                WeixinSurveyEntity weixinSurvey = (WeixinSurveyEntity)this.weixinSurveyService.get(WeixinSurveyEntity.class, (Serializable)((Object)surveyid));
                if ("1".equals(weixinSurvey.getSurveyType()) || "2".equals(weixinSurvey.getSurveyType())) {
                    String[] optionids = valstrs[2].split(";");
                    int allcount = 0;
                    String[] stringArray2 = optionids;
                    int n3 = optionids.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String oid = stringArray2[n4];
                        WeixinSurveyOptionEntity optionEntity = (WeixinSurveyOptionEntity)this.weixinSurveyOptionService.get(WeixinSurveyOptionEntity.class, (Serializable)((Object)oid));
                        optionEntity.setCount(optionEntity.getCount() + 1);
                        this.weixinSurveyOptionService.updateEntitie(optionEntity);
                        ++n4;
                    }
                    List optionlist = this.weixinSurveyOptionService.findByProperty(WeixinSurveyOptionEntity.class, "weixinSurvey.id", weixinSurvey.getId());
                    for (WeixinSurveyOptionEntity o : optionlist) {
                        allcount += o.getCount().intValue();
                    }
                    for (WeixinSurveyOptionEntity oid : optionlist) {
                        WeixinSurveyOptionEntity optionEntity = (WeixinSurveyOptionEntity)this.weixinSurveyOptionService.get(WeixinSurveyOptionEntity.class, (Serializable)((Object)oid.getId()));
                        String scale = String.format("%.2f", (double)optionEntity.getCount().intValue() / (double)allcount);
                        optionEntity.setScale(Double.valueOf(scale));
                        this.weixinSurveyOptionService.updateEntitie(optionEntity);
                    }
                }
                WeixinSurveyRecordEntity surveyRecordEntity = new WeixinSurveyRecordEntity();
                weixinSurvey.setSurveyCount(weixinSurvey.getSurveyCount() + 1);
                surveyRecordEntity.setAccountid(weixinSurvey.getAccountid());
                surveyRecordEntity.setOpenid(request.getParameter("openid"));
                surveyRecordEntity.setUserid(ResourceUtil.getSessionUserName().getId());
                surveyRecordEntity.setSurveyid(weixinSurvey.getId());
                surveyRecordEntity.setAnswer(answervalue);
                surveyRecordEntity.setMainid(mainid);
                GzUserInfoYw user = this.gzUserInfoService.getLocalUserinfoAll(request.getParameter("openid"), weixinSurvey.getAccountid());
                if (user != null) {
                    surveyRecordEntity.setCreateName(new String(WeixinUtil.decode(user.getNickname())));
                } else {
                    surveyRecordEntity.setCreateName(ResourceUtil.getSessionUserName().getUserName());
                }
                this.weixinSurveyRecordService.save(surveyRecordEntity);
                ++n2;
            }
        }
        if (ResourceUtil.getSessionUserName() != null) {
            this.weixinVipMemberService.updateMemberIntegral(ResourceUtil.getSessionUserName().getId(), request.getParameter("accountid"), weixinSurveyMain.getIntegral());
        }
        j.setSuccess(true);
        return j;
    }

    @RequestMapping(params={"goSurveyResultShow"})
    public ModelAndView goSurveyResultShow(WeixinSurveyMainEntity weixinSurveyMain, HttpServletRequest request) {
        weixinSurveyMain = (WeixinSurveyMainEntity)this.weixinSurveyMainService.get(WeixinSurveyMainEntity.class, (Serializable)((Object)weixinSurveyMain.getId()));
        request.setAttribute("weixinSurveyMain", (Object)weixinSurveyMain);
        return new ModelAndView("weixin/idea/survey/front/survey-show");
    }

    @RequestMapping(params={"goSurveyResult"})
    public ModelAndView goSurveyResult(WeixinSurveyMainEntity weixinSurveyMain, HttpServletRequest request) {
        String accountid = request.getParameter("accountid");
        if (StringUtil.isEmpty((String)accountid)) {
            accountid = ResourceUtil.getQianTaiAccountId();
        }
        weixinSurveyMain = (WeixinSurveyMainEntity)this.weixinSurveyMainService.get(WeixinSurveyMainEntity.class, (Serializable)((Object)weixinSurveyMain.getId()));
        List surveylist = this.weixinSurveyService.findByProperty(WeixinSurveyEntity.class, "mainId", weixinSurveyMain.getId());
        ArrayList<WeixinSurveyResultView> resultlist = new ArrayList<WeixinSurveyResultView>();
        for (WeixinSurveyEntity survey : surveylist) {
            CriteriaQuery cq = new CriteriaQuery(WeixinSurveyRecordEntity.class);
            cq.eq("surveyid", (Object)survey.getId());
            cq.eq("userid", (Object)ResourceUtil.getSessionUserName().getId());
            cq.add();
            WeixinSurveyResultView resultView = new WeixinSurveyResultView();
            List recordlist = this.weixinSurveyRecordService.getListByCriteriaQuery(cq, false);
            resultView.setWeixinSurvey(survey);
            resultView.setRecordlist(recordlist);
            resultlist.add(resultView);
        }
        request.setAttribute("resultlist", resultlist);
        request.setAttribute("weixinSurveyMain", (Object)weixinSurveyMain);
        request.setAttribute("openid", (Object)request.getParameter("openid"));
        request.setAttribute("accountid", (Object)accountid);
        return new ModelAndView("weixin/idea/survey/front/survey-result");
    }

    @RequestMapping(params={"getCalculateData"})
    @ResponseBody
    public AjaxJson getCalculateData(WeixinSurveyEntity weixinSurvey, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (!StringUtil.isEmpty((String)weixinSurvey.getId())) {
            List optionlist = this.weixinSurveyOptionService.findByProperty(WeixinSurveyOptionEntity.class, "weixinSurvey.id", weixinSurvey.getId());
            j.setObj((Object)optionlist);
        }
        return j;
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(WeixinSurveyEntity weixinSurvey, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinSurvey = (WeixinSurveyEntity)this.systemService.getEntity(WeixinSurveyEntity.class, (Serializable)((Object)weixinSurvey.getId()));
        this.message = "\u5fae\u8c03\u7814 \u5220\u9664\u6210\u529f";
        try {
            List optionlist = this.weixinSurveyOptionService.findByProperty(WeixinSurveyOptionEntity.class, "weixinSurvey.id", weixinSurvey.getId());
            this.weixinSurveyRecordService.deleteAllEntitie(optionlist);
            this.weixinSurveyService.delete(weixinSurvey);
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5fae\u8c03\u7814 \u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u5fae\u8c03\u7814 \u5220\u9664\u6210\u529f";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                WeixinSurveyEntity weixinSurvey = (WeixinSurveyEntity)this.systemService.getEntity(WeixinSurveyEntity.class, (Serializable)((Object)id));
                List optionlist = this.weixinSurveyOptionService.findByProperty(WeixinSurveyOptionEntity.class, "weixinSurvey.id", weixinSurvey.getId());
                this.weixinSurveyRecordService.deleteAllEntitie(optionlist);
                this.weixinSurveyService.delete(weixinSurvey);
                this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5fae\u8c03\u7814 \u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(WeixinSurveyEntity weixinSurvey, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u5fae\u8c03\u7814 \u6dfb\u52a0\u6210\u529f";
        try {
            this.weixinSurveyService.save(weixinSurvey);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5fae\u8c03\u7814 \u6dfb\u52a0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doUpdate"})
    @ResponseBody
    public AjaxJson doUpdate(WeixinSurveyEntity weixinSurvey, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u5fae\u8c03\u7814 \u66f4\u65b0\u6210\u529f";
        WeixinSurveyEntity t = (WeixinSurveyEntity)this.weixinSurveyService.get(WeixinSurveyEntity.class, (Serializable)((Object)weixinSurvey.getId()));
        try {
            MyBeanUtils.copyBeanNotNull2Bean((Object)weixinSurvey, (Object)t);
            this.weixinSurveyService.saveOrUpdate(t);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5fae\u8c03\u7814 \u66f4\u65b0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(WeixinSurveyEntity weixinSurvey, HttpServletRequest req) {
        List mainlist = this.weixinSurveyMainService.findByProperty(WeixinSurveyMainEntity.class, "accountid", ResourceUtil.getShangJiaAccountId());
        if (StringUtil.isNotEmpty((Object)weixinSurvey.getId())) {
            weixinSurvey = (WeixinSurveyEntity)this.weixinSurveyService.getEntity(WeixinSurveyEntity.class, (Serializable)((Object)weixinSurvey.getId()));
            req.setAttribute("weixinSurveyPage", (Object)weixinSurvey);
        }
        req.setAttribute("mainlist", (Object)mainlist);
        return new ModelAndView("weixin/idea/survey/weixinSurvey-add");
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(WeixinSurveyEntity weixinSurvey, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinSurvey.getId())) {
            weixinSurvey = (WeixinSurveyEntity)this.weixinSurveyService.getEntity(WeixinSurveyEntity.class, (Serializable)((Object)weixinSurvey.getId()));
            List mainlist = this.weixinSurveyMainService.findByProperty(WeixinSurveyMainEntity.class, "accountid", ResourceUtil.getShangJiaAccountId());
            req.setAttribute("mainlist", (Object)mainlist);
            req.setAttribute("weixinSurveyPage", (Object)weixinSurvey);
        }
        return new ModelAndView("weixin/idea/survey/weixinSurvey-add");
    }

    @RequestMapping(params={"upload"})
    public ModelAndView upload(HttpServletRequest req) {
        return new ModelAndView("weixin/idea/survey/weixinSurveyUpload");
    }

    @RequestMapping(params={"exportXls"})
    public void exportXls(WeixinSurveyEntity weixinSurvey, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u5fae\u8c03\u7814 ";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                CriteriaQuery cq = new CriteriaQuery(WeixinSurveyEntity.class, dataGrid);
                HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinSurvey, (Map)request.getParameterMap());
                List weixinSurveys = this.weixinSurveyService.getListByCriteriaQuery(cq, false);
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("\u5fae\u8c03\u7814 \u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WeixinSurveyEntity.class, (Collection)weixinSurveys);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"exportXlsByT"})
    public void exportXlsByT(WeixinSurveyEntity weixinSurvey, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u5fae\u8c03\u7814 ";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("\u5fae\u8c03\u7814 \u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WeixinSurveyEntity.class, null);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"importExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson importExcel(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setSecondTitleRows(1);
            params.setNeedSave(true);
            try {
                try {
                    List listWeixinSurveyEntitys = (List)ExcelImportUtil.importExcelByIs((InputStream)file.getInputStream(), WeixinSurveyEntity.class, (ImportParams)params);
                    for (WeixinSurveyEntity weixinSurvey : listWeixinSurveyEntitys) {
                        this.weixinSurveyService.save(weixinSurvey);
                    }
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01");
                }
                catch (Exception e) {
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
                    logger.error((Object)ExceptionUtil.getExceptionMessage((Exception)e));
                    try {
                        file.getInputStream().close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                file.getInputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return j;
    }
}

