/*
 * Decompiled with CFR 0.152.
 */
package weixin.idea.sign.controller;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.guanjia.account.entity.WeixinAccountEntity;
import weixin.guanjia.core.util.WeixinUtil;
import weixin.guanjia.gzuserinfo.entity.GzUserInfoYw;
import weixin.guanjia.location.entity.LocationEntity;
import weixin.idea.sign.entity.SignRecordEntity;
import weixin.idea.sign.service.SignRecordServiceI;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/signRecordController"})
public class SignRecordController
extends BaseController {
    private static final Logger logger = Logger.getLogger(SignRecordController.class);
    @Autowired
    private SignRecordServiceI signRecordService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"signRecord"})
    public ModelAndView signRecord(HttpServletRequest request) {
        return new ModelAndView("weixin/idea/sign/signRecordList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(SignRecordEntity signRecord, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(SignRecordEntity.class, dataGrid);
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)signRecord, (Map)request.getParameterMap());
        this.signRecordService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(SignRecordEntity signRecord, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        signRecord = (SignRecordEntity)this.systemService.getEntity(SignRecordEntity.class, (Serializable)((Object)signRecord.getId()));
        this.message = "\u7b7e\u5230\u7ba1\u7406\u5220\u9664\u6210\u529f";
        this.signRecordService.delete(signRecord);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(SignRecordEntity signRecord, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u606d\u559c\u60a8\uff0c\u7b7e\u5230\u6210\u529f\uff01";
        String accountid = ResourceUtil.getShangJiaAccountId();
        LogUtil.info((Object)("....accountid...." + accountid));
        signRecord.setAccountid(accountid);
        signRecord.setAddtime(new Date());
        this.signRecordService.save(signRecord);
        this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goRegistPage"})
    public ModelAndView goRegistPage(SignRecordEntity signRecord, HttpServletRequest req) {
        String openid = req.getParameter("openid");
        String accountId = req.getParameter("accountid");
        if (StringUtil.isNotEmpty((Object)openid)) {
            LocationEntity location = (LocationEntity)this.systemService.findUniqueByProperty(LocationEntity.class, "openid", (Object)openid);
            req.setAttribute("location", (Object)location);
            GzUserInfoYw gzUserInfo = (GzUserInfoYw)((Object)this.systemService.findUniqueByProperty(GzUserInfoYw.class, "openid", (Object)openid));
            GzUserInfoYw gzUserInfoPage = new GzUserInfoYw();
            try {
                MyBeanUtils.copyBean2Bean((Object)((Object)gzUserInfoPage), (Object)((Object)gzUserInfo));
                String nickName = new String(WeixinUtil.decode(gzUserInfoPage.getNickname()));
                gzUserInfoPage.setNickname(nickName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            req.setAttribute("gzUserInfo", (Object)gzUserInfoPage);
        }
        WeixinAccountEntity weixinAccountEntity = (WeixinAccountEntity)this.systemService.findUniqueByProperty(WeixinAccountEntity.class, "id", (Object)accountId);
        req.getSession().setAttribute("WEIXIN_ACCOUNT", (Object)weixinAccountEntity);
        req.getSession().setAttribute("openid", (Object)openid);
        return new ModelAndView("weixin/idea/sign/registpage");
    }
}

