/*
 * Decompiled with CFR 0.152.
 */
package weixin.idea.qrcode.service.impl;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import weixin.bbs.entity.WeixinBbsEntity;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.core.entity.message.resp.TextMessageResp;
import weixin.guanjia.core.util.MessageUtil;
import weixin.guanjia.core.util.WeixinUtil;
import weixin.guanjia.linksucai.entity.WeixinLinksucaiEntity;
import weixin.idea.awardquestion.entity.WeixinAwardQuestionMainEntity;
import weixin.idea.huodong.entity.HuodongEntity;
import weixin.idea.huodong.service.HuodongServiceI;
import weixin.idea.qrcode.entity.WeixinQrcodeEntity;
import weixin.idea.qrcode.model.ActionInfo;
import weixin.idea.qrcode.model.ActionInfoLink;
import weixin.idea.qrcode.model.QrCode;
import weixin.idea.qrcode.model.Scene;
import weixin.idea.qrcode.model.SceneInstance;
import weixin.idea.qrcode.service.WeixinQrcodeSceneServiceI;
import weixin.idea.qrcode.service.WeixinQrcodeServiceI;
import weixin.idea.survey.entity.WeixinSurveyMainEntity;
import weixin.idea.vote.entity.WeixinVoteEntity;

@Service(value="weixinQrcodeService")
@Transactional
public class WeixinQrcodeServiceImpl
extends CommonServiceImpl
implements WeixinQrcodeServiceI {
    @Autowired
    private WeixinQrcodeSceneServiceI weixinQrcodeSceneService;
    @Autowired
    WeixinAccountServiceI weixinAccountService;
    @Autowired
    private HuodongServiceI huodongService;
    private static final Integer hd = 100;
    private static final Integer dy = 101;
    private static final Integer wd = 102;
    private static final Integer sq = 103;
    private static final Integer tp = 104;
    private static final Integer qd = 105;
    private static final Integer wb = 106;
    private static final Integer lj = 107;

    @Override
    public <T> void delete(T entity) {
        super.delete(entity);
        this.doDelSql((WeixinQrcodeEntity)entity);
    }

    @Override
    public <T> Serializable save(T entity) {
        Serializable t = super.save(entity);
        this.doAddSql((WeixinQrcodeEntity)entity);
        return t;
    }

    @Override
    public <T> void saveOrUpdate(T entity) {
        super.saveOrUpdate(entity);
        this.doUpdateSql((WeixinQrcodeEntity)entity);
    }

    @Override
    public boolean doAddSql(WeixinQrcodeEntity t) {
        return true;
    }

    @Override
    public boolean doUpdateSql(WeixinQrcodeEntity t) {
        return true;
    }

    @Override
    public boolean doDelSql(WeixinQrcodeEntity t) {
        return true;
    }

    @Override
    public String getQrcodeImgurl(WeixinQrcodeEntity weixinQrcode, HttpServletRequest request) {
        String imgurl = "";
        QrCode qrCode = new QrCode();
        Scene scene = new Scene();
        ActionInfo actionInfo = new ActionInfo();
        qrCode.setAction_name("QR_LIMIT_SCENE");
        scene.setScene_id(weixinQrcode.getSceneId());
        actionInfo.setScene(scene);
        qrCode.setAction_info(actionInfo);
        JSONObject jsonQrcode = JSONObject.fromObject((Object)qrCode);
        String accesstoken = this.weixinAccountService.getAccessToken(weixinQrcode.getAccountid());
        String ticketurl = WeixinUtil.qrcode_ticket_url.replace("ACCESS_TOKEN", accesstoken);
        JSONObject ticketjson = WeixinUtil.httpRequest(ticketurl, "POST", jsonQrcode.toString());
        if (!ticketjson.containsKey((Object)"errcode")) {
            String ticket = ticketjson.getString("ticket");
            String qrcodeimgurl = WeixinUtil.get_qrcode_url.replace("TICKET", ticket);
            String filename = String.valueOf(weixinQrcode.getAccountid()) + weixinQrcode.getSceneId() + ".jpg";
            String targetPath = String.valueOf(request.getSession().getServletContext().getRealPath("upload/weixinqrcode")) + "/" + filename;
            imgurl = "upload/weixinqrcode/" + filename;
            File target = new File(targetPath);
            WeixinUtil.saveHttpImage(qrcodeimgurl, "GET", "", target);
        }
        return imgurl;
    }

    public String replaceVal(String sql, WeixinQrcodeEntity t) {
        sql = sql.replace("#{id}", String.valueOf(t.getId()));
        sql = sql.replace("#{create_name}", String.valueOf(t.getCreateName()));
        sql = sql.replace("#{create_date}", String.valueOf(t.getCreateDate()));
        sql = sql.replace("#{update_name}", String.valueOf(t.getUpdateName()));
        sql = sql.replace("#{update_date}", String.valueOf(t.getUpdateDate()));
        sql = sql.replace("#{expire_seconds}", String.valueOf(t.getExpireSeconds()));
        sql = sql.replace("#{action_name}", String.valueOf(t.getActionName()));
        sql = sql.replace("#{action_info}", String.valueOf(t.getActionInfo()));
        sql = sql.replace("#{scene_id}", String.valueOf(t.getSceneId()));
        sql = sql.replace("#{accountid}", String.valueOf(t.getAccountid()));
        sql = sql.replace("#{UUID}", UUID.randomUUID().toString());
        return sql;
    }

    @Override
    public SceneInstance detailBusiness(Integer businessType) {
        if (businessType == hd) {
            return this.scene_hd();
        }
        if (businessType == dy) {
            return this.scene_dy();
        }
        if (businessType == wd) {
            return this.scene_wd();
        }
        if (businessType == sq) {
            return this.scene_sq();
        }
        if (businessType == tp) {
            return this.scene_tp();
        }
        if (businessType == qd) {
            return this.scene_qd();
        }
        if (businessType == wb) {
            return this.scene_wb();
        }
        if (businessType == lj) {
            return this.scene_lj();
        }
        return new SceneInstance();
    }

    @Override
    public List<SceneInstance> listBusinessType() {
        ArrayList<SceneInstance> list = new ArrayList<SceneInstance>();
        SceneInstance instance = new SceneInstance();
        instance.setId(hd);
        instance.setType("link");
        instance.setTitle("\u5fae\u6d3b\u52a8");
        list.add(instance);
        instance = new SceneInstance();
        instance.setId(dy);
        instance.setType("link");
        instance.setTitle("\u5fae\u8c03\u7814");
        list.add(instance);
        instance = new SceneInstance();
        instance.setId(wd);
        instance.setType("link");
        instance.setTitle("\u6709\u5956\u95ee\u7b54");
        list.add(instance);
        instance = new SceneInstance();
        instance.setId(sq);
        instance.setType("link");
        instance.setTitle("\u5fae\u793e\u533a");
        list.add(instance);
        instance = new SceneInstance();
        instance.setId(tp);
        instance.setType("link");
        instance.setTitle("\u5fae\u6295\u7968");
        list.add(instance);
        instance = new SceneInstance();
        instance.setId(qd);
        instance.setType("link");
        instance.setTitle("\u5fae\u7b7e\u5230");
        list.add(instance);
        instance = new SceneInstance();
        instance.setId(lj);
        instance.setType("link");
        instance.setTitle("\u94fe\u63a5\u7d20\u6750");
        list.add(instance);
        instance = new SceneInstance();
        instance.setId(wb);
        instance.setType("link");
        instance.setTitle("\u7eaf\u6587\u672c");
        list.add(instance);
        return list;
    }

    private SceneInstance scene_hd() {
        SceneInstance instance = new SceneInstance();
        instance.setType("link");
        instance.setTitle("\u5fae\u6d3b\u52a8");
        String hql = "from HuodongEntity where triggerFlag='Y' and hdCode='1' and accountid='" + ResourceUtil.getShangJiaAccountId() + "'";
        List hdList = this.findByQueryString(hql);
        ArrayList<ActionInfoLink> links = new ArrayList<ActionInfoLink>();
        ActionInfoLink link = null;
        for (HuodongEntity hd : hdList) {
            link = new ActionInfoLink();
            link.setTitle(hd.getTitle());
            link.setUrl(this.link(hd.getUrl(), "hdid", hd.getId()));
            links.add(link);
        }
        instance.setList(links);
        return instance;
    }

    private SceneInstance scene_dy() {
        SceneInstance instance = new SceneInstance();
        instance.setType("link");
        instance.setTitle("\u5fae\u8c03\u7814");
        String hql = "from WeixinSurveyMainEntity where statement='1' and accountid='" + ResourceUtil.getShangJiaAccountId() + "'";
        List dyList = this.findByQueryString(hql);
        ArrayList<ActionInfoLink> links = new ArrayList<ActionInfoLink>();
        ActionInfoLink link = null;
        for (WeixinSurveyMainEntity dy : dyList) {
            link = new ActionInfoLink();
            link.setTitle(dy.getSurveyTitle());
            link.setUrl(this.link("weixinSurveyMainController.do?goReview", "id", dy.getId()));
            links.add(link);
        }
        instance.setList(links);
        return instance;
    }

    private SceneInstance scene_wd() {
        SceneInstance instance = new SceneInstance();
        instance.setType("link");
        instance.setTitle("\u6709\u5956\u95ee\u7b54");
        String hql = "from WeixinAwardQuestionMainEntity where statement='1' and accountid='" + ResourceUtil.getShangJiaAccountId() + "'";
        List wdList = this.findByQueryString(hql);
        ArrayList<ActionInfoLink> links = new ArrayList<ActionInfoLink>();
        ActionInfoLink link = null;
        for (WeixinAwardQuestionMainEntity wd : wdList) {
            link = new ActionInfoLink();
            link.setTitle(wd.getAwardQuestionTitle());
            link.setUrl(this.link("weixinAwardQuestionMainController.do?goReview", "id", wd.getId()));
            links.add(link);
        }
        instance.setList(links);
        return instance;
    }

    private SceneInstance scene_sq() {
        SceneInstance instance = new SceneInstance();
        instance.setType("link");
        instance.setTitle("\u5fae\u793e\u533a");
        String hql = "from WeixinBbsEntity where accountid='" + ResourceUtil.getShangJiaAccountId() + "'";
        List sqList = this.findByQueryString(hql);
        ArrayList<ActionInfoLink> links = new ArrayList<ActionInfoLink>();
        ActionInfoLink link = null;
        for (WeixinBbsEntity sq : sqList) {
            link = new ActionInfoLink();
            link.setTitle(sq.getName());
            link.setUrl(this.link("bbsController.do?goPage&page=index", "id", sq.getId()));
            links.add(link);
        }
        instance.setList(links);
        return instance;
    }

    private SceneInstance scene_tp() {
        SceneInstance instance = new SceneInstance();
        instance.setType("link");
        instance.setTitle("\u5fae\u6295\u7968");
        String hql = "from WeixinVoteEntity where statement='1' and accountid='" + ResourceUtil.getShangJiaAccountId() + "'";
        List tpList = this.findByQueryString(hql);
        ArrayList<ActionInfoLink> links = new ArrayList<ActionInfoLink>();
        ActionInfoLink link = null;
        for (WeixinVoteEntity tp : tpList) {
            link = new ActionInfoLink();
            link.setTitle(tp.getVoteTitle());
            link.setUrl(this.link("weixinVoteController.do?goVote", "id", tp.getId()));
            links.add(link);
        }
        instance.setList(links);
        return instance;
    }

    private SceneInstance scene_qd() {
        SceneInstance instance = new SceneInstance();
        instance.setType("link");
        instance.setTitle("\u5fae\u7b7e\u5230");
        ArrayList<ActionInfoLink> links = new ArrayList<ActionInfoLink>();
        ActionInfoLink link = null;
        link = new ActionInfoLink();
        link.setTitle("\u5fae\u7b7e\u5230");
        link.setUrl(this.link("signRecordController.do?goRegistPage", "id", "0"));
        links.add(link);
        instance.setList(links);
        return instance;
    }

    private SceneInstance scene_wb() {
        SceneInstance instance = new SceneInstance();
        instance.setType("text");
        instance.setTitle("\u7eaf\u6587\u672c");
        instance.setList(new ArrayList<ActionInfoLink>());
        return instance;
    }

    private SceneInstance scene_lj() {
        SceneInstance instance = new SceneInstance();
        instance.setType("link");
        instance.setTitle("\u94fe\u63a5\u7d20\u6750");
        String hql = "from WeixinLinksucaiEntity where shareStatus='Y'";
        List ljList = this.findByQueryString(hql);
        ArrayList<ActionInfoLink> links = new ArrayList<ActionInfoLink>();
        ActionInfoLink link = null;
        for (WeixinLinksucaiEntity lj : ljList) {
            link = new ActionInfoLink();
            link.setTitle(lj.getName());
            link.setUrl(this.link("weixinLinksucaiController.do?link", "id", lj.getId()));
            links.add(link);
        }
        instance.setList(links);
        return instance;
    }

    private String link(String uri, String idField, String id) {
        String url = "";
        ResourceBundle bundler = ResourceBundle.getBundle("sysConfig");
        url = String.valueOf(bundler.getString("domain")) + "/" + uri + "&" + idField + "=" + id;
        url = String.valueOf(url) + "&accountid=" + ResourceUtil.getShangJiaAccountId();
        return url;
    }

    @Override
    public String scanResponse(WeixinQrcodeEntity qrcode, TextMessageResp textMessage, String respMessage, String toUserName, String fromUserName, String respContent, String sys_accountId) {
        if ("link".equalsIgnoreCase(qrcode.getScanReptype())) {
            String content = qrcode.getActionInfo();
            String title = qrcode.getQrcodeTitle();
            if (oConvertUtils.isNotEmpty((Object)title)) {
                textMessage.setContent(String.valueOf(title) + " \u7f51\u5740:" + content);
            } else {
                textMessage.setContent("\u7f51\u5740:" + content);
            }
            respMessage = MessageUtil.textMessageToXml(textMessage);
        } else {
            String content = qrcode.getActionInfo();
            textMessage.setContent(content);
            respMessage = MessageUtil.textMessageToXml(textMessage);
        }
        return respMessage;
    }
}

