/*
 * Decompiled with CFR 0.152.
 */
package weixin.idea.qrcode.controller;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.jeewx.api.core.exception.WexinReqException;
import org.jeewx.api.wxuser.user.JwUserAPI;
import org.jeewx.api.wxuser.user.model.Wxuser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.core.util.WeixinUtil;
import weixin.guanjia.gzuserinfo.entity.GzUserInfoYw;
import weixin.idea.qrcode.entity.WeixinQrcodeScanRecord;
import weixin.idea.qrcode.service.WeixinQrcodeScanRecordServiceI;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/weixinQrcodeScanRecordController"})
public class WeixinQrcodeScanRecordController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinQrcodeScanRecordController.class);
    @Autowired
    private WeixinQrcodeScanRecordServiceI weixinQrcodeScanRecordService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private WeixinAccountServiceI weixinAccountService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"weixinQrcodeScanRecord"})
    public ModelAndView weixinQrcodeScene(HttpServletRequest request, String scenekey) {
        request.setAttribute("scenekey", (Object)scenekey);
        return new ModelAndView("weixin/idea/qrcode/weixinQrcodeScanRecordList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeixinQrcodeScanRecord weixinQrcode, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinQrcodeScanRecord.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinQrcode, (Map)request.getParameterMap());
        try {
            cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
            cq.add();
            this.weixinQrcodeScanRecordService.getDataGridReturn(cq, true);
            List scanRecordList = cq.getDataGrid().getResults();
            for (WeixinQrcodeScanRecord record : scanRecordList) {
                if (!oConvertUtils.isEmpty((Object)record.getNickname()) || !oConvertUtils.isNotEmpty((Object)record.getOpenid())) continue;
                record.setNickname(this.getNickname(record.getOpenid(), record.getAccountid()));
                this.systemService.updateEntitie((Object)record);
            }
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    private String getNickname(String openid, String accountId) {
        try {
            List data = this.systemService.findHql("from GzUserInfoYw where accountId=? and openid=?", new Object[]{accountId, openid});
            if (data != null && data.size() > 0) {
                return new String(WeixinUtil.decode(((GzUserInfoYw)((Object)data.get(0))).getNickname()));
            }
            String accesstoken = this.weixinAccountService.getAccessToken(accountId);
            try {
                Wxuser user = JwUserAPI.getWxuser((String)accesstoken, (String)openid);
                return user.getNickname();
            }
            catch (WexinReqException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

