/*
 * Decompiled with CFR 0.152.
 */
package weixin.idea.qrcode.controller;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.BrowserUtils;
import org.jeecgframework.core.util.ExceptionUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExcelTitle;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.core.util.WeixinUtil;
import weixin.idea.qrcode.entity.WeixinQrcodeEntity;
import weixin.idea.qrcode.entity.WeixinQrcodeSceneEntity;
import weixin.idea.qrcode.model.ActionInfo;
import weixin.idea.qrcode.model.QrCode;
import weixin.idea.qrcode.model.Scene;
import weixin.idea.qrcode.model.SceneInstance;
import weixin.idea.qrcode.service.WeixinQrcodeSceneServiceI;
import weixin.idea.qrcode.service.WeixinQrcodeServiceI;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/weixinQrcodeController"})
public class WeixinQrcodeController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinQrcodeController.class);
    @Autowired
    private WeixinQrcodeServiceI weixinQrcodeService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private WeixinQrcodeSceneServiceI weixinQrcodeSceneService;
    @Autowired
    private WeixinAccountServiceI weixinAccountService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"createQrcode"})
    @ResponseBody
    public AjaxJson createQrcode(HttpServletRequest request, WeixinQrcodeEntity weixinQrcode) {
        AjaxJson j = new AjaxJson();
        QrCode qrCode = new QrCode();
        Scene scene = new Scene();
        ActionInfo actionInfo = new ActionInfo();
        if ((weixinQrcode = (WeixinQrcodeEntity)this.weixinQrcodeService.get(WeixinQrcodeEntity.class, (Serializable)((Object)weixinQrcode.getId()))).getActionName().equals("1")) {
            qrCode.setAction_name("QR_SCENE");
            if (weixinQrcode.getExpireSeconds() != null) {
                qrCode.setExpire_seconds(weixinQrcode.getExpireSeconds());
            } else {
                qrCode.setExpire_seconds(1800);
            }
        } else if (weixinQrcode.getActionName().equals("2")) {
            qrCode.setAction_name("QR_LIMIT_SCENE");
        }
        scene.setScene_id(weixinQrcode.getSceneId());
        actionInfo.setScene(scene);
        qrCode.setAction_info(actionInfo);
        JSONObject jsonQrcode = JSONObject.fromObject((Object)qrCode);
        String accesstoken = this.weixinAccountService.getAccessToken();
        if (accesstoken == null) {
            this.message = "\u6267\u884c\u5931\u8d25\uff0c\u5fae\u4fe1\u516c\u4f17accesstoken\u83b7\u53d6\u5931\u8d25\u3002";
            j.setMsg(this.message);
            j.setSuccess(false);
            return j;
        }
        String ticketurl = WeixinUtil.qrcode_ticket_url.replace("ACCESS_TOKEN", accesstoken);
        JSONObject ticketjson = WeixinUtil.httpRequest(ticketurl, "POST", jsonQrcode.toString());
        if (ticketjson.containsKey((Object)"errcode")) {
            this.message = "\u4e8c\u7ef4\u7801\u751f\u6210\u5931\u8d25\uff01\u9519\u8bef\u7801\u4e3a\uff1a" + ticketjson.getInt("errcode") + "\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + ticketjson.getString("errmsg");
            j.setSuccess(false);
            j.setMsg(this.message);
            return j;
        }
        String ticket = ticketjson.getString("ticket");
        String qrcodeimgurl = WeixinUtil.get_qrcode_url.replace("TICKET", ticket);
        String filename = String.valueOf(ResourceUtil.getShangJiaAccountId()) + weixinQrcode.getSceneId() + ".jpg";
        String targetPath = String.valueOf(request.getSession().getServletContext().getRealPath("upload/weixinqrcode")) + "/" + filename;
        weixinQrcode.setImageurl("upload/weixinqrcode/" + filename);
        File target = new File(targetPath);
        WeixinUtil.saveHttpImage(qrcodeimgurl, "GET", "", target);
        this.weixinQrcodeService.updateEntitie(weixinQrcode);
        this.message = "\u64cd\u4f5c\u6210\u529f\uff01";
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"weixinQrcode"})
    public ModelAndView weixinQrcode(HttpServletRequest request) {
        return new ModelAndView("weixin/idea/qrcode/weixinQrcodeList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeixinQrcodeEntity weixinQrcode, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinQrcodeEntity.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinQrcode, (Map)request.getParameterMap());
        try {
            cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        cq.add();
        this.weixinQrcodeService.getDataGridReturn(cq, true);
        List qrcodeList = cq.getDataGrid().getResults();
        List sceneList = null;
        for (WeixinQrcodeEntity qrcode : qrcodeList) {
            if (!oConvertUtils.isNotEmpty((Object)qrcode.getSceneId()) || !oConvertUtils.isNotEmpty((Object)(sceneList = this.systemService.findByProperty(WeixinQrcodeSceneEntity.class, "scenekey", (Object)qrcode.getSceneId()))) || sceneList.size() <= 0) continue;
            qrcode.setSceneValue(((WeixinQrcodeSceneEntity)sceneList.get(0)).getScenevalue());
        }
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(WeixinQrcodeEntity weixinQrcode, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinQrcode = (WeixinQrcodeEntity)this.systemService.getEntity(WeixinQrcodeEntity.class, (Serializable)((Object)weixinQrcode.getId()));
        this.message = "\u4e8c\u7ef4\u7801\u4fe1\u606f\u5220\u9664\u6210\u529f";
        try {
            this.weixinQrcodeService.delete(weixinQrcode);
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u4e8c\u7ef4\u7801\u4fe1\u606f\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u4e8c\u7ef4\u7801\u4fe1\u606f\u5220\u9664\u6210\u529f";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                WeixinQrcodeEntity weixinQrcode = (WeixinQrcodeEntity)this.systemService.getEntity(WeixinQrcodeEntity.class, (Serializable)((Object)id));
                this.weixinQrcodeService.delete(weixinQrcode);
                this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u4e8c\u7ef4\u7801\u4fe1\u606f\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(WeixinQrcodeEntity weixinQrcode, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u4e8c\u7ef4\u7801\u4fe1\u606f\u6dfb\u52a0\u6210\u529f";
        try {
            if (StringUtil.isNotEmpty((Object)weixinQrcode.getId())) {
                WeixinQrcodeEntity t = (WeixinQrcodeEntity)this.weixinQrcodeService.get(WeixinQrcodeEntity.class, (Serializable)((Object)weixinQrcode.getId()));
                MyBeanUtils.copyBeanNotNull2Bean((Object)weixinQrcode, (Object)t);
                if ("1".equals(t.getActionName())) {
                    t.setExpireSeconds(1800);
                } else {
                    t.setExpireSeconds(null);
                }
                this.weixinQrcodeService.saveOrUpdate(t);
                this.systemService.addLog("\u4e8c\u7ef4\u7801\u4fe1\u606f\u66f4\u65b0\u6210\u529f", Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            } else {
                if ("1".equals(weixinQrcode.getActionName())) {
                    weixinQrcode.setExpireSeconds(1800);
                } else {
                    weixinQrcode.setExpireSeconds(null);
                }
                this.weixinQrcodeService.save(weixinQrcode);
                this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u4e8c\u7ef4\u7801\u4fe1\u606f\u6dfb\u52a0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doUpdate"})
    @ResponseBody
    public AjaxJson doUpdate(WeixinQrcodeEntity weixinQrcode, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u4e8c\u7ef4\u7801\u4fe1\u606f\u66f4\u65b0\u6210\u529f";
        WeixinQrcodeEntity t = (WeixinQrcodeEntity)this.weixinQrcodeService.get(WeixinQrcodeEntity.class, (Serializable)((Object)weixinQrcode.getId()));
        try {
            MyBeanUtils.copyBeanNotNull2Bean((Object)weixinQrcode, (Object)t);
            this.weixinQrcodeService.saveOrUpdate(t);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u4e8c\u7ef4\u7801\u4fe1\u606f\u66f4\u65b0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(WeixinQrcodeEntity weixinQrcode, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinQrcode.getId())) {
            weixinQrcode = (WeixinQrcodeEntity)this.weixinQrcodeService.getEntity(WeixinQrcodeEntity.class, (Serializable)((Object)weixinQrcode.getId()));
            req.setAttribute("weixinQrcodePage", (Object)weixinQrcode);
        }
        List<Object> scenelist = new ArrayList();
        scenelist = this.weixinQrcodeService.listBusinessType();
        req.setAttribute("scenelist", scenelist);
        List list = this.weixinQrcodeService.findByProperty(WeixinQrcodeSceneEntity.class, "accountid", ResourceUtil.getShangJiaAccountId());
        req.setAttribute("list", (Object)list);
        return new ModelAndView("weixin/idea/qrcode/weixinQrcode-add");
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(WeixinQrcodeEntity weixinQrcode, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinQrcode.getId())) {
            weixinQrcode = (WeixinQrcodeEntity)this.weixinQrcodeService.getEntity(WeixinQrcodeEntity.class, (Serializable)((Object)weixinQrcode.getId()));
            req.setAttribute("weixinQrcodePage", (Object)weixinQrcode);
        }
        List<Object> scenelist = new ArrayList();
        scenelist = this.weixinQrcodeService.listBusinessType();
        req.setAttribute("scenelist", scenelist);
        List list = this.weixinQrcodeService.findByProperty(WeixinQrcodeSceneEntity.class, "accountid", ResourceUtil.getShangJiaAccountId());
        req.setAttribute("list", (Object)list);
        return new ModelAndView("weixin/idea/qrcode/weixinQrcode-add");
    }

    @RequestMapping(params={"detailBusiness"})
    @ResponseBody
    public SceneInstance detailBusiness(Integer businessType, HttpServletRequest req) {
        SceneInstance qrcodeBusi = this.weixinQrcodeService.detailBusiness(businessType);
        return qrcodeBusi;
    }

    @RequestMapping(params={"upload"})
    public ModelAndView upload(HttpServletRequest req) {
        return new ModelAndView("weixin/idea/qrcode/weixinQrcodeUpload");
    }

    @RequestMapping(params={"downqrcode"})
    public void downQrcode(WeixinQrcodeEntity weixinQrcode, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/jpg");
        weixinQrcode = (WeixinQrcodeEntity)this.weixinQrcodeService.get(WeixinQrcodeEntity.class, (Serializable)((Object)weixinQrcode.getId()));
        WeixinQrcodeSceneEntity weixinQrcodeScene = (WeixinQrcodeSceneEntity)this.weixinQrcodeSceneService.findUniqueByProperty(WeixinQrcodeSceneEntity.class, "scenekey", weixinQrcode.getSceneId());
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                int bytesRead;
                String qrcodepath = request.getSession().getServletContext().getRealPath(weixinQrcode.getImageurl());
                File file = new File(qrcodepath);
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
                byte[] buff = new byte[2048];
                codedFileName = weixinQrcodeScene != null ? "\u4e8c\u7ef4\u7801\u4fe1\u606f" + weixinQrcodeScene.getScenevalue() : "\u4e8c\u7ef4\u7801\u4fe1\u606f";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".jpg");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".jpg");
                }
                fOut = response.getOutputStream();
                while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                    fOut.write(buff, 0, bytesRead);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"exportXls"})
    public void exportXls(WeixinQrcodeEntity weixinQrcode, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u4e8c\u7ef4\u7801\u4fe1\u606f";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                CriteriaQuery cq = new CriteriaQuery(WeixinQrcodeEntity.class, dataGrid);
                HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinQrcode, (Map)request.getParameterMap());
                List weixinQrcodes = this.weixinQrcodeService.getListByCriteriaQuery(cq, false);
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("\u4e8c\u7ef4\u7801\u4fe1\u606f\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WeixinQrcodeEntity.class, (Collection)weixinQrcodes);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"exportXlsByT"})
    public void exportXlsByT(WeixinQrcodeEntity weixinQrcode, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u4e8c\u7ef4\u7801\u4fe1\u606f";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("\u4e8c\u7ef4\u7801\u4fe1\u606f\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WeixinQrcodeEntity.class, null);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"importExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson importExcel(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setSecondTitleRows(1);
            params.setNeedSave(true);
            try {
                try {
                    List listWeixinQrcodeEntitys = (List)ExcelImportUtil.importExcelByIs((InputStream)file.getInputStream(), WeixinQrcodeEntity.class, (ImportParams)params);
                    for (WeixinQrcodeEntity weixinQrcode : listWeixinQrcodeEntitys) {
                        this.weixinQrcodeService.save(weixinQrcode);
                    }
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01");
                }
                catch (Exception e) {
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
                    logger.error((Object)ExceptionUtil.getExceptionMessage((Exception)e));
                    try {
                        file.getInputStream().close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                file.getInputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return j;
    }
}

