/*
 * Decompiled with CFR 0.152.
 */
package weixin.idea.photo.controller;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.common.UploadFile;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.idea.photo.entity.WeixinPhotoAlbumEntity;
import weixin.idea.photo.entity.WeixinPhotoEntity;
import weixin.idea.photo.service.WeixinPhotoAlbumServiceI;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/weixinPhotoAlbumController"})
public class WeixinPhotoAlbumController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinPhotoAlbumController.class);
    @Autowired
    private WeixinPhotoAlbumServiceI weixinPhotoAlbumService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"weixinPhotoAlbum"})
    public ModelAndView weixinPhotoAlbum(HttpServletRequest request, WeixinPhotoAlbumEntity weixinPhotoAlbum) {
        CriteriaQuery cq = new CriteriaQuery(WeixinPhotoAlbumEntity.class);
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        cq.add();
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinPhotoAlbum, (Map)request.getParameterMap());
        List albums = this.weixinPhotoAlbumService.getListByCriteriaQuery(cq, false);
        request.setAttribute("albums", (Object)albums);
        return new ModelAndView("weixin/idea/photo/weixinPhotoAlbumList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeixinPhotoAlbumEntity weixinPhotoAlbum, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinPhotoAlbumEntity.class, dataGrid);
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        cq.add();
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinPhotoAlbum, (Map)request.getParameterMap());
        this.weixinPhotoAlbumService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(WeixinPhotoAlbumEntity weixinPhotoAlbum, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String id = request.getParameter("id");
        weixinPhotoAlbum = (WeixinPhotoAlbumEntity)this.systemService.getEntity(WeixinPhotoAlbumEntity.class, (Serializable)((Object)id));
        this.weixinPhotoAlbumService.deleteFiles(weixinPhotoAlbum);
        this.message = "\u5fae\u76f8\u518c\u5220\u9664\u6210\u529f";
        this.weixinPhotoAlbumService.delete(weixinPhotoAlbum);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"delPhoto"})
    @ResponseBody
    public AjaxJson delPhoto(WeixinPhotoEntity weixinPhoto, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinPhoto = (WeixinPhotoEntity)this.systemService.getEntity(WeixinPhotoEntity.class, (Serializable)((Object)weixinPhoto.getId()));
        this.weixinPhotoAlbumService.deleteFile(weixinPhoto);
        this.message = "\u76f8\u7247\u5220\u9664\u6210\u529f";
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(WeixinPhotoAlbumEntity weixinPhotoAlbum, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String albumId = null;
        if (StringUtil.isNotEmpty((Object)weixinPhotoAlbum.getId())) {
            this.message = "\u5fae\u76f8\u518c\u66f4\u65b0\u6210\u529f";
            albumId = weixinPhotoAlbum.getId();
            WeixinPhotoAlbumEntity t = (WeixinPhotoAlbumEntity)this.weixinPhotoAlbumService.get(WeixinPhotoAlbumEntity.class, (Serializable)((Object)weixinPhotoAlbum.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)weixinPhotoAlbum, (Object)t);
                this.weixinPhotoAlbumService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u5fae\u76f8\u518c\u66f4\u65b0\u5931\u8d25";
            }
        } else {
            String accountId = ResourceUtil.getShangJiaAccountId();
            weixinPhotoAlbum.setAccountid(accountId);
            this.message = "\u5fae\u76f8\u518c\u6dfb\u52a0\u6210\u529f";
            albumId = (String)((Object)this.weixinPhotoAlbumService.save(weixinPhotoAlbum));
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        j.setMsg(this.message);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("albumId", albumId);
        j.setAttributes(attributes);
        return j;
    }

    @RequestMapping(params={"savePhoto"})
    @ResponseBody
    public AjaxJson savePhoto(WeixinPhotoEntity weixinPhoto, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty((Object)weixinPhoto.getId())) {
            this.message = "\u76f8\u7247\u66f4\u65b0\u6210\u529f";
            WeixinPhotoEntity t = (WeixinPhotoEntity)this.systemService.get(WeixinPhotoEntity.class, (Serializable)((Object)weixinPhoto.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)weixinPhoto, (Object)t);
                this.weixinPhotoAlbumService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u76f8\u7247\u66f4\u65b0\u5931\u8d25";
            }
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(WeixinPhotoAlbumEntity weixinPhotoAlbum, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinPhotoAlbum.getId())) {
            weixinPhotoAlbum = (WeixinPhotoAlbumEntity)this.weixinPhotoAlbumService.getEntity(WeixinPhotoAlbumEntity.class, (Serializable)((Object)weixinPhotoAlbum.getId()));
            req.setAttribute("weixinPhotoAlbumPage", (Object)weixinPhotoAlbum);
        }
        return new ModelAndView("weixin/idea/photo/weixinPhotoAlbum");
    }

    @RequestMapping(params={"goEditPhoto"})
    public ModelAndView goEditPhoto(WeixinPhotoEntity weixinPhoto, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinPhoto.getId())) {
            weixinPhoto = (WeixinPhotoEntity)this.weixinPhotoAlbumService.getEntity(WeixinPhotoEntity.class, (Serializable)((Object)weixinPhoto.getId()));
            req.setAttribute("weixinPhoto", (Object)weixinPhoto);
        }
        return new ModelAndView("weixin/idea/photo/weixinPhoto");
    }

    @RequestMapping(params={"uploadPhotoInit"})
    public ModelAndView uploadPhotoInit(HttpServletRequest request) {
        request.setAttribute("albumId", (Object)request.getParameter("albumId"));
        return new ModelAndView("weixin/idea/photo/uploadPhoto");
    }

    @RequestMapping(params={"viewPhotos"})
    public ModelAndView viewPhotos(HttpServletRequest request) {
        String id = request.getParameter("id");
        request.setAttribute("id", (Object)id);
        WeixinPhotoAlbumEntity weixinPhotoAlbum = (WeixinPhotoAlbumEntity)this.weixinPhotoAlbumService.getEntity(WeixinPhotoAlbumEntity.class, (Serializable)((Object)id));
        List<WeixinPhotoEntity> photos = weixinPhotoAlbum.getPhotos();
        if (weixinPhotoAlbum.getPhoto() != null) {
            request.setAttribute("photoId", (Object)weixinPhotoAlbum.getPhoto().getId());
        } else {
            request.setAttribute("photoId", (Object)"");
        }
        request.setAttribute("photos", photos);
        return new ModelAndView("weixin/idea/photo/viewPhotos");
    }

    @RequestMapping(params={"saveFiles"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveFiles(HttpServletRequest request, HttpServletResponse response, WeixinPhotoEntity photo) {
        AjaxJson j = new AjaxJson();
        HashMap<String, String> attributes = new HashMap<String, String>();
        String fileKey = oConvertUtils.getString((String)request.getParameter("fileKey"));
        String albumId = oConvertUtils.getString((String)request.getParameter("albumId"));
        if (StringUtil.isNotEmpty((Object)fileKey)) {
            photo.setId(fileKey);
            photo = (WeixinPhotoEntity)this.systemService.getEntity(WeixinPhotoEntity.class, (Serializable)((Object)fileKey));
        }
        WeixinPhotoAlbumEntity album = (WeixinPhotoAlbumEntity)this.systemService.getEntity(WeixinPhotoAlbumEntity.class, (Serializable)((Object)albumId));
        photo.setAlbum(album);
        photo.setName("\u672a\u547d\u540d");
        UploadFile uploadFile = new UploadFile(request, (Object)photo);
        uploadFile.setCusPath("files");
        uploadFile.setSwfpath("swfpath");
        uploadFile.setByteField(null);
        photo = (WeixinPhotoEntity)this.systemService.uploadFile(uploadFile);
        attributes.put("fileKey", photo.getId());
        attributes.put("viewhref", "commonController.do?objfileList&fileKey=" + photo.getId());
        attributes.put("delurl", "commonController.do?delObjFile&fileKey=" + photo.getId());
        j.setMsg("\u6587\u4ef6\u6dfb\u52a0\u6210\u529f");
        j.setAttributes(attributes);
        return j;
    }

    @RequestMapping(params={"setAlbumFace"})
    @ResponseBody
    public AjaxJson setAlbumFace(WeixinPhotoAlbumEntity weixinPhotoAlbum, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String photoId = request.getParameter("photoId");
        WeixinPhotoEntity photo = (WeixinPhotoEntity)this.systemService.get(WeixinPhotoEntity.class, (Serializable)((Object)photoId));
        WeixinPhotoAlbumEntity t = (WeixinPhotoAlbumEntity)this.weixinPhotoAlbumService.get(WeixinPhotoAlbumEntity.class, (Serializable)((Object)weixinPhotoAlbum.getId()));
        t.setPhoto(photo);
        this.weixinPhotoAlbumService.saveOrUpdate(t);
        this.message = "\u6210\u529f\u8bbe\u7f6e\u5c01\u9762";
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"cancelAlbumFace"})
    @ResponseBody
    public AjaxJson cancelAlbumFace(WeixinPhotoAlbumEntity weixinPhotoAlbum, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        WeixinPhotoAlbumEntity t = (WeixinPhotoAlbumEntity)this.weixinPhotoAlbumService.get(WeixinPhotoAlbumEntity.class, (Serializable)((Object)weixinPhotoAlbum.getId()));
        t.setPhoto(null);
        this.weixinPhotoAlbumService.saveOrUpdate(t);
        this.message = "\u6210\u529f\u53d6\u6d88\u5c01\u9762";
        j.setMsg(this.message);
        return j;
    }
}

