/*
 * Decompiled with CFR 0.152.
 */
package weixin.idea.photo.controller;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.common.UploadFile;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.cms.util.CmsFreemarkerHelper;
import weixin.idea.photo.common.PhotoConstant;
import weixin.idea.photo.entity.WeixinPhotoAlbumEntity;
import weixin.idea.photo.entity.WeixinPhotoEntity;
import weixin.idea.photo.service.WeixinPhotoAlbumServiceI;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/frontPhotoAlbumController"})
public class FrontPhotoAlbumController
extends BaseController
implements PhotoConstant {
    private static final Logger logger = Logger.getLogger(FrontPhotoAlbumController.class);
    @Autowired
    private WeixinPhotoAlbumServiceI weixinPhotoAlbumService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    private Map<String, String> paramsToMap(HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        Enumeration em = request.getParameterNames();
        while (em.hasMoreElements()) {
            String paramName = (String)em.nextElement();
            String paramValue = request.getParameter(paramName);
            params.put(paramName, paramValue);
        }
        if (!params.containsKey("accountid")) {
            params.put("accountid", ResourceUtil.getShangJiaAccountId());
        }
        return params;
    }

    @RequestMapping(params={"goPage"})
    public void goPage(HttpServletRequest request, HttpServletResponse response, @RequestParam String page) {
        Map<String, String> params = this.paramsToMap(request);
        String styleUrl = "/template/photo";
        WeixinPhotoAlbumEntity photoAlbum = (WeixinPhotoAlbumEntity)this.weixinPhotoAlbumService.findUniqueByProperty(WeixinPhotoAlbumEntity.class, "accountid", params.get("accountid"));
        styleUrl = photoAlbum != null ? String.valueOf(styleUrl) + "/" + "default" : String.valueOf(styleUrl) + "/" + "default";
        HashMap<String, Object> data = new HashMap<String, Object>();
        String res = "template/photo/default";
        data.put("res", res);
        List photoAlbums = this.weixinPhotoAlbumService.getList(WeixinPhotoAlbumEntity.class);
        data.put("photoAlbumData", photoAlbums);
        if (photoAlbums != null && photoAlbums.size() > 0) {
            List<WeixinPhotoEntity> photos = ((WeixinPhotoAlbumEntity)photoAlbums.get(0)).getPhotos();
            data.put("photoData", photos);
        }
        CmsFreemarkerHelper cmsFreemarkerHelper = new CmsFreemarkerHelper();
        String pageUrl = String.valueOf(styleUrl) + "/" + "html" + "/" + page + ".html";
        String html = cmsFreemarkerHelper.parseTemplate(pageUrl, data);
        response.setContentType("text/html");
        response.setHeader("Cache-Control", "no-store");
        PrintWriter writer = null;
        try {
            try {
                writer = response.getWriter();
                writer.println(html);
                writer.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
                if (writer != null) {
                    writer.close();
                }
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeixinPhotoAlbumEntity weixinPhotoAlbum, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinPhotoAlbumEntity.class, dataGrid);
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        cq.add();
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinPhotoAlbum, (Map)request.getParameterMap());
        this.weixinPhotoAlbumService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(WeixinPhotoAlbumEntity weixinPhotoAlbum, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String id = request.getParameter("id");
        weixinPhotoAlbum = (WeixinPhotoAlbumEntity)this.systemService.getEntity(WeixinPhotoAlbumEntity.class, (Serializable)((Object)id));
        this.weixinPhotoAlbumService.deleteFiles(weixinPhotoAlbum);
        this.message = "\u5fae\u76f8\u518c\u5220\u9664\u6210\u529f";
        this.weixinPhotoAlbumService.delete(weixinPhotoAlbum);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"delPhoto"})
    @ResponseBody
    public AjaxJson delPhoto(WeixinPhotoEntity weixinPhoto, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinPhoto = (WeixinPhotoEntity)this.systemService.getEntity(WeixinPhotoEntity.class, (Serializable)((Object)weixinPhoto.getId()));
        this.weixinPhotoAlbumService.deleteFile(weixinPhoto);
        this.message = "\u76f8\u7247\u5220\u9664\u6210\u529f";
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(WeixinPhotoAlbumEntity weixinPhotoAlbum, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String albumId = null;
        if (StringUtil.isNotEmpty((Object)weixinPhotoAlbum.getId())) {
            this.message = "\u5fae\u76f8\u518c\u66f4\u65b0\u6210\u529f";
            albumId = weixinPhotoAlbum.getId();
            WeixinPhotoAlbumEntity t = (WeixinPhotoAlbumEntity)this.weixinPhotoAlbumService.get(WeixinPhotoAlbumEntity.class, (Serializable)((Object)weixinPhotoAlbum.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)weixinPhotoAlbum, (Object)t);
                this.weixinPhotoAlbumService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u5fae\u76f8\u518c\u66f4\u65b0\u5931\u8d25";
            }
        } else {
            String accountId = ResourceUtil.getShangJiaAccount().getAccountappid();
            weixinPhotoAlbum.setAccountid(accountId);
            this.message = "\u5fae\u76f8\u518c\u6dfb\u52a0\u6210\u529f";
            albumId = (String)((Object)this.weixinPhotoAlbumService.save(weixinPhotoAlbum));
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        j.setMsg(this.message);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("albumId", albumId);
        j.setAttributes(attributes);
        return j;
    }

    @RequestMapping(params={"savePhoto"})
    @ResponseBody
    public AjaxJson savePhoto(WeixinPhotoEntity weixinPhoto, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty((Object)weixinPhoto.getId())) {
            this.message = "\u76f8\u7247\u66f4\u65b0\u6210\u529f";
            WeixinPhotoEntity t = (WeixinPhotoEntity)this.systemService.get(WeixinPhotoEntity.class, (Serializable)((Object)weixinPhoto.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)weixinPhoto, (Object)t);
                this.weixinPhotoAlbumService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u76f8\u7247\u66f4\u65b0\u5931\u8d25";
            }
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(WeixinPhotoAlbumEntity weixinPhotoAlbum, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinPhotoAlbum.getId())) {
            weixinPhotoAlbum = (WeixinPhotoAlbumEntity)this.weixinPhotoAlbumService.getEntity(WeixinPhotoAlbumEntity.class, (Serializable)((Object)weixinPhotoAlbum.getId()));
            req.setAttribute("weixinPhotoAlbumPage", (Object)weixinPhotoAlbum);
        }
        return new ModelAndView("weixin/idea/photo/weixinPhotoAlbum");
    }

    @RequestMapping(params={"goEditPhoto"})
    public ModelAndView goEditPhoto(WeixinPhotoEntity weixinPhoto, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinPhoto.getId())) {
            weixinPhoto = (WeixinPhotoEntity)this.weixinPhotoAlbumService.getEntity(WeixinPhotoEntity.class, (Serializable)((Object)weixinPhoto.getId()));
            req.setAttribute("weixinPhoto", (Object)weixinPhoto);
        }
        return new ModelAndView("weixin/idea/photo/weixinPhoto");
    }

    @RequestMapping(params={"uploadPhotoInit"})
    public ModelAndView uploadPhotoInit(HttpServletRequest request) {
        request.setAttribute("albumId", (Object)request.getParameter("albumId"));
        return new ModelAndView("weixin/idea/photo/uploadPhoto");
    }

    @RequestMapping(params={"viewPhotos"})
    public ModelAndView viewPhotos(HttpServletRequest request) {
        String id = request.getParameter("id");
        request.setAttribute("id", (Object)id);
        WeixinPhotoAlbumEntity weixinPhotoAlbum = (WeixinPhotoAlbumEntity)this.weixinPhotoAlbumService.getEntity(WeixinPhotoAlbumEntity.class, (Serializable)((Object)id));
        List<WeixinPhotoEntity> photos = weixinPhotoAlbum.getPhotos();
        if (weixinPhotoAlbum.getPhoto() != null) {
            request.setAttribute("photoId", (Object)weixinPhotoAlbum.getPhoto().getId());
        } else {
            request.setAttribute("photoId", (Object)"");
        }
        request.setAttribute("photos", photos);
        return new ModelAndView("weixin/idea/photo/viewPhotos");
    }

    @RequestMapping(params={"saveFiles"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveFiles(HttpServletRequest request, HttpServletResponse response, WeixinPhotoEntity photo) {
        AjaxJson j = new AjaxJson();
        HashMap<String, String> attributes = new HashMap<String, String>();
        String fileKey = oConvertUtils.getString((String)request.getParameter("fileKey"));
        String albumId = oConvertUtils.getString((String)request.getParameter("albumId"));
        if (StringUtil.isNotEmpty((Object)fileKey)) {
            photo.setId(fileKey);
            photo = (WeixinPhotoEntity)this.systemService.getEntity(WeixinPhotoEntity.class, (Serializable)((Object)fileKey));
        }
        WeixinPhotoAlbumEntity album = (WeixinPhotoAlbumEntity)this.systemService.getEntity(WeixinPhotoAlbumEntity.class, (Serializable)((Object)albumId));
        photo.setAlbum(album);
        photo.setName("\u672a\u547d\u540d");
        UploadFile uploadFile = new UploadFile(request, (Object)photo);
        uploadFile.setCusPath("files");
        uploadFile.setSwfpath("swfpath");
        uploadFile.setByteField(null);
        photo = (WeixinPhotoEntity)this.systemService.uploadFile(uploadFile);
        attributes.put("fileKey", photo.getId());
        attributes.put("viewhref", "commonController.do?objfileList&fileKey=" + photo.getId());
        attributes.put("delurl", "commonController.do?delObjFile&fileKey=" + photo.getId());
        j.setMsg("\u6587\u4ef6\u6dfb\u52a0\u6210\u529f");
        j.setAttributes(attributes);
        return j;
    }

    @RequestMapping(params={"setAlbumFace"})
    @ResponseBody
    public AjaxJson setAlbumFace(WeixinPhotoAlbumEntity weixinPhotoAlbum, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String photoId = request.getParameter("photoId");
        WeixinPhotoEntity photo = (WeixinPhotoEntity)this.systemService.get(WeixinPhotoEntity.class, (Serializable)((Object)photoId));
        WeixinPhotoAlbumEntity t = (WeixinPhotoAlbumEntity)this.weixinPhotoAlbumService.get(WeixinPhotoAlbumEntity.class, (Serializable)((Object)weixinPhotoAlbum.getId()));
        t.setPhoto(photo);
        this.weixinPhotoAlbumService.saveOrUpdate(t);
        this.message = "\u6210\u529f\u8bbe\u7f6e\u5c01\u9762";
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"cancelAlbumFace"})
    @ResponseBody
    public AjaxJson cancelAlbumFace(WeixinPhotoAlbumEntity weixinPhotoAlbum, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        WeixinPhotoAlbumEntity t = (WeixinPhotoAlbumEntity)this.weixinPhotoAlbumService.get(WeixinPhotoAlbumEntity.class, (Serializable)((Object)weixinPhotoAlbum.getId()));
        t.setPhoto(null);
        this.weixinPhotoAlbumService.saveOrUpdate(t);
        this.message = "\u6210\u529f\u53d6\u6d88\u5c01\u9762";
        j.setMsg(this.message);
        return j;
    }
}

