/*
 * Decompiled with CFR 0.152.
 */
package weixin.idea.oauth2.util;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import jodd.util.StringUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jeecgframework.core.util.LogUtil;
import org.springframework.web.bind.annotation.RequestMapping;
import weixin.guanjia.core.util.WeixinUtil;
import weixin.idea.oauth2.pojo.SNSUserInfo;

public class OAuth2Util {
    public static final String SNSAPI_USERINFO = "snsapi_userinfo";
    public static final String SNSAPI_BASE = "snsapi_base";

    public static SNSUserInfo getSNSUserInfo(String accessToken, String openId) {
        SNSUserInfo snsUserInfo = null;
        String requestUrl = WeixinUtil.web_oauth_userinfo_url;
        JSONObject jsonObject = WeixinUtil.httpRequest(requestUrl = requestUrl.replace("ACCESS_TOKEN", accessToken).replace("OPENID", openId), "GET", null);
        if (jsonObject != null) {
            try {
                snsUserInfo = new SNSUserInfo();
                snsUserInfo.setOpenId(jsonObject.getString("openid"));
                snsUserInfo.setNickname(jsonObject.getString("nickname"));
                snsUserInfo.setSex(jsonObject.getInt("sex"));
                snsUserInfo.setCountry(jsonObject.getString("country"));
                snsUserInfo.setProvince(jsonObject.getString("province"));
                snsUserInfo.setCity(jsonObject.getString("city"));
                snsUserInfo.setHeadImgUrl(jsonObject.getString("headimgurl"));
                snsUserInfo.setPrivilegeList(JSONArray.toList((JSONArray)jsonObject.getJSONArray("privilege"), List.class));
            }
            catch (Exception e) {
                snsUserInfo = null;
                int errorCode = jsonObject.getInt("errcode");
                String errorMsg = jsonObject.getString("errmsg");
                LogUtil.error((String)("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25 errorCode" + errorCode + ",errorMsg" + errorMsg));
            }
        }
        return snsUserInfo;
    }

    public static String obtainWeixinOAuth2Url(String targetUrl, String appid, String scope) {
        String shareurl = "";
        String encodeTargetURL = "";
        try {
            encodeTargetURL = URLEncoder.encode(targetUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        shareurl = WeixinUtil.web_oauth_url.replace("APPID", appid).replace("REDIRECT_URI", encodeTargetURL).replace("SCOPE", scope);
        return shareurl;
    }

    public static String obtainTargetUrl(Class clazz, String currentMethodName, Map<String, String> paramsMap) {
        Method[] methodArray;
        if (StringUtil.isEmpty((String)currentMethodName) || clazz == null) {
            return null;
        }
        StringBuffer targetURL = new StringBuffer();
        String suffixStr = ".do?";
        targetURL.append(ResourceBundle.getBundle("sysConfig").getString("domain"));
        RequestMapping annotation = clazz.getAnnotation(RequestMapping.class);
        if (annotation != null) {
            targetURL.append(annotation.value()[0]).append(suffixStr);
        }
        Method[] methodArray2 = methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method tempMethod = methodArray2[n2];
            if (currentMethodName.equals(tempMethod.getName())) {
                targetURL.append(tempMethod.getAnnotation(RequestMapping.class).params()[0]);
                break;
            }
            ++n2;
        }
        if (paramsMap != null && paramsMap.size() > 0) {
            Set<String> keys = paramsMap.keySet();
            for (String key : keys) {
                targetURL.append("&").append(key).append("=").append(paramsMap.get(key));
            }
        }
        return targetURL.toString();
    }

    public static String obtainTargetUrl(Class clazz, String currentMethodName) {
        return OAuth2Util.obtainTargetUrl(clazz, currentMethodName, null);
    }
}

