/*
 * Decompiled with CFR 0.152.
 */
package weixin.idea.oauth2.controller;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.web.cgform.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import weixin.guanjia.account.entity.WeixinAccountEntity;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.core.wxRule.impl.RemoteWeixinMethod;
import weixin.guanjia.core.wxRule.pojo.oauth2.Oauth2CodePojo;
import weixin.idea.oauth2.util.OAuth2Util;

@Controller
@RequestMapping(value={"/sharePageOauth2Controller"})
public class SharePageOauth2Controller
extends BaseController {
    @Autowired
    private WeixinAccountServiceI weixinAccountService;

    @RequestMapping(params={"oauth"})
    public String oauth(HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException {
        String code = request.getParameter("code");
        LogUtil.info((Object)("code\u7684\u503c=" + code));
        String shareurl = request.getParameter("shareurl");
        LogUtil.info((Object)("shareurl=" + shareurl));
        try {
            String accountId = this.parseAccountId(shareurl);
            if (!"authdeny".equals(code) && oConvertUtils.isNotEmpty((Object)accountId)) {
                WeixinAccountEntity account = (WeixinAccountEntity)this.weixinAccountService.get(WeixinAccountEntity.class, (Serializable)((Object)accountId));
                Oauth2CodePojo oauth2CodePojo = new Oauth2CodePojo(account.getAccountappid(), account.getAccountappsecret(), code);
                Map<String, Object> map = new RemoteWeixinMethod().getOauth2AccessToken(oauth2CodePojo);
                String openid = (String)map.get("openid");
                String redirect = "redirect:" + this.decodeShareurl(shareurl) + "&openid=" + openid;
                LogUtil.info((Object)("redirect\u503c=" + redirect));
                return redirect;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    @RequestMapping(params={"sharePage"})
    public String sharePage(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        String shareurl = request.getParameter("shareurl");
        String accountId = this.parseAccountId(shareurl);
        if (oConvertUtils.isNotEmpty((Object)accountId)) {
            WeixinAccountEntity account = (WeixinAccountEntity)this.weixinAccountService.get(WeixinAccountEntity.class, (Serializable)((Object)accountId));
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("shareurl", shareurl);
            String tagetUrl = OAuth2Util.obtainTargetUrl(((Object)((Object)this)).getClass(), "oauth", params);
            LogUtil.info((Object)("targetURL\u7684\u503c=" + tagetUrl));
            String redirectURL = OAuth2Util.obtainWeixinOAuth2Url(tagetUrl, account.getAccountappid(), "snsapi_base");
            return "redirect:" + redirectURL;
        }
        throw new BusinessException(shareurl);
    }

    private String parseAccountId(String shareurl) {
        String find = "@accountid-";
        String accountId = "";
        if (oConvertUtils.isNotEmpty((Object)shareurl) && shareurl.contains(find) && (accountId = shareurl.substring(shareurl.indexOf(find) + find.length())).indexOf("@") > -1) {
            accountId = accountId.substring(0, accountId.indexOf("@"));
        }
        return accountId;
    }

    private String decodeShareurl(String shareurl) {
        String redirect = shareurl.replaceAll("@", "&").replaceAll("-", "=");
        return redirect;
    }
}

