/*
 * Decompiled with CFR 0.152.
 */
package weixin.idea.oauth2.controller;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import weixin.guanjia.account.entity.WeixinAccountEntity;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.core.util.WeixinUtil;
import weixin.guanjia.gzuserinfo.entity.GzUserInfoYw;
import weixin.util.DateUtils;
import weixin.vip.entity.WeixinVipMemberEntity;

@Controller
@RequestMapping(value={"/openDataController"})
public class OpenDataController {
    @Autowired
    private WeixinAccountServiceI weixinAccountService;
    @Autowired
    private SystemService systemService;

    @RequestMapping(params={"getWeixinAccount"})
    public void getWeixinAccount(HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException {
        HashMap<String, String> map = new HashMap<String, String>();
        WeixinAccountEntity po = new WeixinAccountEntity();
        String weixinId = request.getParameter("weixinId");
        if (oConvertUtils.isEmpty((Object)weixinId)) {
            map.put("success", "false");
            map.put("error", "\u5fae\u4fe1ID\u4e3a\u7a7a");
        } else {
            List ls = this.weixinAccountService.findByProperty(WeixinAccountEntity.class, "weixinOriginalAccountid", weixinId);
            if (ls != null && ls.size() > 0) {
                po = (WeixinAccountEntity)ls.get(0);
                map.put("success", "true");
                map.put("accountname", po.getAccountname());
                map.put("accounttoken", po.getAccounttoken());
                map.put("weixinOriginalAccountid", po.getWeixinOriginalAccountid());
                map.put("accountappid", po.getAccountappid());
                map.put("accountaccesstoken", po.getAccountaccesstoken());
            } else {
                map.put("success", "false");
                map.put("error", "\u5fae\u4fe1ID\u65e0\u6548");
            }
        }
        response.setContentType("application/json");
        response.setHeader("Cache-Control", "no-store");
        try {
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            PrintWriter pw = response.getWriter();
            pw.write(JSONObject.toJSONString(map));
            pw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(params={"getWeixinToken"})
    public void getWeixinToken(HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException {
        HashMap<String, String> map = new HashMap<String, String>();
        WeixinAccountEntity po = new WeixinAccountEntity();
        boolean isValidIp = this.systemService.validateLimitIp(request);
        if (!isValidIp) {
            map.put("success", "false");
            map.put("error", "\u8bbf\u95eeIP\u65e0\u6548");
        } else {
            String weixinId = request.getParameter("weixinId");
            if (oConvertUtils.isEmpty((Object)weixinId)) {
                map.put("success", "false");
                map.put("error", "\u5fae\u4fe1ID\u4e3a\u7a7a");
            } else {
                List ls = this.weixinAccountService.findByProperty(WeixinAccountEntity.class, "weixinOriginalAccountid", weixinId);
                if (ls != null && ls.size() > 0) {
                    po = (WeixinAccountEntity)ls.get(0);
                    WeixinAccountEntity jsapiticket_po = this.weixinAccountService.doGetJsapiticket(po);
                    Date jsapiticket_time = new Date(jsapiticket_po.getJsapitickettime().getTime());
                    Date toekntime = new Date(po.getAddtoekntime().getTime());
                    map.put("success", "true");
                    map.put("accountname", po.getAccountname());
                    map.put("jsapiticket", jsapiticket_po.getJsapiticket());
                    map.put("jsapitickettime", DateUtils.date2Str(jsapiticket_time, DateUtils.datetimeFormat));
                    map.put("accountaccesstoken", po.getAccountaccesstoken());
                    map.put("tokentime", DateUtils.date2Str(toekntime, DateUtils.datetimeFormat));
                } else {
                    map.put("success", "false");
                    map.put("error", "\u5fae\u4fe1ID\u65e0\u6548");
                }
            }
        }
        response.setContentType("application/json");
        response.setHeader("Cache-Control", "no-store");
        try {
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            PrintWriter pw = response.getWriter();
            pw.write(JSONObject.toJSONString(map));
            pw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(params={"getUserInfo"})
    public void getUserInfo(HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException {
        HashMap<String, String> map = new HashMap<String, String>();
        String openid = request.getParameter("openid");
        if (oConvertUtils.isEmpty((Object)openid)) {
            map.put("success", "false");
            map.put("error", "\u5fae\u4fe1openid\u4e3a\u7a7a");
        } else {
            List ls = this.weixinAccountService.findByProperty(GzUserInfoYw.class, "openid", openid);
            if (ls != null && ls.size() > 0) {
                GzUserInfoYw userInfo = (GzUserInfoYw)((Object)ls.get(0));
                map.put("success", "true");
                map.put("subscribe", userInfo.getSubscribe());
                map.put("openid", userInfo.getOpenid());
                map.put("nickname", userInfo.getNickname());
                map.put("sex", userInfo.getSex());
                map.put("city", userInfo.getCity());
                map.put("province", userInfo.getProvince());
                map.put("country", userInfo.getCountry());
                map.put("headimgurl", userInfo.getHeadimgurl());
                map.put("subscribe_time", userInfo.getSubscribe_time());
                map.put("bzname", userInfo.getBzname());
                WeixinVipMemberEntity memberEntity = (WeixinVipMemberEntity)this.systemService.findUniqueByProperty(WeixinVipMemberEntity.class, "openid", (Object)userInfo.getOpenid());
                if (memberEntity != null) {
                    map.put("phone", memberEntity.getMemberMobile());
                }
            } else {
                map.put("success", "false");
                map.put("error", "\u5fae\u4fe1openid\u65e0\u6548");
            }
        }
        response.setContentType("application/json");
        response.setHeader("Cache-Control", "no-store");
        try {
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            PrintWriter pw = response.getWriter();
            pw.write(JSONObject.toJSONString(map));
            pw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String url = "http://localhost/jeewx/openDataController.do?getUserInfo&openid=oO4u8jo9xf44Qnkc8KX9qa0ckyV4";
        String jsonObj = WeixinUtil.httpCommonRequest(url, "GET", "");
        System.out.println(jsonObj);
    }
}

