/*
 * Decompiled with CFR 0.152.
 */
package weixin.idea.oauth2.controller;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.util.StringUtil;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.ResourceUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import weixin.guanjia.account.entity.WeixinAccountEntity;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.core.wxRule.impl.RemoteWeixinMethod;
import weixin.guanjia.core.wxRule.pojo.oauth2.Oauth2CodePojo;
import weixin.idea.oauth2.pojo.SNSUserInfo;
import weixin.idea.oauth2.util.OAuth2Util;

@Controller
@RequestMapping(value={"/oauth2DemoController"})
public class Oauth2DemoController {
    @Autowired
    private WeixinAccountServiceI weixinAccountService;

    @RequestMapping(params={"oauth"})
    public String oauth(HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException {
        String code = request.getParameter("code");
        LogUtil.info((Object)("code\u7684\u503c=" + code));
        if (!"authdeny".equals(code)) {
            Oauth2CodePojo oauth2CodePojo = new Oauth2CodePojo("wx00737224cb9dbc7d", "b9479ebdb58d1c6b6efd4171ebe718b5", code);
            Map<String, Object> map = new RemoteWeixinMethod().getOauth2AccessToken(oauth2CodePojo);
            String openId = (String)map.get("openid");
            String accessToken = (String)map.get("access_token");
            SNSUserInfo snsUserInfo = OAuth2Util.getSNSUserInfo(accessToken, openId);
            request.setAttribute("snsUserInfo", (Object)snsUserInfo);
        }
        return "weixin/idea/oauth2/oauth2Demo";
    }

    @RequestMapping(params={"testSnsapiUserinfoDemo"})
    public String testSnsapiUserinfoDemo(HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException {
        String code = request.getParameter("code");
        String accountId = request.getParameter("accountId");
        String openId = ResourceUtil.getUserOpenId();
        if (StringUtil.isEmpty((String)openId)) {
            WeixinAccountEntity account = (WeixinAccountEntity)this.weixinAccountService.get(WeixinAccountEntity.class, (Serializable)((Object)accountId));
            LogUtil.info((Object)("code\u7684\u503c=" + code));
            if (StringUtil.isEmpty((String)code)) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("accountId", accountId);
                String tagetUrl = OAuth2Util.obtainTargetUrl(this.getClass(), "testSnsapiUserinfoDemo", params);
                LogUtil.info((Object)("targetURL\u7684\u503c=" + tagetUrl));
                String redirectURL = OAuth2Util.obtainWeixinOAuth2Url(tagetUrl, account.getAccountappid(), "snsapi_base");
                return "redirect:" + redirectURL;
            }
            if (!"authdeny".equals(code)) {
                Oauth2CodePojo oauth2CodePojo = new Oauth2CodePojo(account.getAccountappid(), account.getAccountappsecret(), code);
                Map<String, Object> map = new RemoteWeixinMethod().getOauth2AccessToken(oauth2CodePojo);
                openId = (String)map.get("openid");
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("accountId", accountId);
                String tagetUrl = OAuth2Util.obtainTargetUrl(this.getClass(), "testSnsapiUserinfoDemo", params);
                request.setAttribute("tagetUrl", (Object)tagetUrl);
                request.setAttribute("openId", (Object)openId);
            }
            request.getSession().setAttribute("USER_OPENID", (Object)openId);
        } else {
            LogUtil.info((Object)("session\u4e2d\u7684openId\u7684\u503c=" + openId));
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("accountId", accountId);
            String tagetUrl = OAuth2Util.obtainTargetUrl(this.getClass(), "testSnsapiUserinfoDemo", params);
            request.setAttribute("tagetUrl", (Object)tagetUrl);
            request.setAttribute("openId", (Object)openId);
        }
        return "weixin/idea/oauth2/testSnsapiUserinfoDemo";
    }

    @RequestMapping(params={"redirectOauthURL"})
    public String redirectOauthURL(HttpServletRequest request) {
        String urlStr = request.getParameter("urlStr");
        String openId = ResourceUtil.getUserOpenId();
        LogUtil.info((Object)("\u8df3\u8f6cURL=" + urlStr));
        LogUtil.info((Object)("openid=" + openId));
        return "redirect:" + urlStr;
    }

    @RequestMapping(params={"testSnsapiBaseDemo"})
    public String testSnsapiBaseDemo(HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException {
        String code = request.getParameter("code");
        String accountId = request.getParameter("accountId");
        String openId = ResourceUtil.getUserOpenId();
        if (StringUtil.isEmpty((String)openId)) {
            WeixinAccountEntity account = (WeixinAccountEntity)this.weixinAccountService.get(WeixinAccountEntity.class, (Serializable)((Object)accountId));
            LogUtil.info((Object)("code\u7684\u503c=" + code));
            if (StringUtil.isEmpty((String)code)) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("accountId", accountId);
                String tagetUrl = OAuth2Util.obtainTargetUrl(this.getClass(), "testSnsapiBaseDemo", params);
                LogUtil.info((Object)("targetURL\u7684\u503c=" + tagetUrl));
                String redirectURL = OAuth2Util.obtainWeixinOAuth2Url(tagetUrl, account.getAccountappid(), "snsapi_base");
                return "redirect:" + redirectURL;
            }
            if (!"authdeny".equals(code)) {
                Oauth2CodePojo oauth2CodePojo = new Oauth2CodePojo(account.getAccountappid(), account.getAccountappsecret(), code);
                Map<String, Object> map = new RemoteWeixinMethod().getOauth2AccessToken(oauth2CodePojo);
                openId = (String)map.get("openid");
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("accountId", accountId);
                String tagetUrl = OAuth2Util.obtainTargetUrl(this.getClass(), "testSnsapiBaseDemo", params);
                request.setAttribute("tagetUrl", (Object)tagetUrl);
                request.setAttribute("openId", (Object)openId);
            }
            request.getSession().setAttribute("USER_OPENID", (Object)openId);
        } else {
            LogUtil.info((Object)("session\u4e2d\u7684openId\u7684\u503c=" + openId));
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("accountId", accountId);
            String tagetUrl = OAuth2Util.obtainTargetUrl(this.getClass(), "testSnsapiBaseDemo", params);
            request.setAttribute("tagetUrl", (Object)tagetUrl);
            request.setAttribute("openId", (Object)openId);
        }
        return "weixin/idea/oauth2/testSnsapiBaseDemo";
    }
}

