/*
 * Decompiled with CFR 0.152.
 */
package weixin.idea.huodong.service.impl;

import java.util.ArrayList;
import java.util.List;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.jeecgframework.core.util.oConvertUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import weixin.idea.huodong.entity.HuodongEntity;
import weixin.idea.huodong.entity.WeixinAwardsAwardEntity;
import weixin.idea.huodong.service.WeixinAwardsAwardServiceI;

@Service(value="weixinAwardsAwardService")
@Transactional
public class WeixinAwardsAwardServiceImpl
extends CommonServiceImpl
implements WeixinAwardsAwardServiceI {
    @Override
    public String getPrize(String awardsLevelId, String hdid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinAwardsAwardEntity.class);
        try {
            cq.eq("awardslevle.id", (Object)awardsLevelId);
            cq.eq("huodongmodel.id", (Object)hdid);
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        cq.add();
        List awardlist = this.getListByCriteriaQuery(cq, false);
        if (awardlist.size() != 0) {
            return ((WeixinAwardsAwardEntity)awardlist.get(0)).getAwardmodel().getName();
        }
        return null;
    }

    @Override
    public WeixinAwardsAwardEntity getAwards(String awardsLevelId, String hdid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinAwardsAwardEntity.class);
        try {
            cq.eq("awardslevle.id", (Object)awardsLevelId);
            cq.eq("huodongmodel.id", (Object)hdid);
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        cq.add();
        List awardlist = this.getListByCriteriaQuery(cq, false);
        if (awardlist.size() != 0) {
            return (WeixinAwardsAwardEntity)awardlist.get(0);
        }
        return null;
    }

    @Override
    public List<WeixinAwardsAwardEntity> getAwardsList(String awardsLevelId, String hdid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinAwardsAwardEntity.class);
        try {
            cq.eq("awardslevle.id", (Object)awardsLevelId);
            cq.eq("huodongmodel.id", (Object)hdid);
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        cq.add();
        List awardlist = this.getListByCriteriaQuery(cq, false);
        return awardlist;
    }

    @Override
    public List<HuodongEntity> getHuodongs(String awardId) {
        ArrayList<HuodongEntity> houdongs = new ArrayList<HuodongEntity>();
        CriteriaQuery cq = new CriteriaQuery(WeixinAwardsAwardEntity.class);
        try {
            cq.eq("awardmodel.id", (Object)awardId);
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        cq.add();
        List awardlist = this.getListByCriteriaQuery(cq, false);
        if (oConvertUtils.isNotEmpty((Object)awardlist) && awardlist.size() > 0) {
            HuodongEntity hd = null;
            for (WeixinAwardsAwardEntity wardAware : awardlist) {
                hd = wardAware.getHuodongmodel();
                if (!oConvertUtils.isNotEmpty((Object)hd)) continue;
                houdongs.add(hd);
            }
        }
        return houdongs;
    }
}

