/*
 * Decompiled with CFR 0.152.
 */
package weixin.idea.huodong.service.impl;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.jeecgframework.core.constant.WeiXinConstant;
import org.jeecgframework.core.util.StringUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import weixin.idea.huodong.entity.HdRecordEntity;
import weixin.idea.huodong.entity.HuodongEntity;
import weixin.idea.huodong.entity.ValidateResult;
import weixin.idea.huodong.service.HuodongServiceI;
import weixin.util.DateUtils;
import weixin.vip.entity.WeixinVipMemberEntity;

@Service(value="huodongService")
@Transactional
public class HuodongServiceImpl
extends CommonServiceImpl
implements HuodongServiceI {
    @Override
    public ValidateResult validateCanJoin(HuodongEntity hdEntity, String openId) {
        if (hdEntity == null) {
            return new ValidateResult(false, "\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("from WeixinVipMemberEntity where 1=1 ");
        sb.append(" and accountid=?");
        sb.append(" and openid=?");
        List list = this.findHql(sb.toString(), new Object[]{hdEntity.getAccountid(), openId});
        if (list != null && list.size() > 0) {
            WeixinVipMemberEntity memberEntity = (WeixinVipMemberEntity)list.get(0);
            if (WeiXinConstant.HUODONG_LIMIT_FLAG.equals(hdEntity.getBindingMobileCanJoin()) && !"Y".equals(memberEntity.getBindingMemberPhoneStatus())) {
                return new ValidateResult(false, "\u975e\u624b\u673a\u7ed1\u5b9a\u7528\u6237\u4e0d\u80fd\u53c2\u4e0e\u6d3b\u52a8");
            }
        } else {
            if (WeiXinConstant.HUODONG_LIMIT_FLAG.equals(hdEntity.getFoucsUserCanJoin())) {
                return new ValidateResult(false, "\u975e\u516c\u4f17\u53f7\u5173\u6ce8\u7c89\u4e1d\u4e0d\u80fd\u53c2\u4e0e\u6d3b\u52a8");
            }
            if (WeiXinConstant.HUODONG_LIMIT_FLAG.equals(hdEntity.getBindingMobileCanJoin())) {
                return new ValidateResult(false, "\u975e\u624b\u673a\u7ed1\u5b9a\u7528\u6237\u4e0d\u80fd\u53c2\u4e0e\u6d3b\u52a8");
            }
        }
        return new ValidateResult(true, null);
    }

    @Override
    public ValidateResult validateCanLottery(HuodongEntity hdEntity, String openId) {
        if (hdEntity == null) {
            return new ValidateResult(false, "\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("from HdRecordEntity where hdid=? ");
        sb.append(" and opendid=?");
        sb.append(" and accountid=?");
        List hdRecrdList = this.findHql(sb.toString(), new Object[]{hdEntity.getId(), openId, hdEntity.getAccountid()});
        if (hdRecrdList.size() > 0) {
            int currDayCount;
            HdRecordEntity hdRecord = (HdRecordEntity)hdRecrdList.get(0);
            int total = hdRecord.getTotal();
            if (total >= Integer.parseInt(hdEntity.getCount())) {
                return new ValidateResult(false, "\u4eb2\uff0c\u60a8\u7684\u62bd\u5956\u6b21\u6570\u5df2\u7ecf\u7528\u5b8c\u3002");
            }
            int lastdayTotal = hdRecord.getLastdayTotal() == null ? 0 : hdRecord.getLastdayTotal();
            int currDaylimitCount = hdEntity.getNumPerDay() == null ? 0 : hdEntity.getNumPerDay();
            int n = currDayCount = hdRecord.getUpdateDate() == null ? 0 : total - lastdayTotal;
            if (hdRecord.getUpdateDate() != null) {
                Calendar updateDate = Calendar.getInstance();
                updateDate.setTime(hdRecord.getUpdateDate());
                int day = DateUtils.dateDiff('d', Calendar.getInstance(), updateDate);
                if (day != 0) {
                    currDayCount = 0;
                }
            }
            if (currDaylimitCount > 0 && currDayCount >= currDaylimitCount) {
                return new ValidateResult(false, "\u4eb2\uff0c\u60a8\u4eca\u65e5\u7684\u62bd\u5956\u6b21\u6570\u5df2\u7ecf\u7528\u5b8c\u3002");
            }
        }
        return new ValidateResult(true, null);
    }

    @Override
    public void hdRecordCount(HuodongEntity hdEntity, String openId) {
        String hql = "from HdRecordEntity where hdid=? and opendid=?";
        List hdRecrdList = this.findHql(hql, new Object[]{hdEntity.getId(), openId});
        HdRecordEntity hdRecord = null;
        if (hdRecrdList != null && hdRecrdList.size() > 0) {
            hdRecord = (HdRecordEntity)hdRecrdList.get(0);
        }
        if (hdRecord != null) {
            int total = hdRecord.getTotal();
            if (hdRecord.getUpdateDate() != null) {
                Calendar updateDate = Calendar.getInstance();
                updateDate.setTime(hdRecord.getUpdateDate());
                int day = DateUtils.dateDiff('d', Calendar.getInstance(), updateDate);
                if (day > 0) {
                    hdRecord.setLastdayTotal(total);
                }
            } else {
                hdRecord.setLastdayTotal(total);
            }
            hdRecord.setTotal(total + 1);
            hdRecord.setUpdateDate(new Date());
            this.updateEntitie(hdRecord);
        } else {
            Date now = new Date();
            hdRecord = new HdRecordEntity();
            hdRecord.setAddtime(now);
            hdRecord.setHdid(hdEntity.getId());
            hdRecord.setOpendid(openId);
            hdRecord.setTotal(1);
            hdRecord.setLastdayTotal(0);
            hdRecord.setNickname("");
            hdRecord.setAccountid(hdEntity.getAccountid());
            hdRecord.setUpdateDate(now);
            this.save(hdRecord);
        }
    }

    @Override
    public void hdRecordCount(HuodongEntity hdEntity, String openId, String accountid) {
        String hql = "from HdRecordEntity where hdid=? and opendid=?";
        hql = StringUtil.isNotEmpty((Object)accountid) ? String.valueOf(hql) + " and accountid='" + accountid + "'" : String.valueOf(hql) + " and accountid='-'";
        List hdRecrdList = this.findHql(hql, new Object[]{hdEntity.getId(), openId});
        HdRecordEntity hdRecord = null;
        if (hdRecrdList != null && hdRecrdList.size() > 0) {
            hdRecord = (HdRecordEntity)hdRecrdList.get(0);
        }
        if (hdRecord != null) {
            int total = hdRecord.getTotal();
            if (hdRecord.getUpdateDate() != null) {
                Calendar updateDate = Calendar.getInstance();
                updateDate.setTime(hdRecord.getUpdateDate());
                int day = DateUtils.dateDiff('d', Calendar.getInstance(), updateDate);
                if (day > 0) {
                    hdRecord.setLastdayTotal(total);
                }
            } else {
                hdRecord.setLastdayTotal(total);
            }
            hdRecord.setTotal(total + 1);
            hdRecord.setUpdateDate(new Date());
            this.updateEntitie(hdRecord);
        } else {
            Date now = new Date();
            hdRecord = new HdRecordEntity();
            hdRecord.setAddtime(now);
            hdRecord.setHdid(hdEntity.getId());
            hdRecord.setOpendid(openId);
            hdRecord.setTotal(1);
            hdRecord.setLastdayTotal(0);
            hdRecord.setNickname("");
            hdRecord.setAccountid(hdEntity.getAccountid());
            hdRecord.setUpdateDate(now);
            this.save(hdRecord);
        }
    }
}

