/*
 * Decompiled with CFR 0.152.
 */
package weixin.idea.huodong.controller;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.constant.WeiXinConstant;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.core.util.WeixinUtil;
import weixin.guanjia.core.wxRule.impl.RemoteWeixinMethod;
import weixin.guanjia.gzuserinfo.entity.GzUserInfoYw;
import weixin.guanjia.gzuserinfo.service.GzUserInfoService;
import weixin.idea.huodong.entity.AwardsLevelEntity;
import weixin.idea.huodong.entity.HdRecordEntity;
import weixin.idea.huodong.entity.HuoDongAwardEntity;
import weixin.idea.huodong.entity.HuodongEntity;
import weixin.idea.huodong.entity.PrizeRecordEntity;
import weixin.idea.huodong.entity.ValidateResult;
import weixin.idea.huodong.entity.WeixinAwardsAwardEntity;
import weixin.idea.huodong.service.AwardsLevelServiceI;
import weixin.idea.huodong.service.HdRecordServiceI;
import weixin.idea.huodong.service.HuoDongAwardServiceI;
import weixin.idea.huodong.service.HuodongServiceI;
import weixin.idea.huodong.service.PrizeRecordServiceI;
import weixin.idea.huodong.service.WeixinAwardsAwardServiceI;
import weixin.idea.huodong.utils.AwardGraphics;
import weixin.idea.huodong.utils.HdUtils;
import weixin.idea.oauth2.util.OAuth2Util;

@Controller
@RequestMapping(value={"/zpController2"})
public class ZpController2 {
    private static final Logger logger = Logger.getLogger(ZpController2.class);
    @Autowired
    private GzUserInfoService gzUserInfoService;
    @Autowired
    private RemoteWeixinMethod remoteWeixinMethod;
    @Autowired
    private WeixinAccountServiceI weixinAccountService;
    private SystemService systemService;
    private String message;
    @Autowired
    private PrizeRecordServiceI prizeRecordService;
    @Autowired
    private AwardsLevelServiceI awardsLevelService;
    @Autowired
    WeixinAwardsAwardServiceI weixinAwardsAwardService;
    @Autowired
    private HuoDongAwardServiceI huoDongAwardService;
    @Autowired
    private HdRecordServiceI hdRecordService;
    @Autowired
    private HuodongServiceI huodongService;

    @Resource(name="systemService")
    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    @RequestMapping(params={"goLuckyFruit"})
    public ModelAndView goLuckyFruit(HttpServletRequest request) {
        String hdid = request.getParameter("hdid");
        if (StringUtil.isEmpty((String)hdid)) {
            request.setAttribute("msg", (Object)"\u4eb2\uff0c\u60a8\u63d0\u4ea4\u7684\u6d3b\u52a8\u4e0d\u5b58\u5728");
            return new ModelAndView("weixin/idea/huodong2/luckyFruit/luckyFruitover");
        }
        List hdlst = this.systemService.findByQueryString(" FROM HuodongEntity h WHERE h.id='" + hdid + "' AND type=4");
        if (hdlst == null || hdlst.size() == 0) {
            request.setAttribute("huodongstatus", (Object)WeiXinConstant.HUODONG_HDCODE_NO_START);
            request.setAttribute("msg", (Object)"\u5546\u5bb6\u672a\u542f\u52a8\u6c34\u679c\u673a\u6d3b\u52a8\u3002");
            return new ModelAndView("weixin/idea/huodong2/luckyFruit/luckyFruitover");
        }
        String targetUrlMethod = "goLuckyFruit";
        HuodongEntity hdEntity = (HuodongEntity)hdlst.get(0);
        String accountId = hdEntity.getAccountid();
        String weixin_author2_url = this.myHuoDongCallWeixinAuthor2(request, accountId, hdid, targetUrlMethod);
        if (oConvertUtils.isNotEmpty((Object)weixin_author2_url)) {
            return new ModelAndView(weixin_author2_url);
        }
        String openId = this.getOpenId(request);
        if (StringUtils.isEmpty((CharSequence)openId) || StringUtils.isEmpty((CharSequence)hdEntity.getAccountid())) {
            throw new BusinessException("openid or accountid can not be null");
        }
        ValidateResult result = this.huodongService.validateCanJoin(hdEntity, openId);
        if (!result.isSucc()) {
            request.setAttribute("msg", (Object)result.getMessage());
            return new ModelAndView("weixin/idea/huodong2/luckyFruit/luckyFruitover");
        }
        request.setAttribute("accountid", (Object)hdEntity.getAccountid());
        request.setAttribute("openid", (Object)openId);
        int shakeTimeCount = this.getCount(hdEntity, openId);
        String hdcountStr = "\u60a8\u6709 " + Integer.parseInt(hdEntity.getCount()) + " \u6b21\u673a\u4f1a\u6447\u5956\uff0c\u5df2\u7ecf\u6447\u4e86 " + shakeTimeCount + " \u6b21";
        request.setAttribute("hdcountStr", (Object)hdcountStr);
        ValidateResult countResult = this.huodongService.validateCanLottery(hdEntity, openId);
        if (!countResult.isSucc()) {
            request.setAttribute("msg", (Object)countResult.getMessage());
            return new ModelAndView("weixin/idea/huodong2/luckyFruit/luckyFruitover");
        }
        List<HuoDongAwardEntity> awardslist = hdEntity.getAwardslist();
        request.setAttribute("huodongEntity", (Object)hdEntity);
        request.setAttribute("hdId", (Object)hdEntity.getId());
        HashMap<String, List> awardmap = new HashMap<String, List>();
        for (HuoDongAwardEntity awards : awardslist) {
            List awardlist = this.systemService.findByQueryString("from WeixinAwardsAwardEntity w where w.huodongmodel='" + hdEntity.getId() + "' and " + " w.awardslevle='" + awards.getAwardslevle().getId() + "'");
            awardmap.put(awards.getId(), awardlist);
        }
        request.setAttribute("awardmap", awardmap);
        request.setAttribute("awardslist", awardslist);
        request.setAttribute("awardscount", (Object)hdEntity.getAwardslist().size());
        return new ModelAndView("weixin/idea/huodong2/luckyFruit/luckyFruit");
    }

    @RequestMapping(params={"goGglNew"})
    public ModelAndView goGglNew(HttpServletRequest request) {
        String hdid = request.getParameter("hdid");
        LogUtil.info((Object)("....hdId..." + hdid));
        List hdlst = this.systemService.findByQueryString(" FROM HuodongEntity h WHERE h.id='" + hdid + "' AND type=1");
        if (hdlst == null || hdlst.size() == 0) {
            request.setAttribute("msg", (Object)"\u5546\u5bb6\u672a\u542f\u52a8\u522e\u522e\u4e50\u6d3b\u52a8\u3002");
            return new ModelAndView("weixin/idea/huodong2/ggl/gglover");
        }
        String targetUrlMethod = "goGglNew";
        HuodongEntity huodongEntity = (HuodongEntity)hdlst.get(0);
        String accountId = huodongEntity.getAccountid();
        String weixin_author2_url = this.myHuoDongCallWeixinAuthor2(request, accountId, hdid, targetUrlMethod);
        if (oConvertUtils.isNotEmpty((Object)weixin_author2_url)) {
            return new ModelAndView(weixin_author2_url);
        }
        String openId = this.getOpenId(request);
        if (StringUtils.isEmpty((CharSequence)openId) || StringUtils.isEmpty((CharSequence)huodongEntity.getAccountid())) {
            throw new BusinessException("openid or accountid can not be null");
        }
        ValidateResult result = this.huodongService.validateCanJoin(huodongEntity, openId);
        if (!result.isSucc()) {
            request.setAttribute("msg", (Object)result.getMessage());
            return new ModelAndView("weixin/idea/huodong2/ggl/gglover");
        }
        ValidateResult countResult = this.huodongService.validateCanLottery(huodongEntity, openId);
        if (!countResult.isSucc()) {
            PrizeRecordEntity record = this.prizeRecordService.getRecordByOpenid(huodongEntity.getId(), openId);
            if (record != null) {
                if (!StringUtil.isEmpty((String)record.getMobile()) && !StringUtil.isEmpty((String)record.getUsername())) {
                    request.setAttribute("updateinfo", (Object)0);
                    request.setAttribute("msg", (Object)("\u4eb2\uff0c\u60a8\u5df2\u7ecf\u522e\u51fa" + record.getPrizetype() + " \u5956\u54c1\u4e3a\uff1a" + record.getPrize() + " \u8bf7\u901f\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\u53d6\u5f97\u793c\u54c1\u3002"));
                    return new ModelAndView("weixin/idea/huodong2/ggl/gglover");
                }
                if (StringUtil.isEmpty((String)record.getMobile()) || StringUtil.isEmpty((String)record.getUsername())) {
                    request.setAttribute("record", (Object)record);
                    this.loadAwardslist(huodongEntity, request);
                    return new ModelAndView("weixin/idea/huodong2/ggl/gglupdate");
                }
            }
            request.setAttribute("msg", (Object)countResult.getMessage());
            return new ModelAndView("weixin/idea/huodong2/ggl/gglover");
        }
        if (WeiXinConstant.HUODONG_HDCODE_START.equals(huodongEntity.getHdCode())) {
            String gl = huodongEntity.getGl();
            String[] glArr = gl.split("/");
            int randomNum = HdUtils.createPrice(Integer.parseInt(glArr[0]), Integer.parseInt(glArr[1]), huodongEntity.getAwardslist().size());
            List<HuoDongAwardEntity> awardslist = huodongEntity.getAwardslist();
            boolean zhongjiang = false;
            for (HuoDongAwardEntity aw : awardslist) {
                if (aw.getAwardslevle().getAwardsValue() != randomNum) continue;
                int count = this.huoDongAwardService.getAwardsAmount(aw.getAwardslevle().getId(), huodongEntity.getId());
                List<PrizeRecordEntity> recordlist = this.prizeRecordService.listRecord(huodongEntity.getId(), aw.getAwardslevle().getAwardsName());
                if (recordlist.size() >= count) {
                    randomNum = 0;
                    zhongjiang = false;
                    break;
                }
                zhongjiang = true;
                break;
            }
            if (zhongjiang) {
                logger.info((Object)("\u4e2d\u5956\u4fe1\u606f\uff1a\u5956\u9879\uff1a" + randomNum));
                AwardsLevelEntity level = this.awardsLevelService.getAwardsLevelByValue(randomNum, huodongEntity.getAccountid());
                request.setAttribute("prizetype", (Object)level.getAwardsName());
                request.setAttribute("level", (Object)level);
                request.setAttribute("prize", (Object)randomNum);
                AwardGraphics cg = new AwardGraphics();
                String path = String.valueOf(request.getSession().getServletContext().getRealPath("plug-in/weixin/images/ggl")) + "/" + openId + "prize.jpg";
                try {
                    cg.graphicsGeneration(path, level.getAwardsName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                request.setAttribute("prize", (Object)0);
            }
            HttpSession session = request.getSession();
            session.setAttribute("hdId", (Object)huodongEntity.getId());
            session.setAttribute("accountid", (Object)huodongEntity.getAccountid());
            session.setAttribute("openid", (Object)openId);
            request.setAttribute("huodongEntity", (Object)huodongEntity);
            request.setAttribute("hdId", (Object)huodongEntity.getId());
            request.setAttribute("accountid", (Object)huodongEntity.getAccountid());
            request.setAttribute("openid", (Object)openId);
            HashMap<String, List> awardmap = new HashMap<String, List>();
            for (HuoDongAwardEntity awards : awardslist) {
                List awardlist = this.systemService.findByQueryString("from WeixinAwardsAwardEntity w where w.huodongmodel='" + huodongEntity.getId() + "' and " + " w.awardslevle='" + awards.getAwardslevle().getId() + "'");
                awardmap.put(awards.getId(), awardlist);
            }
            request.setAttribute("awardmap", awardmap);
            request.setAttribute("awardslist", awardslist);
            request.setAttribute("awardscount", (Object)huodongEntity.getAwardslist().size());
            request.setAttribute("huodongstatus", (Object)WeiXinConstant.HUODONG_HDCODE_START);
        } else if (WeiXinConstant.HUODONG_HDCODE_NO_START.equals(huodongEntity.getHdCode())) {
            request.setAttribute("huodongstatus", (Object)WeiXinConstant.HUODONG_HDCODE_NO_START);
        } else if (WeiXinConstant.HUODONG_HDCODE_STOP.equals(huodongEntity.getHdCode())) {
            request.setAttribute("huodongstatus", (Object)WeiXinConstant.HUODONG_HDCODE_STOP);
        }
        return new ModelAndView("weixin/idea/huodong2/ggl/ggl");
    }

    @RequestMapping(params={"goShakeNew"})
    public ModelAndView goShakeNew(HttpServletRequest request) {
        String hdid = request.getParameter("hdid");
        List hdlst = this.systemService.findByQueryString(" FROM HuodongEntity h WHERE h.id='" + hdid + "' AND type=5");
        if (hdlst == null || hdlst.size() == 0) {
            request.setAttribute("msg", (Object)"\u5546\u5bb6\u672a\u542f\u52a8\u6447\u4e00\u6447\u6d3b\u52a8\u3002");
            return new ModelAndView("weixin/idea/huodong2/shake/shakePrizeover");
        }
        String targetUrlMethod = "goShakeNew";
        HuodongEntity hdEntity = (HuodongEntity)hdlst.get(0);
        String accountId = hdEntity.getAccountid();
        String weixin_author2_url = this.myHuoDongCallWeixinAuthor2(request, accountId, hdid, targetUrlMethod);
        if (oConvertUtils.isNotEmpty((Object)weixin_author2_url)) {
            return new ModelAndView(weixin_author2_url);
        }
        String openId = this.getOpenId(request);
        if (StringUtils.isEmpty((CharSequence)openId) || StringUtils.isEmpty((CharSequence)hdEntity.getAccountid())) {
            throw new BusinessException("openid or accountid can not be null");
        }
        ValidateResult result = this.huodongService.validateCanJoin(hdEntity, openId);
        if (!result.isSucc()) {
            request.setAttribute("msg", (Object)result.getMessage());
            return new ModelAndView("weixin/idea/huodong2/shake/shakePrizeover");
        }
        int shakeTimeCount = this.getCount(hdEntity, openId);
        String hdcountStr = "\u60a8\u6709 " + Integer.parseInt(hdEntity.getCount()) + " \u6b21\u673a\u4f1a\u6447\u5956\uff0c\u5df2\u7ecf\u6447\u4e86 " + shakeTimeCount + " \u6b21";
        request.setAttribute("hdcountStr", (Object)hdcountStr);
        ValidateResult countResult = this.huodongService.validateCanLottery(hdEntity, openId);
        if (!countResult.isSucc()) {
            PrizeRecordEntity record = this.prizeRecordService.getRecordByOpenid(hdEntity.getId(), openId, accountId);
            if (record != null) {
                if (!StringUtil.isEmpty((String)record.getMobile()) && !StringUtil.isEmpty((String)record.getUsername())) {
                    request.setAttribute("updateinfo", (Object)0);
                    request.setAttribute("msg", (Object)("\u4eb2\uff0c\u60a8\u5df2\u7ecf\u6447\u51fa" + record.getPrizetype() + " \u5956\u54c1\u4e3a\uff1a" + record.getPrize() + " \u8bf7\u901f\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\u53d6\u5f97\u793c\u54c1\u3002"));
                    return new ModelAndView("weixin/idea/huodong2/shake/shakePrizeover");
                }
                if (StringUtil.isEmpty((String)record.getMobile()) || StringUtil.isEmpty((String)record.getUsername())) {
                    request.setAttribute("record", (Object)record);
                    this.loadAwardslist(hdEntity, request);
                    return new ModelAndView("weixin/idea/huodong2/shake/shakePrizeupdate");
                }
            }
            request.setAttribute("msg", (Object)countResult.getMessage());
            return new ModelAndView("weixin/idea/huodong2/shake/shakePrizeover");
        }
        if (WeiXinConstant.HUODONG_HDCODE_START.equals(hdEntity.getHdCode())) {
            String gl = hdEntity.getGl();
            String[] glArr = gl.split("/");
            int randomNum = HdUtils.createPrice(Integer.parseInt(glArr[0]), Integer.parseInt(glArr[1]), hdEntity.getAwardslist().size());
            List<HuoDongAwardEntity> awardslist = hdEntity.getAwardslist();
            boolean zhongjiang = false;
            for (HuoDongAwardEntity aw : awardslist) {
                if (aw.getAwardslevle().getAwardsValue() != randomNum) continue;
                int count = this.huoDongAwardService.getAwardsAmount(aw.getAwardslevle().getId(), hdEntity.getId());
                List<PrizeRecordEntity> recordlist = this.prizeRecordService.listRecord(hdEntity.getId(), aw.getAwardslevle().getAwardsName(), hdEntity.getAccountid());
                if (recordlist.size() >= count) {
                    randomNum = 0;
                    zhongjiang = false;
                    break;
                }
                zhongjiang = true;
                break;
            }
            if (zhongjiang) {
                logger.info((Object)("\u4e2d\u5956\u4fe1\u606f\uff1a\u5956\u9879\uff1a" + randomNum));
                AwardsLevelEntity level = this.awardsLevelService.getAwardsLevelByValue(randomNum, hdEntity.getAccountid());
                request.setAttribute("prizetype", (Object)level.getAwardsName());
                request.setAttribute("level", (Object)level);
                request.setAttribute("prize", (Object)randomNum);
                AwardGraphics cg = new AwardGraphics();
                String path = String.valueOf(request.getSession().getServletContext().getRealPath("plug-in/weixin/shakePrize/images")) + "/" + openId + "prize.jpg";
                try {
                    cg.graphicsGeneration(path, level.getAwardsName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                request.setAttribute("prize", (Object)0);
            }
            request.setAttribute("huodongEntity", (Object)hdEntity);
            request.setAttribute("hdId", (Object)hdEntity.getId());
            request.setAttribute("accountid", (Object)hdEntity.getAccountid());
            request.setAttribute("openid", (Object)openId);
            HashMap<String, List> awardmap = new HashMap<String, List>();
            for (HuoDongAwardEntity awards : awardslist) {
                List awardlist = this.systemService.findByQueryString("from WeixinAwardsAwardEntity w where w.huodongmodel='" + hdEntity.getId() + "' and " + " w.awardslevle='" + awards.getAwardslevle().getId() + "'");
                awardmap.put(awards.getId(), awardlist);
            }
            request.setAttribute("awardmap", awardmap);
            request.setAttribute("awardslist", awardslist);
            request.setAttribute("awardscount", (Object)hdEntity.getAwardslist().size());
            request.setAttribute("huodongstatus", (Object)WeiXinConstant.HUODONG_HDCODE_START);
        } else if (WeiXinConstant.HUODONG_HDCODE_NO_START.equals(hdEntity.getHdCode())) {
            request.setAttribute("huodongstatus", (Object)WeiXinConstant.HUODONG_HDCODE_NO_START);
        } else if (WeiXinConstant.HUODONG_HDCODE_STOP.equals(hdEntity.getHdCode())) {
            request.setAttribute("huodongstatus", (Object)WeiXinConstant.HUODONG_HDCODE_STOP);
        }
        return new ModelAndView("weixin/idea/huodong2/shake/shakePrize");
    }

    @RequestMapping(params={"doShake"})
    @ResponseBody
    public AjaxJson doShake(HttpServletRequest request) {
        String prizetype = request.getParameter("prizetype");
        String openid = request.getParameter("openid");
        String hdid = request.getParameter("hdid");
        AjaxJson j = new AjaxJson();
        HuodongEntity hdEntity = (HuodongEntity)this.systemService.get(HuodongEntity.class, (Serializable)((Object)hdid));
        ValidateResult result = this.huodongService.validateCanJoin(hdEntity, openid);
        if (!result.isSucc()) {
            j.setSuccess(false);
            j.setMsg(result.getMessage());
            return j;
        }
        ValidateResult countResult = this.huodongService.validateCanLottery(hdEntity, openid);
        if (!countResult.isSucc()) {
            j.setSuccess(false);
            j.setMsg(countResult.getMessage());
            return j;
        }
        this.huodongService.hdRecordCount(hdEntity, openid);
        int shakeTimeCount = this.getCount(hdEntity, openid);
        String hdcountStr = "\u60a8\u6709 " + Integer.parseInt(hdEntity.getCount()) + " \u6b21\u673a\u4f1a\u6447\u5956\uff0c\u5df2\u7ecf\u6447\u4e86 " + (shakeTimeCount + 1) + " \u6b21";
        j.setObj((Object)hdcountStr);
        if (!prizetype.equals("0")) {
            PrizeRecordEntity record = new PrizeRecordEntity();
            record.setAccountid(hdEntity.getAccountid());
            record.setAddtime(new Date());
            record.setAwardsCode(UUID.randomUUID().toString());
            record.setHdid(hdid);
            record.setOpenId(openid);
            record.setSendstatus("0");
            AwardsLevelEntity level = this.awardsLevelService.getAwardsLevelByValue(Integer.valueOf(prizetype), hdEntity.getAccountid());
            record.setPrizetype(level.getAwardsName());
            WeixinAwardsAwardEntity awards = this.weixinAwardsAwardService.getAwards(level.getId(), hdid);
            record.setPrize(awards.getAwardmodel().getName());
            this.systemService.save((Object)record);
        }
        return j;
    }

    @RequestMapping(params={"goShakeComplete"})
    public ModelAndView goShakeComplete(HttpServletRequest request, PrizeRecordEntity record) {
        if ((record = !StringUtil.isEmpty((String)record.getId()) ? (PrizeRecordEntity)this.prizeRecordService.get(PrizeRecordEntity.class, (Serializable)((Object)record.getId())) : this.prizeRecordService.getRecordByOpenid(record.getHdid(), record.getOpenId(), record.getAccountid())) != null && !StringUtil.isEmpty((String)record.getMobile()) && !StringUtil.isEmpty((String)record.getUsername())) {
            request.setAttribute("msg", (Object)("\u4eb2\uff0c\u60a8\u5df2\u7ecf\u522e\u51fa" + record.getPrizetype() + " \u5956\u54c1\u4e3a\uff1a" + record.getPrize() + " \u8bf7\u901f\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\u53d6\u5f97\u793c\u54c1\u3002"));
            return new ModelAndView("weixin/idea/huodong2/shake/shakePrizeover");
        }
        return new ModelAndView("weixin/idea/huodong2/shake/shakePrizeover");
    }

    @RequestMapping(params={"doGgl"})
    @ResponseBody
    public AjaxJson doGgl(HttpServletRequest request) {
        String prizetype = request.getParameter("prizetype");
        String openId = request.getParameter("openid");
        String hdId = request.getParameter("hdid");
        String accountid = this.findAccountId(request);
        AjaxJson j = new AjaxJson();
        HuodongEntity hdEntity = (HuodongEntity)this.systemService.get(HuodongEntity.class, (Serializable)((Object)hdId));
        ValidateResult result = this.huodongService.validateCanJoin(hdEntity, openId);
        if (!result.isSucc()) {
            j.setSuccess(false);
            j.setMsg(result.getMessage());
            return j;
        }
        ValidateResult countResult = this.huodongService.validateCanLottery(hdEntity, openId);
        if (!countResult.isSucc()) {
            j.setSuccess(false);
            j.setMsg(countResult.getMessage());
            return j;
        }
        String hql1 = "from PrizeRecordEntity where hdid='" + hdId + "' and openId='" + openId + "'";
        hql1 = StringUtil.isNotEmpty((Object)accountid) ? String.valueOf(hql1) + " and accountid='" + accountid + "'" : String.valueOf(hql1) + " and accountid='-'";
        List prizeList = this.systemService.findByQueryString(hql1);
        if (prizeList.size() > 0) {
            j.setSuccess(false);
            this.message = "\u5bf9\u4e0d\u8d77\u672c\u6b21\u6d3b\u52a8\u4f60\u5df2\u7ecf\u4e2d\u5956\uff0c\u4e0d\u80fd\u518d\u62bd\u5956\uff01";
            j.setMsg(this.message);
            return j;
        }
        this.huodongService.hdRecordCount(hdEntity, openId);
        if (!prizetype.equals("0")) {
            PrizeRecordEntity record = new PrizeRecordEntity();
            record.setAccountid(accountid);
            record.setAddtime(new Date());
            record.setAwardsCode(UUID.randomUUID().toString());
            record.setHdid(hdId);
            record.setOpenId(openId);
            record.setSendstatus("0");
            AwardsLevelEntity level = this.awardsLevelService.getAwardsLevelByValue(Integer.valueOf(prizetype), accountid);
            record.setPrizetype(level.getAwardsName());
            WeixinAwardsAwardEntity awards = this.weixinAwardsAwardService.getAwards(level.getId(), hdId);
            record.setPrize(awards.getAwardmodel().getName());
            this.systemService.save((Object)record);
        }
        return j;
    }

    @RequestMapping(params={"goGglComplete"})
    public ModelAndView goGglComplete(HttpServletRequest request, PrizeRecordEntity record) {
        if ((record = !StringUtil.isEmpty((String)record.getId()) ? (PrizeRecordEntity)this.prizeRecordService.get(PrizeRecordEntity.class, (Serializable)((Object)record.getId())) : this.prizeRecordService.getRecordByOpenid(record.getHdid(), record.getOpenId(), record.getAccountid())) != null && !StringUtil.isEmpty((String)record.getMobile()) && !StringUtil.isEmpty((String)record.getUsername())) {
            request.setAttribute("msg", (Object)("\u4eb2\uff0c\u60a8\u5df2\u7ecf\u522e\u51fa" + record.getPrizetype() + " \u5956\u54c1\u4e3a\uff1a" + record.getPrize() + " \u8bf7\u901f\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\u53d6\u5f97\u793c\u54c1\u3002"));
            return new ModelAndView("weixin/idea/huodong2/ggl/gglover");
        }
        return new ModelAndView("weixin/idea/huodong2/ggl/gglover");
    }

    @RequestMapping(params={"saveGglPrize"})
    @ResponseBody
    public AjaxJson saveGglPrize(HttpServletRequest request, PrizeRecordEntity record) {
        AjaxJson j = new AjaxJson();
        PrizeRecordEntity recordnew = new PrizeRecordEntity();
        recordnew = !StringUtil.isEmpty((String)record.getId()) ? (PrizeRecordEntity)this.prizeRecordService.get(PrizeRecordEntity.class, (Serializable)((Object)record.getId())) : this.prizeRecordService.getRecordByOpenid(record.getHdid(), record.getOpenId(), record.getAccountid());
        recordnew.setUsername(record.getUsername());
        recordnew.setMobile(record.getMobile());
        recordnew.setAddress(record.getAddress());
        this.systemService.updateEntitie((Object)recordnew);
        return j;
    }

    @RequestMapping(params={"addRecord"})
    @ResponseBody
    public AjaxJson addRecord(HttpServletRequest request) {
        Timestamp nowTime = new Timestamp(new Date().getTime());
        AjaxJson j = new AjaxJson();
        HttpSession session = request.getSession();
        Object hdIdObj = session.getAttribute("hdId");
        Object opendIdObj = session.getAttribute("opendId");
        String accountid = this.findAccountId(request);
        String hdId = "";
        String opendId = "";
        if (hdIdObj != null) {
            hdId = hdIdObj.toString();
        }
        if (opendIdObj != null) {
            opendId = opendIdObj.toString();
        }
        String hql = "from HdRecordEntity hd where hd.hdid='" + hdId + "' and hd.opendid='" + opendId + "'";
        List hdList = this.systemService.findByQueryString(hql);
        HdRecordEntity hd = new HdRecordEntity();
        if (hdList != null && hdList.size() > 0) {
            hd = (HdRecordEntity)hdList.get(0);
            hd.setTotal(hd.getTotal() + 1);
        } else {
            hd.setOpendid(opendId);
            hd.setAddtime(nowTime);
            hd.setHdid(hdId);
            hd.setAccountid(accountid);
            if (hd.getTotal() != null && !"".equals(hd.getTotal())) {
                hd.setTotal(hd.getTotal() + 1);
            } else {
                hd.setTotal(1);
            }
        }
        this.systemService.saveOrUpdate((Object)hd);
        return j;
    }

    @RequestMapping(params={"goYaoyiyaoNew"})
    public ModelAndView goYaoyiyaoNew(HttpServletRequest request) {
        PrizeRecordEntity record;
        String openid = request.getParameter("openid");
        String accountid = this.findAccountId(request);
        List hdlst = this.systemService.findByQueryString(" FROM HuodongEntity h WHERE h.accountid='" + accountid + "' AND type=4");
        HuodongEntity huodongEntity = new HuodongEntity();
        if (hdlst.size() != 0 && (record = this.prizeRecordService.getRecordByOpenid((huodongEntity = (HuodongEntity)hdlst.get(0)).getId(), openid, accountid)) != null) {
            if (!StringUtil.isEmpty((String)record.getMobile()) && !StringUtil.isEmpty((String)record.getUsername())) {
                request.setAttribute("updateinfo", (Object)0);
                request.setAttribute("msg", (Object)("\u4eb2\uff0c\u60a8\u5df2\u7ecf\u6447\u51fa" + record.getPrizetype() + " \u5956\u54c1\u4e3a\uff1a" + record.getPrize() + " \u8bf7\u901f\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\u53d6\u5f97\u793c\u54c1\u3002"));
                return new ModelAndView("weixin/idea/huodong2/yaoyiyao/yaoyiyaoover");
            }
            if (StringUtil.isEmpty((String)record.getMobile()) || StringUtil.isEmpty((String)record.getUsername())) {
                request.setAttribute("record", (Object)record);
                this.loadAwardslist(huodongEntity, request);
                return new ModelAndView("weixin/idea/huodong2/yaoyiyao/yaoyiyaoupdate");
            }
        }
        if (this.checkCount(huodongEntity, openid)) {
            request.setAttribute("msg", (Object)"\u5df2\u7ecf\u8d85\u8fc7\u6447\u5956\u6b21\u6570\u3002\u4e0d\u80fd\u8fdb\u884c\u6447\u5956\u3002");
            return new ModelAndView("weixin/idea/huodong2/yaoyiyao/yaoyiyaoover");
        }
        if (WeiXinConstant.HUODONG_HDCODE_START.equals(huodongEntity.getHdCode())) {
            String gl = huodongEntity.getGl();
            String[] glArr = gl.split("/");
            int randomNum = HdUtils.createPrice(Integer.parseInt(glArr[0]), Integer.parseInt(glArr[1]), huodongEntity.getAwardslist().size());
            List<HuoDongAwardEntity> awardslist = huodongEntity.getAwardslist();
            boolean zhongjiang = false;
            for (HuoDongAwardEntity aw : awardslist) {
                if (aw.getAwardslevle().getAwardsValue() != randomNum) continue;
                int count = this.huoDongAwardService.getAwardsAmount(aw.getAwardslevle().getId(), huodongEntity.getId());
                List<PrizeRecordEntity> recordlist = this.prizeRecordService.listRecord(huodongEntity.getId(), aw.getAwardslevle().getAwardsName(), accountid);
                if (recordlist.size() >= count) {
                    randomNum = 0;
                    zhongjiang = false;
                    break;
                }
                zhongjiang = true;
                break;
            }
            if (zhongjiang) {
                logger.info((Object)("\u4e2d\u5956\u4fe1\u606f\uff1a\u5956\u9879\uff1a" + randomNum));
                AwardsLevelEntity level = this.awardsLevelService.getAwardsLevelByValue(randomNum, accountid);
                request.setAttribute("prizetype", (Object)level.getAwardsName());
                request.setAttribute("level", (Object)level);
                request.setAttribute("prize", (Object)randomNum);
                AwardGraphics cg = new AwardGraphics();
                String path = String.valueOf(request.getSession().getServletContext().getRealPath("plug-in/weixin/images/ggl")) + "/" + openid + "prize.jpg";
                try {
                    cg.graphicsGeneration(path, level.getAwardsName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                request.setAttribute("prize", (Object)0);
            }
            HttpSession session = request.getSession();
            session.setAttribute("hdId", (Object)huodongEntity.getId());
            session.setAttribute("accountid", (Object)accountid);
            session.setAttribute("openid", (Object)openid);
            request.setAttribute("huodongEntity", (Object)huodongEntity);
            request.setAttribute("hdId", (Object)huodongEntity.getId());
            request.setAttribute("accountid", (Object)accountid);
            request.setAttribute("openid", (Object)openid);
            HashMap<String, List> awardmap = new HashMap<String, List>();
            for (HuoDongAwardEntity awards : awardslist) {
                List awardlist = this.systemService.findByQueryString("from WeixinAwardsAwardEntity w where w.huodongmodel='" + huodongEntity.getId() + "' and " + " w.awardslevle='" + awards.getAwardslevle().getId() + "'");
                awardmap.put(awards.getId(), awardlist);
            }
            request.setAttribute("awardmap", awardmap);
            request.setAttribute("awardslist", awardslist);
            request.setAttribute("awardscount", (Object)huodongEntity.getAwardslist().size());
            request.setAttribute("huodongstatus", (Object)WeiXinConstant.HUODONG_HDCODE_START);
        } else if (WeiXinConstant.HUODONG_HDCODE_NO_START.equals(huodongEntity.getHdCode())) {
            request.setAttribute("huodongstatus", (Object)WeiXinConstant.HUODONG_HDCODE_NO_START);
        } else if (WeiXinConstant.HUODONG_HDCODE_STOP.equals(huodongEntity.getHdCode())) {
            request.setAttribute("huodongstatus", (Object)WeiXinConstant.HUODONG_HDCODE_STOP);
        }
        return new ModelAndView("weixin/idea/huodong2/yaoyiyao/yaoyiyao");
    }

    @RequestMapping(params={"doYaoyiyao"})
    @ResponseBody
    public AjaxJson doYaoyiyao(HttpServletRequest request) {
        String prizetype = request.getParameter("prizetype");
        String openId = request.getParameter("openid");
        String hdId = request.getParameter("hdid");
        String accountid = this.findAccountId(request);
        AjaxJson j = new AjaxJson();
        HuodongEntity hdEntity = (HuodongEntity)this.systemService.get(HuodongEntity.class, (Serializable)((Object)hdId));
        if (this.checkCount(hdEntity, openId)) {
            j.setSuccess(false);
            this.message = "\u4eb2\uff0c\u62bd\u5956\u673a\u4f1a\u5df2\u7ecf\u7528\u5b8c";
            j.setMsg(this.message);
            return j;
        }
        String hql1 = "from PrizeRecordEntity where hdid='" + hdId + "' and openId='" + openId + "'";
        hql1 = StringUtil.isNotEmpty((Object)accountid) ? String.valueOf(hql1) + " and accountid='" + accountid + "'" : String.valueOf(hql1) + " and accountid='-'";
        List prizeList = this.systemService.findByQueryString(hql1);
        if (prizeList.size() > 0) {
            j.setSuccess(false);
            this.message = "\u5bf9\u4e0d\u8d77\u672c\u6b21\u6d3b\u52a8\u4f60\u5df2\u7ecf\u4e2d\u5956\uff0c\u4e0d\u80fd\u518d\u6447\u5956\uff01";
            j.setMsg(this.message);
            return j;
        }
        HdRecordEntity hdRecord = this.hdRecordService.getHdRecord(openId, hdId);
        if (hdRecord != null) {
            j.setSuccess(true);
            hdRecord.setTotal(hdRecord.getTotal() + 1);
            this.systemService.updateEntitie((Object)hdRecord);
        } else {
            hdRecord = new HdRecordEntity();
            hdRecord.setAddtime(new Date());
            hdRecord.setHdid(hdId);
            hdRecord.setOpendid(openId);
            hdRecord.setTotal(1);
            hdRecord.setNickname("");
            hdRecord.setAccountid(accountid);
            this.systemService.save((Object)hdRecord);
            LogUtil.info((Object)this.message);
            j.setMsg(this.message);
        }
        if (!prizetype.equals("0")) {
            PrizeRecordEntity record = new PrizeRecordEntity();
            record.setAccountid(accountid);
            record.setAddtime(new Date());
            record.setAwardsCode(UUID.randomUUID().toString());
            record.setHdid(hdId);
            record.setOpenId(openId);
            record.setSendstatus("0");
            AwardsLevelEntity level = this.awardsLevelService.getAwardsLevelByValue(Integer.valueOf(prizetype), accountid);
            record.setPrizetype(level.getAwardsName());
            WeixinAwardsAwardEntity awards = this.weixinAwardsAwardService.getAwards(level.getId(), hdId);
            record.setPrize(awards.getAwardmodel().getName());
            this.systemService.save((Object)record);
        }
        return j;
    }

    @RequestMapping(params={"goYaoyiyaoComplete"})
    public ModelAndView goYaoyiyaoComplete(HttpServletRequest request, PrizeRecordEntity record) {
        if ((record = !StringUtil.isEmpty((String)record.getId()) ? (PrizeRecordEntity)this.prizeRecordService.get(PrizeRecordEntity.class, (Serializable)((Object)record.getId())) : this.prizeRecordService.getRecordByOpenid(record.getHdid(), record.getOpenId(), record.getAccountid())) != null && !StringUtil.isEmpty((String)record.getMobile()) && !StringUtil.isEmpty((String)record.getUsername())) {
            request.setAttribute("msg", (Object)("\u4eb2\uff0c\u60a8\u5df2\u7ecf\u6447\u51fa" + record.getPrizetype() + " \u5956\u54c1\u4e3a\uff1a" + record.getPrize() + " \u8bf7\u901f\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\u53d6\u5f97\u793c\u54c1\u3002"));
            return new ModelAndView("weixin/idea/huodong2/yaoyiyao/yaoyiyaoover");
        }
        return new ModelAndView("weixin/idea/huodong2/yaoyiyao/yaoyiyaoover");
    }

    @RequestMapping(params={"goZhuanpanComplete"})
    public ModelAndView goZhuanpanComplete(HttpServletRequest request, PrizeRecordEntity record) {
        if ((record = !StringUtil.isEmpty((String)record.getId()) ? (PrizeRecordEntity)this.prizeRecordService.get(PrizeRecordEntity.class, (Serializable)((Object)record.getId())) : this.prizeRecordService.getRecordByOpenid(record.getHdid(), record.getOpenId(), record.getAccountid())) != null && !StringUtil.isEmpty((String)record.getMobile()) && !StringUtil.isEmpty((String)record.getUsername())) {
            request.setAttribute("msg", (Object)("\u4eb2\uff0c\u60a8\u5df2\u7ecf\u62bd\u4e2d" + record.getPrizetype() + " \u5956\u54c1\u4e3a\uff1a" + record.getPrize() + " \u8bf7\u901f\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\u53d6\u5f97\u793c\u54c1\u3002"));
            return new ModelAndView("weixin/idea/huodong2/zp/zhuanpanover");
        }
        return new ModelAndView("weixin/idea/huodong2/zp/zhuanpanover");
    }

    @RequestMapping(params={"toZhuanpanDuijiang"})
    public ModelAndView toZhuanpanDuijiang(HttpServletRequest request) {
        String openid = ResourceUtil.getOpenid((HttpServletRequest)request);
        String hdid = oConvertUtils.getString((String)request.getParameter("hdid"), (String)"");
        String recordid = oConvertUtils.getString((String)request.getParameter("recordid"), (String)"");
        PrizeRecordEntity prizeRecord = (PrizeRecordEntity)this.systemService.findUniqueByProperty(PrizeRecordEntity.class, "id", (Object)recordid);
        HuodongEntity hdEntity = (HuodongEntity)this.systemService.findUniqueByProperty(HuodongEntity.class, "id", (Object)hdid);
        HdRecordEntity hdRecord = this.hdRecordService.getHdRecord(openid, hdEntity.getId());
        int leaveTime = Integer.valueOf(hdEntity.getCount()) - hdRecord.getTotal();
        request.setAttribute("prizeRecord", (Object)prizeRecord);
        request.setAttribute("leaveTime", (Object)leaveTime);
        request.setAttribute("openid", (Object)openid);
        request.setAttribute("hdEntity", (Object)hdEntity);
        this.loadAwardslist(hdEntity, request);
        return new ModelAndView("weixin/idea/huodong2/zp/zhuanpanupdate");
    }

    @RequestMapping(params={"goZhuanpan"})
    public ModelAndView goZhuanpan(HttpServletRequest request) {
        String hdid = request.getParameter("hdid");
        if (StringUtil.isEmpty((String)hdid)) {
            request.setAttribute("msg", (Object)"\u4eb2\uff0c\u60a8\u63d0\u4ea4\u7684\u6d3b\u52a8\u4e0d\u5b58\u5728");
            return new ModelAndView("weixin/idea/huodong2/zp/zhuanpanover");
        }
        List hdlst = this.systemService.findByQueryString(" FROM HuodongEntity h WHERE h.id='" + hdid + "' AND type=2");
        if (hdlst == null || hdlst.size() == 0) {
            request.setAttribute("huodongstatus", (Object)WeiXinConstant.HUODONG_HDCODE_NO_START);
            request.setAttribute("msg", (Object)"\u5546\u5bb6\u672a\u542f\u52a8\u5927\u8f6c\u76d8\u6d3b\u52a8\u3002");
            return new ModelAndView("weixin/idea/huodong2/zp/zhuanpanover");
        }
        String targetUrlMethod = "goZhuanpan";
        HuodongEntity hdEntity = (HuodongEntity)hdlst.get(0);
        String accountId = hdEntity.getAccountid();
        String weixin_author2_url = this.myHuoDongCallWeixinAuthor2(request, accountId, hdid, targetUrlMethod);
        if (oConvertUtils.isNotEmpty((Object)weixin_author2_url)) {
            return new ModelAndView(weixin_author2_url);
        }
        String openId = this.getOpenId(request);
        if (StringUtils.isEmpty((CharSequence)openId) || StringUtils.isEmpty((CharSequence)hdEntity.getAccountid())) {
            throw new BusinessException("openid or accountid can not be null");
        }
        ValidateResult result = this.huodongService.validateCanJoin(hdEntity, openId);
        if (!result.isSucc()) {
            request.setAttribute("msg", (Object)result.getMessage());
            return new ModelAndView("weixin/idea/huodong2/zp/zhuanpanover");
        }
        if (WeiXinConstant.HUODONG_HDCODE_START.equals(hdEntity.getHdCode())) {
            ValidateResult countResult = this.huodongService.validateCanLottery(hdEntity, openId);
            if (!countResult.isSucc()) {
                request.setAttribute("msg", (Object)countResult.getMessage());
                return new ModelAndView("weixin/idea/huodong2/zp/zhuanpanover");
            }
            request.setAttribute("hdEntity", (Object)hdEntity);
            request.setAttribute("hdid", (Object)hdEntity.getId());
            request.setAttribute("openId", (Object)openId);
            List<HuoDongAwardEntity> awardslist = hdEntity.getAwardslist();
            HashMap<String, List> awardmap = new HashMap<String, List>();
            for (HuoDongAwardEntity awards : awardslist) {
                List awardlist = this.systemService.findByQueryString("from WeixinAwardsAwardEntity w where w.huodongmodel='" + hdEntity.getId() + "' and " + " w.awardslevle='" + awards.getAwardslevle().getId() + "'");
                awardmap.put(awards.getId(), awardlist);
            }
            request.setAttribute("awardmap", awardmap);
            request.setAttribute("awardslist", awardslist);
            request.setAttribute("awardscount", (Object)hdEntity.getAwardslist().size());
            HdRecordEntity hdrecord = this.hdRecordService.getHdRecord(openId, hdEntity.getId());
            request.setAttribute("count", (Object)hdEntity.getCount());
            if (hdrecord != null) {
                request.setAttribute("leavecount", (Object)(Integer.valueOf(hdEntity.getCount()) - hdrecord.getTotal()));
            } else {
                request.setAttribute("leavecount", (Object)hdEntity.getCount());
            }
        } else {
            if (WeiXinConstant.HUODONG_HDCODE_NO_START.equals(hdEntity.getHdCode())) {
                request.setAttribute("huodongstatus", (Object)WeiXinConstant.HUODONG_HDCODE_NO_START);
                request.setAttribute("msg", (Object)"\u5546\u5bb6\u672a\u542f\u52a8\u5927\u8f6c\u76d8\u6d3b\u52a8\u3002");
                return new ModelAndView("weixin/idea/huodong2/zp/zhuanpanover");
            }
            if (WeiXinConstant.HUODONG_HDCODE_STOP.equals(hdEntity.getHdCode())) {
                request.setAttribute("huodongstatus", (Object)WeiXinConstant.HUODONG_HDCODE_STOP);
                request.setAttribute("msg", (Object)"\u5546\u5bb6\u672a\u542f\u52a8\u5927\u8f6c\u76d8\u6d3b\u52a8\u3002");
                return new ModelAndView("weixin/idea/huodong2/zp/zhuanpanover");
            }
        }
        request.setAttribute("accountid", (Object)accountId);
        LogUtil.info((Object)("....hdid...." + hdEntity.getId() + "...openId.." + openId));
        return new ModelAndView("weixin/idea/huodong2/zhuanpannew/lottery");
    }

    private String getOpenId(HttpServletRequest request) {
        String openId = ResourceUtil.getOpenid((HttpServletRequest)request);
        if (oConvertUtils.isNullOrEmpty((Object)openId)) {
            openId = ResourceUtil.getUserOpenId();
        }
        return openId;
    }

    private void loadAwardslist(HuodongEntity hdEntity, HttpServletRequest request) {
        List<HuoDongAwardEntity> awardslist = hdEntity.getAwardslist();
        HashMap<String, List> awardmap = new HashMap<String, List>();
        for (HuoDongAwardEntity awards : awardslist) {
            List awardlist = this.systemService.findByQueryString("from WeixinAwardsAwardEntity w where w.huodongmodel='" + hdEntity.getId() + "' and " + " w.awardslevle='" + awards.getAwardslevle().getId() + "'");
            awardmap.put(awards.getId(), awardlist);
        }
        request.setAttribute("awardmap", awardmap);
        request.setAttribute("awardslist", awardslist);
        request.setAttribute("awardscount", (Object)hdEntity.getAwardslist().size());
    }

    private boolean checkCount(HuodongEntity hdEntity, String openId) {
        String hql = "from HdRecordEntity where hdid='" + hdEntity.getId() + "' and opendid='" + openId + "'";
        List hdRecrdList = this.systemService.findHql(hql, null);
        if (hdRecrdList.size() > 0) {
            HdRecordEntity hdRecord = (HdRecordEntity)hdRecrdList.get(0);
            int total = hdRecord.getTotal();
            return total >= Integer.parseInt(hdEntity.getCount());
        }
        return false;
    }

    private int getCount(HuodongEntity hdEntity, String openId) {
        List hdRecrdList;
        String hql = "from HdRecordEntity where hdid='" + hdEntity.getId() + "' and opendid='" + openId + "' and accountid='" + hdEntity.getAccountid() + "'";
        if (openId == null) {
            hql = "from HdRecordEntity where hdid='" + hdEntity.getId() + "'  and accountid='" + hdEntity.getAccountid() + "'";
        }
        if ((hdRecrdList = this.systemService.findHql(hql, null)).size() > 0) {
            return ((HdRecordEntity)hdRecrdList.get(0)).getTotal();
        }
        return 0;
    }

    @RequestMapping(params={"goZhuanpanForVotepk"})
    public ModelAndView goZhuanpanForVotepk(HttpServletRequest request, String openid, String accountid) {
        List hdlst = this.systemService.findByQueryString(" FROM HuodongEntity h WHERE h.accountid='" + accountid + "' AND type=2");
        HuodongEntity hdEntity = new HuodongEntity();
        if (hdlst.size() != 0) {
            hdEntity = (HuodongEntity)hdlst.get(0);
            if (WeiXinConstant.HUODONG_HDCODE_START.equals(hdEntity.getHdCode())) {
                request.setAttribute("hdEntity", (Object)hdEntity);
                request.setAttribute("hdId", (Object)hdEntity.getId());
                request.setAttribute("openId", (Object)openid);
                request.setAttribute("accountid", (Object)accountid);
                List<HuoDongAwardEntity> awardslist = hdEntity.getAwardslist();
                HashMap<String, List> awardmap = new HashMap<String, List>();
                for (HuoDongAwardEntity awards : awardslist) {
                    List awardlist = this.systemService.findByQueryString("from WeixinAwardsAwardEntity w where w.huodongmodel='" + hdEntity.getId() + "' and " + " w.awardslevle='" + awards.getAwardslevle().getId() + "'");
                    awardmap.put(awards.getId(), awardlist);
                }
                request.setAttribute("awardmap", awardmap);
                request.setAttribute("awardslist", awardslist);
                request.setAttribute("awardscount", (Object)hdEntity.getAwardslist().size());
            } else if (WeiXinConstant.HUODONG_HDCODE_NO_START.equals(hdEntity.getHdCode())) {
                request.setAttribute("huodongstatus", (Object)WeiXinConstant.HUODONG_HDCODE_NO_START);
            } else if (WeiXinConstant.HUODONG_HDCODE_STOP.equals(hdEntity.getHdCode())) {
                request.setAttribute("huodongstatus", (Object)WeiXinConstant.HUODONG_HDCODE_STOP);
            }
        }
        return new ModelAndView("weixin/idea/huodong2/zp/zhuanpanforvotepk");
    }

    @RequestMapping(params={"getZpPize"})
    @ResponseBody
    public AjaxJson doZpPize(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String hdId = request.getParameter("hdId");
        String openId = request.getParameter("openId");
        String accountid = this.findAccountId(request);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtil.isNotEmpty((Object)hdId) && StringUtil.isNotEmpty((Object)openId)) {
            HuodongEntity hdEntity = (HuodongEntity)this.systemService.getEntity(HuodongEntity.class, (Serializable)((Object)hdId));
            String hql = "from HdRecordEntity where hdid='" + hdId + "' and opendid='" + openId + "'";
            hql = StringUtil.isNotEmpty((Object)accountid) ? String.valueOf(hql) + " and accountid='" + accountid + "'" : String.valueOf(hql) + " and accountid='-'";
            List hdRecrdList = this.systemService.findHql(hql, null);
            Timestamp nowTime = new Timestamp(new Date().getTime());
            if (hdEntity != null) {
                HdRecordEntity hdRecord;
                if (hdRecrdList.size() > 0) {
                    hdRecord = (HdRecordEntity)hdRecrdList.get(0);
                    int total = hdRecord.getTotal();
                    if (total < Integer.parseInt(hdEntity.getCount())) {
                        String hql1 = "from PrizeRecordEntity where hdid='" + hdId + "' and openId='" + openId + "'";
                        hql1 = StringUtil.isNotEmpty((Object)accountid) ? String.valueOf(hql1) + " and accountid='" + accountid + "'" : String.valueOf(hql1) + " and accountid='-'";
                        List prizeList = this.systemService.findByQueryString(hql1);
                        if (prizeList.size() > 0) {
                            j.setSuccess(false);
                            params.put("error", "getsn");
                            params.put("prizetype", ((PrizeRecordEntity)prizeList.get(0)).getPrizetype());
                        } else {
                            hdRecord.setTotal(total + 1);
                            this.systemService.updateEntitie((Object)hdRecord);
                        }
                    } else {
                        j.setSuccess(false);
                        params.put("error", "invalid");
                        params.put("total", total);
                    }
                } else {
                    hdRecord = new HdRecordEntity();
                    hdRecord.setAddtime(nowTime);
                    hdRecord.setHdid(hdId);
                    hdRecord.setOpendid(openId);
                    hdRecord.setTotal(1);
                    hdRecord.setNickname("");
                    hdRecord.setAccountid(accountid);
                    this.systemService.save((Object)hdRecord);
                }
                String prizetype = "";
                String gl = hdEntity.getGl();
                String[] glArr = gl.split("/");
                int randomNum = HdUtils.createPrice(Integer.parseInt(glArr[0]), Integer.parseInt(glArr[1]), hdEntity.getAwardslist().size());
                switch (randomNum) {
                    case 1: {
                        prizetype = "\u4e00\u7b49\u5956";
                        break;
                    }
                    case 2: {
                        prizetype = "\u4e8c\u7b49\u5956";
                        break;
                    }
                    case 3: {
                        prizetype = "\u4e09\u7b49\u5956";
                        break;
                    }
                }
                AwardsLevelEntity level = this.awardsLevelService.getAwardsLevel(prizetype, accountid);
                int count = this.huoDongAwardService.getAwardsAmount(level.getId(), hdEntity.getId());
                List<PrizeRecordEntity> recordlist = this.prizeRecordService.listRecord(hdEntity.getId(), prizetype, accountid);
                if (recordlist.size() >= count) {
                    randomNum = 0;
                }
                if (randomNum == 1 || randomNum == 2 || randomNum == 3) {
                    PrizeRecordEntity record = new PrizeRecordEntity();
                    record.setAccountid(hdEntity.getAccountid());
                    record.setAddress("");
                    record.setAwardsCode(UUID.randomUUID().toString());
                    record.setAddtime(new Date());
                    record.setHdid(hdId);
                    record.setOpenId(openId);
                    switch (randomNum) {
                        case 1: {
                            record.setPrizetype("\u4e00\u7b49\u5956");
                            break;
                        }
                        case 2: {
                            record.setPrizetype("\u4e8c\u7b49\u5956");
                            break;
                        }
                        case 3: {
                            record.setPrizetype("\u4e09\u7b49\u5956");
                            break;
                        }
                    }
                    record.setPrize(this.getPrize(record.getPrizetype(), hdEntity.getId(), accountid));
                    this.systemService.save((Object)record);
                    params.put("prizetype", randomNum);
                    HttpSession session = request.getSession();
                    session.setAttribute("hdId", (Object)hdId);
                    session.setAttribute("openId", (Object)openId);
                    session.setAttribute("prize", (Object)randomNum);
                    session.setAttribute("accountid", (Object)accountid);
                }
            }
        }
        j.setAttributes(params);
        return j;
    }

    private String getPrize(String prizetype, String hdid, String accountid) {
        AwardsLevelEntity level = this.awardsLevelService.getAwardsLevel(prizetype, accountid);
        return this.weixinAwardsAwardService.getPrize(level.getId(), hdid);
    }

    @RequestMapping(params={"getZpPrizeForVotepk"})
    @ResponseBody
    public AjaxJson getZpPrizeForVotepk(HttpServletRequest request, String openid, String accountid) {
        HuodongEntity hdEntity;
        AjaxJson j = new AjaxJson();
        String hdId = request.getParameter("hdId");
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtil.isNotEmpty((Object)hdId) && StringUtil.isNotEmpty((Object)openid) && (hdEntity = (HuodongEntity)this.systemService.getEntity(HuodongEntity.class, (Serializable)((Object)hdId))) != null) {
            GzUserInfoYw voteuser;
            int total;
            String gl = hdEntity.getGl();
            String[] glArr = gl.split("/");
            int randomNum = HdUtils.createPrice(Integer.parseInt(glArr[0]), Integer.parseInt(glArr[1]), hdEntity.getAwardslist().size());
            if (randomNum == 1 || randomNum == 2 || randomNum == 3) {
                params.put("prizetype", randomNum);
                HttpSession session = request.getSession();
                session.setAttribute("hdId", (Object)hdId);
                session.setAttribute("openId", (Object)openid);
                session.setAttribute("prize", (Object)randomNum);
                session.setAttribute("accountid", (Object)accountid);
            }
            if ((total = (voteuser = this.gzUserInfoService.getLocalUserinfoSubscribe(openid, accountid)).getLettecount().intValue()) == 0) {
                j.setSuccess(false);
                params.put("error", "invalid");
                params.put("total", total);
                j.setAttributes(params);
                return j;
            }
            String hql1 = "from PrizeRecordEntity where hdid='" + hdId + "' and openId='" + openid + "'";
            hql1 = StringUtil.isNotEmpty((Object)accountid) ? String.valueOf(hql1) + " and accountid='" + accountid + "'" : String.valueOf(hql1) + " and accountid='-'";
            List prizeList = this.systemService.findByQueryString(hql1);
            if (prizeList.size() > 0) {
                j.setSuccess(false);
                params.put("error", "getsn");
                params.put("prizetype", ((PrizeRecordEntity)prizeList.get(0)).getPrizetype());
                j.setAttributes(params);
                return j;
            }
            HdRecordEntity hdRecord = new HdRecordEntity();
            hdRecord.setAddtime(new Date());
            hdRecord.setHdid(hdId);
            hdRecord.setOpendid(openid);
            hdRecord.setTotal(1);
            hdRecord.setNickname(new String(WeixinUtil.decode(voteuser.getNickname())));
            hdRecord.setAccountid(accountid);
            this.systemService.save((Object)hdRecord);
        }
        GzUserInfoYw voteuser = this.gzUserInfoService.getLocalUserinfoAll(openid, accountid);
        voteuser.setLettecount(voteuser.getLettecount() - 1);
        this.systemService.updateEntitie((Object)voteuser);
        return j;
    }

    @RequestMapping(params={"saveZpPrize"})
    @ResponseBody
    public AjaxJson saveZpPrize(HttpServletRequest request, PrizeRecordEntity record) {
        AjaxJson j = new AjaxJson();
        PrizeRecordEntity recordnew = new PrizeRecordEntity();
        recordnew = !StringUtil.isEmpty((String)record.getId()) ? (PrizeRecordEntity)this.prizeRecordService.get(PrizeRecordEntity.class, (Serializable)((Object)record.getId())) : this.prizeRecordService.getRecordByOpenid(record.getHdid(), record.getOpenId(), record.getAccountid());
        recordnew.setUsername(record.getUsername());
        recordnew.setMobile(record.getMobile());
        this.systemService.updateEntitie((Object)recordnew);
        return j;
    }

    private String findAccountId(HttpServletRequest request) {
        if (request == null) {
            return "";
        }
        String accountid = request.getParameter("accountid");
        if (accountid != null && !"".equals(accountid)) {
            return accountid;
        }
        return ResourceUtil.getShangJiaAccountId();
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"goGoldEgg"})
    public ModelAndView goGoldEgg(HttpServletRequest request) {
        String hdid = request.getParameter("hdid");
        List hdlst = this.systemService.findByQueryString(" FROM HuodongEntity h WHERE h.id='" + hdid + "' AND type=3");
        if (hdlst == null || hdlst.size() == 0) {
            request.setAttribute("msg", (Object)"\u6d3b\u52a8\u5df2\u7ed3\u675f\u3002");
            return new ModelAndView("weixin/idea/huodong2/goldegg/goldeggover");
        }
        String targetUrlMethod = "goGoldEgg";
        HuodongEntity hdEntity = (HuodongEntity)hdlst.get(0);
        String accountId = hdEntity.getAccountid();
        String weixin_author2_url = this.myHuoDongCallWeixinAuthor2(request, accountId, hdid, targetUrlMethod);
        if (oConvertUtils.isNotEmpty((Object)weixin_author2_url)) {
            return new ModelAndView(weixin_author2_url);
        }
        String openId = this.getOpenId(request);
        if (StringUtils.isEmpty((CharSequence)openId) || StringUtils.isEmpty((CharSequence)hdEntity.getAccountid())) {
            throw new BusinessException("openid or accountid can not be null");
        }
        ValidateResult result = this.huodongService.validateCanJoin(hdEntity, openId);
        if (!result.isSucc()) {
            request.setAttribute("msg", (Object)result.getMessage());
            return new ModelAndView("weixin/idea/huodong2/goldegg/goldeggover");
        }
        if (WeiXinConstant.HUODONG_HDCODE_START.equals(hdEntity.getHdCode())) {
            ValidateResult countResult = this.huodongService.validateCanLottery(hdEntity, openId);
            if (!countResult.isSucc()) {
                PrizeRecordEntity record = this.prizeRecordService.getRecordByOpenid(hdEntity.getId(), openId, hdEntity.getAccountid());
                if (record != null) {
                    if (!StringUtil.isEmpty((String)record.getMobile()) && !StringUtil.isEmpty((String)record.getUsername())) {
                        request.setAttribute("updateinfo", (Object)0);
                        request.setAttribute("hdEntity", (Object)hdEntity);
                        request.setAttribute("msg", (Object)("\u4eb2\uff0c\u60a8\u5df2\u7ecf\u62bd\u4e2d" + record.getPrizetype() + " \u5956\u54c1\u4e3a\uff1a" + record.getPrize() + " \u8bf7\u901f\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\u53d6\u5f97\u793c\u54c1\u3002"));
                        return new ModelAndView("weixin/idea/huodong2/goldegg/goldeggover");
                    }
                    if (StringUtil.isEmpty((String)record.getMobile()) || StringUtil.isEmpty((String)record.getUsername())) {
                        request.setAttribute("record", (Object)record);
                        request.setAttribute("hdEntity", (Object)hdEntity);
                        this.loadAwardslist(hdEntity, request);
                        return new ModelAndView("weixin/idea/huodong2/goldegg/goldeggupdate");
                    }
                }
                request.setAttribute("msg", (Object)countResult.getMessage());
                return new ModelAndView("weixin/idea/huodong2/goldegg/goldeggover");
            }
            this.huodongService.hdRecordCount(hdEntity, openId);
            String gl = hdEntity.getGl();
            String[] glArr = gl.split("/");
            int randomNum = HdUtils.createPrice(Integer.parseInt(glArr[0]), Integer.parseInt(glArr[1]), hdEntity.getAwardslist().size());
            List<HuoDongAwardEntity> awardslist = hdEntity.getAwardslist();
            boolean zhongjiang = false;
            for (HuoDongAwardEntity aw : awardslist) {
                if (aw.getAwardslevle().getAwardsValue() != randomNum) continue;
                int count = this.huoDongAwardService.getAwardsAmount(aw.getAwardslevle().getId(), hdEntity.getId());
                List<PrizeRecordEntity> recordlist = this.prizeRecordService.listRecord(hdEntity.getId(), aw.getAwardslevle().getAwardsName(), hdEntity.getAccountid());
                if (recordlist.size() >= count) {
                    randomNum = 0;
                    zhongjiang = false;
                    break;
                }
                zhongjiang = true;
                break;
            }
            if (zhongjiang) {
                logger.info((Object)("\u4e2d\u5956\u4fe1\u606f\uff1a\u5956\u9879\uff1a" + randomNum));
                AwardsLevelEntity level = this.awardsLevelService.getAwardsLevelByValue(randomNum, hdEntity.getAccountid());
                request.setAttribute("prizetype", (Object)level.getAwardsName());
                request.setAttribute("level", (Object)level);
                request.setAttribute("prize", (Object)randomNum);
                this.goldEggRecord(openId, hdEntity.getAccountid(), hdEntity.getId(), "" + level.getAwardsValue());
                AwardGraphics cg = new AwardGraphics();
                String path = String.valueOf(request.getSession().getServletContext().getRealPath("plug-in/weixin/images/ggl")) + "/" + openId + "prize.jpg";
            } else {
                request.setAttribute("prize", (Object)0);
            }
            request.setAttribute("hdEntity", (Object)hdEntity);
            request.setAttribute("hdId", (Object)hdEntity.getId());
            request.setAttribute("openId", (Object)openId);
            request.setAttribute("accountid", (Object)hdEntity.getAccountid());
            HashMap<String, List> awardmap = new HashMap<String, List>();
            for (HuoDongAwardEntity awards : awardslist) {
                List awardlist = this.systemService.findByQueryString("from WeixinAwardsAwardEntity w where w.huodongmodel='" + hdEntity.getId() + "' and " + " w.awardslevle='" + awards.getAwardslevle().getId() + "'");
                awardmap.put(awards.getId(), awardlist);
            }
            request.setAttribute("awardmap", awardmap);
            request.setAttribute("awardslist", awardslist);
            request.setAttribute("awardscount", (Object)hdEntity.getAwardslist().size());
            HdRecordEntity hdrecord = this.hdRecordService.getHdRecord(openId, hdEntity.getId());
            request.setAttribute("count", (Object)hdEntity.getCount());
            if (hdrecord != null) {
                request.setAttribute("leavecount", (Object)(Integer.valueOf(hdEntity.getCount()) - hdrecord.getTotal()));
            } else {
                request.setAttribute("leavecount", (Object)hdEntity.getCount());
            }
        } else {
            if (WeiXinConstant.HUODONG_HDCODE_NO_START.equals(hdEntity.getHdCode())) {
                request.setAttribute("huodongstatus", (Object)WeiXinConstant.HUODONG_HDCODE_NO_START);
                request.setAttribute("msg", (Object)"\u6d3b\u52a8\u5df2\u7ed3\u675f\u3002");
                return new ModelAndView("weixin/idea/huodong2/goldegg/goldeggover");
            }
            if (WeiXinConstant.HUODONG_HDCODE_STOP.equals(hdEntity.getHdCode())) {
                request.setAttribute("huodongstatus", (Object)WeiXinConstant.HUODONG_HDCODE_STOP);
                request.setAttribute("msg", (Object)"\u6d3b\u52a8\u5df2\u7ed3\u675f\u3002");
                return new ModelAndView("weixin/idea/huodong2/goldegg/goldeggover");
            }
        }
        LogUtil.info((Object)("....hdid...." + hdEntity.getId() + "...openId.." + openId));
        return new ModelAndView("weixin/idea/huodong2/goldegg/goldegg");
    }

    private void goldEggRecord(String openId, String accountid, String hdId, String prizetype) {
        PrizeRecordEntity record = new PrizeRecordEntity();
        record.setAccountid(accountid);
        record.setAddtime(new Date());
        record.setAwardsCode(UUID.randomUUID().toString());
        record.setHdid(hdId);
        record.setOpenId(openId);
        AwardsLevelEntity level = this.awardsLevelService.getAwardsLevelByValue(Integer.valueOf(prizetype), accountid);
        record.setPrizetype(level.getAwardsName());
        WeixinAwardsAwardEntity awards = this.weixinAwardsAwardService.getAwards(level.getId(), hdId);
        record.setPrize(awards.getAwardmodel().getName());
        this.systemService.save((Object)record);
    }

    @RequestMapping(params={"goZymShake"})
    public ModelAndView goZymShake(HttpServletRequest request) {
        String hdid = request.getParameter("hdid");
        List hdlst = this.systemService.findByQueryString(" FROM HuodongEntity h WHERE h.id='" + hdid + "' AND type=5");
        if (hdlst == null || hdlst.size() == 0) {
            request.setAttribute("msg", (Object)"\u5546\u5bb6\u672a\u542f\u52a8\u6447\u4e00\u6447\u6d3b\u52a8\u3002");
            return new ModelAndView("weixin/idea/huodong2/shake/shakePrizeover");
        }
        String targetUrlMethod = "goZymShake";
        HuodongEntity hdEntity = (HuodongEntity)hdlst.get(0);
        String accountId = hdEntity.getAccountid();
        String weixin_author2_url = this.myHuoDongCallWeixinAuthor2(request, accountId, hdid, targetUrlMethod);
        if (oConvertUtils.isNotEmpty((Object)weixin_author2_url)) {
            return new ModelAndView(weixin_author2_url);
        }
        String openId = this.getOpenId(request);
        if (StringUtils.isEmpty((CharSequence)openId) || StringUtils.isEmpty((CharSequence)hdEntity.getAccountid())) {
            throw new BusinessException("openid or accountid can not be null");
        }
        ValidateResult result = this.huodongService.validateCanJoin(hdEntity, openId);
        if (!result.isSucc()) {
            request.setAttribute("msg", (Object)result.getMessage());
            return new ModelAndView("weixin/idea/huodong2/shake/shakePrizeover");
        }
        int shakeTimeCount = this.getCount(hdEntity, openId);
        String hdcountStr = "\u60a8\u6709 " + Integer.parseInt(hdEntity.getCount()) + " \u6b21\u673a\u4f1a\u6447\u5956\uff0c\u5df2\u7ecf\u6447\u4e86 " + shakeTimeCount + " \u6b21";
        request.setAttribute("hdcountStr", (Object)hdcountStr);
        if (WeiXinConstant.HUODONG_HDCODE_START.equals(hdEntity.getHdCode())) {
            ValidateResult countResult = this.huodongService.validateCanLottery(hdEntity, openId);
            if (!countResult.isSucc()) {
                request.setAttribute("msg", (Object)countResult.getMessage());
                return new ModelAndView("weixin/idea/huodong/shake/shakePrizeover");
            }
            request.setAttribute("hdEntity", (Object)hdEntity);
            request.setAttribute("hdId", (Object)hdEntity.getId());
            request.setAttribute("openId", (Object)openId);
            request.setAttribute("accountid", (Object)accountId);
            List<HuoDongAwardEntity> awardslist = hdEntity.getAwardslist();
            HashMap<String, List> awardmap = new HashMap<String, List>();
            for (HuoDongAwardEntity awards : awardslist) {
                List awardlist = this.systemService.findByQueryString("from WeixinAwardsAwardEntity w where w.huodongmodel='" + hdEntity.getId() + "' and " + " w.awardslevle='" + awards.getAwardslevle().getId() + "'");
                awardmap.put(awards.getId(), awardlist);
            }
            request.setAttribute("awardmap", awardmap);
            request.setAttribute("awardslist", awardslist);
            request.setAttribute("awardscount", (Object)hdEntity.getAwardslist().size());
            HdRecordEntity hdrecord = this.hdRecordService.getHdRecord(openId, hdEntity.getId());
            request.setAttribute("count", (Object)hdEntity.getCount());
            if (hdrecord != null) {
                request.setAttribute("leavecount", (Object)(Integer.valueOf(hdEntity.getCount()) - hdrecord.getTotal()));
            } else {
                request.setAttribute("leavecount", (Object)hdEntity.getCount());
            }
        } else {
            if (WeiXinConstant.HUODONG_HDCODE_NO_START.equals(hdEntity.getHdCode())) {
                request.setAttribute("huodongstatus", (Object)WeiXinConstant.HUODONG_HDCODE_NO_START);
                request.setAttribute("msg", (Object)"\u5546\u5bb6\u672a\u542f\u52a8\u6447\u4e00\u6447\u6d3b\u52a8\u3002");
                return new ModelAndView("weixin/idea/huodong/shake/shakePrizeover");
            }
            if (WeiXinConstant.HUODONG_HDCODE_STOP.equals(hdEntity.getHdCode())) {
                request.setAttribute("huodongstatus", (Object)WeiXinConstant.HUODONG_HDCODE_STOP);
                request.setAttribute("msg", (Object)"\u5546\u5bb6\u672a\u542f\u52a8\u6447\u4e00\u6447\u6d3b\u52a8\u3002");
                return new ModelAndView("weixin/idea/huodong/shake/shakePrizeover");
            }
        }
        LogUtil.info((Object)("....hdid...." + hdEntity.getId() + "...openId.." + openId));
        return new ModelAndView("weixin/idea/huodong/newshake/index");
    }

    @RequestMapping(params={"saveGoldEggPrize"})
    @ResponseBody
    public AjaxJson saveGoldEggPrize(HttpServletRequest request, PrizeRecordEntity record) {
        AjaxJson j = new AjaxJson();
        PrizeRecordEntity recordnew = new PrizeRecordEntity();
        recordnew = !StringUtil.isEmpty((String)record.getId()) ? (PrizeRecordEntity)this.prizeRecordService.get(PrizeRecordEntity.class, (Serializable)((Object)record.getId())) : this.prizeRecordService.getRecordByOpenid(record.getHdid(), record.getOpenId(), record.getAccountid());
        recordnew.setUsername(record.getUsername());
        recordnew.setMobile(record.getMobile());
        recordnew.setAddress(record.getAddress());
        this.systemService.updateEntitie((Object)recordnew);
        return j;
    }

    @RequestMapping(params={"goGoldEggComplete"})
    public ModelAndView goGoldEggComplete(HttpServletRequest request, PrizeRecordEntity record) {
        if ((record = !StringUtil.isEmpty((String)record.getId()) ? (PrizeRecordEntity)this.prizeRecordService.get(PrizeRecordEntity.class, (Serializable)((Object)record.getId())) : this.prizeRecordService.getRecordByOpenid(record.getHdid(), record.getOpenId(), record.getAccountid())) != null && !StringUtil.isEmpty((String)record.getMobile()) && !StringUtil.isEmpty((String)record.getUsername())) {
            request.setAttribute("msg", (Object)("\u4eb2\uff0c\u60a8\u5df2\u7ecf\u7838\u51fa" + record.getPrizetype() + " \u5956\u54c1\u4e3a\uff1a" + record.getPrize() + " \u8bf7\u901f\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\u53d6\u5f97\u793c\u54c1\u3002"));
            return new ModelAndView("weixin/idea/huodong2/goldegg/goldeggover");
        }
        return new ModelAndView("weixin/idea/huodong2/goldegg/goldeggover");
    }

    @RequestMapping(params={"getZpPizeNew"})
    @ResponseBody
    public AjaxJson getZpPizeNew(HttpServletRequest request) {
        HuodongEntity hdEntity;
        AjaxJson j = new AjaxJson();
        String hdId = request.getParameter("hdid");
        String openId = request.getParameter("openId");
        String accountid = request.getParameter("accountid");
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtil.isNotEmpty((Object)hdId) && StringUtil.isNotEmpty((Object)openId) && (hdEntity = (HuodongEntity)this.systemService.getEntity(HuodongEntity.class, (Serializable)((Object)hdId))) != null) {
            String gl = hdEntity.getGl();
            List<HuoDongAwardEntity> awardslist = hdEntity.getAwardslist();
            String[] glArr = gl.split("/");
            int choujiangcount = 0;
            HuoDongAwardEntity chouaward = HdUtils.getAward(Integer.parseInt(glArr[0]), Integer.parseInt(glArr[1]), awardslist);
            if (chouaward != null) {
                boolean zhongjiangflag = true;
                int prizecount = 0;
                for (HuoDongAwardEntity a : awardslist) {
                    prizecount = a.getAmount() + prizecount;
                }
                ++choujiangcount;
                int count = this.huoDongAwardService.getAwardsAmount(chouaward.getAwardslevle().getId(), hdEntity.getId());
                List<PrizeRecordEntity> recordlist = this.prizeRecordService.listRecord(hdEntity.getId(), chouaward.getAwardslevle().getAwardsName(), accountid);
                while (recordlist.size() >= count) {
                    chouaward = HdUtils.getAward(Integer.parseInt(glArr[0]), Integer.parseInt(glArr[1]), awardslist);
                    count = this.huoDongAwardService.getAwardsAmount(chouaward.getAwardslevle().getId(), hdEntity.getId());
                    recordlist = this.prizeRecordService.listRecord(hdEntity.getId(), chouaward.getAwardslevle().getAwardsName(), accountid);
                    if (++choujiangcount <= prizecount) continue;
                    zhongjiangflag = false;
                    break;
                }
                if (zhongjiangflag) {
                    params.put("prizetype", chouaward.getAwardslevle().getAwardsName());
                    String prizenames = this.getAwardsNames(chouaward.getAwardslevle().getId(), hdEntity.getId());
                    params.put("prizename", prizenames);
                    PrizeRecordEntity record = new PrizeRecordEntity();
                    record.setAccountid(hdEntity.getAccountid());
                    record.setAddress("");
                    record.setAwardsCode(UUID.randomUUID().toString());
                    record.setAddtime(new Date());
                    record.setHdid(hdId);
                    record.setOpenId(openId);
                    record.setPrizetype(chouaward.getAwardslevle().getAwardsName());
                    record.setPrize(prizenames);
                    this.systemService.save((Object)record);
                    params.put("recordid", record.getId());
                } else {
                    j.setSuccess(false);
                    j.setMsg("\u771f\u9057\u61be\uff0c\u518d\u63a5\u518d\u5389\u3002");
                }
            } else {
                j.setSuccess(false);
                j.setMsg("\u771f\u9057\u61be\uff0c\u518d\u63a5\u518d\u5389\u3002");
            }
            this.huodongService.hdRecordCount(hdEntity, openId);
        }
        j.setAttributes(params);
        return j;
    }

    private String getAwardsNames(String levelid, String hdid) {
        List<WeixinAwardsAwardEntity> chouawardslist = this.weixinAwardsAwardService.getAwardsList(levelid, hdid);
        String awardsnames = "";
        for (WeixinAwardsAwardEntity a : chouawardslist) {
            awardsnames = String.valueOf(awardsnames) + a.getAwardmodel().getName() + ",";
        }
        if (awardsnames != null && awardsnames.length() != 0) {
            awardsnames = awardsnames.substring(0, awardsnames.length() - 1);
        }
        return awardsnames;
    }

    public String myHuoDongCallWeixinAuthor2(HttpServletRequest request, String accountId, String hdid, String targetUrlMethod) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("hdid", hdid);
        String tagetUrl = OAuth2Util.obtainTargetUrl(this.getClass(), targetUrlMethod, paramsMap);
        String weixin_author2_url = this.remoteWeixinMethod.callWeixinAuthor2(request, accountId, tagetUrl);
        return weixin_author2_url;
    }
}

