/*
 * Decompiled with CFR 0.152.
 */
package weixin.idea.huodong.controller;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.poi.excel.entity.ExcelTitle;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.cgform.common.SysVar;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.idea.huodong.entity.PrizeRecordEntity;
import weixin.idea.huodong.service.PrizeRecordServiceI;

@Controller
@RequestMapping(value={"/prizeRecordController"})
public class PrizeRecordController
extends BaseController {
    private static final Logger logger = Logger.getLogger(PrizeRecordController.class);
    @Autowired
    private PrizeRecordServiceI prizeRecordService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"goPrizeRecord"})
    public ModelAndView goPrizeRecord(HttpServletRequest request) {
        String hdId = request.getParameter("hdId");
        request.setAttribute("hdId", (Object)hdId);
        return new ModelAndView("weixin/idea/huodong/prizerecord/prizeRecordList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(PrizeRecordEntity prizeRecord, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        String hdid = request.getParameter("hdid");
        LogUtil.info((Object)(".....openwin...." + hdid));
        CriteriaQuery cq = new CriteriaQuery(PrizeRecordEntity.class, dataGrid);
        cq.eq("hdid", (Object)hdid);
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        cq.add();
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)prizeRecord, (Map)request.getParameterMap());
        this.prizeRecordService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(PrizeRecordEntity prizeRecord, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        prizeRecord = (PrizeRecordEntity)this.systemService.getEntity(PrizeRecordEntity.class, (Serializable)((Object)prizeRecord.getId()));
        this.message = "\u4e2d\u5956\u7eaa\u5f55\u5220\u9664\u6210\u529f";
        this.prizeRecordService.delete(prizeRecord);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(PrizeRecordEntity prizeRecord, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty((Object)prizeRecord.getId())) {
            this.message = "\u4e2d\u5956\u7eaa\u5f55\u66f4\u65b0\u6210\u529f";
            PrizeRecordEntity t = (PrizeRecordEntity)this.prizeRecordService.get(PrizeRecordEntity.class, (Serializable)((Object)prizeRecord.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)prizeRecord, (Object)t);
                this.prizeRecordService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u4e2d\u5956\u7eaa\u5f55\u66f4\u65b0\u5931\u8d25";
            }
        } else {
            this.message = "\u4e2d\u5956\u7eaa\u5f55\u6dfb\u52a0\u6210\u529f";
            this.prizeRecordService.save(prizeRecord);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"addOrUpdate"})
    public ModelAndView addOrUpdate(PrizeRecordEntity prizeRecord, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)prizeRecord.getId())) {
            prizeRecord = (PrizeRecordEntity)this.prizeRecordService.getEntity(PrizeRecordEntity.class, (Serializable)((Object)prizeRecord.getId()));
            req.setAttribute("prizeRecordPage", (Object)prizeRecord);
        }
        return new ModelAndView("weixin/idea/huodong/prizerecord/prizeRecord");
    }

    @RequestMapping(params={"goSendGoods"})
    public ModelAndView goSendGoods(HttpServletRequest request, PrizeRecordEntity record) {
        record = (PrizeRecordEntity)this.prizeRecordService.get(PrizeRecordEntity.class, (Serializable)((Object)record.getId()));
        request.setAttribute("record", (Object)record);
        return new ModelAndView("weixin/idea/huodong/prizerecord/sendgoods");
    }

    @RequestMapping(params={"doSendGoods"})
    @ResponseBody
    public AjaxJson doSendGoods(HttpServletRequest request, PrizeRecordEntity record) {
        AjaxJson json = new AjaxJson();
        PrizeRecordEntity record2 = (PrizeRecordEntity)this.prizeRecordService.get(PrizeRecordEntity.class, (Serializable)((Object)record.getId()));
        if (oConvertUtils.isNotEmpty((Object)record2.getSendstatus()) && record2.getSendstatus().equals("1")) {
            json.setSuccess(true);
            json.setMsg("\u5df2\u7ecf\u53d1\u8fc7\u8d27\u4e86,\u4e0d\u80fd\u518d\u53d1\u4e86\uff01");
        } else {
            record2.setExpressname(record.getExpressname());
            record2.setExpressnumber(record.getExpressnumber());
            record2.setSendstatus("1");
            record2.setSendtime(new Date());
            record2.setSenduser(ResourceUtil.getSessionUserName().getRealName());
            this.systemService.updateEntitie((Object)record2);
            json.setSuccess(true);
            json.setMsg("\u53d1\u8d27\u6210\u529f");
        }
        return json;
    }

    @RequestMapping(params={"exportXls"})
    public String exportXls(PrizeRecordEntity prizeRecord, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid, ModelMap map) throws UnsupportedEncodingException {
        response.setContentType("text/html;charset=utf-8");
        String hdid = request.getParameter("hdid");
        CriteriaQuery cq = new CriteriaQuery(PrizeRecordEntity.class, dataGrid);
        prizeRecord.setAccountid(ResourceUtil.getShangJiaAccountId());
        prizeRecord.setHdid(hdid);
        prizeRecord.setUsername(!StringUtil.isEmpty((String)prizeRecord.getUsername()) ? new String(prizeRecord.getUsername().getBytes("iso-8859-1"), "utf-8") : null);
        prizeRecord.setAddress(!StringUtil.isEmpty((String)prizeRecord.getAddress()) ? new String(prizeRecord.getAddress().getBytes("iso-8859-1"), "utf-8") : null);
        prizeRecord.setPrizetype(!StringUtil.isEmpty((String)prizeRecord.getPrizetype()) ? new String(prizeRecord.getPrizetype().getBytes("iso-8859-1"), "utf-8") : null);
        prizeRecord.setPrize(!StringUtil.isEmpty((String)prizeRecord.getPrize()) ? new String(prizeRecord.getPrize().getBytes("iso-8859-1"), "utf-8") : null);
        prizeRecord.setExpressnumber(!StringUtil.isEmpty((String)prizeRecord.getExpressnumber()) ? new String(prizeRecord.getExpressnumber().getBytes("iso-8859-1"), "utf-8") : null);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)prizeRecord, (Map)request.getParameterMap());
        List prizeRecords = this.prizeRecordService.getListByCriteriaQuery(cq, false);
        map.put((Object)"fileName", (Object)"\u4e2d\u5956\u7eaa\u5f55");
        map.put((Object)"entity", PrizeRecordEntity.class);
        map.put((Object)"title", (Object)new ExcelTitle("\u4e2d\u5956\u5217\u8868", "\u5bfc\u51fa\u4eba:" + SysVar.username.getSysValue(), "\u5bfc\u51fa\u4fe1\u606f"));
        map.put((Object)"data", (Object)prizeRecords);
        return "jeecgExcelView";
    }
}

