/*
 * Decompiled with CFR 0.152.
 */
package weixin.idea.huodong.controller;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang3.StringUtils;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.idea.huodong.entity.AwardsLevelEntity;
import weixin.idea.huodong.entity.HdRecordEntity;
import weixin.idea.huodong.entity.HuoDongAwardEntity;
import weixin.idea.huodong.entity.HuodongEntity;
import weixin.idea.huodong.entity.PrizeRecordEntity;
import weixin.idea.huodong.entity.ValidateResult;
import weixin.idea.huodong.service.AwardsLevelServiceI;
import weixin.idea.huodong.service.HuoDongAwardServiceI;
import weixin.idea.huodong.service.HuodongServiceI;
import weixin.idea.huodong.service.PrizeRecordServiceI;
import weixin.idea.huodong.service.WeixinAwardsAwardServiceI;
import weixin.util.DateUtils;

@Controller
@RequestMapping(value={"/luckyFruitController"})
public class LuckyFruitController
extends BaseController {
    private SystemService systemService;
    @Autowired
    private PrizeRecordServiceI prizeRecordService;
    @Autowired
    private AwardsLevelServiceI awardsLevelService;
    @Autowired
    private HuoDongAwardServiceI huoDongAwardService;
    @Autowired
    WeixinAwardsAwardServiceI weixinAwardsAwardService;
    @Autowired
    private HuodongServiceI huodongService;

    @Resource(name="systemService")
    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    @RequestMapping(params={"goLuckyFruit"})
    public ModelAndView goLuckyFruit(HttpServletRequest request) {
        String openid = request.getParameter("openid");
        String accountid = this.findAccountId(request);
        if (StringUtils.isEmpty((CharSequence)openid) || StringUtils.isEmpty((CharSequence)accountid)) {
            throw new BusinessException("openid or accountid can not be null");
        }
        request.setAttribute("accountid", (Object)accountid);
        request.setAttribute("openid", (Object)openid);
        List hdlst = this.systemService.findByQueryString(" FROM HuodongEntity h WHERE h.accountid='" + accountid + "' AND type=4");
        HuodongEntity huodongEntity = new HuodongEntity();
        if (hdlst.size() == 0) {
            request.setAttribute("msg", (Object)"\u5546\u5bb6\u672a\u542f\u52a8\u5e78\u8fd0\u6c34\u679c\u673a\u6d3b\u52a8\u3002");
            return new ModelAndView("weixin/idea/huodong2/luckyFruit/luckyFruitover");
        }
        huodongEntity = (HuodongEntity)hdlst.get(0);
        ValidateResult result = this.huodongService.validateCanJoin(huodongEntity, openid);
        if (!result.isSucc()) {
            request.setAttribute("msg", (Object)result.getMessage());
            return new ModelAndView("weixin/idea/huodong2/luckyFruit/luckyFruitover");
        }
        int shakeTimeCount = this.getCount(huodongEntity, openid);
        String hdcountStr = "\u60a8\u6709 " + Integer.parseInt(huodongEntity.getCount()) + " \u6b21\u673a\u4f1a\u62bd\u5956\uff0c\u5df2\u7ecf\u4f7f\u7528\u4e86 " + shakeTimeCount + " \u6b21";
        request.setAttribute("hdcountStr", (Object)hdcountStr);
        ValidateResult countResult = this.huodongService.validateCanLottery(huodongEntity, openid);
        if (!countResult.isSucc()) {
            request.setAttribute("msg", (Object)countResult.getMessage());
            return new ModelAndView("weixin/idea/huodong2/luckyFruit/luckyFruitover");
        }
        List<HuoDongAwardEntity> awardslist = huodongEntity.getAwardslist();
        request.setAttribute("huodongEntity", (Object)huodongEntity);
        request.setAttribute("hdId", (Object)huodongEntity.getId());
        HashMap<String, List> awardmap = new HashMap<String, List>();
        for (HuoDongAwardEntity awards : awardslist) {
            List awardlist = this.systemService.findByQueryString("from WeixinAwardsAwardEntity w where w.huodongmodel='" + huodongEntity.getId() + "' and " + " w.awardslevle='" + awards.getAwardslevle().getId() + "'");
            awardmap.put(awards.getId(), awardlist);
        }
        request.setAttribute("awardmap", awardmap);
        request.setAttribute("awardslist", awardslist);
        request.setAttribute("awardscount", (Object)huodongEntity.getAwardslist().size());
        return new ModelAndView("weixin/idea/huodong/luckyFruit/luckyFruit");
    }

    private int getCount(HuodongEntity hdEntity, String openId) {
        List hdRecrdList;
        String hql = "from HdRecordEntity where hdid='" + hdEntity.getId() + "' and opendid='" + openId + "' and accountid='" + hdEntity.getAccountid() + "'";
        if (openId == null) {
            hql = "from HdRecordEntity where hdid='" + hdEntity.getId() + "'  and accountid='" + hdEntity.getAccountid() + "'";
        }
        if ((hdRecrdList = this.systemService.findHql(hql, null)).size() > 0) {
            return ((HdRecordEntity)hdRecrdList.get(0)).getTotal();
        }
        return 0;
    }

    @RequestMapping(params={"getAjax"})
    @ResponseBody
    public Map<String, Object> getAjax(String openid, HttpServletRequest request, HttpServletResponse response) {
        String accountid = this.findAccountId(request);
        HashMap<String, Object> m = new HashMap<String, Object>();
        List<HuodongEntity> hdlst = this.queryHuodongListByType(accountid, "4");
        if (oConvertUtils.isNullOrEmpty(hdlst)) {
            m.put("error", 1);
            m.put("msg", "\u5546\u5bb6\u672a\u5f00\u542f\u6d3b\u52a8");
            return m;
        }
        HuodongEntity huodongEntity = hdlst.get(0);
        ValidateResult result = this.huodongService.validateCanJoin(huodongEntity, openid);
        if (!result.isSucc()) {
            m.put("error", 1);
            m.put("msg", result.getMessage());
            return m;
        }
        ValidateResult countResult = this.huodongService.validateCanLottery(huodongEntity, openid);
        if (!countResult.isSucc()) {
            m.put("error", 1);
            m.put("msg", countResult.getMessage());
            return m;
        }
        Random rand = new Random();
        String left = "" + rand.nextInt(8);
        String middle = "" + rand.nextInt(8);
        String right = "" + rand.nextInt(8);
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put(left, left);
        dataMap.put(middle, middle);
        dataMap.put(right, right);
        m = new HashMap();
        m.put("success", 1);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("left", left);
        data.put("middle", middle);
        data.put("right", right);
        data.put("sn", "");
        int shakeTimeCount = this.getCount(huodongEntity, openid);
        String hdcountStr = "\u60a8\u6709 " + Integer.parseInt(huodongEntity.getCount()) + " \u6b21\u673a\u4f1a\u62bd\u5956\uff0c\u5df2\u7ecf\u4f7f\u7528\u4e86 " + (shakeTimeCount + 1) + " \u6b21";
        data.put("hdcountStr", hdcountStr);
        if (dataMap.size() == 1 || dataMap.size() == 2) {
            String prizetype = "";
            switch (dataMap.size()) {
                case 1: {
                    prizetype = "\u4e00\u7b49\u5956";
                    break;
                }
                case 2: {
                    prizetype = "\u4e8c\u7b49\u5956";
                    break;
                }
            }
            AwardsLevelEntity level = this.awardsLevelService.getAwardsLevel(prizetype, accountid);
            int count = this.huoDongAwardService.getAwardsAmount(level.getId(), huodongEntity.getId());
            List<PrizeRecordEntity> recordlist = this.prizeRecordService.listRecord(huodongEntity.getId(), prizetype, accountid);
            if (recordlist.size() >= count) {
                data.put("prize_type", "\u5f88\u9057\u61be\uff0c" + (dataMap.size() == 1 ? "\u4e00\u7b49\u5956" : "\u4e8c\u7b49\u5956") + "\u5df2\u62bd\u5b8c");
                data.put("prize", "");
                data.put("type", 0);
                m.put("data", data);
            } else {
                PrizeRecordEntity record = new PrizeRecordEntity();
                record.setAccountid(huodongEntity.getAccountid());
                record.setAddress("");
                record.setAwardsCode(UUID.randomUUID().toString());
                record.setAddtime(new Date());
                record.setHdid(huodongEntity.getId());
                record.setOpenId(openid);
                record.setPrizetype(prizetype);
                record.setPrize(this.getPrize(record.getPrizetype(), huodongEntity.getId(), accountid));
                String recordid = (String)((Object)this.systemService.save((Object)record));
                data.put("recordid", recordid);
                data.put("prize_type", dataMap.size() == 1 ? "\u4e00\u7b49\u5956" : "\u4e8c\u7b49\u5956");
                data.put("prize", dataMap.size() == 1 ? "\u4e00\u7b49\u5956" : "\u4e8c\u7b49\u5956");
                data.put("type", 1);
                m.put("data", data);
            }
        } else {
            data.put("prize_type", "\u4eb2\uff0c\u4e0b\u6b21\u7ee7\u7eed\u52aa\u529b\u54e6");
            data.put("prize", "");
            data.put("type", 0);
            m.put("data", data);
        }
        this.huodongService.hdRecordCount(huodongEntity, openid);
        return m;
    }

    private List<HuodongEntity> queryHuodongListByType(String accountid, String type) {
        String hql = " FROM HuodongEntity h WHERE h.accountid='" + accountid + "' AND type=" + type + " AND h.triggerFlag ='Y' ";
        String nowTime = DateUtils.date2Str(DateUtils.date_sdf);
        hql = String.valueOf(hql) + " AND starttime <='" + nowTime + "' AND endtime >= '" + nowTime + "'";
        return this.systemService.findByQueryString(hql);
    }

    @RequestMapping(params={"getUseNums"})
    @ResponseBody
    public Map<String, Object> getUseNums(String openid, HttpServletRequest request, HttpServletResponse response) {
        String accountid = this.findAccountId(request);
        List hdlst = this.systemService.findByQueryString(" FROM HuodongEntity h WHERE h.accountid='" + accountid + "' AND type=4");
        HuodongEntity huodongEntity = new HuodongEntity();
        if (hdlst.size() != 0) {
            huodongEntity = (HuodongEntity)hdlst.get(0);
        }
        String hql = "from HdRecordEntity where hdid='" + huodongEntity.getId() + "' and opendid='" + openid + "' and accountid='" + huodongEntity.getAccountid() + "'";
        List hdRecrdList = this.systemService.findHql(hql, null);
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (hdRecrdList.size() > 0) {
            HdRecordEntity hdRecord = (HdRecordEntity)hdRecrdList.get(0);
            int total = hdRecord.getTotal();
            m.put("usenums", total);
        } else {
            m.put("usenums", 0);
        }
        return m;
    }

    @RequestMapping(params={"getHuodongInfo"})
    @ResponseBody
    public Map<String, Object> getHuodongInfo(String openid, HttpServletRequest request, HttpServletResponse response) {
        String accountid = this.findAccountId(request);
        List hdlst = this.systemService.findByQueryString(" FROM HuodongEntity h WHERE h.accountid='" + accountid + "' AND type=4");
        HuodongEntity huodongEntity = new HuodongEntity();
        if (hdlst.size() != 0) {
            huodongEntity = (HuodongEntity)hdlst.get(0);
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("totalnums", huodongEntity.getCount());
        m.put("starttime", DateFormatUtils.format((Date)huodongEntity.getStarttime(), (String)"yyyy/MM/dd"));
        m.put("endtime", DateFormatUtils.format((Date)huodongEntity.getEndtime(), (String)"yyyy/MM/dd"));
        String numberOnePrize = this.getPrize("\u4e00\u7b49\u5956", huodongEntity.getId(), accountid);
        m.put("numberOnePrize", numberOnePrize);
        String numberTwoPrize = this.getPrize("\u4e8c\u7b49\u5956", huodongEntity.getId(), accountid);
        m.put("numberTwoPrize", numberTwoPrize);
        return m;
    }

    @RequestMapping(params={"getPrizeInfo"})
    @ResponseBody
    public Map<String, Object> getPrizeInfo(String openid, HttpServletRequest request, HttpServletResponse response) {
        PrizeRecordEntity record;
        String accountid = this.findAccountId(request);
        HashMap<String, Object> m = new HashMap<String, Object>();
        List hdlst = this.systemService.findByQueryString(" FROM HuodongEntity h WHERE h.accountid='" + accountid + "' AND type=4");
        HuodongEntity huodongEntity = new HuodongEntity();
        if (hdlst.size() != 0) {
            huodongEntity = (HuodongEntity)hdlst.get(0);
        }
        if ((record = this.prizeRecordService.getRecordByOpenid(huodongEntity.getId(), openid, accountid)) != null) {
            m.put("zhongjiang", "Y");
            m.put("prize", StringUtils.trimToEmpty((String)record.getPrizetype()));
            m.put("MOBILE", StringUtils.trimToEmpty((String)record.getMobile()));
            m.put("address", StringUtils.trimToEmpty((String)record.getAddress()));
            m.put("recordid", StringUtils.trimToEmpty((String)record.getId()));
        } else {
            m.put("zhongjiang", "N");
        }
        return m;
    }

    @RequestMapping(params={"submitPrizedUserInfo"})
    @ResponseBody
    public AjaxJson submitPrizedUserInfo(String id, String openid, String MOBILE, String address, HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        PrizeRecordEntity record = (PrizeRecordEntity)this.prizeRecordService.get(PrizeRecordEntity.class, (Serializable)((Object)id));
        if (record != null && !StringUtil.isEmpty((String)record.getId())) {
            record.setMobile(MOBILE);
            record.setAddress(address);
            this.systemService.updateEntitie((Object)record);
        }
        return j;
    }

    private String getPrize(String prizetype, String hdid, String accountid) {
        AwardsLevelEntity level = this.awardsLevelService.getAwardsLevel(prizetype, accountid);
        return this.weixinAwardsAwardService.getPrize(level.getId(), hdid);
    }

    private String findAccountId(HttpServletRequest request) {
        if (request == null) {
            return "";
        }
        String accountid = request.getParameter("accountid");
        if (accountid != null && !"".equals(accountid)) {
            return accountid;
        }
        return ResourceUtil.getShangJiaAccountId();
    }
}

