/*
 * Decompiled with CFR 0.152.
 */
package weixin.idea.huodong.controller;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.idea.huodong.entity.AwardEntity;
import weixin.idea.huodong.entity.AwardsLevelEntity;
import weixin.idea.huodong.entity.HuoDongAwardEntity;
import weixin.idea.huodong.entity.HuodongEntity;
import weixin.idea.huodong.entity.WeixinAwardsAwardEntity;
import weixin.idea.huodong.service.AwardServiceI;
import weixin.idea.huodong.service.AwardsLevelServiceI;
import weixin.idea.huodong.service.HuodongServiceI;
import weixin.idea.huodong.service.WeixinAwardsAwardServiceI;
import weixin.idea.huodong.utils.AwardInfoVO;

@Controller
@RequestMapping(value={"/huodongController"})
public class HuodongController
extends BaseController {
    private static final Logger logger = Logger.getLogger(HuodongController.class);
    @Autowired
    private HuodongServiceI huodongService;
    @Autowired
    private AwardsLevelServiceI awardsLevelService;
    @Autowired
    private AwardServiceI awardService;
    @Autowired
    private SystemService systemService;
    @Autowired
    WeixinAwardsAwardServiceI weixinAwardsAwardService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"list"})
    public ModelAndView list(HttpServletRequest request) {
        String type = request.getParameter("type");
        request.setAttribute("type", (Object)type);
        return new ModelAndView("weixin/idea/huodong/huodong/huodongList");
    }

    @RequestMapping(params={"pophuodonglink"})
    public ModelAndView pophuodonglink(ModelMap modelMap, @RequestParam String url, @RequestParam String hdid, HttpServletRequest request) {
        ResourceBundle bundler = ResourceBundle.getBundle("sysConfig");
        String absolutePathUrl = String.valueOf(bundler.getString("domain")) + "/" + url;
        modelMap.put((Object)"url", (Object)absolutePathUrl);
        modelMap.put((Object)"hdid", (Object)hdid);
        return new ModelAndView("weixin/idea/huodong/huodong/pophuodonglink");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(HuodongEntity huodong, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        String type = request.getParameter("type");
        CriteriaQuery cq = new CriteriaQuery(HuodongEntity.class, dataGrid);
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        cq.add();
        LogUtil.info((Object)(".....type....." + type));
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)huodong, (Map)request.getParameterMap());
        this.huodongService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(HuodongEntity huodong, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if ((huodong = (HuodongEntity)this.systemService.getEntity(HuodongEntity.class, (Serializable)((Object)huodong.getId()))).getAwardslist() != null && huodong.getAwardslist().size() > 0) {
            for (HuoDongAwardEntity oldawards : huodong.getAwardslist()) {
                this.systemService.delete((Object)oldawards);
            }
        }
        if (huodong.getAwardlist() != null && huodong.getAwardlist().size() > 0) {
            for (WeixinAwardsAwardEntity oldaward : huodong.getAwardlist()) {
                this.systemService.delete((Object)oldaward);
            }
        }
        this.message = "\u6d3b\u52a8\u5220\u9664\u6210\u529f";
        this.huodongService.delete(huodong);
        String sql = "delete from  weixin_prizerecord where hdid = '" + huodong.getId() + "'";
        this.huodongService.updateBySqlString(sql);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(HuodongEntity huodong, HttpServletRequest request) {
        List<AwardInfoVO> awardInfolist = this.doAwardInfoVO(request);
        String url = this.obtainUrl(huodong.getType());
        huodong.setUrl(url);
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty((Object)huodong.getId())) {
            this.message = "\u6d3b\u52a8\u66f4\u65b0\u6210\u529f";
            HuodongEntity t = (HuodongEntity)this.huodongService.get(HuodongEntity.class, (Serializable)((Object)huodong.getId()));
            if (t.getAwardslist() != null && t.getAwardslist().size() > 0) {
                for (HuoDongAwardEntity oldawards : t.getAwardslist()) {
                    this.systemService.delete((Object)oldawards);
                }
            }
            if (t.getAwardlist() != null && t.getAwardlist().size() > 0) {
                for (WeixinAwardsAwardEntity oldaward : t.getAwardlist()) {
                    this.systemService.delete((Object)oldaward);
                }
            }
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)huodong, (Object)t);
                this.huodongService.saveOrUpdate(t);
                if (awardInfolist != null && awardInfolist.size() > 0) {
                    for (AwardInfoVO model : awardInfolist) {
                        HuoDongAwardEntity hdawards = new HuoDongAwardEntity();
                        hdawards.setHuodongmodel(huodong);
                        AwardsLevelEntity level = new AwardsLevelEntity();
                        List levellist = this.awardsLevelService.findByProperty(AwardsLevelEntity.class, "id", model.getAwardsid());
                        if (levellist == null || levellist.size() <= 0) continue;
                        level = (AwardsLevelEntity)levellist.get(0);
                        hdawards.setAwardslevle(level);
                        hdawards.setAccountid(huodong.getAccountid());
                        hdawards.setAmount(model.getAmount());
                        this.systemService.save((Object)hdawards);
                        for (String id : model.getAwardidlist()) {
                            WeixinAwardsAwardEntity awardmodel = new WeixinAwardsAwardEntity();
                            awardmodel.setHuodongmodel(huodong);
                            awardmodel.setAwardslevle(level);
                            AwardEntity award = new AwardEntity();
                            List awardlist = this.awardService.findByProperty(AwardEntity.class, "id", id);
                            if (awardlist == null || awardlist.size() <= 0) continue;
                            award = (AwardEntity)awardlist.get(0);
                            awardmodel.setAwardmodel(award);
                            awardmodel.setAccountid(huodong.getAccountid());
                            this.systemService.save((Object)awardmodel);
                        }
                    }
                }
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u6d3b\u52a8\u66f4\u65b0\u5931\u8d25";
            }
        } else {
            this.message = "\u6d3b\u52a8\u6dfb\u52a0\u6210\u529f";
            huodong.setHdCode("1");
            this.huodongService.save(huodong);
            if (awardInfolist != null && awardInfolist.size() > 0) {
                for (AwardInfoVO model : awardInfolist) {
                    HuoDongAwardEntity hdawards = new HuoDongAwardEntity();
                    hdawards.setHuodongmodel(huodong);
                    AwardsLevelEntity level = new AwardsLevelEntity();
                    List levellist = this.awardsLevelService.findByProperty(AwardsLevelEntity.class, "id", model.getAwardsid());
                    if (levellist == null || levellist.size() <= 0) continue;
                    level = (AwardsLevelEntity)levellist.get(0);
                    hdawards.setAwardslevle(level);
                    hdawards.setAccountid(huodong.getAccountid());
                    hdawards.setAmount(model.getAmount());
                    this.systemService.save((Object)hdawards);
                    for (String id : model.getAwardidlist()) {
                        WeixinAwardsAwardEntity awardmodel = new WeixinAwardsAwardEntity();
                        awardmodel.setHuodongmodel(huodong);
                        awardmodel.setAwardslevle(level);
                        AwardEntity award = new AwardEntity();
                        List awardlist = this.awardService.findByProperty(AwardEntity.class, "id", id);
                        if (awardlist == null || awardlist.size() <= 0) continue;
                        award = (AwardEntity)awardlist.get(0);
                        awardmodel.setAwardmodel(award);
                        awardmodel.setAccountid(huodong.getAccountid());
                        this.systemService.save((Object)awardmodel);
                    }
                }
            }
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        j.setMsg(this.message);
        return j;
    }

    private String obtainUrl(String type) {
        String tempUrl = "";
        HashMap<String, String> urlMap = new HashMap<String, String>();
        urlMap.put("1", "zpController2.do?goGglNew");
        urlMap.put("2", "zpController2.do?goZhuanpan");
        urlMap.put("3", "zpController2.do?goGoldEgg");
        urlMap.put("4", "zpController2.do?goLuckyFruit");
        urlMap.put("5", "zpController2.do?goZymShake");
        tempUrl = (String)urlMap.get(type);
        return tempUrl;
    }

    @RequestMapping(params={"addOrUpdate"})
    public ModelAndView addOrUpdate(HuodongEntity huodong, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)huodong.getId())) {
            if ((huodong = (HuodongEntity)this.huodongService.getEntity(HuodongEntity.class, (Serializable)((Object)huodong.getId()))) != null && huodong.getAwardlist() != null && huodong.getAwardlist().size() > 0) {
                List<HuoDongAwardEntity> awardslist = huodong.getAwardslist();
                HashMap<String, String> mapname = new HashMap<String, String>();
                HashMap<String, String> mapid = new HashMap<String, String>();
                String name = "";
                String id = "";
                for (HuoDongAwardEntity awards : awardslist) {
                    WeixinAwardsAwardEntity awardsr = this.weixinAwardsAwardService.getAwards(awards.getAwardslevle().getId(), huodong.getId());
                    if (awardsr != null) {
                        name = awardsr.getAwardmodel().getName();
                        id = awardsr.getAwardmodel().getId();
                    }
                    mapname.put(awards.getId(), name);
                    mapid.put(awards.getId(), id);
                }
                req.setAttribute("mapname", mapname);
                req.setAttribute("mapid", mapid);
            }
            req.setAttribute("huodongPage", (Object)huodong);
        }
        return new ModelAndView("weixin/idea/huodong/huodong/huodong");
    }

    @RequestMapping(params={"dostatus"})
    @ResponseBody
    public AjaxJson dostatus(HuodongEntity huodong, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        huodong = (HuodongEntity)this.systemService.getEntity(HuodongEntity.class, (Serializable)((Object)huodong.getId()));
        String flag = request.getParameter("flag");
        int num = this.huodongService.updateBySqlString("update weixin_huodong h set hd_code='" + flag + "' where id='" + huodong.getId() + "'");
        if (num > 0) {
            this.message = "\u64cd\u4f5c\u6210\u529f";
        }
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"dotrigger"})
    @ResponseBody
    public AjaxJson dotrigger(HuodongEntity huodong, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        huodong = (HuodongEntity)this.systemService.getEntity(HuodongEntity.class, (Serializable)((Object)huodong.getId()));
        this.huodongService.updateBySqlString("update weixin_huodong h set trigger_flag= 'N' where h.type='" + huodong.getType() + "'");
        int num = this.huodongService.updateBySqlString("update weixin_huodong h set trigger_flag= 'Y' where h.id='" + huodong.getId() + "'");
        if (num > 0) {
            this.message = "\u64cd\u4f5c\u6210\u529f";
        }
        this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    private List<AwardInfoVO> doAwardInfoVO(HttpServletRequest request) {
        String jsonstr = request.getParameter("jsonstr");
        JSONArray jsonarray = JSONArray.fromObject((Object)jsonstr);
        Object[] obj = jsonarray.toArray();
        ArrayList<AwardInfoVO> awardInfolist = new ArrayList<AwardInfoVO>();
        int i = 0;
        while (i < obj.length) {
            JSONObject jsonobj = JSONObject.fromObject((Object)obj[i]);
            String awardsid = jsonobj.get("awardsid").toString();
            String awardsname = jsonobj.get("awardsname").toString();
            String awardid = jsonobj.get("awardid").toString();
            String[] idarray = awardid.split(",");
            String awardname = jsonobj.get("awardname").toString();
            String[] namearray = awardname.split(",");
            String amountname = jsonobj.get("amountname").toString();
            AwardInfoVO info = new AwardInfoVO();
            info.setAwardsid(awardsid);
            info.setAwardsname(awardsname);
            ArrayList<String> idlist = new ArrayList<String>();
            int j = 0;
            while (j < idarray.length) {
                idlist.add(idarray[j]);
                ++j;
            }
            info.setAwardidlist(idlist);
            ArrayList<String> namelist = new ArrayList<String>();
            int k = 0;
            while (k < awardid.split(",").length) {
                namelist.add(namearray[k]);
                ++k;
            }
            info.setAwardnamelist(namelist);
            info.setAmount(Integer.parseInt(amountname));
            awardInfolist.add(info);
            ++i;
        }
        return awardInfolist;
    }

    public void doImage(HttpServletRequest request, HttpServletResponse response) {
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Integer width = 180;
        Integer height = 40;
        String name = request.getParameter("awardsname");
        BufferedImage image = new BufferedImage(180, 40, 1);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, width, height);
        graphics.drawRect(0, 0, width - 1, height - 1);
        String resultCode = name;
        int i = 0;
        while (i < resultCode.length()) {
            graphics.setColor(Color.BLACK);
            graphics.setFont(new Font("Times New Roman", 1, 24));
            graphics.drawString(String.valueOf(resultCode.charAt(i)), 23 * i + 8, 26);
            ++i;
        }
        graphics.dispose();
        try {
            ImageIO.write((RenderedImage)image, "JPEG", (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

