/*
 * Decompiled with CFR 0.152.
 */
package weixin.idea.huodong.controller;

import java.io.Serializable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.idea.huodong.entity.HdRecordEntity;
import weixin.idea.huodong.service.HdRecordServiceI;

@Controller
@RequestMapping(value={"/hdRecordController"})
public class HdRecordController
extends BaseController {
    private static final Logger logger = Logger.getLogger(HdRecordController.class);
    @Autowired
    private HdRecordServiceI hdRecordService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"hdRecord"})
    public ModelAndView hdRecord(HttpServletRequest request) {
        String hdId = request.getParameter("hdId");
        request.setAttribute("hdId", (Object)hdId);
        return new ModelAndView("weixin/idea/huodong/hdrecord/hdRecordList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(HdRecordEntity hdRecord, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        String hdId = request.getParameter("hdId");
        CriteriaQuery cq = new CriteriaQuery(HdRecordEntity.class, dataGrid);
        cq.eq("hdid", (Object)hdId);
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        cq.add();
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)hdRecord, (Map)request.getParameterMap());
        this.hdRecordService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(HdRecordEntity hdRecord, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        hdRecord = (HdRecordEntity)this.systemService.getEntity(HdRecordEntity.class, (Serializable)((Object)hdRecord.getId()));
        this.message = "\u53c2\u52a0\u6d3b\u52a8\u8bb0\u5f55\u5220\u9664\u6210\u529f";
        this.hdRecordService.delete(hdRecord);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(HdRecordEntity hdRecord, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty((Object)hdRecord.getId())) {
            this.message = "\u53c2\u52a0\u6d3b\u52a8\u8bb0\u5f55\u66f4\u65b0\u6210\u529f";
            HdRecordEntity t = (HdRecordEntity)this.hdRecordService.get(HdRecordEntity.class, (Serializable)((Object)hdRecord.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)hdRecord, (Object)t);
                this.hdRecordService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u53c2\u52a0\u6d3b\u52a8\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25";
            }
        } else {
            this.message = "\u53c2\u52a0\u6d3b\u52a8\u8bb0\u5f55\u6dfb\u52a0\u6210\u529f";
            this.hdRecordService.save(hdRecord);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"addorUpdate"})
    public ModelAndView addorUpdate(HdRecordEntity hdRecord, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)hdRecord.getId())) {
            hdRecord = (HdRecordEntity)this.hdRecordService.getEntity(HdRecordEntity.class, (Serializable)((Object)hdRecord.getId()));
            req.setAttribute("hdRecordPage", (Object)hdRecord);
        }
        return new ModelAndView("weixin/idea/huodong/hdrecord/hdRecord");
    }
}

