/*
 * Decompiled with CFR 0.152.
 */
package weixin.idea.huodong.controller;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.idea.huodong.entity.AwardsLevelEntity;
import weixin.idea.huodong.entity.HuodongEntity;
import weixin.idea.huodong.service.AwardsLevelServiceI;
import weixin.idea.huodong.service.HuoDongAwardServiceI;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/awardsLevelController"})
public class AwardsLevelController
extends BaseController {
    private static final Logger logger = Logger.getLogger(AwardsLevelController.class);
    @Autowired
    private AwardsLevelServiceI awardsLevelService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private HuoDongAwardServiceI huoDongAwardService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"awardsLevel"})
    public ModelAndView awardsLevel(HttpServletRequest request) {
        return new ModelAndView("weixin/idea/huodong/huodong/awardsLevelList");
    }

    @RequestMapping(params={"awardsLevelPop"})
    public ModelAndView awardsLevelPop(HttpServletRequest request) {
        return new ModelAndView("weixin/idea/huodong/huodong/awardsLevelListPop");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(AwardsLevelEntity awardsLevel, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(AwardsLevelEntity.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)awardsLevel, (Map)request.getParameterMap());
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        cq.add();
        this.awardsLevelService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(AwardsLevelEntity awardsLevel, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        List<HuodongEntity> list = this.huoDongAwardService.getHuodongs(awardsLevel.getId());
        if (oConvertUtils.isEmpty(list) || list.size() < 1) {
            awardsLevel = (AwardsLevelEntity)this.systemService.getEntity(AwardsLevelEntity.class, (Serializable)((Object)awardsLevel.getId()));
            this.message = "\u5956\u9879\u5220\u9664\u6210\u529f";
            this.awardsLevelService.delete(awardsLevel);
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        } else {
            this.message = "\u5956\u9879\u5df2\u88ab\u6d3b\u52a8[" + list.get(0).getTitle() + "]\u4f7f\u7528,\u4e0d\u80fd\u5220\u9664!";
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(AwardsLevelEntity awardsLevel, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty((Object)awardsLevel.getId())) {
            this.message = "\u5956\u9879\u8868\u66f4\u65b0\u6210\u529f";
            AwardsLevelEntity t = (AwardsLevelEntity)this.awardsLevelService.get(AwardsLevelEntity.class, (Serializable)((Object)awardsLevel.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)awardsLevel, (Object)t);
                this.awardsLevelService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u5956\u9879\u8868\u66f4\u65b0\u5931\u8d25";
            }
        } else {
            this.message = "\u5956\u9879\u8868\u6dfb\u52a0\u6210\u529f";
            awardsLevel.setAwardsValue(this.maxAwardsValue());
            this.awardsLevelService.save(awardsLevel);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(AwardsLevelEntity awardsLevel, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)awardsLevel.getId())) {
            awardsLevel = (AwardsLevelEntity)this.awardsLevelService.getEntity(AwardsLevelEntity.class, (Serializable)((Object)awardsLevel.getId()));
            req.setAttribute("awardsLevelPage", (Object)awardsLevel);
        }
        return new ModelAndView("weixin/idea/huodong/huodong/awardsLevel");
    }

    private Integer maxAwardsValue() {
        String sql = "select max(a.awards_value) from weixin_awards_level a where a.accountid=?";
        Long max = this.awardsLevelService.getCountForJdbcParam(sql, new Object[]{ResourceUtil.getShangJiaAccountId()});
        if (max == null) {
            return 1;
        }
        return max.intValue() + 1;
    }
}

