/*
 * Decompiled with CFR 0.152.
 */
package weixin.idea.huodong.controller;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.idea.huodong.entity.AwardEntity;
import weixin.idea.huodong.entity.HuodongEntity;
import weixin.idea.huodong.service.AwardServiceI;
import weixin.idea.huodong.service.WeixinAwardsAwardServiceI;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/awardController"})
public class AwardController
extends BaseController {
    private static final Logger logger = Logger.getLogger(AwardController.class);
    @Autowired
    private AwardServiceI awardService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private WeixinAwardsAwardServiceI weixinAwardsAwardService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"award"})
    public ModelAndView award(HttpServletRequest request) {
        return new ModelAndView("weixin/idea/huodong/huodong/awardList");
    }

    @RequestMapping(params={"awardPop"})
    public ModelAndView awardPop(HttpServletRequest request) {
        return new ModelAndView("weixin/idea/huodong/huodong/awardListPop");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(AwardEntity award, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(AwardEntity.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)award, (Map)request.getParameterMap());
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        cq.add();
        this.awardService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(AwardEntity award, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        List<HuodongEntity> list = this.weixinAwardsAwardService.getHuodongs(award.getId());
        if (oConvertUtils.isEmpty(list) || list.size() < 1) {
            AwardEntity awards = (AwardEntity)this.systemService.getEntity(AwardEntity.class, (Serializable)((Object)award.getId()));
            this.message = "\u5956\u54c1\u5220\u9664\u6210\u529f";
            this.awardService.delete(awards);
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        } else {
            this.message = "\u5956\u54c1\u5df2\u88ab\u6d3b\u52a8[" + list.get(0).getTitle() + "]\u4f7f\u7528,\u4e0d\u80fd\u5220\u9664!";
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(AwardEntity award, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty((Object)award.getId())) {
            this.message = "\u5956\u54c1\u8868\u66f4\u65b0\u6210\u529f";
            AwardEntity t = (AwardEntity)this.awardService.get(AwardEntity.class, (Serializable)((Object)award.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)award, (Object)t);
                this.awardService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u5956\u54c1\u8868\u66f4\u65b0\u5931\u8d25";
            }
        } else {
            this.message = "\u5956\u54c1\u8868\u6dfb\u52a0\u6210\u529f";
            this.awardService.save(award);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(AwardEntity award, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)award.getId())) {
            award = (AwardEntity)this.awardService.getEntity(AwardEntity.class, (Serializable)((Object)award.getId()));
            req.setAttribute("awardPage", (Object)award);
        }
        return new ModelAndView("weixin/idea/huodong/huodong/award");
    }
}

